package cn.gtmap.landtax.web.ydqc;

/**
 * Created by Administrator on 2014/9/2.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.print.PrintTjtzExcelUtil;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.VerticalAlignment;
import jxl.write.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.math.BigDecimal;
import java.util.*;

/**
 * .
 * <p/>
 * 税源宗地数据对比疑点清册
 * @author xuchao
 * @version V1.0, 2014/9/2
 */
@Controller
@RequestMapping("/ydqc/zd")
public class ZdYdqcController {
    @Autowired
    YdqcService ydqcService;
    @Autowired
    ZdService zdService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DwxxService dwxxService;

    /**
     * 国土宗地核查疑点
     * @param model
     * @return
     */
    @RequestMapping("zdydTz")
    public String zdydTz(Model model){
        return "landtax/ydqc/zd/zdydTz";
    }

    @RequestMapping("zdydTzJson")
    @ResponseBody
    public Object zdydTzJson(Model model){
        String result = ydqcService.getZdydTzListJson();
        return result;
    }
    /**
     * 存在疑点的宗地列表
     * @param model
     * @return
     */
    @RequestMapping("list")
    public String list(Model model, String dwdm){
        model.addAttribute("dwdm", dwdm);
        return "landtax/ydqc/zd/zdList";
    }

    @RequestMapping("listJson")
    @ResponseBody
    public Object getZd(Model model,Pageable request,ZdQuery zdQuery) {
        String djh = zdQuery.getDjh();
        if (djh == null) {
            djh = "";
        }
        String swdwdm = dwxxService.getUserQxDm();
        if (swdwdm != null) {
            if (djh.length() < 6) {
                zdQuery.setDjh(swdwdm);
            }
            else if (!swdwdm.isEmpty() && !swdwdm.equals(djh.substring(0, 6))){
                zdQuery.setDjh(swdwdm);
            }
        }
        return ydqcService.findZdList(zdQuery, request);
    }
    /**
     * 已下发疑点任务的宗地列表
     * @param model
     * @return
     */
    @RequestMapping("yxfList")
    public String yxfList(Model model, String dwdm) {
        model.addAttribute("dwdm", dwdm);
        return "landtax/ydqc/zd/zdYxfList";
    }

    @RequestMapping("yxfListJson")
    @ResponseBody
    public Object yxfListJson(Model model,Pageable request,ZdQuery zdQuery) {
        return ydqcService.findZdYxfList(zdQuery, request);
    }
    /**
     *新建国土宗地疑点信息核查项目
     *
     * @param model
     * @param hcxmMc
     * @param
     * @return
     */
    @RequestMapping("xjxm")
    @ResponseBody
    public Object xjxm(Model model,String hcxmMc,String djhs,ZdQuery zdQuery){
        String result = "true";
        List<Zd> zdList=null;
        if(StringUtils.isNotBlank(djhs)){
            String[] djhArray = djhs.split(",");
            zdList = zdService.getZdsByDjhs(djhArray);
        }else{
            zdList = ydqcService.findZdListTz(zdQuery);
        }

        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("国土宗地疑点核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.SYZDYDQC.toString());
        swHcXm.setXmybj("0");
        hcxmService.createGtzdYdqcHcxm(swHcXm, zdList);
        return result;
    }

    @RequestMapping("sytz")
    public String sytz(Model model,Pageable request,String proid) {
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String djh = hcxmService.getHcxmBdIdByWiid(proid);
        String jpql = "from SwDjSy o where o.zd.djh =?0 and (o.syzt is null or o.syzt='1') ";
        List<SwDjSy> swdjSyList = baseRepository.getByJpql(jpql,djh);
        List<SwDjSyTemp> swDjSyTempList =  ydqcService.findSytzByProid(proid);
        String[] swDjSyTempIdArr = new String[swDjSyTempList.size()];

        for(int i=0;i<swDjSyTempList.size();i++){
            swDjSyTempIdArr[i] = swDjSyTempList.get(i).getSyId();
        }
        for(int j=0;j<swdjSyList.size();j++){
            if(!CommonUtil.isIn(swdjSyList.get(j).getSyId(),swDjSyTempIdArr)){
                SwDjSy swDjSy = baseRepository.get(SwDjSy.class,swdjSyList.get(j).getSyId());
                hcxmService.saveSwDjHisZdYdqc(swDjSy, proid, swHcXmRwRel.getSwHcXm().getCjrId(), Czlx.UPDATE.toString());
            }
        }
        swDjSyTempList =  ydqcService.findSytzByProid(proid);
        model.addAttribute("swDjSyTempList",swDjSyTempList);
        model.addAttribute("proid",proid);

        Zd zd = zdService.findZdByDjh(djh);
        if(zd==null){
            zd = new Zd();
        }

        model.addAttribute("zd",zd);
        return "landtax/ydqc/zd/SyxxTz";

    }

    @RequestMapping("/syxx/save")
    @ResponseBody
    public Object saveSyxx(Model model,SwDjSyTemp swDjSyTemp,String rwid) {
        String syId = swDjSyTemp.getSyId();
        if(StringUtils.isBlank(syId)){
            syId = UUIDGenerator.generate();
        }
        SwDjSyTemp tempVo = swdjSyTempService.getswDjSyTempBySyIdAndRwid(syId,rwid);
        if(tempVo!=null){

        }else{

        }
        String proid = tempVo.getProid();
        swDjSyTemp.setRwid(rwid);
        swDjSyTemp.setProid(proid);
        String djh = swDjSyTemp.getDjh();
        Zd zd = zdService.findZdByDjh(djh);
        swDjSyTemp.setTdyt(zd.getTdyt());
        swDjSyTemp.setQlrmc(zd.getQlrmc());
        swDjSyTemp.setScmjZd(zd.getScmjZd());
        swdjSyTempService.updateSwDjSyTemp(swDjSyTemp);
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg("保存成功");
        return vo;

    }

    @RequestMapping("syxx")
    public String sytz(Model model,Pageable request,String rwid,String syId,String djh,String proid) throws  Exception{
        if(syId!=null && rwid!=null){
            SwDjSyTemp tempVo = swdjSyTempService.getswDjSyTempBySyIdAndRwid(syId,rwid);
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            BeanUtils.copyProperties(tempVo, swDjSyQuery);

            //设置征管系统应交额与欠缴额
            String glbm = swDjSyQuery.getGlbm();
            if(StringUtils.isNotBlank(glbm)){
                swDjSyQuery =  taxService.setZgxtSet(glbm,swDjSyQuery);
            }
            model.addAttribute("syxx",swDjSyQuery);
            if (StringUtils.isEmpty(djh)) {
                djh = tempVo.getDjh();
            }
        }

        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);
        model.addAttribute("proid",proid);
        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByDjhLike(djh);
        model.addAttribute("tddjList",tddjList);
        return "landtax/ydqc/zd/syxxMenu";

    }

    /**
     * 工作流办结事件
     * @param model
     * @param proid
     * @return
     * @throws Exception
     */
    @RequestMapping("/wf/end")
    @ResponseBody
    public String wfEnd(Model model,String proid) throws  Exception{
       ydqcService.zdYdqcWfEnd(proid);
       return "";
    }

    /**
     * 工作流删除事件
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("/wf/del")
    @ResponseBody
    public String wfDel(Model model,String proid) {
        ydqcService.zdYdqcWfDel(proid);
        return "";
    }


    @RequestMapping("exportExcelTz")
    public String exportExcelTz(ZdQuery zdQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("zdQuery",zdQuery);
            }
            List<Object> zdydqcTzList = ydqcService.getZdydqcTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdydqcTzList.size();i++){
                String[] tempArr = new String[8];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdydqcTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdYdqc.xls"); //
            eb.setExcelXml("zdYdqc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("zdydCbd")
    public String zdydCbd(Model model,String proid){
        String djh = hcxmService.getHcxmBdIdByWiid(proid);
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);

        BigDecimal beforeSumScmj = new BigDecimal(0);
        BigDecimal afterSumScmj = new BigDecimal(0);


        List<SwDjSyTemp> swDjSyTempList = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            afterSumScmj = afterSumScmj.add(swDjSyTemp.getScmj()==null?new BigDecimal(0):swDjSyTemp.getScmj());
        }
        beforeSumScmj = taxService.getSumScmjByDjh(djh);
        model.addAttribute("beforeSumScmj",beforeSumScmj);
        model.addAttribute("afterSumScmj",afterSumScmj);

        model.addAttribute("proid",proid);

        return "landtax/ydqc/zd/zdyd_cbd";
    }
    @RequestMapping("exportZdydTzJson")
    public void exportZdydTzJson(Model model,HttpServletResponse response,HttpServletRequest request){
        String filePath = request.getSession().getServletContext().getRealPath("/")+"\\static\\excel\\template\\common.xls";
        Integer flag = 0;
        Integer hs = 0;//记录行数

        try{
            WritableWorkbook wwb = Workbook.createWorkbook(new File(filePath));
            WritableSheet ws = wwb.createSheet("sheet1", 0);
            ws.setColumnView(0, 50);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 20);
            ws.setColumnView(3, 20);
            ws.setColumnView(4, 20);
            ws.getSettings().setDefaultRowHeight(400);

            //设置字体大小与单元格样式
            WritableFont titleFont = new WritableFont(WritableFont.createFont("宋体"), 18, WritableFont.BOLD);
            WritableCellFormat titleFormat = new jxl.write.WritableCellFormat(titleFont);
            titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            titleFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont contentFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat contentFormat = new jxl.write.WritableCellFormat(contentFont);
            contentFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            contentFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont nameFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat nameFormat = new jxl.write.WritableCellFormat(nameFont);
            nameFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            nameFormat.setAlignment(Alignment.LEFT); // 水平对齐


            ws.mergeCells(0, 0, 4, 0); // 合并标题单元格

            Label excelLabel1 = new Label(0, 0, "国土宗地核查疑点",titleFormat);
            ws.addCell(excelLabel1);

            //设置表头
            Label excelLabel21 = new Label(0,1,"区县",titleFormat);
            Label excelLabel22 = new Label(1,1,"疑点总数",titleFormat);
            Label excelLabel23 = new Label(2,1,"下发疑点数",titleFormat);
            Label excelLabel24 = new Label(3,1,"未下发疑点数",titleFormat);
            Label excelLabel25 = new Label(4,1,"下发率（%）",titleFormat);
            ws.addCell(excelLabel21);
            ws.addCell(excelLabel22);
            ws.addCell(excelLabel23);
            ws.addCell(excelLabel24);
            ws.addCell(excelLabel25);

            //设置内容

            String listJson = ydqcService.getZdydTzListJson();
            String[] columnArr = new String[]{"name","zs","yxf","wxf","xfl"};
            List list = Arrays.asList(columnArr);
            PrintTjtzExcelUtil.printTjtzExcel(list, listJson, ws, flag, hs, contentFormat, nameFormat, wwb, response, filePath);

            model.addAttribute("FileDownLoadURL",filePath);

        }catch (Exception e){

        }
    }
    @RequestMapping("exportExcelYxfTz")
    public String exportExcelYxfTz(ZdQuery zdQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("zdQuery",zdQuery);
            }
            List<Object> zdydqcTzList = ydqcService.getZdYxfTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdydqcTzList.size();i++){
                String[] tempArr = new String[8];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdydqcTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdYdqc.xls"); //
            eb.setExcelXml("zdYdqc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
}
