package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Szdm;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.print.PrintTjtzExcelUtil;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.VerticalAlignment;
import jxl.write.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Controller
@RequestMapping("/tj/hcjd")
public class HcjdController {
    @Autowired
    HcxmService hcxmService;
    @Autowired
    ZdhcService zdhcService;
    @Autowired
    GdhcService gdhcService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    BphcService bphcService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping("")
    public String tj(Model model, String hcxmlx, String queryYear, String querystartRq, String queryEndRq){
        addSqAttribute(model, hcxmlx);

        if (StringUtils.isNotEmpty(queryYear)) {
            model.addAttribute("queryYear", queryYear);
            model.addAttribute("querystartRq", querystartRq);
            model.addAttribute("queryEndRq", queryEndRq);
        }
        model.addAttribute("hcxmlx",hcxmlx);
        return "landtax/tj/hcjd/hcjd";
    }

    /**
     * 查询征收疑点核查进度
     * @param model
     * @param hcxmlx 征收疑点的核查项目类型
     * @param ssnf 所属年份
     * @param sssq 所属属期
     * @return
     */
    @RequestMapping("hcjdJson")
    @ResponseBody
    public Object zdydqcJson(Model model,String hcxmlx, String ssnf, String sssq){
        String result = hcxmService.getHcjd(hcxmlx, null, ssnf, sssq);
        return result;
    }

    @RequestMapping("syncHcjd")
    public String syncHcjd(Model model,String hcxmlx){
        model.addAttribute("hcxmlx",hcxmlx);
        return "landtax/tj/hcjd/syncHcjd";
    }

    @RequestMapping("syncHcjdRootJson")
    @ResponseBody
    public Object syncHcjdRootJson(Model model,String hcxmlx,String id){
        Object obj = hcxmService.syncHcjdRootJson(hcxmlx,id);
        return obj;
    }

    @RequestMapping("zdhctz")
    public String zdhctz(Model model){
        return "landtax/tj/hcjd/HctzZd";
    }

    @RequestMapping("zdhctzRootJson")
    @ResponseBody
    public Object zdhctzRootJson(Model model,String id){
        Object obj = hcxmService.syncHctzZdRootJson(id);
        return obj;
    }

    @RequestMapping("swhctz")
    public String swhctz(Model model){
        return "landtax/tj/hcjd/HctzSw";
    }

    @RequestMapping("swhctzRootJson")
    @ResponseBody
    public Object swhctzRootJson(Model model,String id){
        Object obj = hcxmService.syncHctzSwRootJson(id);
        return obj;
    }

    //处理进度
    @RequestMapping("cljd")
    public String cljd(Model model, String hcxmlx , String queryYear, String querystartRq, String queryEndRq){
        addSqAttribute(model, hcxmlx);

        if (StringUtils.isNotEmpty(queryYear)) {
            model.addAttribute("queryYear", queryYear);
            model.addAttribute("querystartRq", querystartRq);
            model.addAttribute("queryEndRq", queryEndRq);
        }

        model.addAttribute("hcxmlx",hcxmlx);
        return "landtax/tj/hcjd/cljd";
    }

    /**
     * 查询征收疑点处理进度
     * @param model
     * @param hcxmlx 征收疑点的核查项目类型
     * @param ssnf 所属年份
     * @param sssq 所属属期
     * @return
     */
    @RequestMapping("cljdJson")
    @ResponseBody
    public Object cljdJson(Model model,String hcxmlx, String ssnf, String sssq){
        String result = hcxmService.getCljd(hcxmlx, null, ssnf, sssq);
        return result;
    }

    @RequestMapping("hcjdDetail")
    public String hcjdDetail(Model model,String xzqdm,String hcxmlx,String jdlx) throws  Exception{
        model.addAttribute("xzqdm",xzqdm);
        model.addAttribute("hcxmlx",hcxmlx);
        model.addAttribute("jdlx",jdlx);
        if(StringUtils.isNotBlank(hcxmlx)){
            if(Hcxmlx.ZDHC.toString().equals(hcxmlx))
                return "landtax/tj/hcjd/zdhcHcjdDetail";
            else if(Hcxmlx.GDHC.toString().equals(hcxmlx)){
                //获取所有区县信息
                List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
                model.addAttribute("allQxList",allQxList);
                return "landtax/tj/hcjd/gdhcHcjdDetail";
            }else if(Hcxmlx.BPHC.toString().equals(hcxmlx)){
                //获取所有区县信息
                List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
                model.addAttribute("allQxList",allQxList);
                return "landtax/tj/hcjd/bphcHcjdDetail";
            }

        }
        return null;
    }

    @RequestMapping("hcjdDetailZdhcJson")
    @ResponseBody
    public Object hcjdDetailZdhcJson(Model model,String xzqdm,String jdlx,Pageable pageable,GtSwTzQuery sSjGtbd){
        return hcxmService.getHcjdDetailZdhc(xzqdm,jdlx,pageable,sSjGtbd);

    }
    @RequestMapping("hcjdDetailGdhcJson")
    @ResponseBody
    public Object hcjdDetailGdhcJson(Model model,String xzqdm,String jdlx,Pageable pageable,SwDjQsQuery swDjQsQuery){
        return hcxmService.getHcjdDetailGdhc(xzqdm, jdlx, pageable, swDjQsQuery);

    }
    @RequestMapping("hcjdDetailBphcJson")
    @ResponseBody
    public Object hcjdDetailBphcJson(Model model,String xzqdm,String jdlx,Pageable pageable,GdzysQuery gdzysQuery){
        return hcxmService.getHcjdDetailBphc(xzqdm, jdlx, pageable, gdzysQuery);

    }

    @RequestMapping("zdhc/getTJrws")
    @ResponseBody
    public Object getZdhcTJrws(String xzqdm,String jdlx ,GtSwTzQuery sSjGtbd) throws Exception{
        Object obj = hcxmService.getZdhcTJrws(xzqdm,jdlx,sSjGtbd);
        return obj;
    }

    @RequestMapping("gdhc/getTJrws")
    @ResponseBody
    public Object getGdhcTJrws(String xzqdm,String jdlx ,SwDjQsQuery swDjQsQuery) throws Exception{
        Object obj = hcxmService.getGdhcTJrws(xzqdm,jdlx,swDjQsQuery);
        return obj;
    }

    @RequestMapping("bphc/getTJrws")
    @ResponseBody
    public Object getBphcTJrws(String xzqdm,String jdlx ,GdzysQuery gdzysQuery) throws Exception{
        Object obj = hcxmService.getBphcTJrws(xzqdm, jdlx, gdzysQuery);
        return obj;
    }

    @RequestMapping("gdhc/exportExcelTz")
    public String exportExcelTzGdhc(String xzqdm,String jdlx, SwDjQsQuery swDjQsQuery,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出

            List<HashMap> whcGdList = hcxmService.getHcjdDetailGdhcList(xzqdm, jdlx, swDjQsQuery);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = swDjQsQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(whcGdList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                HashMap tempMap = whcGdList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = String.valueOf(tempMap.get("XMMC")==null?"":tempMap.get("XMMC"));
                tempArr[2] = String.valueOf(tempMap.get("YDDW") == null ? "" : tempMap.get("YDDW"));
                tempArr[3] = new BigDecimal(String.valueOf(tempMap.get("GDMJ")==null?"0":tempMap.get("GDMJ"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[4] = new BigDecimal(String.valueOf(tempMap.get("QDJG")==null?"0":tempMap.get("QDJG"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[5] = tempMap.get("GDSJ")==null?"":new SimpleDateFormat("yyyy-MM-dd").format(tempMap.get("GDSJ"));
                //根据gtbdId获取任务节点
                String statue = String.valueOf(((HashMap)gdhcService.getZtByXmId(String.valueOf(tempMap.get("XM_ID")))).get("statue"));
                String userName = String.valueOf(((HashMap) gdhcService.getZtByXmId(String.valueOf(tempMap.get("XM_ID")))).get("userName"));
                if("0".equals(statue)){
                    tempArr[6] = "未下发";
                }else if("1".equals(statue)){
                    tempArr[6] = "市局下发";
                }else if("2".equals(statue)){
                    tempArr[6] = "县级管理员任务分派";
                }else if("3".equals(statue)){
                    tempArr[6] = "核查组长分派任务";
                }else if("4".equals(statue)){
                    tempArr[6] = "税务人员核查";
                }else if("5".equals(statue)){
                    tempArr[6] = "核查组长确认入库";
                }else if("6".equals(statue)){
                    tempArr[6] = "已办结";
                }
                tempArr[7] = userName;
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("gdhcTz.xls"); //
            eb.setExcelXml("gdhcTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("zdhc/exportExcelTz")
    public String exportExcelTzZdhc(String xzqdm,String jdlx,GtSwTzQuery sSjGtbd,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出

            List<HashMap> whczdList = hcxmService.getHcjdDetailZdhcList(xzqdm,jdlx,sSjGtbd);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = sSjGtbd.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(whczdList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                HashMap tempMap = whczdList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = String.valueOf(tempMap.get("DJH")==null?"":tempMap.get("DJH"));
                tempArr[2] = new BigDecimal(String.valueOf(tempMap.get("SCMJ") == null ? "0" : tempMap.get("SCMJ"))).setScale(2, BigDecimal.ROUND_DOWN).toString();
                tempArr[3] = String.valueOf(tempMap.get("TDYTMC")==null?"":tempMap.get("TDYTMC"));
                tempArr[4] = String.valueOf(tempMap.get("TDZL") == null ? "" : tempMap.get("TDZL"));
                tempArr[5] = String.valueOf(tempMap.get("QLRMC") == null ? "" : tempMap.get("QLRMC"));
                //根据gtbdId获取任务节点
                String statue = String.valueOf(((HashMap)zdhcService.getZtByGtbdId(String.valueOf(tempMap.get("GTBD_ID")))).get("statue"));
                String userName = String.valueOf(((HashMap) zdhcService.getZtByGtbdId(String.valueOf(tempMap.get("GTBD_ID")))).get("userName"));
                if("0".equals(statue)){
                    tempArr[6] = "未下发";
                }else if("1".equals(statue)){
                    tempArr[6] = "市局下发";
                }else if("2".equals(statue)){
                    tempArr[6] = "县级管理员任务分派";
                }else if("3".equals(statue)){
                    tempArr[6] = "核查组长分派任务";
                }else if("4".equals(statue)){
                    tempArr[6] = "税务人员核查";
                }else if("5".equals(statue)){
                    tempArr[6] = "核查组长确认入库";
                }else if("6".equals(statue)){
                    tempArr[6] = "已办结";
                }
                tempArr[7] = userName;
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("wppzdTz.xls"); //
            eb.setExcelXml("wppzdTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("bphc/exportExcelTz")
    public String exportExcelTzBphc(String xzqdm,String jdlx, GdzysQuery gdzysQuery,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出

            List<HashMap> whcBpList = hcxmService.getHcjdDetailBphcList(xzqdm, jdlx, gdzysQuery);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = gdzysQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(whcBpList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[12];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                HashMap tempMap = whcBpList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = tempMap.get("PCMC")==null?"":String.valueOf(tempMap.get("PCMC"));
                tempArr[2] = tempMap.get("YDDW")==null?"":String.valueOf(tempMap.get("YDDW"));
                tempArr[3] = new BigDecimal(String.valueOf(tempMap.get("GDMJ")==null?"0":tempMap.get("GDMJ"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[4] = new BigDecimal(String.valueOf(tempMap.get("FGDNYDMJ")==null?"0":tempMap.get("FGDNYDMJ"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[5] = new BigDecimal(String.valueOf(tempMap.get("JBNTMJ")==null?"0":tempMap.get("JBNTMJ"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[6] = new BigDecimal(String.valueOf(tempMap.get("NYDMJ")==null?"0":tempMap.get("NYDMJ"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[7] = new BigDecimal(String.valueOf(tempMap.get("PZMJ")==null?"0":tempMap.get("PZMJ"))).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[8] = tempMap.get("PZSJ")==null?"":new SimpleDateFormat("yyyy-MM-dd").format(tempMap.get("PZSJ"));
                //根据pcId获取任务节点
                String statue = String.valueOf(((HashMap)bphcService.getZtByPcId(String.valueOf(tempMap.get("PC_ID")))).get("statue"));
                String userName = String.valueOf(((HashMap) bphcService.getZtByPcId(String.valueOf(tempMap.get("PC_ID")))).get("userName"));
                if("0".equals(statue)){
                    tempArr[9] = "未下发";
                }else if("1".equals(statue)){
                    tempArr[9] = "市局下发";
                }else if("2".equals(statue)){
                    tempArr[9] = "县级管理员任务分派";
                }else if("3".equals(statue)){
                    tempArr[9] = "核查组长分派任务";
                }else if("4".equals(statue)){
                    tempArr[9] = "税务人员核查";
                }else if("5".equals(statue)){
                    tempArr[9] = "核查组长确认入库";
                }else if("6".equals(statue)){
                    tempArr[9] = "已办结";
                }
                tempArr[10] = userName;
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("bphcTz.xls"); //
            eb.setExcelXml("bphcTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    /**
     * 导出征收疑点核查进度
     * @param model
     * @param response
     * @param request
     * @param xzq 导出的单位代码
     * @param hcxmlx 征收疑点的核查项目类型
     * @param ssnf 所属年份
     * @param sssq 所属属期
     */
    @RequestMapping("exportHcjdJson")
    public void exportHcjdJson(Model model,HttpServletResponse response,HttpServletRequest request,String xzq,String hcxmlx, String ssnf, String sssq){
        String filePath = request.getSession().getServletContext().getRealPath("/")+"\\static\\excel\\template\\common.xls";
        Integer flag = 0;
        Integer hs = 0;//记录行数

        try{
            WritableWorkbook wwb = Workbook.createWorkbook(new File(filePath));
            WritableSheet ws = wwb.createSheet("sheet1", 0);
            ws.setColumnView(0, 50);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 20);
            ws.setColumnView(3, 30);
            ws.setColumnView(4, 30);
            ws.getSettings().setDefaultRowHeight(400);

            //设置字体大小与单元格样式
            WritableFont titleFont = new WritableFont(WritableFont.createFont("宋体"), 18, WritableFont.BOLD);
            WritableCellFormat titleFormat = new jxl.write.WritableCellFormat(titleFont);
            titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            titleFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont contentFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat contentFormat = new jxl.write.WritableCellFormat(contentFont);
            contentFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            contentFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont nameFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat nameFormat = new jxl.write.WritableCellFormat(nameFont);
            nameFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            nameFormat.setAlignment(Alignment.LEFT); // 水平对齐


            ws.mergeCells(0, 0, 5, 0);//合并行政区单元格
            //设置标题
            String hcxmLxMc = getExcelTitleByHcxmlx(hcxmlx);

            Label excelLabel1 = new Label(0, 0, hcxmLxMc+"完成进度",titleFormat);
            ws.addCell(excelLabel1);

            //设置表头
            Label excelLabel21 = new Label(0,1,"名称",titleFormat);
            Label excelLabel22 = new Label(1,1,"核查总数",titleFormat);
            Label excelLabel23 = new Label(2,1,"已处理",titleFormat);
            Label excelLabel24 = new Label(3,1,"未处理",titleFormat);
            Label excelLabel25 = new Label(4,1,"完成进度（%）",titleFormat);
            ws.addCell(excelLabel21);
            ws.addCell(excelLabel22);
            ws.addCell(excelLabel23);
            ws.addCell(excelLabel24);
            ws.addCell(excelLabel25);

            //设置内容

            String listJson = hcxmService.getHcjd(hcxmlx, null, ssnf, sssq);
            String[] columnArr = new String[]{"name","zs","ycl","wcl","cll"};
            List list = Arrays.asList(columnArr);
            PrintTjtzExcelUtil.printTjtzExcel(list, listJson, ws, flag, hs, contentFormat, nameFormat, wwb, response, filePath);

            model.addAttribute("FileDownLoadURL",filePath);

        }catch (Exception e){

        }
    }

    /**
     * 导出征收疑点处理进度
     * @param response
     * @param request
     * @param xzq 导出的单位代码
     * @param hcxmlx 征收疑点的核查项目类型
     * @param ssnf 所属年份
     * @param sssq 所属属期
     */
    @RequestMapping("exportCljdJson")
    public void exportCljdJson(HttpServletResponse response,HttpServletRequest request,String xzq,String hcxmlx, String ssnf, String sssq){
        String filePath = request.getSession().getServletContext().getRealPath("/")+"\\static\\excel\\template\\common.xls";
        Integer flag = 0;
        Integer hs = 0;//记录行数

        try{
            WritableWorkbook wwb = Workbook.createWorkbook(new File(filePath));
            WritableSheet ws = wwb.createSheet("sheet1", 0);
            ws.setColumnView(0, 50);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 20);
            ws.setColumnView(3, 30);
            ws.setColumnView(4, 30);
            ws.getSettings().setDefaultRowHeight(400);

            //设置字体大小与单元格样式
            WritableFont titleFont = new WritableFont(WritableFont.createFont("宋体"), 18, WritableFont.BOLD);
            WritableCellFormat titleFormat = new jxl.write.WritableCellFormat(titleFont);
            titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            titleFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont contentFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat contentFormat = new jxl.write.WritableCellFormat(contentFont);
            contentFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            contentFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont nameFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat nameFormat = new jxl.write.WritableCellFormat(nameFont);
            nameFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            nameFormat.setAlignment(Alignment.LEFT); // 水平对齐


            ws.mergeCells(0, 0, 5, 0);//合并行政区单元格
            //设置标题
            String hcxmLxMc = getExcelTitleByHcxmlx(hcxmlx);
            Label excelLabel1 = new Label(0, 0, hcxmLxMc+"处理进度",titleFormat);
            ws.addCell(excelLabel1);

            //设置表头
            Label excelLabel21 = new Label(0,1,"名称",titleFormat);
            Label excelLabel22 = new Label(1,1,"下发总数",titleFormat);
            Label excelLabel23 = new Label(2,1,"核查完成",titleFormat);
            Label excelLabel24 = new Label(3,1,"已审核",titleFormat);
            Label excelLabel25 = new Label(4,1,"处理进度（%）",titleFormat);
            ws.addCell(excelLabel21);
            ws.addCell(excelLabel22);
            ws.addCell(excelLabel23);
            ws.addCell(excelLabel24);
            ws.addCell(excelLabel25);

            //设置内容

            String listJson = hcxmService.getCljd(hcxmlx, null, ssnf, sssq);
            String[] columnArr = new String[]{"name","zs","yhcs","yshfjz","cll"};
            List list = Arrays.asList(columnArr);
            PrintTjtzExcelUtil.printTjtzExcel(list, listJson, ws, flag, hs, contentFormat, nameFormat, wwb, response, filePath);

        }catch (Exception e){

        }
    }

    /**
     * 获取导出Excel的标题
     * @param hcxmlx 征收疑点的核查项目类型
     * @return
     */
    private String getExcelTitleByHcxmlx(String hcxmlx){
        String hcxmLxMc = "";
        if (Hcxmlx.TDZSYDQC.toString().equals(hcxmlx)) {
            hcxmLxMc = "城镇土地使用税征收疑点核查";
        } else if(Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            hcxmLxMc = "房产税征收疑点核查";
        }
        return hcxmLxMc;
    }

    /**
     * 将当前所属年份所属属期加到model中
     * @param model
     * @param hcxmlx 征收疑点核查项目类型
     */
    private void addSqAttribute(Model model, String hcxmlx) {
        String szdm = Szdm.CZTDSYS.toString();
        int sqCount = 4;
        if (Hcxmlx.FCZSYDQC.toString().equals(hcxmlx)) {
            szdm = Szdm.FCS.toString();
            sqCount = 2;
        }

        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int sssq = Integer.valueOf(CommonUtil.getSssqByNow(szdm));
        if (sssq == 1) {
            sssq = sqCount;
            currentYear = currentYear - 1;
        } else {
            sssq = sssq - 1;
        }

        List<String> yearList = new ArrayList<String>();
        String minYear = "2014";
        for (int year = currentYear; year >= Integer.valueOf(minYear); year--) {
            yearList.add(String.valueOf(year));
        }
        model.addAttribute("yearList",yearList);
        model.addAttribute("sssq", String.valueOf(sssq));
        model.addAttribute("currentYear",String.valueOf(currentYear));
    }

    /**
     * 征收疑点详情
     * @param model
     * @param hcxmlx
     * @param xzqdm
     * @param xflx 下发类型，“0”或空为未下发，“1”为已下发
     * @param cllx 处理类型，“1”为未处理，“2”为已处理
     * @param ssnf
     * @param sssq
     * @return
     */
    @RequestMapping("wclYclTz")
    public String wclYclTz(Model model, String hcxmlx, String xzqdm, String xflx, String cllx, String ssnf, String sssq){
        model.addAttribute("hcxmlx", hcxmlx);
        model.addAttribute("xzqdm", xzqdm);
        model.addAttribute("cllx", cllx);//1表示未处理台帐，2表示已处理台帐
        model.addAttribute("xflx", xflx);//0表示已下发，1表示未下发
        model.addAttribute("ssnf", ssnf);
        model.addAttribute("sssq", sssq);

        String name = Hcxmlx.getMcByDm(hcxmlx);
        name = name + getCllxMc(cllx);

        model.addAttribute("name",name);

        return "landtax/tj/hcjd/wclYclTz";
    }

    /**
     * 获取征收疑点详情数据
     * @param model
     * @param pageable
     * @param hcxmlx
     * @param xzqdm
     * @param xflx 下发类型，“0”或空为未下发，“1”为已下发
     * @param cllx 处理类型，“1”为未处理，“2”为已处理
     * @param ssnf
     * @param sssq
     * @return
     */
    @RequestMapping("wclYclTzJson")
    @ResponseBody
    public Object wclYclTzJson(Model model,Pageable pageable, String hcxmlx,String xzqdm,String xflx, String cllx, String ssnf, String sssq){
        return hcxmService.getWclYclTzJson(pageable, hcxmlx,xzqdm, xflx, cllx, ssnf, sssq);
    }

    /**
     * 获取用户在任务中的taskid值
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("getTaskUrl")
    @ResponseBody
    public Object getTaskUrl(Model model,String proid){
        // 获取用户ID
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();

        String sql = "";
        Query query = null;

        // 根据任务某个节点的ID获取任务当前节点的ID
        sql = "SELECT USER_ID, ASSIGNMENT_ID, BEGIN_TIME, BJ, " +
                "       RANK() OVER(PARTITION BY USER_ID ORDER BY BEGIN_TIME DESC) AS YHPM, " +
                "       RANK() OVER(ORDER BY BEGIN_TIME DESC) AS JDPM " +
                "FROM ( " +
                "      SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, ASSIGNMENT_ID, 0 AS BJ " +
                "      FROM PF_ASSIGNMENT " +
                "      UNION " +
                "      SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, ASSIGNMENT_ID, 1 AS BJ " +
                "      FROM PF_ASSIGNMENTHISTORY " +
                "     ) t " +
                "WHERE t.ACTIVITY_ID IN ( " +
                "      SELECT ACTIVITY_ID " +
                "      FROM PF_ACTIVITY " +
                "      WHERE WORKFLOW_INSTANCE_ID='" + proid + "' " +
                "      ) ";
        sql = "SELECT * FROM (" + sql + ") WHERE USER_ID='" + userId + "' AND YHPM=1 AND ROWNUM=1 ";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String, Object>> list = query.getResultList();

        String url = "";
        String taskid = "";
        if (CollectionUtils.isNotEmpty(list)){  // 该用户对该流程已办理
            taskid = list.get(0).get("ASSIGNMENT_ID").toString();
            String jdpm = list.get(0).get("JDPM").toString();
            String bj = list.get(0).get("BJ").toString();
            if (jdpm.equals("1") && bj.equals("0")) {
                url = "taskhandle.action?taskid=" + taskid;
            } else {
                url = "taskoverhandle.action?taskid=" + taskid;
            }
        } else {  // 该用户未参与流程
            url = "";
        }

        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(url);
        return responseMessage;
    }

    /**
     * 导出征收疑点详情
     * @param model
     * @param response
     * @param request
     * @param hcxmlx
     * @param xzqdm
     * @param xflx 下发类型，“0”或空为未下发，“1”为已下发
     * @param cllx 处理类型，“1”为未处理，“2”为已处理
     * @param ssnf
     * @param sssq
     */
    @RequestMapping("exportWclYclJson")
    public void exportWclYclJson(Model model,HttpServletResponse response,HttpServletRequest request,String hcxmlx,String xzqdm,String xflx,String cllx, String ssnf, String sssq){
        String filePath = request.getSession().getServletContext().getRealPath("/")+"\\static\\excel\\template\\common.xls";
        Integer flag = 0;
        Integer hs = 0;//记录行数

        try{
            //设置字体大小与单元格样式
            WritableFont titleFont = new WritableFont(WritableFont.createFont("宋体"), 18, WritableFont.BOLD);
            WritableCellFormat titleFormat = new jxl.write.WritableCellFormat(titleFont);
            titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            titleFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont contentFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat contentFormat = new jxl.write.WritableCellFormat(contentFont);
            contentFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            contentFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont nameFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat nameFormat = new jxl.write.WritableCellFormat(nameFont);
            nameFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            nameFormat.setAlignment(Alignment.LEFT); // 水平对齐

            WritableWorkbook wwb = Workbook.createWorkbook(new File(filePath));
            WritableSheet ws = wwb.createSheet("sheet1", 0);

            //标题
            String titleName = Hcxmlx.getMcByDm(hcxmlx);
            if(StringUtils.isNotBlank(cllx) && "1".equals(cllx)){
                titleName = titleName + "未处理任务详情";
            }else if(StringUtils.isNotBlank(cllx) && "2".equals(cllx)){
                titleName = titleName + "已处理任务详情";
            }

            String[] fieldName = null;
            String[] fieldValue = null;
            if (hcxmlx.equals("1") || hcxmlx.equals("4")) {
                fieldName = new String[]{"DJH","QLRMC","TDYT_MC","SCMJ","TDZL","SSQX","SSFJ","SSSGY"};
                fieldValue = new String[]{"地籍号","权利人名称","土地用途","国土宗地面积","土地坐落","任务所属区县","任务所属分局","任务办理人员"};
            } else if (hcxmlx.equals("2") || hcxmlx.equals("3")) {
                fieldName = new String[]{"GLBM","NSRMC","ZGKG_MC","NYNSE","SSQX","SSFJ","SSSGY"};
                fieldValue = new String[]{"管理代码","纳税人名称","主管税务机关","年应纳税额","任务所属区县","任务所属分局","任务办理人员"};
            } else if (hcxmlx.equals("7") || hcxmlx.equals("8")) {
                fieldName = new String[]{"GLBM","NSRMC","ZGKG_MC","NYNSE","RKSE","CYJE","CYBL","SSQX","SSFJ","SSSGY"};
                fieldValue = new String[]{"管理代码","纳税人名称","主管税务机关","年应纳税额","入库税额","差异金额","少申报比例","任务所属区县","任务所属分局","任务办理人员"};
            } else {
                fieldName = new String[]{};
                fieldValue = new String[]{};
            };

            // 初始化列
            for (int i=0; i<fieldName.length; i++) {
                ws.setColumnView(i, 40);
            }
            ws.getSettings().setDefaultRowHeight(400);

            // 标题
            ws.mergeCells(0, 0, fieldName.length - 1, 0);//合并行政区单元格
            Label excelLabel1 = new Label(0, 0, titleName, titleFormat);
            ws.addCell(excelLabel1);


            //设置表头
            for (int i=0; i<fieldValue.length; i++) {
                ws.addCell(new Label(i, 1, fieldValue[i], titleFormat));
            }

            //设置内容
            List<HashMap<String, Object>> listResult = hcxmService.getWclYclTzExportJson(hcxmlx, xzqdm, xflx, cllx, ssnf, sssq);
            String listJson = "";
            String value = "";
            listJson += "[";
            for (int row=0; row<listResult.size(); row++){
                listJson += "{";
                for (int col=0; col<fieldName.length; col++) {
                    value = "";
                    if (listResult.get(row).get(fieldName[col]) != null)
                        value = listResult.get(row).get(fieldName[col]).toString();
                    if (value == null || value.equals("null"))
                        value = "";
                    listJson += "\"" + fieldName[col] + "\":" + "\"" + value + "\"";
                    if (col != (fieldName.length - 1))
                        listJson += ",";
                }
                listJson += "}";
            }
            listJson += "]";

            List list = Arrays.asList(fieldName);
            PrintTjtzExcelUtil.printTjtzExcel(list, listJson, ws, flag, hs, contentFormat, nameFormat, wwb, response, filePath);

            model.addAttribute("FileDownLoadURL",filePath);

        }catch (Exception e){

        }
    }

    /**
     * cllx对应的名称
     * @param cllx
     * @return
     */
    private String getCllxMc(String cllx) {
        String mc = "";
        if (StringUtils.isEmpty(cllx)) {
            mc = "";
        } else if (cllx.equals("0")) {
            mc = "任务详情";
        } else if (cllx.equals("1")) {
            mc = "未处理任务详情";
        } else if (cllx.equals("2")) {
            mc = "已处理任务详情";
        } else if (cllx.equals("3")) {
            mc = "已核查任务详情";
        } else if (cllx.equals("4")) {
            mc = "已审核任务详情";
        }

        return mc;
    }
}
