package cn.gtmap.landtax.web.syhc;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.GtDjTzQuery;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.TddjtzService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * .
 * <p/>
 * 国土宗地匹配台账
 * @author yang
 * @version V1.0, 14-7-7
 */
@Controller
@RequestMapping("tddjtz")
public class TddjtzController {
    @Autowired
    TddjtzService tddjtzService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    /**
     * 已匹配列表
     * @param model
     * @param xzq
     * @return
     */
    @RequestMapping("tddjypp")
    public String   tddjypp(Model model,String xzq){
        model.addAttribute("xzq",xzq);
        return "landtax/syhc/zdpptz/gtdjsjypp";
    }

    /**
     * 未匹配列表
     * @param model
     * @param xzq
     * @return
     */
    @RequestMapping("tddjwpp")
    public String   tddjwpp(Model model,String xzq){
        model.addAttribute("xzq",xzq);
        return "landtax/syhc/zdpptz/gtdjsjwpp";
    }


    //国土宗地匹配台账
    @RequestMapping("tz")
    public String   test(Model model){
        return  "landtax/syhc/zdpptz/gtdjtz";
    }

    //未匹配税源处理情况
    @RequestMapping("projecttz")
    public String   projecttz(Model model){
        return "landtax/syhc/zdpptz/gtdjprojecttz";
    }

    @RequestMapping("projecttzJson")
    @ResponseBody
    public Object projectTzJson(Model model,String xzq){
         return tddjtzService.getProjectGttzJson(xzq, new StringBuffer());
    }

    @RequestMapping("tzJson")
    @ResponseBody
    public Object getTz(Model model,String xzq){
          return tddjtzService.getTddjtzJson(xzq,new StringBuffer());
    }

    @RequestMapping("ppxxJson")
    @ResponseBody
    public Page<GtSwTzQuery> getGtdjSy(Model model,String xzqbh,String lx,Pageable request,GtSwTzQuery sSjGtbd) {
        model.addAttribute("xzq",xzqbh);
        Page<GtSwTzQuery> sjSwbdPage =tddjtzService.findGtppxxMap(xzqbh, lx, request, sSjGtbd);
        return sjSwbdPage;

    }

    @RequestMapping("wpphcJson")
    @ResponseBody
    public Page<GtSwTzQuery> getGtdjwpphc(Model model,String xzqbh,String lx,Pageable request,GtSwTzQuery sSjGtbd) {
        Page<GtSwTzQuery> sjSwbdPage =tddjtzService.findGtppxxMap(xzqbh, lx, request, sSjGtbd);
        return sjSwbdPage;

    }


    @RequestMapping("wppxxJsonProject")
    @ResponseBody
    public List<SSjGtbd>  wppxxJsonProject(Model model,Pageable pageable,String proid) {
        List<SSjGtbd> sSjGtbdTemps =tddjtzService.findWppxxJsonProject(pageable,proid);
        return sSjGtbdTemps;
    }

    /**
     * 宗地核查项目（工作流项目）删除处理方法
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("delproject")
    @ResponseBody
    public Object delProject(Model model,String proid){
        if(StringUtils.isNotBlank(proid))
            tddjtzService.delGtbdProject(proid);
        return null;
    }



    @RequestMapping("hcjd")
    public String hcjd(Model model,String hcxmId){
        SwHcXm swHcXm = baseRepository.get(SwHcXm.class,hcxmId);
        model.addAttribute("hcxmId",hcxmId);
        return "landtax/tj/ydqc/xmhcjd";
    }
    @RequestMapping("hcjdJson")
    @ResponseBody
    public Object zdydqcJson(Model model,String xzq,String hcxmId){
        String result = hcxmService.getHcjd(xzq, hcxmId, null, null);
        return result;
    }


}
