package cn.gtmap.landtax.web.syhc;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Dldm;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.SwdjtzService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.util.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 税源登记匹配台账
 * <p/>
 *
 * @author yang
 * @version V1.0, 14-7-5
 */
@Controller
@RequestMapping("/swdjtz")
public class SwdjtzController {
    @Autowired
    SwdjtzService swdjtzService;
    @Autowired
    ZdService zdService;
    @Autowired
    TaxService taxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;

    //未匹配走流程列表
    @RequestMapping("")
    public String   swdjwpplist(Model model,String xzq){
        return "landtax/syhc/sypptz/swdjwpplist";
    }

    @RequestMapping("swdjYxfList")
    public String   swdjYxfList(Model model){
        return "landtax/syhc/sypptz/swdjYxfList";
    }

    //税源已匹配列表
    @RequestMapping("swdjsjypp")
    public String   swdjypp(Model model,String xzq,String lx){
        model.addAttribute("xzq",xzq);
        model.addAttribute("lx",lx);
        return "landtax/syhc/sypptz/swdjsjypp";
    }
    //税源未匹配列表
    @RequestMapping("swdjsjwpp")
    public String   swdjwpp(Model model,String xzq,String lx){
        model.addAttribute("xzq",xzq);
        model.addAttribute("lx",lx);
        return "landtax/syhc/sypptz/swdjsjwpp";
    }

    @RequestMapping("sydj")
    public String getSydj(){
        return  "landtax/syhc/swdjsjNew";
    }
     //匹配登记台账
    @RequestMapping("tz")
    public String   tz(Model model,String lx){
        if (lx.equals("1")){
            return "landtax/syhc/sypptz/swdjtz";
        }else if(lx.equals("2")){
            return "landtax/syhc/sypptz/swdjtzFc";
        }
        return "" ;
    }


    //匹配登记台账
    @RequestMapping("projecttz")
    public String   projecttz(Model model){
        return "landtax/syhc/sypptz/swdjprojecttz";
    }

    @RequestMapping("projecttzJson")
    @ResponseBody
    public Object projectTzJson(Model model,String xzq){
        return swdjtzService.getProjectSwtzJson(xzq, new StringBuffer());
    }

    @RequestMapping("tzJson")
    @ResponseBody
    public Object getTz(Model model,String xzq,String lx){
        //土地税务登记台帐统计
          return swdjtzService.getSwtzJson(xzq,new StringBuffer(),lx);
    }


    @RequestMapping("ppxxJson")
    @ResponseBody
    public Page<SSjSwbd> getSwdjSy(Model model,String xzqbh,String lx,String lxs,Pageable request,SwDjSyQuery swDjSyQuery) {
        Sylx sylx=null;
        if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
            sylx=Sylx.TDSY;
        else
            sylx = Sylx.FCSY;
        model.addAttribute("xzq",xzqbh);
        Page<SSjSwbd> sjSwbdPage = swdjtzService.findSyppxxMap(xzqbh,lx,request,swDjSyQuery,sylx);
        return sjSwbdPage;

    }

    @RequestMapping("wppJson")
    @ResponseBody
    public Page<SSjSwbd> getSwdjSyWpp(Model model,String xzqbh,String lxs,Pageable request,SwDjSyQuery swDjSyQuery) {
        Sylx sylx=null;
        if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
            sylx=Sylx.TDSY;
        else
            sylx = Sylx.FCSY;
        model.addAttribute("xzq",xzqbh);
        Page<SSjSwbd> sjSwbdPage =swdjtzService.findWppSyMap(xzqbh,request,swDjSyQuery,sylx);
        return sjSwbdPage;
    }

    @RequestMapping("yxfJson")
    @ResponseBody
    public Page<SSjSwbd> yxfJson(Model model,String lxs,Pageable pageable,SwDjSyQuery swDjSyQuery) {
        Sylx sylx=null;
        if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
            sylx=Sylx.TDSY;
        else
            sylx = Sylx.FCSY;
        Page<SSjSwbd> sjSwbdPage =swdjtzService.findYxfSyMap(pageable,swDjSyQuery,sylx);
        return sjSwbdPage;
    }


    @RequestMapping("exportExcelTz")
    public String exportExcelTz(String xzqbh,String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {

            HashMap param = new HashMap();
            param.put("xzqbh",xzqbh);
            param.put("sylx",sylx);

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            List<GtSwTzQuery> swdjTzList = swdjtzService.getSwdjTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<swdjTzList.size();i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                GtSwTzQuery gtSwTzQuery = swdjTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                tempArr[1] = gtSwTzQuery.getGlbm();
                tempArr[2] = gtSwTzQuery.getDjh();
                tempArr[3] = String.valueOf(gtSwTzQuery.getScmj() == null ? "" : gtSwTzQuery.getScmj());
                tempArr[4] = gtSwTzQuery.getNsrmc();
                tempArr[5] = gtSwTzQuery.getZgjgMc();
                tempArr[6] = gtSwTzQuery.getGlyMc();
                tempArr[7] = String.valueOf(gtSwTzQuery.getTdnynse());
                tempArr[8] = String.valueOf(gtSwTzQuery.getFcnynse());
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("swdjtz.xls"); //
            eb.setExcelXml("swdjtz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("save")
    @ResponseBody
    public String getSwdjSave(Model model,String json) {

        String mess = swdjtzService.saveListJson(json);
        return mess ;
    }

    @RequestMapping("saveDjh")
    @ResponseBody
    public Object saveDjh(Model model,String djh,String tdId,String fcId,String dbh) {

        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg("保存成功");
        try{
            //判断djh是否存在
            Zd zd = zdService.findZdByDjh(djh);
            if(zd==null){
                responseMessage.setMsg("您输入的地籍号不存在，请核查!");
            }else{
                swdjtzService.saveDjh(djh,tdId,fcId,dbh);
            }
        }catch(Exception e){
            e.printStackTrace();
            responseMessage.setMsg("保存失败");
        }
        return responseMessage;

    }


    @RequestMapping("wppxxJsonProject")
    @ResponseBody
    public List<SSjSwbd>  wppxxJsonProject(Model model,Pageable pageable,String proid) {
        List<SSjSwbd> sjSwbdPage =swdjtzService.findWppxxJsonProject(pageable,proid);
        return sjSwbdPage;
    }

    /*
    @RequestMapping("wppProjectList")
    public String   wppProjectList(Model model,String xzq,String proid){
        System.out.println(proid);
        model.addAttribute("proid",proid);
        return "landtax/syhc/sypptz/swWppProjectList";
    }
    */

    @RequestMapping("wppProject")
    public String   wppProject(Model model,String xzq,String proid){
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
        String bdId = swHcXmRwRel.getBdId();

        SwDjTdWbd swDjTdWbd = baseRepository.get(SwDjTdWbd.class, bdId);
        model.addAttribute("swDjTdWbd",swDjTdWbd);

//        SwDjFcWbd swDjFcWbd = baseRepository.get(SwDjFcWbd.class, bdId);
//        model.addAttribute("swDjFcWbd", swDjFcWbd);

        String djh = "";
        if(swDjTdWbd!=null){
            djh = swDjTdWbd.getDjh();
        }
//        else if(swDjFcWbd!=null){
//            djh = swDjFcWbd.getDjh();
//        }
        if(StringUtils.isNotBlank(djh)){
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
        }

        model.addAttribute("proid",proid);
        return "landtax/syhc/sypptz/swWppProject";
    }

    @RequestMapping("getprojectInform")
    @ResponseBody
    public Object getProjectInform(){
        Project project = swdjtzService.getProjectInform();
        return project;
    }


    @RequestMapping("newproject")
    @ResponseBody
    public String newProject(Model model,String glbm,Project newProject,String sylx,String hcxmMc,String tdIds,String fcIds){

        String mess = swdjtzService.getCreateNewProject(glbm,newProject,sylx,hcxmMc,tdIds,fcIds);
        return mess;
    }

    @RequestMapping("uploadToData")
    @ResponseBody
    public String uploadToData(Model model,String proid) throws  Exception{
        swdjtzService.uploadToData(proid);
        return "";
    }

    @RequestMapping("delproject")
    @ResponseBody
    public Object delProject(Model model,String proid){
        if(StringUtils.isNotBlank(proid))
            swdjtzService.delSwbdProject(proid);
        return null;
    }


    @RequestMapping("findZdqueryByDjh")
    @ResponseBody
    public Object findZdqueryByDjh(Model model,String djh) throws Exception{
        if(StringUtils.isNotBlank(djh)){
            ZdQuery zdQuery = zdService.findZdqueryByDjh(djh);

            //根据地籍号创建地编号
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            if(zdQuery!=null){
                String dbh = taxService.createDbhByDjh(djh);
                BeanUtils.copyProperties(swDjSyQuery,zdQuery);
                swDjSyQuery.setDbh(dbh);
                String tdyt = swDjSyQuery.getTdyt();
                if(StringUtils.isNotBlank(tdyt)){
                    String tdytMc = Dldm.getMcByDm(tdyt);
                    swDjSyQuery.setTdytMc(tdytMc);
                }
            }
            return swDjSyQuery;
        }
        return null;
    }



}