package cn.gtmap.landtax.web.syhc;/**
 * Created by janeshen on 2014/8/19.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 */
@Controller
@RequestMapping("/syhc/gdhc")
public class GdhcController {
    @Autowired
    GdhcService gdhcService;
    @Autowired
    ZdhcService zdhcService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;


    @RequestMapping("whclb")
    public String whclb(Model model){
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        zdhcService.isShowBtnByRoleName("gdhcDelBtnRoleName","gdhcAutoCreRoleName","gdhcCreateRoleName",model);
        model.addAttribute("showJd","true");
        return "landtax/syhc/gdhc/gdwhclb";
    }

    @RequestMapping("whclbJson")
    @ResponseBody
    public Page<SwDjXmxx> whclbJson(Model model,Pageable pageable,SwDjQsQuery swDjQsQuery) {
        return gdhcService.whclbJson(swDjQsQuery,pageable);
    }

    @RequestMapping("getZtByXmId")
    @ResponseBody
    public Object getZtByXmId(Model model,String xmId) {
        return gdhcService.getZtByXmId(xmId);
    }


    @RequestMapping("getTJrws")
    @ResponseBody
    public Object getTJrws(Model model,SwDjQsQuery swDjQsQuery) throws  Exception{
        return gdhcService.getTJrws(swDjQsQuery);
    }

    @RequestMapping("xjxm")
    @ResponseBody
    public Object xjxm(Model model,String hcxmMc,String xmIds) throws  Exception{
        String result = "true";
        List<SwDjXmxx> swDjXmxxList=new ArrayList<SwDjXmxx>();
        if(StringUtils.isNotBlank(xmIds)){
            String[] xmIdArray = xmIds.split(",");
            swDjXmxxList = gdhcService.getGdxmListByIds(xmIdArray);
        }else{
            //可以创建全部任务
        }

        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("供地核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.GDHC.toString());
        swHcXm.setXmybj("0");
        String userId = SessionUtil.getCurrentUserId();
        gdhcService.createHcxm(swHcXm, swDjXmxxList, userId);
        return result;
    }

    @RequestMapping("xjxmGdbl")
    @ResponseBody
    public String xjxmGdbl(Model model,String xmId) throws  Exception{
        SwDjXmxx swDjXmxx = new SwDjXmxx();
        if(StringUtils.isNotBlank(xmId)){
            String[] xmIdArray = xmId.split(",");
            List<SwDjXmxx> swDjXmxxList = gdhcService.getGdxmListByIds(xmIdArray);
            if (swDjXmxxList.size() > 0)
                swDjXmxx = swDjXmxxList.get(0);
        }

        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc("供地税源补录"+ swDjXmxx.getXmmc());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.GDBL.toString());
        swHcXm.setXmybj("0");
        String userId = SessionUtil.getCurrentUserId();
        return gdhcService.createHcxmGdbl(swHcXm, swDjXmxx, userId);
    }

    @RequestMapping("/checkXm")
    @ResponseBody
    public String checkXm(Model model,String xmId){
        String msg = "";
        String sqlGdhc = "SELECT t.* " +
                "FROM SW_HC_XM_RW_REL t " +
                "     LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                "WHERE t1.XMLX='" + Hcxmlx.GDHC.toString() + "' AND t.BLZT <> 1 AND t.BD_ID='" + xmId + "'";
        Query queryGdhc = baseRepository.getEntityManager().createNativeQuery(sqlGdhc);
        queryGdhc.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listGdhc = queryGdhc.getResultList();
        if(CollectionUtils.isNotEmpty(listGdhc)){
            msg = "1";
        }

        String sqlGdbl = "SELECT t.* " +
                "FROM SW_HC_XM_RW_REL t " +
                "     LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                "WHERE t1.XMLX='" + Hcxmlx.GDBL.toString() + "' AND t.BLZT <> 1 AND t.BD_ID='" + xmId + "'";
        Query queryGdbl = baseRepository.getEntityManager().createNativeQuery(sqlGdbl);
        queryGdbl.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listGdbl = queryGdbl.getResultList();
        if(CollectionUtils.isNotEmpty(listGdbl)){
            msg = "2";
        }
        return msg;
    }

    @RequestMapping("/wf/del")
    @ResponseBody
    public String wfDel(Model model,String proid) {
        gdhcService.wfDel(proid);
        return "";
    }

    @RequestMapping("/wf/end")
    @ResponseBody
    public String wfEnd(Model model,String proid) throws  Exception{
        gdhcService.wfEnd(proid);
        return "";
    }

    @RequestMapping("sytz")
    public String sytz(Model model,Pageable request,@RequestParam String wiid) {
        if(hcxmService.isYbjByProid(wiid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        //根据wiid获取关联对象
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(wiid);
        model.addAttribute("swHcXmRwRel",swHcXmRwRel);
        SwDjXmxx swDjXmxx = baseRepository.get(SwDjXmxx.class,swHcXmRwRel.getBdId());
        if (swDjXmxx.getGdmj() != null)
            swDjXmxx.setGdmj(swDjXmxx.getGdmj().setScale(2, BigDecimal.ROUND_DOWN));
        if (swDjXmxx.getQdjg() != null)
            swDjXmxx.setQdjg(swDjXmxx.getQdjg().setScale(2, BigDecimal.ROUND_DOWN));
        model.addAttribute("swDjXmxx",swDjXmxx);

        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        model.addAttribute("swDjSyList",swDjSyList);
        //根据djh获取已录税源列表
        List<SwDjSyQuery> rkSwDjSyList = taxService.getSwDjSyByXmId(swDjXmxx.getXmId());
        model.addAttribute("rkSwDjSyList",rkSwDjSyList);

        return "landtax/syhc/gdhc/sytz";
    }

    @RequestMapping("exportExcelTz")
    public String exportExcelTz(SwDjQsQuery swDjQsQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("swDjQsQuery",swDjQsQuery);
            }
            List<SwDjXmxx> swDjXmxxList = gdhcService.getSwDjXmxxList(param);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = swDjQsQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(swDjXmxxList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[9];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjXmxx swDjXmxx = swDjXmxxList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = swDjXmxx.getXmmc();
                tempArr[2] = swDjXmxx.getXmYddw();
                tempArr[3] = swDjXmxx.getXmTdzl();
                tempArr[4] = new BigDecimal(String.valueOf(swDjXmxx.getGdmj()==null?"0":swDjXmxx.getGdmj())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[5] = new BigDecimal(String.valueOf(swDjXmxx.getQdjg()==null?"0":swDjXmxx.getQdjg())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[6] = swDjXmxx.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(swDjXmxx.getGdsj());
                //根据gtbdId获取任务节点
                HashMap tempMap = (HashMap)gdhcService.getZtByXmId(swDjXmxx.getXmId());

                String statue = String.valueOf(tempMap.get("statue"));
                String userName = String.valueOf(tempMap.get("userName"));
                if("0".equals(statue)){
                    tempArr[7] = "未下发";
                }else if("1".equals(statue)){
                    tempArr[7] = "市局下发";
                }else if("2".equals(statue)){
                    tempArr[7] = "县级管理员任务分派";
                }else if("3".equals(statue)){
                    tempArr[7] = "核查组长分派任务";
                }else if("4".equals(statue)){
                    tempArr[7] = "税务人员核查";
                }else if("5".equals(statue)){
                    tempArr[7] = "核查组长确认入库";
                }else if("6".equals(statue)){
                    tempArr[7] = "已办结";
                }
                tempArr[8] = userName;
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("gdhcTz.xls"); //
            eb.setExcelXml("gdhcTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("delWorkflow")
    @ResponseBody
    public Object delWorkflow(Model model,String xzqdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            gdhcService.delWorkflow(xzqdm);
            responseMessage.setMsg("删除成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，删除失败");
        }
        return responseMessage;
    }

    @RequestMapping("autoCreateWorkflow")
    @ResponseBody
    public Object autoCreateWorkflow(Model model,String xzqdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            gdhcService.autoCreateWorkflow(xzqdm);
            responseMessage.setMsg("下发成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，下发失败");
        }
        return responseMessage;
    }

    @RequestMapping("createDbhbyXmId")
    @ResponseBody
    public  String createDbhByXmId(Model model, String xmId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class, qSwDjSy.dbh);
        query.from(qSwDjSy).where(qSwDjSy.swDjXmxx.xmId.eq(xmId));
        query.where(qSwDjSy.dbh.isNotNull());
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy, "dbh")));

        List<SwDjSyQuery> swDjSyQueryList =  (List)baseRepository.dslList(query,qBean);
        //获取所有地编号
        List<Long> dbhList = new ArrayList<Long>();
        for(SwDjSyQuery vo : swDjSyQueryList){
            dbhList.add(Long.parseLong(vo.getDbh()));
        }
        //根据地编号获取最大值
        Long temp = 0L;
        for(Long dbh : dbhList){
            temp = Math.max(temp,dbh);

        }
        temp = temp/10 + 1;
        String resultDbh = String.valueOf(temp);
        int length = resultDbh.length();
        for(int i=0;i<9-length;i++){
            resultDbh = "0" + resultDbh;
        }
        return resultDbh+"0";
    }

}
