package cn.gtmap.landtax.web.syhc;/**
 * Created by janeshen on 2014/8/19.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 */
@Controller
@RequestMapping("/syhc/bphc")
public class BphcController {
    @Autowired
    BphcService bphcService;
    @Autowired
    ZdhcService zdhcService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    GdzysService gdzysService;


    @RequestMapping("whclb")
    public String whclb(Model model){
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);
        zdhcService.isShowBtnByRoleName("bphcDelBtnRoleName","bphcAutoCreRoleName","bphcCreateRoleName",model);
        model.addAttribute("showJd","true");
        return "landtax/syhc/bphc/bpwhclb";
    }

    @RequestMapping("whclbJson")
    @ResponseBody
    public Page<SwDjPcxx> whclbJson(Model model,Pageable pageable,GdzysQuery gdzysQuery) {
        return bphcService.whclbJson(gdzysQuery,pageable);
    }

    @RequestMapping("getZtByPcId")
    @ResponseBody
    public Object getZtByPcId(Model model,String pcId) {
        return bphcService.getZtByPcId(pcId);
    }


    @RequestMapping("getTJrws")
    @ResponseBody
    public Object getTJrws(Model model,GdzysQuery gdzysQuery) throws  Exception{
        return bphcService.getTJrws(gdzysQuery);
    }

    @RequestMapping("xjxm")
    @ResponseBody
    public Object xjxm(Model model,String hcxmMc,String pcIds) throws  Exception{
        String result = "true";
        List<SwDjPcxx> swDjPcxxList=new ArrayList<SwDjPcxx>();
        if(StringUtils.isNotBlank(pcIds)){
            String[] pcIdArray = pcIds.split(",");
            swDjPcxxList = bphcService.getBpxmListByIds(pcIdArray);
        }else{
            //可以创建全部任务
        }

        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("报批核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.BPHC.toString());
        swHcXm.setXmybj("0");
        String userId = SessionUtil.getCurrentUserId();
        bphcService.createHcxm(swHcXm, swDjPcxxList, userId);
        return result;
    }

    @RequestMapping("xjxmBpbl")
    @ResponseBody
    public String xjxmBpbl(Model model,String pcId) throws  Exception{
        String taskId = "";
        SwDjPcxx swDjPcxx=new SwDjPcxx();
        if(StringUtils.isNotBlank(pcId)){
            String[] pcIdArray = pcId.split(",");
            List<SwDjPcxx> swDjPcxxList = bphcService.getBpxmListByIds(pcIdArray);
            if (swDjPcxxList.size() > 0)
                swDjPcxx = swDjPcxxList.get(0);
        }else{
            //可以创建全部任务
        }

        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc("报批税源补录"+ swDjPcxx.getPcmc());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.BPBL.toString());
        swHcXm.setXmybj("0");
        String userId = SessionUtil.getCurrentUserId();
        taskId = bphcService.createHcxmBpbl(swHcXm, swDjPcxx, userId);
        return taskId;
    }

    @RequestMapping("/checkXm")
    @ResponseBody
    public String checkXm(Model model,String pcId){
        String msg = "";
        String sqlBphc = "SELECT t.* " +
                "FROM SW_HC_XM_RW_REL t " +
                "     LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                "WHERE t1.XMLX='" + Hcxmlx.BPHC.toString() + "' AND t.BLZT <> 1 AND t.BD_ID='" + pcId + "'";
        Query queryBphc = baseRepository.getEntityManager().createNativeQuery(sqlBphc);
        queryBphc.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listBphc = queryBphc.getResultList();
        if(CollectionUtils.isNotEmpty(listBphc)){
            msg = "1";
        }

        String sqlBpbl = "SELECT t.* " +
                "FROM SW_HC_XM_RW_REL t " +
                "     LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                "WHERE t1.XMLX='" + Hcxmlx.BPBL.toString() + "' AND t.BLZT <> 1 AND t.BD_ID='" + pcId + "'";
        Query queryBpbl = baseRepository.getEntityManager().createNativeQuery(sqlBpbl);
        queryBpbl.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listBpbl = queryBpbl.getResultList();
        if(CollectionUtils.isNotEmpty(listBpbl)){
            msg = "2";
        }

        String sqlBpsy = "SELECT t.* " +
                "FROM SW_DJ_SY t " +
                "WHERE t.SYZT = 1 AND t.BP_ID='" + pcId + "'";
        Query queryBpsy = baseRepository.getEntityManager().createNativeQuery(sqlBpsy);
        queryBpsy.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> listBpsy = queryBpsy.getResultList();
        if(CollectionUtils.isNotEmpty(listBpsy)){
            msg = "3";
        }
        return msg;
    }

    @RequestMapping("/wf/del")
    @ResponseBody
    public String wfDel(Model model,String proid) {
        bphcService.wfDel(proid);
        return "";
    }

    @RequestMapping("/wf/end")
    @ResponseBody
    public String wfEnd(Model model,String proid) throws  Exception{
        bphcService.wfEnd(proid);
        return "";
    }

    @RequestMapping("sytz")
    public String sytz(Model model,Pageable request,@RequestParam String wiid) {
        //根据wiid获取关联对象
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(wiid);
        model.addAttribute("swHcXmRwRel",swHcXmRwRel);
        SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class,swHcXmRwRel.getBdId());
        if (swDjPcxx.getGdmj() != null)
            swDjPcxx.setGdmj(swDjPcxx.getGdmj().setScale(2, BigDecimal.ROUND_DOWN));
        if (swDjPcxx.getFgdnydmj() != null)
            swDjPcxx.setFgdnydmj(swDjPcxx.getFgdnydmj().setScale(2, BigDecimal.ROUND_DOWN));
        if (swDjPcxx.getJbntmj() != null)
            swDjPcxx.setJbntmj(swDjPcxx.getJbntmj().setScale(2, BigDecimal.ROUND_DOWN));
        if (swDjPcxx.getNydmj() != null)
            swDjPcxx.setNydmj(swDjPcxx.getNydmj().setScale(2, BigDecimal.ROUND_DOWN));
        if (swDjPcxx.getPzmj() != null)
            swDjPcxx.setPzmj(swDjPcxx.getPzmj().setScale(2, BigDecimal.ROUND_DOWN));
        model.addAttribute("swDjPcxx",swDjPcxx);
        model.addAttribute("proId",wiid);
        Set<SwDjSy> swDjSySet = swHcXmRwRel.getSwDjSySet();
        List<SwDjSy> swDjSyList = new ArrayList<SwDjSy>(swDjSySet);
        model.addAttribute("swDjSyList",swDjSyList);
        //根据djh获取已录税源列表
        List<SwDjSyQuery> rkSwDjSyList = taxService.getSwDjSyByPcId(swDjPcxx.getPcId());
        model.addAttribute("rkSwDjSyList",rkSwDjSyList);

        return "landtax/syhc/bphc/sytz";
    }

    @RequestMapping("/gdzysxx")
    public String gdzysxx(Model model,String proid) {
        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
            String pcId = "";
            pcId = swHcXmRwRel.getBdId();
            GdzysQuery pcxx = gdzysService.findGdzysqueryByPCID(pcId);
            model.addAttribute("pcxx", pcxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class, swDjSyTemp.getBpId());
            SwDjSyQuery pcxx = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, pcxx);
            BeanUtils.copyProperties(swDjPcxx, pcxx);
            model.addAttribute("pcxx", pcxx);
        }
        model.addAttribute("proid",proid);

        return "landtax/sjwh/syxgGdzysxx";
    }

    @RequestMapping("exportExcelTz")
    public String exportExcelTz(GdzysQuery gdzysQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("gdzysQuery",gdzysQuery);
            }
            List<SwDjPcxx> swDjPcxxList = bphcService.getSwDjPcxxList(param);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = gdzysQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(swDjPcxxList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[12];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjPcxx swDjPcxx = swDjPcxxList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = swDjPcxx.getPcmc();
                tempArr[2] = swDjPcxx.getPcYddw();
                tempArr[3] = new BigDecimal(String.valueOf(swDjPcxx.getGdmj()==null?"0":swDjPcxx.getGdmj())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[4] = new BigDecimal(String.valueOf(swDjPcxx.getFgdnydmj()==null?"0":swDjPcxx.getFgdnydmj())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[5] = new BigDecimal(String.valueOf(swDjPcxx.getJbntmj()==null?"0":swDjPcxx.getJbntmj())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[6] = new BigDecimal(String.valueOf(swDjPcxx.getNydmj()==null?"0":swDjPcxx.getNydmj())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[7] = new BigDecimal(String.valueOf(swDjPcxx.getPzmj()==null?"0":swDjPcxx.getPzmj())).setScale(2,BigDecimal.ROUND_DOWN).toString();
                tempArr[8] = swDjPcxx.getPzsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(swDjPcxx.getPzsj());
                //根据gtbdId获取任务节点
                HashMap tempMap = (HashMap)bphcService.getZtByPcId(swDjPcxx.getPcId());

                String statue = String.valueOf(tempMap.get("statue"));
                String userName = String.valueOf(tempMap.get("userName"));
                if("0".equals(statue)){
                    tempArr[9] = "未下发";
                }else if("1".equals(statue)){
                    tempArr[9] = "市局下发";
                }else if("2".equals(statue)){
                    tempArr[9] = "县级管理员任务分派";
                }else if("3".equals(statue)){
                    tempArr[9] = "核查组长分派任务";
                }else if("4".equals(statue)){
                    tempArr[9] = "税务人员核查";
                }else if("5".equals(statue)){
                    tempArr[9] = "核查组长确认入库";
                }else if("6".equals(statue)){
                    tempArr[9] = "已办结";
                }
                tempArr[10] = userName;
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("bphcTz.xls"); //
            eb.setExcelXml("bphcTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("delWorkflow")
    @ResponseBody
    public Object delWorkflow(Model model,String xzqdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            bphcService.delWorkflow(xzqdm);
            responseMessage.setMsg("删除成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，删除失败");
        }
        return responseMessage;
    }

    @RequestMapping("autoCreateWorkflow")
    @ResponseBody
    public Object autoCreateWorkflow(Model model,String xzqdm) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            bphcService.autoCreateWorkflow(xzqdm);
            responseMessage.setMsg("下发成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，下发失败");
        }
        return responseMessage;
    }



}
