package cn.gtmap.landtax.web.sjwh;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.spring.BaseController;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 * 税源修改管理
 *
 * @author yang
 * @version V1.0, 14-5-26
 */
@Controller
@RequestMapping("/syxg")
public class SyxgController {
    @Autowired
    TaxService taxService;
    @Autowired
    SyxgService syxgService;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    ZdService zdService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SwDjQsService swDjQsService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HcxmService hcxmService;

    @RequestMapping("/spb")
    public String spb(Model model,String proid) {
        List<SwDjSyHis> swDjSyHisList = syxgService.getSwDjSyHisListByRwid(proid);

        SwDjSyHis swDjSyHis=null;
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
        }else{
            swDjSyHis = new SwDjSyHis();
        }
        String userId = swDjSyHis.getUserid();
        PfUserVo pfUserVo = sysUserService.getUserVo(userId);
        String username = pfUserVo.getUserName();
        model.addAttribute("username",username);
        model.addAttribute("swDjSyHis",swDjSyHis);
        return "landtax/sjwh/syxgSpb";
    }

    @RequestMapping("/spb/save")
    @ResponseBody
    public Object saveSpb(Model model,SwDjSyHis swDjSyHis) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            SwDjSyHis oldSwDjSyHis = syxgService.getSwDjSyHis(swDjSyHis.getSyhisId());
            oldSwDjSyHis.setXgyy(swDjSyHis.getXgyy());
            //oldSwDjSyHis.setCzlx(swDjSyHis.getCzlx());
            syxgService.saveSwDjSyHis(oldSwDjSyHis);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，保存失败");
        }

        return responseMessage;
    }

    @RequestMapping("/syxx")
    public String syxx(Model model,String proid)throws Exception{
        String hydm_level = AppConfig.getProperty("HYDM_LEVELS");
        model.addAttribute("hydm_level",hydm_level);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");

        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }

        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String tdId = "";
            String fcId = "";
            if(swDjSy.getSwDjTd()!=null){
                tdId = swDjSy.getSwDjTd().getTdId();
            }
            if(swDjSy.getSwDjFc()!=null){
                fcId = swDjSy.getSwDjFc().getFcId();
            }
            SwDjSyQuery syxx = taxService.getSwDjSyById(tdId,fcId);
            String djh = syxx.getDjh();
            if(StringUtils.isNotBlank(djh)){
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList",tddjList);
            }
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            model.addAttribute("syxx",syxx);

        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            String djh = swDjSyTemp.getDjh();
            if(StringUtils.isNotBlank(djh)){
                List tddjList = taxService.getTddjByDjhLike(djh);
                model.addAttribute("tddjList",tddjList);
            }
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
            model.addAttribute("syxx",swDjSyTemp);
        }
        model.addAttribute("proid",proid);
        return "landtax/sjwh/syxgSyxx";
    }

    @RequestMapping("/syxggk")
    public String syxggk(Model model,String proid) {
        //历史信息
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
            if(StringUtils.isNotBlank(swDjSyHis.getTdSgztDm()) && StringUtils.isBlank(swDjSyHis.getTdSgztMc())){
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyHis.getTdSgztDm()));
            }
        }
        model.addAttribute("swDjSyHis",swDjSyHis);
        //本次修改信息
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String sgztMc = "";
        if(CollectionUtils.isNotEmpty(list)){
            swDjSyTemp = list.get(0);
            String sgztDm = swDjSyTemp.getSgztDm();
            sgztMc = Sgzt.getMcByDm(sgztDm);

        }
        //计算差值
        BigDecimal ynmjCz = (swDjSyHis.getTdYnmj()==null?BigDecimal.ZERO:swDjSyHis.getTdYnmj()).subtract(swDjSyTemp.getYnmj()==null?BigDecimal.ZERO:swDjSyTemp.getYnmj());
        BigDecimal nynseTdCz = (swDjSyHis.getTdNynse()==null?BigDecimal.ZERO:swDjSyHis.getTdNynse()).subtract(swDjSyTemp.getNynseTd()==null?BigDecimal.ZERO:swDjSyTemp.getNynseTd());
        BigDecimal fcyzYsCz = (swDjSyHis.getFcFcyzYs()==null?BigDecimal.ZERO:swDjSyHis.getFcFcyzYs()).subtract(swDjSyTemp.getFcyzYs()==null?BigDecimal.ZERO:swDjSyTemp.getFcyzYs());
        BigDecimal fcynseZyCz = (swDjSyHis.getFcYnseZy()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseZy()).subtract(swDjSyTemp.getYnseZy()==null?BigDecimal.ZERO:swDjSyTemp.getYnseZy());
        BigDecimal nzjCz = (swDjSyHis.getFcNzj()==null?BigDecimal.ZERO:swDjSyHis.getFcNzj()).subtract(swDjSyTemp.getNzj()==null?BigDecimal.ZERO:swDjSyTemp.getNzj());
        BigDecimal fcynseCzCz = (swDjSyHis.getFcYnseCz()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseCz()).subtract(swDjSyTemp.getYnseCz()==null?BigDecimal.ZERO:swDjSyTemp.getYnseCz());
        BigDecimal fcnynseCz = (swDjSyHis.getFcNynse()==null?BigDecimal.ZERO:swDjSyHis.getFcNynse()).subtract(swDjSyTemp.getNynseFc()==null?BigDecimal.ZERO:swDjSyTemp.getNynseFc());
        Map czMap = new HashMap();
        czMap.put("ynmjCz",ynmjCz);
        czMap.put("nynseTdCz",nynseTdCz);
        czMap.put("fcyzYsCz",fcyzYsCz);
        czMap.put("fcynseZyCz",fcynseZyCz);
        czMap.put("nzjCz",nzjCz);
        czMap.put("fcynseCzCz",fcynseCzCz);
        czMap.put("fcnynseCz",fcnynseCz);
        model.addAttribute("czMap", czMap);
        model.addAttribute("xghSgztMc",sgztMc);
        model.addAttribute("swDjSyTemp",swDjSyTemp);
        return "landtax/sjwh/syxggk";
    }

    @RequestMapping("/syxggk_gdzys")
    public String syxggkGdzys(Model model,String proid) {
        //历史信息
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
            if(StringUtils.isNotBlank(swDjSyHis.getTdSgztDm()) && StringUtils.isBlank(swDjSyHis.getTdSgztMc())){
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyHis.getTdSgztDm()));
            }
        }
        model.addAttribute("swDjSyHis",swDjSyHis);
        //本次修改信息
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String sgztMc = "";
        if(CollectionUtils.isNotEmpty(list)){
            swDjSyTemp = list.get(0);
            String sgztDm = swDjSyTemp.getSgztDm();
            sgztMc = Sgzt.getMcByDm(sgztDm);

        }
        //计算差值
        BigDecimal ynseCz = (swDjSyHis.getGdzysYnse()==null?BigDecimal.ZERO:swDjSyHis.getGdzysYnse()).subtract(swDjSyTemp.getGdzysYnse()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysYnse());
        BigDecimal yjneCz = (swDjSyHis.getGdzysYjne()==null?BigDecimal.ZERO:swDjSyHis.getGdzysYjne()).subtract(swDjSyTemp.getGdzysYjne()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysYjne());
        BigDecimal jmseCz = (swDjSyHis.getGdzysJmse()==null?BigDecimal.ZERO:swDjSyHis.getGdzysJmse()).subtract(swDjSyTemp.getGdzysJmse()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysJmse());
        BigDecimal xbjseCz = (swDjSyHis.getGdzysXbjse()==null?BigDecimal.ZERO:swDjSyHis.getGdzysXbjse()).subtract(swDjSyTemp.getGdzysXbjse()==null?BigDecimal.ZERO:swDjSyTemp.getGdzysXbjse());
        Map czMap = new HashMap();
        czMap.put("ynseCz",ynseCz);
        czMap.put("yjneCz",yjneCz);
        czMap.put("jmseCz",jmseCz);
        czMap.put("xbjseCz",xbjseCz);
        model.addAttribute("czMap", czMap);
        model.addAttribute("xghSgztMc",sgztMc);
        model.addAttribute("swDjSyTemp",swDjSyTemp);
        return "landtax/sjwh/syxggk_gdzys";
    }

    @RequestMapping("/qsxx")
    public String qsxx(Model model,String proid) {
        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        String xmXzqdm = "";
        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            SwDjSyQuery qsxx = swDjQsService.getQsBySyId(syId);
            xmXzqdm = qsxx.getXmXzqdm();
            model.addAttribute("qsxx",qsxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            SwDjXmxx swDjXmxx = baseRepository.get(SwDjXmxx.class, swDjSyTemp.getGdId());
            SwDjSyQuery qsxx = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, qsxx);
            BeanUtils.copyProperties(swDjXmxx, qsxx);
            xmXzqdm = qsxx.getXmXzqdm();
            model.addAttribute("qsxx",qsxx);
        }
        model.addAttribute("proid",proid);

        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByXzqdm(xmXzqdm);
        model.addAttribute("tddjList",tddjList);

        return "landtax/sjwh/syxgQsxx";
    }

    @RequestMapping("/gdzysxx")
    public String gdzysxx(Model model,String proid) {
        if(hcxmService.isYbjByProid(proid)){//已办结
            model.addAttribute("isYbj","true");
        }else{
            model.addAttribute("isYbj","false");
        }
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);

        if(CollectionUtils.isEmpty(list)){//说明是第一次修改
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            GdzysQuery pcxx = gdzysService.findGdzysqueryBySyId(syId);
            model.addAttribute("pcxx", pcxx);
        }else{//说明之前修改过
            SwDjSyTemp swDjSyTemp = list.get(0);
            SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class, swDjSyTemp.getBpId());
            SwDjSyQuery pcxx = new SwDjSyQuery();
            BeanUtils.copyProperties(swDjSyTemp, pcxx);
            BeanUtils.copyProperties(swDjPcxx, pcxx);
            model.addAttribute("pcxx", pcxx);
        }
        model.addAttribute("proid",proid);

        return "landtax/sjwh/syxgGdzysxx";
    }

    @RequestMapping("/syxx/save")
    @ResponseBody
    public Object saveSyxx(Model model,SwDjSyTemp swDjSyTemp) {
        ResponseMessage responseMessage = new ResponseMessage();
        try{
            swdjSyTempService.saveSwDjSyTemp(swDjSyTemp);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，保存失败");
        }
        return responseMessage;

    }

    /**
     * 工作流办结事件
     * @param model
     * @param proid
     * @return
     * @throws Exception
     */
    @RequestMapping("/syxx/commit")
    @ResponseBody
    public String commitSyxg(Model model,String proid) throws  Exception{
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(CollectionUtils.isNotEmpty(list)){
            BeanUtils.copyProperties(list.get(0),swDjSyQuery);
        }else{//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String tdId = "";
            String fcId = "";
            if(swDjSy.getSwDjTd()!=null){
                tdId = swDjSy.getSwDjTd().getTdId();
            }
            if(swDjSy.getSwDjFc()!=null){
                fcId = swDjSy.getSwDjFc().getFcId();
            }
            swDjSyQuery = taxService.getSwDjSyById(tdId,fcId);
        }

        taxService.saveSwDjSyQuery(swDjSyQuery, Syzt.ZC.toString());
        return "";
    }

    @RequestMapping("/syxx/commitQs")
    @ResponseBody
    public String commitSyxgQs(Model model,String proid) throws  Exception{
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(CollectionUtils.isNotEmpty(list)){
            BeanUtils.copyProperties(list.get(0),swDjSyQuery);
        }else{//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            swDjSyQuery = taxService.getSwDjSyBySyId(syId);
        }
        swDjSyQuery.setSyzt(Syzt.ZC.toString());
        swDjSyQuery.setXmId(swDjSyQuery.getGdId());
        swDjQsService.SaveQs(swDjSyQuery);
        return "";
    }

    @RequestMapping("/syxx/commitGdzys")
    @ResponseBody
    public String commitSyxgGdzys(Model model,String proid) throws  Exception{
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(CollectionUtils.isNotEmpty(list)){
            BeanUtils.copyProperties(list.get(0),swDjSyQuery);
        }else{//说明只是创建了修改流程，但是并没有修改，保存，直接转发下去
            SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
            SwDjSy swDjSy = swDjSyHis.getSwDjSy();
            String syId = "";
            syId = swDjSy.getSyId();
            swDjSyQuery = taxService.getSwDjSyBySyId(syId);
        }
        GdzysQuery gdzysQuery = new GdzysQuery();
        BeanUtils.copyProperties(swDjSyQuery, gdzysQuery);
        gdzysQuery.setSyzt(Syzt.ZC.toString());
        gdzysQuery.setPcId(gdzysQuery.getBpId());
        gdzysService.SaveGdzys(gdzysQuery);
        return "";
    }

    /**
     * 工作流删除事件
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("/syxx/del")
    @ResponseBody
    public String delSyxg(Model model,String proid) {
        //删除sw_dj_sy_his表数据
        //删除sw_dj_sy_temp表数据
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/syxx/delQs")
    @ResponseBody
    public String delSyxgQs(Model model,String proid) {
        //删除sw_dj_sy_his表数据
        //删除sw_dj_sy_temp表数据
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/syxx/delGdzys")
    @ResponseBody
    public String delSyxgGdzys(Model model,String proid) {
        //删除sw_dj_sy_his表数据
        //删除sw_dj_sy_temp表数据
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/workflow")
    @ResponseBody
    public Object createSyxgWorkflow(Model model,String syId){
        try{
            return syxgService.createSyxgWorkflow(syId);
        }catch (Exception e){
            return null;
        }

    }

    @RequestMapping("/workflowQs")
    @ResponseBody
    public Object createSyxgWorkflowQs(Model model,String syId){
        try{
            return syxgService.createSyxgWorkflowQs(syId);
        }catch (Exception e){
            return null;
        }

    }

    @RequestMapping("/workflowGdzys")
    @ResponseBody
    public Object createSyxgWorkflowGdzys(Model model,String syId){
        try{
            return syxgService.createSyxgWorkflowGdzys(syId);
        }catch (Exception e){
            return null;
        }

    }


    private SwDjSyHis mergeSwDjSyHis(SwDjSyHis newSwDjSyHis,SwDjSyHis oldSwDjSyHis){
        newSwDjSyHis.setDjh(oldSwDjSyHis.getDjh());
        newSwDjSyHis.setDbh(oldSwDjSyHis.getDbh());
        newSwDjSyHis.setSwDjSy(oldSwDjSyHis.getSwDjSy());
        newSwDjSyHis.setXgyy(oldSwDjSyHis.getXgyy());
        newSwDjSyHis.setXgrq(oldSwDjSyHis.getXgrq());
        newSwDjSyHis.setUserid(oldSwDjSyHis.getUserid());
        newSwDjSyHis.setCzlx(oldSwDjSyHis.getCzlx());
        return newSwDjSyHis;
    }


    @RequestMapping("syxgxxList")
    public String syxgxxList(Model model)throws Exception{
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        String qxdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotEmpty(qxdm)) {
            model.addAttribute("qxdm",qxdm);
        }
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        return "landtax/sjwh/syxgxxList";
    }
    @RequestMapping("syxgxxListJson")
    @ResponseBody
    public Object syxgxxListJson(Model model,Pageable pageable,SwDjSyQuery swDjSyQuery, String sylx) {
        String qxdm = dwxxService.getUserQxDm();
        if (StringUtils.isNotEmpty(qxdm)) {
            swDjSyQuery.setQx(qxdm);
        }
        return syxgService.getSyxgxxLsitJson(swDjSyQuery,pageable, sylx);
    }

    @RequestMapping("/syxggk_qs")
    public String syxggkQs(Model model,String proid) {
        //历史信息
        List<SwDjSyHis> swDjSyHisList =  swdjSyHisService.getSwDjSyHisByRwid(proid);
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            swDjSyHis = swDjSyHisList.get(0);
            if(StringUtils.isNotBlank(swDjSyHis.getTdSgztDm()) && StringUtils.isBlank(swDjSyHis.getTdSgztMc())){
                swDjSyHis.setTdSgztMc(Sgzt.getMcByDm(swDjSyHis.getTdSgztDm()));
            }
        }
        model.addAttribute("swDjSyHis",swDjSyHis);
        //本次修改信息
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        String sgztMc = "";
        if(CollectionUtils.isNotEmpty(list)){
            swDjSyTemp = list.get(0);
            String sgztDm = swDjSyTemp.getSgztDm();
            sgztMc = Sgzt.getMcByDm(sgztDm);

        }
        //计算差值
        BigDecimal ynmjCz = (swDjSyHis.getTdYnmj()==null?BigDecimal.ZERO:swDjSyHis.getTdYnmj()).subtract(swDjSyTemp.getYnmj()==null?BigDecimal.ZERO:swDjSyTemp.getYnmj());
        BigDecimal nynseTdCz = (swDjSyHis.getTdNynse()==null?BigDecimal.ZERO:swDjSyHis.getTdNynse()).subtract(swDjSyTemp.getNynseTd()==null?BigDecimal.ZERO:swDjSyTemp.getNynseTd());
        BigDecimal fcyzYsCz = (swDjSyHis.getFcFcyzYs()==null?BigDecimal.ZERO:swDjSyHis.getFcFcyzYs()).subtract(swDjSyTemp.getFcyzYs()==null?BigDecimal.ZERO:swDjSyTemp.getFcyzYs());
        BigDecimal fcynseZyCz = (swDjSyHis.getFcYnseZy()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseZy()).subtract(swDjSyTemp.getYnseZy()==null?BigDecimal.ZERO:swDjSyTemp.getYnseZy());
        BigDecimal nzjCz = (swDjSyHis.getFcNzj()==null?BigDecimal.ZERO:swDjSyHis.getFcNzj()).subtract(swDjSyTemp.getNzj()==null?BigDecimal.ZERO:swDjSyTemp.getNzj());
        BigDecimal fcynseCzCz = (swDjSyHis.getFcYnseCz()==null?BigDecimal.ZERO:swDjSyHis.getFcYnseCz()).subtract(swDjSyTemp.getYnseCz()==null?BigDecimal.ZERO:swDjSyTemp.getYnseCz());
        BigDecimal fcnynseCz = (swDjSyHis.getFcNynse()==null?BigDecimal.ZERO:swDjSyHis.getFcNynse()).subtract(swDjSyTemp.getNynseFc()==null?BigDecimal.ZERO:swDjSyTemp.getNynseFc());
        BigDecimal ynseCz = (swDjSyHis.getQsYnse()==null?BigDecimal.ZERO:swDjSyHis.getQsYnse()).subtract(swDjSyTemp.getQsYnse()==null?BigDecimal.ZERO:swDjSyTemp.getQsYnse());
        BigDecimal jmseCz = (swDjSyHis.getQsJmse()==null?BigDecimal.ZERO:swDjSyHis.getQsJmse()).subtract(swDjSyTemp.getQsJmse()==null?BigDecimal.ZERO:swDjSyTemp.getQsJmse());
        BigDecimal yjneCz = (swDjSyHis.getQsYjne()==null?BigDecimal.ZERO:swDjSyHis.getQsYjne()).subtract(swDjSyTemp.getQsYjne()==null?BigDecimal.ZERO:swDjSyTemp.getQsYjne());
        BigDecimal xbjseCz = (swDjSyHis.getQsXbjse()==null?BigDecimal.ZERO:swDjSyHis.getQsXbjse()).subtract(swDjSyTemp.getQsXbjse()==null?BigDecimal.ZERO:swDjSyTemp.getQsXbjse());
        Map czMap = new HashMap();
        czMap.put("ynmjCz",ynmjCz);
        czMap.put("nynseTdCz",nynseTdCz);
        czMap.put("fcyzYsCz",fcyzYsCz);
        czMap.put("fcynseZyCz",fcynseZyCz);
        czMap.put("nzjCz",nzjCz);
        czMap.put("fcynseCzCz",fcynseCzCz);
        czMap.put("ynseCz",ynseCz);
        czMap.put("jmseCz",jmseCz);
        czMap.put("yjneCz",yjneCz);
        czMap.put("xbjseCz",xbjseCz);
        czMap.put("fcnynseCz",fcnynseCz);
        model.addAttribute("czMap", czMap);
        model.addAttribute("xghSgztMc",sgztMc);
        model.addAttribute("swDjSyTemp",swDjSyTemp);
        return "landtax/sjwh/syxggk_qs";
    }
}
