package cn.gtmap.landtax.web.sjwh;

import cn.gtmap.landtax.entity.SwDjSyHis;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.service.SwdjSyHisService;
import cn.gtmap.landtax.service.SyscService;
import cn.gtmap.landtax.service.SyxgService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.HashMap;

/**
 * 税源删除
 * Created by xuchao on 2014/8/22.
 */
@Controller
@RequestMapping("/sysc")
public class SyscController {
    @Autowired
    TaxService taxService;
    @Autowired
    SyscService syscService;
    @Autowired
    SyxgService syxgService;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("/workflow")
    @ResponseBody
    public Object createSyscWorkflow(Model model,String syId){
        return syscService.createSyscWorkflow(syId);
    }

    @RequestMapping("/workflowQs")
    @ResponseBody
    public Object createSyscWorkflowQs(Model model,String syId){
        return syscService.createQsSyscWorkflow(syId);
    }

    @RequestMapping("/workflowGdzys")
    @ResponseBody
    public Object createSyscWorkflowGdzys(Model model,String syId){
        return syscService.createGdzysSyscWorkflow(syId);
    }

    @RequestMapping("/spb")
    public String spb(Model model,String proid) {
        SwDjSyHis swDjSyHis = syxgService.getSwDjSyHisListByRwid(proid).get(0);
        model.addAttribute("swDjSyHis",swDjSyHis);

        String userId = swDjSyHis.getUserid();
        PfUserVo pfUserVo = sysUserService.getUserVo(userId);
        String username = pfUserVo.getUserName();
        model.addAttribute("username",username);


        return "landtax/sjwh/syscSpb";
    }

    @RequestMapping("/spb/save")
    @ResponseBody
    public Object saveSpb(Model model,SwDjSyHis swDjSyHis) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            SwDjSyHis oldSwDjSyHis = syxgService.getSwDjSyHis(swDjSyHis.getSyhisId());
            oldSwDjSyHis.setXgyy(swDjSyHis.getXgyy());
            //oldSwDjSyHis.setCzlx(swDjSyHis.getCzlx());
            syxgService.saveSwDjSyHis(oldSwDjSyHis);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            responseMessage.setMsg("保存失败");
        }
        return responseMessage;
    }

    @RequestMapping("/wf/del")
    @ResponseBody
    public String delSyxg(Model model,String proid) {
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/wf/end")
    @ResponseBody
    public String end(Model model,String proid) {
        syscService.delSwdjSyByHisId(proid);
        return "";
    }

    @RequestMapping("/wf/delQs")
    @ResponseBody
    public String delSyxgQs(Model model,String proid) {
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/wf/endQs")
    @ResponseBody
    public String endQs(Model model,String proid) {
        syscService.delSwdjSyByHisIdGqs(proid);
        return "";
    }

    @RequestMapping("/wf/delGdzys")
    @ResponseBody
    public String delSyxgGdzys(Model model,String proid) {
        syxgService.del(proid);
        return "";
    }

    @RequestMapping("/wf/endGdzys")
    @ResponseBody
    public String endGdzys(Model model,String proid) {
        syscService.delSwdjSyByHisIdGqs(proid);
        return "";
    }

    @RequestMapping("printSyscSpb")
    @ResponseBody
    public void printSyscSpb(Model model,HttpServletRequest request,HttpServletResponse response,String syhisId) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyHis swDjSyHis = syxgService.getSwDjSyHis(syhisId);
        if(swDjSyHis==null){
            swDjSyHis = new SwDjSyHis();
        }
        String czlx = swDjSyHis.getCzlx();
        czlx = Czlx.getMcByDm(czlx);
        swDjSyHis.setCzlx(czlx);
        xml.append(xmlBuildHelper.voToXml(swDjSyHis));
//        xml.append("<data name=\"AP_FWZDMJ\" type=\"String\">");
//        xml.append((vo.getAP_LFMJ()==null?0:vo.getAP_LFMJ())+(vo.getAP_PFMJ()==null?0:vo.getAP_PFMJ()));
//        xml.append("</data>");
        HashMap<String, Boolean> keyMap = new HashMap<String, Boolean>();
        keyMap.put("sgsyj", false);
        keyMap.put("fgldyj", false);
        String userId = swDjSyHis.getUserid();
        PfUserVo user = sysUserService.getUserVo(userId);
        String username = "";
        try{
            username = user.getUserName();
        }catch (Exception e){
        }

        xml.append("<data name=\"USERNAME\" type=\"String\">");
        xml.append(username);
        xml.append("</data>");
        xml.append(xmlBuildHelper.getSignToXml(syhisId, request, keyMap));//根据id，进入平台库，查找相应的信息，组织参数，存入xml中

        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

}
