package cn.gtmap.landtax.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;


public class ZttXmlUtil {

	/**
	 * 获取XML中专题图的数据
	 * @param url
	 * @return
	 */
	public static List<Map<String, String>> readXml(String url){
		SAXBuilder builder = new SAXBuilder();
		Document doc = null;
		try {
			doc = builder.build(new File(url));
		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		if(doc == null){
			return new ArrayList<Map<String, String>>();
		}

		Element root = doc.getRootElement();
		//获得ZZTDATA标签数组
		List zztDatas = root.getChildren();

		List<Map<String, String>> responseDatas = new ArrayList<Map<String, String>>();

		for(int i = 0; i < zztDatas.size(); i++){
            Map<String, String> responseData = new HashMap<String, String>();
			// 获得一个ZZTDATA标签
			Element zztData = (Element) zztDatas.get(i);

            //获得所有的字段
            List fields = zztData.getChildren();

            for (int j = 0; j < fields.size(); j++) {
                Element field = (Element) fields.get(j);
                String name = field.getName();
                String value = field.getValue();

                responseData.put(name, value);
            }

            responseDatas.add(responseData);

		}
		return responseDatas;

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		/*List<String> params = readXmlToList("map/src/main/resources/land.xml", "PIDI");

		for (int i = 0; i < params.size(); i++) {
			System.out.println(params.get(i));
		}*/

		/*Map<String, String> params = readFieldNames("map/src/main/resources/land.xml", "PIDI");

		System.out.println(params.get("项目名称"));*/

//		Map<String, String> params = readDataTypes("map/src/main/resources/land.xml", "PIDI");

//		System.out.println(params.get("PZMJ"));

	}

}