package cn.gtmap.landtax.util;

import cn.gtmap.landtax.model.dictionary.Sssq;
import cn.gtmap.landtax.model.dictionary.Szdm;
import com.gtis.spring.Container;
import net.sf.json.JSONArray;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import com.gtis.config.AppConfig;

public class CommonUtil {
	public static String getCurrStrDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		return str;
	}
	/**
	 * 格式化Double精度 type为默认

	 * 
	 * 默认是按照conf/tddj/tddj.xml下配置精度格式化
	 * 
	 * @param value 
	 * @return 默认面积精度
	 */
	public static Double formatNumber(Double value) {
		return formatNumber(value, "default");
	}

    /**
     * 获取map里的值
      * @param object
     * @return
     */
    public static String  getMapString(Object object){
        return object!=null?object.toString():"";
    }
	
	public static String getPfUserName(){
		BasicDataSource dataSource = (BasicDataSource)Container.getBean("globalDataSource");
		String pf_userName = dataSource.getUsername();
		return pf_userName;
	}
	public static String gettddjUserName(){
		BasicDataSource dataSource = (BasicDataSource)Container.getBean("tddj");
		String tddj_userName = dataSource.getUsername();
		return tddj_userName;
	}
	
	/**
	 * 向tddj/tddj.xml写currentYear/value的值 curYear
	 * 为年份字符串 形式"2008"
	 * 
	 * @author liuz
	 * @param curYear
	 */
	public static void setCURRENTYEAR(String curYear) {
		//Common commom = new Common();
		//commom.setCURRENTYEAR(curYear);
	}
    
	/**
	 * 调用commom.getAllSqlx()获取全部申请类型
	 * 
	 * @author liuz
	 * @return listAllSqlx
	 */
	public static List<String> getAllSqlx() {
	//	Common commom = new Common();
	//	List<String> listAllSqlx = commom.getAllSqlx();
	//	return listAllSqlx;  \
        return null;
	}
	
	/**
	 * 从tddj/tddj.xml获取currentYear/value的值 结果为年份字符串 形式为"2008"
	 * 
	 * @author liuz
	 * @return 字符串型当前年份
	 */
	public static String getCURRENTYEAR() {
		//Common commom = new Common();
		//String curYear = commom.getCURRENTYEAR();
		//return curYear;
        return "";
	}
	
	/**
	 * 用于格式化数值型数据 type类型包括 syq,suq,je
	 * 
	 * @author liuz
	 * @param value 
	 * @param type
	 * @return 按精度类型格式化
	 */
	public static Double formatNumber(Double value, String type) {
	/*	try {
			Common commom = new Common();
			String precision = commom.getPrecision(type);
			BigDecimal bd = new BigDecimal(Double.toString(value));
	        BigDecimal one = new BigDecimal("1");
			bd = bd.divide(one,Integer.parseInt(precision),BigDecimal.ROUND_HALF_UP);
			//System.out.println("bigDecimal:"+bd);
			value = bd.doubleValue();			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}		
		return value;  */
        return 0.0;
	}

	public static HashMap<String, Object> getDwdmQuery(HttpServletRequest request,HashMap<String, Object> map){
//		Common com = new Common();
//		XZQ xzq = com.getXZQ();
//		String xzqDM = xzq.getXzqDM();
//		String userId = UserUtil.getUserId(request);
//		String userDwdm = UserUtil.getUserRegionCode(request, userId);
//		if (!userDwdm.equals(xzqDM)){
//			map.put("dwdm",userDwdm);
//		}else{
//		}
		return map;
	}
	
	public static Date getCurrDate() {
		Date date = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		try {
			date = sdf.parse(str);
		} catch (Exception e) {
			return null;
		}
		return date;
	}

	public static Date formatDate(Date date) {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String str = sdf.format(date);		
		try {
			date = sdf.parse(str);
		} catch (Exception e) {
			return null;
		}
		return date;
	}
	
	public static String formateDate(java.sql.Date date) {
		String strDate = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		strDate = sdf.format(date);
		return strDate;
	}

	public static String formateDate(Date date) {
		String strDate = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		strDate = sdf.format(date);
		return strDate;
	}

	public static Date formateDateToStr(String dateString) {
		Date formateDate = null;
		DateFormat format= new SimpleDateFormat("yyyy-MM-dd");
		try { 
			formateDate = format.parse(dateString); 
		}catch (ParseException e){ 
			e.printStackTrace(); 
		} 
		return formateDate;
	}
	
	public static String getCurrYear() {
		GregorianCalendar today = new GregorianCalendar();
		String curYear = today.get(GregorianCalendar.YEAR) + "";
		return curYear;
	}


	public static String getDataXML(Object obj) {
		StringBuffer sb = new StringBuffer();
		sb.append("<datas>");
		if(obj!=null){
			Field[] fds;
			try {
				fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
				for (int i = 0; i < fds.length; i++) {
					String fieldName = fds[i].getName();
					if(fieldName.equals("serialVersionUID")){
						continue;
					}
					String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(
							0, 1).toUpperCase());
					Method m = obj.getClass().getMethod("get" + tempFieldName, null);
					String returnType = m.getReturnType().getName();
					String fieldValue=null;
					if (returnType.equals("java.lang.String")) {
						fieldValue = (String) m.invoke(obj, null);
					} else if (returnType.equals("java.util.Date")) {
						Date adate = (Date) m.invoke(obj, null);
						if(adate==null){
							fieldValue= "";
						}
						else{
							fieldValue= formateDate(adate);
						}
					} else if (returnType.equals("java.lang.Integer")) {
						Integer avalue = (Integer) m.invoke(obj, null);
						avalue=avalue==null?0:avalue;
						fieldValue =avalue.toString();
					} else if (returnType.equals("java.lang.Double")) {
						Double dvalue = (Double) m.invoke(obj, null);
						dvalue=dvalue==null?0:dvalue;
						fieldValue =dvalue.toString();
					}
					fieldValue=fieldValue==null?"":fieldValue;
					//fieldValue = fieldValue == null ? "" : fieldValue;
					fieldValue = fieldValue.replaceAll("<", "&lt;");
					fieldValue = fieldValue.replaceAll(">", "&gt;");
					sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
					sb.append(fieldValue);
					sb.append("</data>");
				}
//				sb.append("<data name=\"xzqmc\" type=\"String(50)\">");
//				sb.append(getXZQ().getXzqName());
//				sb.append("</data>");
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		sb.append("</datas>");
		return sb.toString();
	}
	
	public static String getDetailXML(List list,String detailId) {
		StringBuffer sb = new StringBuffer();
		sb.append("<detail ID='");
		sb.append(detailId);
		sb.append("'>");
		for(int j=0;j<list.size();j++){
			int k=j;
			sb.append("<row ID=\""+k+"\">");
			Object obj=list.get(j);
			
			if(obj!=null){
				Field[] fds;
				try {
					fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
					for (int i = 0; i < fds.length; i++) {
						String fieldName = fds[i].getName();
						//主子表 数据重复问题（土地证条形码projectid问题）排除子表记事projectid数据
						if("TDZJS".equals(detailId)&&"projectId".equals(fieldName)){
							continue;
						}
						if(fieldName.equals("serialVersionUID")){
							continue;
						} 
						//解决老版打印控件登记卡主表和续表的土地证号混乱问题
						if("DJKXB".equals(detailId)&&"tdzh".equals(fieldName)){
							continue;
						}
						String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(
								0, 1).toUpperCase());
						Method m = obj.getClass().getMethod("get" + tempFieldName, null);
						String returnType = m.getReturnType().getName();
						String fieldValue=null;
						if (returnType.equals("java.lang.String")) {
							fieldValue = (String) m.invoke(obj, null);
						} else if (returnType.equals("java.util.Date")) {
							Date adate = (Date) m.invoke(obj, null);
							if(adate==null){
								fieldValue= "";
							}
							else{
								fieldValue= formateDate(adate);
							}
						} else if (returnType.equals("java.lang.Integer")) {
							Integer avalue = (Integer) m.invoke(obj, null);
							avalue=avalue==null?0:avalue;
							fieldValue =avalue.toString();
						} else if (returnType.equals("java.lang.Double")) {
							Double dvalue = (Double) m.invoke(obj, null);
							dvalue=dvalue==null?0:dvalue;
							fieldValue =dvalue.toString();
						}
						
						fieldValue=fieldValue==null?"":fieldValue;
						
						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			sb.append("</row>");
		}
		sb.append("</detail>");
		return sb.toString();
	}
	
	public static String getDetailXML(List list,String detailId,Object vo) {
		StringBuffer sb = new StringBuffer();
		sb.append("<datas></datas>");
		sb.append("<detail ID='");
		sb.append(detailId);
		sb.append("'>");
		for(int j=0;j<list.size();j++){
			int k=j;
			sb.append("<row ID=\""+k+"\">");
			Object obj=list.get(j);
			
			if(obj!=null){
				Field[] fds;
				try {
					fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
					for (int i = 0; i < fds.length; i++) {
						String fieldName = fds[i].getName();
						if(fieldName.equals("serialVersionUID")){
							continue;
						} 
						String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(
								0, 1).toUpperCase());
						Method m = obj.getClass().getMethod("get" + tempFieldName, null);
						String returnType = m.getReturnType().getName();
						String fieldValue=null;
						if (returnType.equals("java.lang.String")) {
							fieldValue = (String) m.invoke(obj, null);
						} else if (returnType.equals("java.util.Date")) {
							Date adate = (Date) m.invoke(obj, null);
							if(adate==null){
								fieldValue= "";
							}
							else{
								fieldValue= formateDate(adate);
							}
						} else if (returnType.equals("java.lang.Integer")) {
							Integer avalue = (Integer) m.invoke(obj, null);
							avalue=avalue==null?0:avalue;
							fieldValue =avalue.toString();
						} else if (returnType.equals("java.lang.Double")) {
							Double dvalue = (Double) m.invoke(obj, null);
							dvalue=dvalue==null?0:dvalue;
							fieldValue =dvalue.toString();
						}
						
						fieldValue=fieldValue==null?"":fieldValue;
						
						sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
						sb.append(fieldValue);
						sb.append("</data>");
					}
					//vo
					if(vo!=null){
						Field[] fds_vo;
						try {
							fds_vo = Class.forName(vo.getClass().getName()).getDeclaredFields();
							for (int i = 0; i < fds_vo.length; i++) {
								String fieldName = fds_vo[i].getName();
								if(fieldName.equals("serialVersionUID")){
									continue;
								}
								String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(
										0, 1).toUpperCase());
								Method m = vo.getClass().getMethod("get" + tempFieldName, null);
								String returnType = m.getReturnType().getName();
								String fieldValue=null;
								if (returnType.equals("java.lang.String")) {
									fieldValue = (String) m.invoke(vo, null);
								} else if (returnType.equals("java.util.Date")) {
									Date adate = (Date) m.invoke(vo, null);
									if(adate==null){
										fieldValue= "";
									}
									else{
										fieldValue= formateDate(adate);
									}
								} else if (returnType.equals("java.lang.Integer")) {
									Integer avalue = (Integer) m.invoke(vo, null);
									avalue=avalue==null?0:avalue;
									fieldValue =avalue.toString();
								} else if (returnType.equals("java.lang.Double")) {
									Double dvalue = (Double) m.invoke(vo, null);
									dvalue=dvalue==null?0:dvalue;
									fieldValue =dvalue.toString();
								}
								fieldValue=fieldValue==null?"":fieldValue;
								fieldName = "add" + fieldName;
								sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
								sb.append(fieldValue);
								sb.append("</data>");
							}
						} catch (SecurityException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (ClassNotFoundException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalArgumentException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (IllegalAccessException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (NoSuchMethodException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						} catch (InvocationTargetException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					
				} catch (SecurityException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (ClassNotFoundException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (NoSuchMethodException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			sb.append("</row>");
		}
		sb.append("</detail>");
		return sb.toString();
	}
	
	
	public static String addDataXML(Object obj, String dataXML) {
		String addDataXML = dataXML.replaceFirst("<datas>", "");
		addDataXML = addDataXML.replaceFirst("</datas>", "");
		StringBuffer sb = new StringBuffer(addDataXML);
		if(obj!=null){
			Field[] fds;
			try {
				fds = Class.forName(obj.getClass().getName()).getDeclaredFields();
				for (int i = 0; i < fds.length; i++) {
					String fieldName = fds[i].getName();
					if(fieldName.equals("serialVersionUID")){
						continue;
					}
					String tempFieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(
							0, 1).toUpperCase());
					Method m = obj.getClass().getMethod("get" + tempFieldName, null);
					String returnType = m.getReturnType().getName();
					String fieldValue=null;
					if (returnType.equals("java.lang.String")) {
						fieldValue = (String) m.invoke(obj, null);
					} else if (returnType.equals("java.util.Date")) {
						Date adate = (Date) m.invoke(obj, null);
						if(adate==null){
							fieldValue= "";
						}
						else{
							fieldValue= formateDate(adate);
						}
					} else if (returnType.equals("java.lang.Integer")) {
						Integer avalue = (Integer) m.invoke(obj, null);
						avalue=avalue==null?0:avalue;
						fieldValue =avalue.toString();
					} else if (returnType.equals("java.lang.Double")) {
						Double dvalue = (Double) m.invoke(obj, null);
						dvalue=dvalue==null?0:dvalue;
						fieldValue =dvalue.toString();
					}
					fieldValue=fieldValue==null?"":fieldValue;
					fieldName = "add" + fieldName;
					sb.append("<data name=\"" + fieldName + "\" type=\"String(50)\">");
					sb.append(fieldValue);
					sb.append("</data>");
				}
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return ("<datas>"+sb+"</datas>").toString();
	}
	/**
	 * 获取当前时间
	 * 
	 * @return 日期型当前时间

	 */
	public static Date getCurrTime() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		Timestamp date = Timestamp.valueOf(str);
		return date;
	}
    public static String DoubleToString(Double doubleData, Integer count){
        if (doubleData == null) {
            return "";
        }
        DecimalFormat myformat = initDecimalFormat(count);
        return myformat.format(doubleData);
    }
    public static DecimalFormat initDecimalFormat(Integer count){
        return initDecimalFormat(count,true);
    }
    public static String DoubleToString(Double doubleData, Integer count,boolean buling){
        if (doubleData == null) {
            return "";
        }
        DecimalFormat myformat = initDecimalFormat(count,buling);
        return myformat.format(doubleData);
    }

    /**
     * 初始化数字格式
     * @param count
     * @return
     */
    public static DecimalFormat initDecimalFormat(Integer count,Boolean buling){
        String formatStr = "#0.";
        if (count == null) {
            count = 8;
        }
        if (count <= 0) {
            formatStr = "#0";
        }else {
            for (int i = 0; i < count; i++) {
                if (buling != null && buling) {
                    formatStr += "0";
                }else {
                    formatStr += "#";
                }
            }
        }
        DecimalFormat myformat = new java.text.DecimalFormat(formatStr);
        return myformat;
    }

    /**
     * 初始化对象，并针对null的String、Integer、Double类型赋值0
     * @param obj
     * @param initString 是否初始化字符串为""
     * @param initInteger 是否初始化整形为0
     * @param initDouble 是否初始化Double为0
     * @return
     * @throws Exception
     */
    public static Object initObj(Object obj,boolean initString,boolean initInteger,boolean initDouble)throws Exception{
        try {
            if (obj == null) {
                obj = new Object();
            }
            Method[] methods = obj.getClass().getMethods();
            for (int i = 0; i < methods.length; i++) {
                Method method = methods[i];
                String methodName = method.getName();
                if(methodName.startsWith("set")){
                    Object[] typeArray = method.getParameterTypes();
                    if (typeArray != null && typeArray.length > 0) {
                        String type = typeArray[0].toString();
                        if (initString) {
                            if(type.equals("class java.lang.String")){
                                methodName.replaceFirst("set", "get");
                                Method getMethod = obj.getClass().getMethod(methodName.replaceFirst("set", "get"));
                                if (getMethod.invoke(obj) == null) {
                                    method.invoke(obj,"");
                                }
                            }
                        }
                        if (initInteger) {
                            if(type.equals("class java.lang.Integer")){
                                methodName.replaceFirst("set", "get");
                                Method getMethod = obj.getClass().getMethod(methodName.replaceFirst("set", "get"));
                                if (getMethod.invoke(obj) == null) {
                                    method.invoke(obj,0);
                                }
                            }
                        }
                        if (initDouble) {
                            if(type.equals("class java.lang.Double")){
                                methodName.replaceFirst("set", "get");
                                Method getMethod = obj.getClass().getMethod(methodName.replaceFirst("set", "get"));
                                if (getMethod.invoke(obj) == null) {
                                    method.invoke(obj,0.0);
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return obj;
    }

    public static  String reSetTddj(String tddj){
        if(StringUtils.isBlank(tddj)){
            return "";
        }else{
            if("9091".equals(tddj) || "9092".equals(tddj) || "9093".equals(tddj) || tddj.startsWith("0")){
            }else{//不是以0开头的
                tddj = "0"+tddj;
            }
            return tddj;
        }
    }

    /**
     * 根据年份，月份判断天数
     */
    public static int calDayByYearAndMonth(String dyear,String dmouth){
        SimpleDateFormat simpleDate = new SimpleDateFormat("yyyy/MM");
        Calendar rightNow = Calendar.getInstance();
        try{
            rightNow.setTime(simpleDate.parse(dyear+"/"+dmouth));
        }catch(ParseException e){
            e.printStackTrace();
        }
        return rightNow.getActualMaximum(Calendar.DAY_OF_MONTH);//根据年月 获取月份天数
    }

    public static String getSssqByNow(){
        String sssq = "";
        int currentMonth = Calendar.getInstance().get(Calendar.MONTH)+1;
        if(currentMonth<5){
            sssq = Sssq.XBN.toString();
        }else if(currentMonth>4 && currentMonth<10){
            sssq = Sssq.SBN.toString();
        }else if(currentMonth>10){
            sssq = Sssq.XBN.toString();
        }
        return sssq;
    }

    public static  String getSssqByNow(String szdm){
        int month = Calendar.getInstance().get(Calendar.MONTH) + 1;

        return getSssqByMonth(szdm, month);
    }

    public static  String getSssqByMonth(String szdm, int month){
        int currentMonth = month;
        String sssq = "";

        if (szdm == Szdm.CZTDSYS.toString()) {
            sssq = String.valueOf((currentMonth - 1) / 3 + 1);
        }
        else if (szdm == Szdm.FCS.toString()) {
            sssq = String.valueOf((currentMonth - 1) / 6 + 1);
        }
        return sssq;
    }

    public static boolean isIn(String substring, String[] source) {
        if (source == null || source.length == 0) {
            return false;
        }
        for (int i = 0; i < source.length; i++) {
            String aSource = source[i];
            if (aSource.equals(substring)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 文件下载
     * @param response
     * @param filePath 文件路径
     * @param fileName 文件名称
     */
    public static void download(HttpServletResponse response, String filePath, String fileName)throws IOException {
        FileInputStream fis = null;
        OutputStream os = null;
        try {
            fis = new FileInputStream(filePath);
            os = response.getOutputStream();// 取得输出流
            response.reset();// 清空输出流
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);// 设定输出文件头
            response.setContentType("application/x-download");
            byte[] mybyte = new byte[8192];
            int len = 0;
            while ((len = fis.read(mybyte)) != -1) {
                os.write(mybyte, 0, len);
            }
            os.close();
        }catch (IOException e) {
            throw e;
        }
    }

    public static String[] filterNullString(String[] arr){
        StringBuffer sb = new StringBuffer();
        for(int i=0; i<arr.length; i++) {
            if("".equals(arr[i].trim())) {
                continue;
            }
            sb.append(arr[i].trim());
            if(i != arr.length - 1) {
                sb.append(";");
            }
        }

        return sb.toString().split(";");
    }

    public static String getOracleSQLIn(List<?> ids, int count, String field) {
        count = Math.min(count, 1000);
        int len = ids.size();
        int size = len % count;
        if (size == 0) {
            size = len / count;
        } else {
            size = (len / count) + 1;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; i++) {
            int fromIndex = i * count;
            int toIndex = Math.min(fromIndex + count, len);
            //System.out.println(ids.subList(fromIndex, toIndex));
            String productId = StringUtils.defaultIfEmpty(StringUtils.join(ids.subList(fromIndex, toIndex), "','"), "");
            if (i != 0) {
                builder.append(" or ");
            }
            builder.append(field).append(" in ('").append(productId).append("')");
        }

        return StringUtils.defaultIfEmpty(builder.toString(), field + " in ('')");
    }


    public static String getFczl(String fczlXian, String fczlZhen, String fczlLu, String fczlHao, String fczlDong, String fczlDy, String fczlLou, String fczlShi) {
        String fczl = "";
        if(StringUtils.isNotBlank(fczlXian)){
            fczl = fczl + fczlXian+"县（区）";
        }
        if(StringUtils.isNotBlank(fczlZhen)){
            fczl = fczl + fczlZhen+"镇（街道、乡）";
        }
        if(StringUtils.isNotBlank(fczlLu)){
            fczl = fczl + fczlLu+"路（街）";
        }
        if(StringUtils.isNotBlank(fczlHao)){
            fczl = fczl + fczlHao+"号";
        }
        if(StringUtils.isNotBlank(fczlDong)){
            fczl = fczl + fczlDong+"幢";
        }
        if(StringUtils.isNotBlank(fczlDy)){
            fczl = fczl + fczlDong+"单元";
        }
        if(StringUtils.isNotBlank(fczlLou)){
            fczl = fczl + fczlLou+"楼";
        }
        if(StringUtils.isNotBlank(fczlShi)){
            fczl = fczl + fczlShi+"室";
        }
        return fczl;
    }

    /**
     * 将前台查询的条件解析成List<QueryCondition>
     * @param jsonStr
     * @return
     */
    public static List<QueryCondition> initQueryCondition(String jsonStr) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        try {
            HashMap filterHashMap = null;
            HashMap operatorHashMap = null;
            if (jsonStr != null) {
                JSONArray jsonArray = JSONArray.fromObject(jsonStr);
                HashMap[] hashMaps = (HashMap[]) JSONArray.toArray(jsonArray, HashMap.class);
                if (hashMaps != null) {
                    if (hashMaps.length > 1) {
                        filterHashMap = hashMaps[0];
                        operatorHashMap = hashMaps[1];
                    } else if (hashMaps.length == 1) {
                        filterHashMap = hashMaps[0];
                        operatorHashMap = new HashMap();
                    }
                }
            }
            if (filterHashMap != null) {
                Iterator iter = ((Map)filterHashMap).entrySet().iterator();

                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (val != null && !val.toString().isEmpty()) {
                        if (operatorHashMap.get(key.toString()) != null) {
                            if (operatorHashMap.get(key.toString()).toString().equals(QueryCondition.IN)) {
                                String[] stringList = val.toString().split(",");
                                String valStr = "";
                                for (int i = 0; i < stringList.length; i++) {
                                    if (valStr != "")
                                        valStr += ",";
                                    valStr += "'" + stringList[i] + "'";
                                }
                                queryConditionList.add(new QueryCondition(key.toString() +  " in (" + valStr + ")"));
                            } else {
                                queryConditionList.add(new QueryCondition(key.toString(), operatorHashMap.get(key.toString()).toString(), val.toString()));
                            }
                        } else {
                            queryConditionList.add(new QueryCondition(key.toString(), QueryCondition.LK, val.toString()));
                        }
                    }
                }
            }
        } catch (Exception e) {
            System.out.println(e.getMessage());
            throw (RuntimeException)e;
        }
        return queryConditionList;
    }

    private static Map<String,Boolean> taxTypeConf;
    public static Map<String,Boolean> getSyTypes()throws Exception{
        if(taxTypeConf!=null)
            return taxTypeConf;
        taxTypeConf=new HashMap<String,Boolean>();
        taxTypeConf.put(ObjectValueManager.LOAD_FCS,false);
        taxTypeConf.put(ObjectValueManager.LOAD_GDZYS,false);
        taxTypeConf.put(ObjectValueManager.LOAD_QS,false);
        String[] syTypes = AppConfig.getProperty("SY_TYPES").split(";");
        for(String syType:syTypes){
            if(syType.equals(ObjectValueManager.FCS)){
                taxTypeConf.put(ObjectValueManager.LOAD_FCS,true);
            }
            if(syType.equals(ObjectValueManager.GDZYS)){
                taxTypeConf.put(ObjectValueManager.LOAD_GDZYS,true);
            }
            if(syType.equals(ObjectValueManager.QS)){
                taxTypeConf.put(ObjectValueManager.LOAD_QS,true);
            }
        }
        return taxTypeConf;
    }
}
