package cn.gtmap.landtax.support.spring;

import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

import java.util.Iterator;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/4
 */
public class PageableMethodArgumentResolver implements HandlerMethodArgumentResolver {
    private static String SIZE_PARAMETER="rows";
    private PageableHandlerMethodArgumentResolver pageableArgumentResolver = new PageableHandlerMethodArgumentResolver();

    public PageableHandlerMethodArgumentResolver getPageableArgumentResolver() {
        return pageableArgumentResolver;
    }

    public void setPageableArgumentResolver(PageableHandlerMethodArgumentResolver pageableArgumentResolver) {
        this.pageableArgumentResolver = pageableArgumentResolver;
    }

    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        return Pageable.class.equals(methodParameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        resolveSizeArgument(nativeWebRequest);
        return pageableArgumentResolver.resolveArgument(methodParameter,modelAndViewContainer,nativeWebRequest,webDataBinderFactory);
    }

    private void resolveSizeArgument(NativeWebRequest webRequest){
        Iterator<String> parameterNames = webRequest.getParameterNames();
        while (parameterNames.hasNext()){
            String name = parameterNames.next();
            if(name.equals(SIZE_PARAMETER)){
                pageableArgumentResolver.setSizeParameterName(SIZE_PARAMETER);
                break;
            }
        }
    }
}
