package cn.gtmap.landtax.support.message;

import cn.gtmap.landtax.ex.ExceptionCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/24
 */
@Component
public class MessageUtils {

    private static MessageService messageService;
    private static final String EXCEPTION_MSG_PREFIX = "exception.";
    private static final String INFORMATION_MSG_PREFIX = "information.";

    @Autowired
    public void setMessageService(MessageService messageService) {
        MessageUtils.messageService = messageService;
    }


    public static String getExceptionMsg(ExceptionCode exceptionCode) {
        return messageService.getMessage(EXCEPTION_MSG_PREFIX + exceptionCode.toString());
    }

    public static String getExceptionMsg(ExceptionCode exceptionCode, Object[] args) {
        return messageService.getMessage(EXCEPTION_MSG_PREFIX + exceptionCode.toString(), args);
    }

    public static String getInfoMsg(String key) {
        return messageService.getMessage(INFORMATION_MSG_PREFIX + key);
    }
}
