package cn.gtmap.landtax.service.impl;


import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.IPlatUtil;
import cn.gtmap.landtax.util.PlatUtil;
import cn.gtmap.landtax.util.QueryCondition;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.*;

@Service
public class bphcServiceImpl implements BphcService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    ZdhcService zdhcService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    GdzysService gdzysService;

    private static final String CREATE_USER_NAME="create_user_name";

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<SwDjPcxx> whclbJson(GdzysQuery gdzysQuery,Pageable pageable) {
        String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.BPHC.toString());
        String sql = "SELECT t1.*, TO_CHAR(t6.USER_NAME) AS USER_NAME, " +
                    "       DECODE(t2.BLZT, " +
                    "              '1', '6', " +
                    "              DECODE(t4.ACTIVITY_DEFINITION_ID, " +
                    "                     :conf0, '1', " +
                    "                     :conf1, '2', " +
                    "                     :conf2, '3', " +
                    "                     :conf3, '4', " +
                    "                     :conf4, '5', " +
                    "                     '0' " +
                    "                     ) " +
                    "              ) AS STATUE " +
                    "FROM SW_DJ_PCXX t1 " +
                    "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX = :hclx)) t2 on t1.PC_ID = t2.BD_ID " +
                    "     LEFT JOIN ( " +
                    "         SELECT * " +
                    "         FROM PF_ACTIVITY t " +
                    "         WHERE t.ACTIVITY_STATE='1' " +
                    "     ) t4 on t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                    "     LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                    "     LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                    "WHERE 1=1 ";
        sql = addWhclbWhere(gdzysQuery,sql,true);

        String statue = gdzysQuery.getStatue();
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("6")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("0")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and (t4.ACTIVITY_DEFINITION_ID NOT IN (:conf0, :conf1, :conf2, :conf3, :conf4) OR t4.ACTIVITY_DEFINITION_ID IS NULL)";
            } else if (statue.equals("1")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = :conf0 ";
            } else if (statue.equals("2")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf1 ";
            } else if (statue.equals("3")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf2 ";
            } else if (statue.equals("4")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf3 ";
            } else if (statue.equals("5")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf4 ";
            }
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql)
                .setParameter("hclx", Hcxmlx.BPHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3])
                .setParameter("conf4", configArr[4]);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("SELECT COUNT(*) FROM (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString())
                .setParameter("hclx", Hcxmlx.BPHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3])
                .setParameter("conf4", configArr[4]);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getZtByPcId(String pcId) {
        String sql = "select t2.blzt,t4.activity_name,t4.activity_state,t4.activity_definition_id,to_char(t5.user_id)user_id,to_char(t6.user_name)user_name from sw_dj_pcxx t1 " +
                "left join sw_hc_xm_rw_rel t2 on t1.pc_id = t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join " +
                "( " +
                "  select * from pf_activity t where t.activity_state='1'   " +
                ") t4  " +
                "on t4.workflow_instance_id=t2.rw_id "+
                "left join pf_assignment t5 on t5.activity_id=t4.activity_id "+
                "left join pf_user t6 on t5.user_id=t6.user_id "+
                "where t3.xmlx = :xmlx "+
                "and t1.pc_id = :pcId ";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("pcId", pcId);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        ResponseMessage responseMessage = new ResponseMessage();
        HashMap resultMap = new HashMap();
        if(CollectionUtils.isNotEmpty(list)){
            HashMap<String,Object> tempMap = list.get(0);
            String activityName = String.valueOf(tempMap.get("ACTIVITY_NAME")==null?"":tempMap.get("ACTIVITY_NAME"));
            String activity_state = String.valueOf(tempMap.get("ACTIVITY_STATE")==null?"":tempMap.get("ACTIVITY_STATE"));
            String activity_definition_id = String.valueOf(tempMap.get("ACTIVITY_DEFINITION_ID")==null?"":tempMap.get("ACTIVITY_DEFINITION_ID"));
            String blzt = String.valueOf(tempMap.get("BLZT")==null?"":tempMap.get("BLZT"));
            String userName = String.valueOf(tempMap.get("USER_NAME")==null?"":tempMap.get("USER_NAME"));
            resultMap.put("userName",StringUtils.isBlank(userName)?"":userName);
            if(StringUtils.isNotBlank(blzt) && "1".equals(blzt)){
                responseMessage.setMsg("6");
            }else if(StringUtils.isBlank(activityName) || "null".equalsIgnoreCase(activityName)){
                responseMessage.setMsg("0");
            }else if("1".equals(activity_state)){
                String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.BPHC.toString());
                if(StringUtils.isNotBlank(activity_definition_id)){
                    for(int i=0;i<configArr.length;i++){
                        if(activity_definition_id.equalsIgnoreCase(configArr[i])){
                            responseMessage.setMsg(i+1+"");
                        }
                    }
                }
            }

        }else{
            responseMessage.setMsg("0");
        }
        resultMap.put("statue",responseMessage.getMsg());
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getTJrws(GdzysQuery gdzysQuery) throws  Exception{
        Map resultMap = new HashMap();
        String workflowDefinId = AppConfig.getProperty("bphc");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String wxf = getWxfSql(gdzysQuery,activityList,regionCode);
        String sjxf = getSjxfSql(gdzysQuery,activityList,regionCode);
        String qxxf = getQxxfSql(gdzysQuery,activityList,regionCode);
        String hczzxf = getHczzxfSql(gdzysQuery,activityList,regionCode);
        String swryxf = getSwryxfSql(gdzysQuery,activityList,regionCode);
        String qrrk = getQrrkSql(gdzysQuery,activityList,regionCode);
        String ybj = getYbjSql(gdzysQuery,activityList,regionCode);
        resultMap.put("WXF",wxf);
        resultMap.put("SJXF",sjxf);
        resultMap.put("QXXF",qxxf);
        resultMap.put("ZZ",hczzxf);
        resultMap.put("SWRY",swryxf);
        resultMap.put("QRRK",qrrk);
        resultMap.put("YBJ",ybj);
        return resultMap;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjPcxx> getBpxmListByIds(String[] pcIds) {
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjPcxx).where(qSwDjPcxx.pcId.in(pcIds));
        return (List)baseRepository.dslList(jpaQuery,qSwDjPcxx);
    }

    @Override
    public List<SwDjPcxx> getBpxmListByQuery(GdzysQuery gdzysQuery) {
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjPcxx);
        applyQueryPredicates(gdzysQuery, qSwDjPcxx, jpaQuery);
        return (List)baseRepository.dslList(jpaQuery,qSwDjPcxx);
    }

    @Override
    @Transactional
    public void createHcxm(SwHcXm swHcXm, List<SwDjPcxx> swDjPcxxList, String userId)throws  Exception{
        baseRepository.save(swHcXm);

        //创建核查任务的工作流项目
        for(SwDjPcxx swDjPcxx:swDjPcxxList){
            Project project = new Project();
            String wiid = UUIDGenerator.generate();
            project.setProjectId(wiid);
            String wwid = AppConfig.getProperty("bphc");
            project.setWdid(wwid);
            try {
                platUtil.createWorkFlowInstance(project, userId,swDjPcxx.getPcmc());
            }catch (Exception e){
                throw  new Exception();
            }


            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel.setShxrId(UUIDGenerator.generate());
            swHcXmRwRel.setRwId(wiid);
            swHcXmRwRel.setSwHcXm(swHcXm);
            swHcXmRwRel.setBdId(swDjPcxx.getPcId());
            swHcXmRwRel.setBlzt("0");
            baseRepository.save(swHcXmRwRel);
        }
    }

    @Override
    @Transactional
    public String createHcxmBpbl(SwHcXm swHcXm, SwDjPcxx swDjPcxx, String userId) throws Exception {
        baseRepository.save(swHcXm);

        //创建核查任务的工作流项目
        String taskId = "";
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = AppConfig.getProperty("bpbl");
        project.setWdid(wwid);
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId,swDjPcxx.getPcmc());
        }catch (Exception e){
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                taskId = "java.lang:" + ((RuntimeException) e).getMessage().substring(0, ((RuntimeException) e).getMessage().length());
                return taskId;
            } else {
                throw new RuntimeException();
            }
        }


        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(UUIDGenerator.generate());
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(swDjPcxx.getPcId());
        swHcXmRwRel.setBlzt("0");
        baseRepository.save(swHcXmRwRel);

        return taskId;
    }

    @Override
    @Transactional
    public void wfDel(String proid) {
        //1,删除swHcXmRwRel下的所有税源，此时税源状态都是3(零时)
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        if (list != null) {
            for (SwDjSyTemp swDjSyTemp : list) {
                //删除税源
                baseRepository.delete(swDjSyTemp);
            }
        }

        //3,删除SwHcXmRwRel记录
        hcxmService.doSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        hcxmService.doSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional
    public void wfEnd(String proid) {
        //1,将swDjSy.syzt 设置成1
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);

        List<SwDjSyTemp> list = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(CollectionUtils.isNotEmpty(list)){
            SwDjSyTemp swDjSyTemp = list.get(0);

            String pcId = swDjSyTemp.getBpId();

            BeanUtils.copyProperties(swDjSyTemp,swDjSyQuery);
            GdzysQuery gdzysQuery = new GdzysQuery();
            BeanUtils.copyProperties(swDjSyQuery, gdzysQuery);
            gdzysQuery.setSyzt(Syzt.ZC.toString());
            gdzysQuery.setPcId(pcId);
            gdzysService.SaveGdzys(gdzysQuery);
        }


        //3,SwHcXmRwRel.blzt 设置为1，表示该任务已办结
        hcxmService.doUpSwHcXmRwRel(swHcXmRwRel);

        //4,判断SwHcXm中是否还有swHcXmRwRel
        hcxmService.doUpSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjPcxx> getSwDjPcxxList(HashMap param) {
        Object idsObj = param.get("ids");
        GdzysQuery gdzysQuery = (GdzysQuery) param.get("gdzysQuery");
        QSwDjPcxx qSwDjPcxx= QSwDjPcxx.swDjPcxx;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());

        QBean qBeanz = Projections.bean(SwDjPcxx.class, qSwDjPcxx.pcId,qSwDjPcxx.pcmc,qSwDjPcxx.fgdnydmj,qSwDjPcxx.gdmj,qSwDjPcxx.jbntmj,qSwDjPcxx.nydmj,qSwDjPcxx.pcXzqdm,qSwDjPcxx.pcYddw,qSwDjPcxx.pwh,qSwDjPcxx.pzmj,qSwDjPcxx.pzsj);
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length()>6){
                regionCode=regionCode.substring(0,6);
            }
        }else{
            regionCode="";
        }
        jpaQuery.from(qSwDjPcxx);

        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjPcxx.pcId.in(idsList));
        }else{
            jpaQuery.where(qSwDjPcxx.pcXzqdm.like(regionCode+ QueryCondition.WILDCARDS));
            applyQueryPredicates(gdzysQuery,qSwDjPcxx,jpaQuery);
        }
        jpaQuery.orderBy(qSwDjPcxx.pcId.desc().nullsLast());
        return (List)baseRepository.dslList(jpaQuery,qBeanz);
    }

    @Override
    @Transactional
    public void delWorkflow(String xzqdm) {
        //删除pf_assignment
        String delAssignmentSql = "delete from pf_assignment t where t.assignment_id in  " +
                                "( " +
                                "  select t1.assignment_id from pf_assignment t1 " +
                                "  left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                                "  left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                                "  where t3.workflow_instance_id in " +
                                "  (select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_pcxx t3 on t3.pc_id=t1.bd_id where t2.xmlx = :xmlx and t3.xzqdm like '%'|| :xzqdm ||'%') " +
                                ")";
        Query delAssignmentQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmentSql)
                .setParameter("xmlx", Hcxmlx.BPHC.toString())
                .setParameter("xzqdm", xzqdm);
        delAssignmentQuery.executeUpdate();
        //3,删除pf_assignmenthistory

        String delAssignmenthistorySql = "delete from pf_assignmenthistory t where t.assignment_id in ( " +
                "       select t1.assignment_id from pf_assignmenthistory t1 " +
                "       left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                "       left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                "       where t3.workflow_instance_id in (select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_pcxx t3 on t3.pc_id=t1.bd_id where t2.xmlx = :xmlx and t3.xzqdm like '%'|| :xzqdm ||'%'))";
        Query delAssignmenthistoryQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmenthistorySql)
                .setParameter("xmlx", Hcxmlx.BPHC.toString())
                .setParameter("xzqdm", xzqdm);
        delAssignmenthistoryQuery.executeUpdate();
        //4，删除pf_activity
        //activityId list
        String delActivitySql = "delete from pf_activity t where t.activity_id in(select t1.activity_id from pf_activity t1 " +
                "left join pf_workflow_instance t2 on t1.workflow_instance_id=t2.workflow_instance_id " +
                "where t2.workflow_instance_id in (select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_pcxx t3 on t3.pc_id=t1.bd_id where t2.xmlx = :xmlx and t3.xzqdm like '%'|| :xzqdm ||'%'))";
        Query delActivityQuery = baseRepository.getEntityManager().createNativeQuery(delActivitySql)
                .setParameter("xmlx", Hcxmlx.BPHC.toString())
                .setParameter("xzqdm", xzqdm);
        delActivityQuery.executeUpdate();
        //5,删除pf_workflow_instance
        String delWorkflowInstanceSql = "delete from pf_workflow_instance t where t.workflow_instance_id in(select t1.rw_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_pcxx t3 on t3.pc_id=t1.bd_id where t2.xmlx = :xmlx and t3.xzqdm like '%'|| :xzqdm ||'%')";
        Query delWorkflowInstanceQuery = baseRepository.getEntityManager().createNativeQuery(delWorkflowInstanceSql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("xzqdm", xzqdm);
        delWorkflowInstanceQuery.executeUpdate();
        //6,删除sw_hc_xm_rw_rel
        String delSwHcXmRwRelSql = "delete from  sw_hc_xm_rw_rel t where t.shxr_id in " +
                "(select t1.shxr_id from sw_hc_xm_rw_rel t1 left join sw_hc_xm t2 on t1.hcxm_id=t2.id left join sw_dj_pcxx t3 on t3.pc_id=t1.bd_id where t2.xmlx = :xmlx and t3.xzqdm like '%'|| :xzqdm ||'%')";
        Query delSwHcXmRwRelQuery = baseRepository.getEntityManager().createNativeQuery(delSwHcXmRwRelSql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("xzqdm", xzqdm);
        delSwHcXmRwRelQuery.executeUpdate();
    }

    @Override
    @Transactional
    public void autoCreateWorkflow(String xzqdm)throws Exception{

        //1,首先删除任务
        delWorkflow(xzqdm);

        //2,自动创建下发
        GdzysQuery gdzysQuery = new GdzysQuery();
        gdzysQuery.setPcXzqdm(xzqdm);
        List<SwDjPcxx> swDjPcxxList = getBpxmListByQuery(gdzysQuery);
        //创建任务
        if(CollectionUtils.isNotEmpty(swDjPcxxList)){
            //获取市局用户id
            String loginName = AppConfig.getProperty(CREATE_USER_NAME);
            if(StringUtils.isBlank(loginName)){
                //默认自动创建的用户名是市局
                loginName = "070037";
            }
            //根据用户名获取用户
            PfUserVo userVo = sysUserService.getUserByloginName(loginName);

            if(userVo!=null){
                /**
                 *自动创建工作流
                 */
                String userId = userVo.getUserId();
                SwHcXm swHcXm = new SwHcXm();
                swHcXm.setMc("报批核查项目"+ Calendar.getInstance().getTime());
                swHcXm.setXmId(UUIDGenerator.generate());
                swHcXm.setCjrq(Calendar.getInstance().getTime());
                swHcXm.setCjrId(SessionUtil.getCurrentUserId());
                swHcXm.setXmlx(Hcxmlx.BPHC.toString());
                swHcXm.setXmybj("0");
                baseRepository.save(swHcXm);

                //创建核查任务的工作流项目
                for(SwDjPcxx swDjPcxx:swDjPcxxList){
                    Project project = new Project();
                    String wiid = UUIDGenerator.generate();
                    project.setProjectId(wiid);
                    String wwid = AppConfig.getProperty("bphc");
                    project.setWdid(wwid);
                    try {
                        platUtil.createWorkFlowInstance(project, userId,swDjPcxx.getPcmc());
                    }catch (Exception e){
                        throw  new Exception();
                    }
                    SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
                    swHcXmRwRel.setShxrId(UUIDGenerator.generate());
                    swHcXmRwRel.setRwId(wiid);
                    swHcXmRwRel.setSwHcXm(swHcXm);
                    swHcXmRwRel.setBdId(swDjPcxx.getPcId());
                    swHcXmRwRel.setBlzt("0");
                    baseRepository.save(swHcXmRwRel);

                    //自动转发到区县
                    PerformerTaskModel result=zdhcService.getTurnUserList(userId, wiid);
                    List<PfUserVo> toUserList = result.getUserList();
                    String toUserId = "";
                    if(CollectionUtils.isNotEmpty(toUserList)){
                        for(PfUserVo pfUserVo : toUserList){
                            String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                            if(regionCode.length()>6){
                                regionCode = regionCode.substring(0,6);
                            }

                            if(xzqdm.equals(regionCode)){
                                toUserId = pfUserVo.getUserId();
                                break;
                            }
                        }
                    }

                    if(StringUtils.isNotBlank(toUserId)){
                        //任务自动转发
                        String taskid = PlatUtil.getTaskIdByProid(wiid);
                        String turnXml = zdhcService.initTurnTaskXml(wiid, toUserId, taskid);
                        Document doc = DocumentHelper.parseText(turnXml);
                        workFlowService.turnTask(doc,taskid);
                    }
                }

            }else{
                throw new RuntimeException("没有根据用户名"+loginName+"查出对应用户");
            }

        }
    }

    private void applyQueryPredicates(GdzysQuery gdzysQuery, QSwDjPcxx qSwDjPcxx, JPQLQuery jpaQuery) {
        if(StringUtils.isNotBlank(gdzysQuery.getPcmc()))
            jpaQuery.where(qSwDjPcxx.pcmc.like(QueryCondition.WILDCARDS+gdzysQuery.getPcmc()+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gdzysQuery.getPcXzqdm()))
            jpaQuery.where(qSwDjPcxx.pcXzqdm.eq(gdzysQuery.getPcXzqdm()));
        if(StringUtils.isNotBlank(gdzysQuery.getPcYddw()))
            jpaQuery.where(qSwDjPcxx.pcYddw.like(QueryCondition.WILDCARDS+gdzysQuery.getPcYddw()+QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gdzysQuery.getExcelBegin()) && StringUtils.isNotBlank(gdzysQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(gdzysQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(gdzysQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }
    }

    private String addWhclbWhere(GdzysQuery gdzysQuery,String sql,Boolean isOrderBY){
        String where = "";
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length() >6)
                regionCode = regionCode.substring(0,6);
        }else{
            regionCode = "";
        }


        if(StringUtils.isNotBlank(gdzysQuery.getPcmc()))
            where = where + "and t1.pcmc like '%"+gdzysQuery.getPcmc()+"%' ";
        if(StringUtils.isNotBlank(gdzysQuery.getPcXzqdm()))
            where = where + "and t1.xzqdm = '"+gdzysQuery.getPcXzqdm()+"' ";
        if(StringUtils.isNotBlank(gdzysQuery.getPcYddw()))
            where = where + "and t1.yddw like '%"+gdzysQuery.getPcYddw()+"%' ";
        if(StringUtils.isNotBlank(regionCode)){
            where = where + "and t1.xzqdm like '"+regionCode+"%' ";
        }
        sql = sql + where;
        if(isOrderBY){
            //sql = sql + "order by t1.pc_id desc ";
        }
        return sql;
    }

    private String getYbjSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(*) from sw_dj_pcxx t1 " +
                     "left join sw_hc_xm_rw_rel t2 on t1.pc_id=t2.bd_id "+
                     "left join sw_hc_xm t3 on t3.id=t2.hcxm_id "+
                     "where t3.xmlx=:xmlx and t2.blzt='1' ";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString());
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQrrkSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.pc_id)) from sw_dj_pcxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.pc_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx=:xmlx and t4.activity_definition_id=:activity_definition_id ";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("activity_definition_id", String.valueOf(((HashMap)activityList.get(4)).get("activityDefinitionId")));
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSwryxfSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.pc_id)) from sw_dj_pcxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.pc_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx=:xmlx and t4.activity_definition_id=:activity_definition_id ";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("activity_definition_id", String.valueOf(((HashMap)activityList.get(3)).get("activityDefinitionId")));
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getHczzxfSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.pc_id)) from sw_dj_pcxx t1   " +
                "left join sw_hc_xm_rw_rel t2 on t1.pc_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx=:xmlx and t4.activity_definition_id=:activity_definition_id ";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("activity_definition_id", String.valueOf(((HashMap)activityList.get(2)).get("activityDefinitionId")));
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQxxfSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.pc_id)) from sw_dj_pcxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.pc_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx=:xmlx and t4.activity_definition_id=:activity_definition_id ";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("activity_definition_id", String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId")));
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSjxfSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.pc_id)) from sw_dj_pcxx t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.pc_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx=:xmlx and t4.activity_definition_id=:activity_definition_id ";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql).setParameter("xmlx", Hcxmlx.BPHC.toString()).setParameter("activity_definition_id", String.valueOf(((HashMap)activityList.get(0)).get("activityDefinitionId")));
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getWxfSql(GdzysQuery gdzysQuery,List activityList,String regionCode) {
        String sql = "select count(*) from sw_dj_pcxx t1 where t1.pc_id not in "+
                     "(" +
                         "select t1.bd_id from sw_hc_xm_rw_rel t1 " +
                         "left join sw_hc_xm t2 on t1.hcxm_id=t2.id " +
                         "where t2.xmlx='"+Hcxmlx.BPHC.toString()+"' " +
                     ")";
        sql = addWhclbWhere(gdzysQuery, sql,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

}
