package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Isxf;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.service.ZdhcService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author shenjian
 * @version V1.0, 2014/8/21
 */
@Service
public class ZdhcServiceImpl implements ZdhcService {
    @Autowired
    BaseRepository baseRepository;

    @Autowired
    HcxmService hcxmService;

    @Autowired
    TaxService taxService;
    @Autowired
    HashMap hcjdConfigMap;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    ZdService zdService;

    private static final String CREATE_USER_NAME="create_user_name";

    @Override
    @Transactional(readOnly = true)
    public List<SSjGtbd> getGtbdById(String[] gtbdId) {
        QSSjGtbd qsSjGtbd = QSSjGtbd.sSjGtbd;
        int length = gtbdId.length;
        if(length>1000){
            String[] gtbdId1 = Arrays.copyOfRange(gtbdId,0,500);
            String[] gtbdId2 = Arrays.copyOfRange(gtbdId,500,length);
            JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
            jpaQuery.from(qsSjGtbd).where(qsSjGtbd.gtbdId.in(gtbdId1).or(qsSjGtbd.gtbdId.in(gtbdId2)));
            return (List)baseRepository.dslList(jpaQuery,qsSjGtbd);
        }
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjGtbd).where(qsSjGtbd.gtbdId.in(gtbdId));
        return (List)baseRepository.dslList(jpaQuery,qsSjGtbd);
    }

    @Override
    @Transactional(readOnly = true)
    public List<SSjGtbd> getDxfGtbdByDjh(String[] djh) {
        QSSjGtbd qsSjGtbd = QSSjGtbd.sSjGtbd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjGtbd).where(qsSjGtbd.djh.in(djh)).where(qsSjGtbd.blzt.isNull());
        return (List)baseRepository.dslList(jpaQuery,qsSjGtbd);
    }

    @Override
    @Transactional(readOnly = true)
    public SSjGtbd getGtbdById(String gtbdId) {
        return baseRepository.get(SSjGtbd.class,gtbdId);
    }

    /*
    @Override
    @Transactional
    public void saveGtbzCztdysHcdjb(GtDjTzQuery gtDjTzQuery) {
        String gtbdId = gtDjTzQuery.getGtbdId();
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByBdId(gtbdId);
        if(swHcXmRwRel.getSwDjSy()==null){
            Zd zd = new Zd();
            SwDjJbb swDjJbb = taxService.findSwDjJbbByGlbm(gtDjTzQuery.getTdjbbglbm());
            if(swDjJbb==null){
                swDjJbb = new SwDjJbb();
                swDjJbb.setJbbId(UUIDGenerator.generate());
                swDjJbb.setGlbm(gtDjTzQuery.getTdjbbglbm());
                swDjJbb.setNsrmc(gtDjTzQuery.getTdjbbnsrmc());
                swDjJbb.setZgkgDm(gtDjTzQuery.getTdjbbzgkgDm());
                swDjJbb.setSgyMc(gtDjTzQuery.getTdjbbsgyMc());
                swDjJbb.setFddbr(gtDjTzQuery.getTdjbbfddbr());
                swDjJbb.setLxdh(gtDjTzQuery.getTdjbblxdh());
            }
            zd.setDjh(gtDjTzQuery.getDjh());
            SwDjTd swDjTd = new SwDjTd();
            swDjTd.setTdId(UUIDGenerator.generate());
            swDjTd.setTdzl(gtDjTzQuery.getTdtdzl());
            SwDjSy swDjSy = new SwDjSy();
            swDjSy.setSyId(UUIDGenerator.generate());
            swDjSy.setSwDjTd(swDjTd);
            swDjSy.setZd(zd);
            swDjSy.setDbh(taxService.createDbhByDjh(gtDjTzQuery.getDjh()));
            swDjSy.setSyzt("3");
            swDjTd.setSwDjSy(swDjSy);
            swDjTd.setSwDjJbb(swDjJbb);
            taxService.saveSwDjSy(swDjSy);
            swHcXmRwRel.setSwDjSy(swDjSy);
            hcxmService.updateSwHcXmRwRel(swHcXmRwRel);
            //新增临时税源
        }else{
            //更新临时税源
            SwDjTd swDjTd =swHcXmRwRel.getSwDjSy().getSwDjTd();
            swDjTd.setTdzl(gtDjTzQuery.getTdtdzl());
            SwDjJbb swDjJbb = taxService.findSwDjJbbByGlbm(gtDjTzQuery.getTdjbbglbm());
            if(swDjJbb==null){
                swDjJbb = new SwDjJbb();
                swDjJbb.setJbbId(UUIDGenerator.generate());
                swDjJbb.setGlbm(gtDjTzQuery.getTdjbbglbm());
                swDjJbb.setNsrmc(gtDjTzQuery.getTdjbbnsrmc());
                swDjJbb.setZgkgMc(gtDjTzQuery.getTdjbbzgkgMc());
                swDjJbb.setSgyMc(gtDjTzQuery.getTdjbbsgyMc());
                swDjJbb.setFddbr(gtDjTzQuery.getTdjbbfddbr());
                swDjJbb.setLxdh(gtDjTzQuery.getTdjbblxdh());
            }
            swDjTd.setSwDjJbb(swDjJbb);
            taxService.updateSwDjTd(swDjTd);
        }
    }


    @Override
    @Transactional
    public void saveGtbzFcsHcdjb(GtDjTzQuery gtDjTzQuery) {
        String gtbdId = gtDjTzQuery.getGtbdId();
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByBdId(gtbdId);
        if(swHcXmRwRel.getSwDjSy().getSwDjFc()==null){
            SwDjJbb swDjJbb = taxService.findSwDjJbbByGlbm(gtDjTzQuery.getFcglbm());
            if(!swHcXmRwRel.getSwDjSy().getSwDjTd().getSwDjJbb().getGlbm().equals(gtDjTzQuery.getFcglbm()))
                throw new TaxException("房产税源的纳税人信息与土地税源的纳税人信息不一致");

            SwDjFc swDjFc = new SwDjFc();
            swDjFc.setFcId(UUIDGenerator.generate());
            swDjFc.setFczh(gtDjTzQuery.getFcfczh());
            swDjFc.setSwDjSy(swHcXmRwRel.getSwDjSy());
            swDjFc.setSwDjJbb(swDjJbb);
            taxService.createSwDjFc(swDjFc);
            //新增临时税源
        }else{
            //更新临时税源
            SwDjFc swDjFc =swHcXmRwRel.getSwDjSy().getSwDjFc();
            swDjFc.setFczh(gtDjTzQuery.getFcfczh());
            taxService.updateSwDjFc(swDjFc);
        }
    }
    */
    @Override
    @Transactional
    public Page<GtSwTzQuery> findGtppxxMap(String xzqbh, String lx, Pageable pageable, GtSwTzQuery gtSwTzQuery) {
        QSSjGtbd qsSjGtbd=QSSjGtbd.sSjGtbd;
        QSSjSwbd qsSjSwbd = QSSjSwbd.sSjSwbd;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;

        if (pageable==null||pageable.getPageNumber()==0) {
            pageable = new PageRequest(1, 15);
        }
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        if (xzqbh!=null){
            if (xzqbh.length()>6&&xzqbh.length()<=8){
                xzqbh=xzqbh.substring(0,6)+"0"+xzqbh.substring(6);

            }else  if (xzqbh.length()>8&&xzqbh.length()<=10){
                xzqbh=xzqbh.substring(0,6)+"0"+xzqbh.substring(6,8)+"0"+xzqbh.substring(8);

            }
        }

        if (lx.equals("1")){
            QBean qBeanz = Projections.bean(GtSwTzQuery.class, qsSjGtbd.tdzh, qsSjGtbd.scmj
                    , qsSjGtbd.tdytMc, qsSjGtbd.tdzl, qsSjGtbd.qlrmc, qsSjGtbd.ppzt, qsSjGtbd.djh, qsSjGtbd.dbh,
                    qsSjSwbd.glbm,   qsSjSwbd.glyMc, qsSjSwbd.fcnynse,
                    qsSjSwbd.tdnynse);
            if (xzqbh!=null){
                jpaQuery.from(qsSjGtbd,qsSjSwbd).where(qsSjGtbd.djh.eq(qsSjSwbd.djh)).where(qsSjGtbd.dbh.eq(qsSjSwbd.dbh))
                        .where(qsSjGtbd.djh.substring(0,xzqbh.length()).eq(xzqbh));
            }else{
                jpaQuery.from(qsSjGtbd,qsSjSwbd).where(qsSjGtbd.djh.eq(qsSjSwbd.djh)).where(qsSjGtbd.dbh.eq(qsSjSwbd.dbh)) ;
            }
            applyQueryPredicates(gtSwTzQuery,qsSjGtbd,jpaQuery,lx);
            return baseRepository.find(jpaQuery,qBeanz,pageable) ;
        }else{

            QBean qBeanz = Projections.bean(GtSwTzQuery.class,qsSjGtbd.tdzh,qsSjGtbd.scmj
                    ,qsSjGtbd.tdytMc,qsSjGtbd.tdzl,qsSjGtbd.qlrmc,qsSjGtbd.ppzt,qsSjGtbd.djh,qsSjGtbd.gtbdId);

            //PQLQuery bdidQuery = new JPAQuery(baseRepository.getEntityManager());
            //List list = bdidQuery.from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.ZDHC.toString())).list(qSwHcXmRwRel.bdId);


            if (xzqbh!=null)
                jpaQuery.from(qsSjGtbd).where(qsSjGtbd.djh.substring(0,xzqbh.length()) .eq(xzqbh)).where(qsSjGtbd.ppzt.isNull()).where(qsSjGtbd.blzt.isNull());
            else
                jpaQuery.from(qsSjGtbd).where(qsSjGtbd.ppzt.isNull()).where(qsSjGtbd.blzt.isNull());
            applyQueryPredicates(gtSwTzQuery,qsSjGtbd,jpaQuery,lx);
            return baseRepository.find(jpaQuery,qBeanz,pageable);
        }
    }

    @Override
    @Transactional
    public List<SSjGtbd> findGtppxxList(String xzqbh, String lx, GtSwTzQuery gtSwTzQuery) {
        QSSjGtbd qsSjGtbd = QSSjGtbd.sSjGtbd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qsSjGtbd).where(qsSjGtbd.blzt.isNull());
        applyQueryPredicates(gtSwTzQuery,qsSjGtbd,jpaQuery,lx);
        return (List)baseRepository.dslList(jpaQuery,qsSjGtbd);
    }




    @Override
    @Transactional
    public void delZdhcRw(String proid) {
        String jpql = "update SSjGtbd set proid=null,istx=null,blzt=null where proid=?0";
        baseRepository.executeJpql(jpql,proid);
        jpql = "delete from SwHcXmRwRel where rwId=?0";
        baseRepository.executeJpql(jpql,proid);
    }

    @Override
    @Transactional
    public void saveSwDjSy(SwDjSyQuery swDjSyQuery) throws  Exception{
        //保存税源
        String syzt = Syzt.LS.toString();
        taxService.saveSwDjSyQuery(swDjSyQuery,syzt);
    }

    @Override
    @Transactional(readOnly = true)
    public List<GtSwTzQuery> getWhczdList(HashMap param) {
        String xzqbh = String.valueOf(param.get("xzqbh")==null?"":param.get("xzqbh"));
        Object idsObj = param.get("ids");
        String lx = String.valueOf(param.get("lx"));
        GtSwTzQuery gtSwTzQuery = (GtSwTzQuery) param.get("sSjGtbd");
        QSSjGtbd qsSjGtbd=QSSjGtbd.sSjGtbd;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QZd qZd = QZd.zd;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        if (StringUtils.isNotBlank(xzqbh)){
            if (xzqbh.length()>6&&xzqbh.length()<=8){
                xzqbh=xzqbh.substring(0,6)+"0"+xzqbh.substring(6);

            }else  if (xzqbh.length()>8&&xzqbh.length()<=10){
                xzqbh=xzqbh.substring(0,6)+"0"+xzqbh.substring(6,8)+"0"+xzqbh.substring(8);

            }
        }
        QBean qBeanz = Projections.bean(GtSwTzQuery.class,qsSjGtbd.tdzh,qsSjGtbd.scmj
                ,qsSjGtbd.tdytMc,qsSjGtbd.tdzl,qsSjGtbd.qlrmc,qsSjGtbd.ppzt,qsSjGtbd.djh,qsSjGtbd.gtbdId);
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();

        if (StringUtils.isNotBlank(xzqbh))
            jpaQuery.from(qsSjGtbd).where(qsSjGtbd.djh.substring(0,xzqbh.length()) .eq(xzqbh)).where(qsSjGtbd.ppzt.isNull()).where(qsSjGtbd.gtbdId.notIn(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.ZDHC.toString())).list(qSwHcXmRwRel.bdId)));
        else
            //jpaQuery.from(qsSjGtbd).where(qsSjGtbd.ppzt.isNull()).where(qsSjGtbd.gtbdId.notIn(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.ZDHC.toString())).list(qSwHcXmRwRel.bdId)));
            jpaQuery.from(qsSjGtbd);

        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qsSjGtbd.gtbdId.in(idsList));
        }else{
            jpaQuery.where(qsSjGtbd.djh.in(new JPASubQuery().from(qZd).where(qZd.sgqdm.like( regionCode + QueryCondition.WILDCARDS)).list(qZd.djh)));
            applyQueryPredicates(gtSwTzQuery,qsSjGtbd,jpaQuery,lx);
        }
        jpaQuery.orderBy(qsSjGtbd.djh.desc().nullsLast());

        return (List)baseRepository.dslList(jpaQuery,qBeanz);

    }

    private void applyQueryPredicates(GtSwTzQuery gtSwTzQuery,EntityPath entityPath,JPQLQuery jpaQuery,String lx){
        if (StringUtils.isNotBlank(lx) && lx.equals("1"))
            jpaQuery.where(Expressions.stringPath(entityPath, "ppzt").isNotNull());
        else
            jpaQuery.where(Expressions.stringPath(entityPath,"ppzt").isNull());
        if(StringUtils.isNotBlank(gtSwTzQuery.getDjh()))
            jpaQuery.where(Expressions.stringPath(entityPath,"djh").like(QueryCondition.WILDCARDS + gtSwTzQuery.getDjh()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(entityPath,"qlrmc").like(QueryCondition.WILDCARDS + gtSwTzQuery.getQlrmc()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(entityPath,"tdzl").like(QueryCondition.WILDCARDS + gtSwTzQuery.getTdzl()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdytDm()))
            jpaQuery.where(Expressions.stringPath(entityPath,"tdytDm").eq(gtSwTzQuery.getTdytDm()));
        if(StringUtils.isNotBlank(gtSwTzQuery.getExcelBegin()) && StringUtils.isNotBlank(gtSwTzQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(gtSwTzQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(gtSwTzQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }

    }

    @Override
    @Transactional(readOnly = true)
    public Page<GtSwTzQuery> yxflbJson(Pageable pageable, GtSwTzQuery gtSwTzQuery) {
        QSSjGtbd qsSjGtbd=QSSjGtbd.sSjGtbd;
        QSSjSwbd qsSjSwbd = QSSjSwbd.sSjSwbd;
        QSwHcXm qSwHcXm = QSwHcXm.swHcXm;
        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;

        if (pageable==null||pageable.getPageNumber()==0) {
            pageable = new PageRequest(1, 15);
        }
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBeanz = Projections.bean(GtSwTzQuery.class,qsSjGtbd.tdzh,qsSjGtbd.scmj
                ,qsSjGtbd.tdytMc,qsSjGtbd.tdzl,qsSjGtbd.qlrmc,qsSjGtbd.ppzt,qsSjGtbd.djh,qsSjGtbd.gtbdId);
        jpaQuery.from(qsSjGtbd).where(qsSjGtbd.gtbdId.in(new JPASubQuery().from(qSwHcXmRwRel).leftJoin(qSwHcXmRwRel.swHcXm,qSwHcXm).where(qSwHcXm.xmlx.eq(Hcxmlx.ZDHC.toString())).list(qSwHcXmRwRel.bdId)));

        if(StringUtils.isNotBlank(gtSwTzQuery.getDjh()))
            jpaQuery.where(Expressions.stringPath(qsSjGtbd,"djh").like(QueryCondition.WILDCARDS + gtSwTzQuery.getDjh()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(qsSjGtbd,"qlrmc").like(QueryCondition.WILDCARDS + gtSwTzQuery.getQlrmc()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qsSjGtbd,"tdzl").like(QueryCondition.WILDCARDS + gtSwTzQuery.getTdzl()+ QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gtSwTzQuery.getTdytDm()))
            jpaQuery.where(Expressions.stringPath(qsSjGtbd,"tdytDm").eq(gtSwTzQuery.getTdytDm()));
        return baseRepository.find(jpaQuery,qBeanz,pageable);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getZtByGtbdId(String gtbdId) {
        String sql = "select t2.blzt,t4.activity_name,t4.activity_state,t4.activity_definition_id,to_char(t5.user_id)user_id,to_char(t6.user_name)user_name from s_sj_gtbd t1 " +
                        "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id = t2.bd_id " +
                        "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                        "left join " +
                        "( " +
                        "  select * from pf_activity t where t.activity_state='1'   " +
                        ") t4  " +
                        "on t4.workflow_instance_id=t2.rw_id "+
                        "left join pf_assignment t5 on t5.activity_id=t4.activity_id "+
                        "left join pf_user t6 on t5.user_id=t6.user_id "+
                        "where t3.xmlx='"+Hcxmlx.ZDHC.toString()+"' "+
                        "and t1.gtbd_id='"+gtbdId+"' ";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        ResponseMessage responseMessage = new ResponseMessage();
        HashMap resultMap = new HashMap();
        if(CollectionUtils.isNotEmpty(list)){
            HashMap<String,Object> tempMap = list.get(0);
            String activityName = String.valueOf(tempMap.get("ACTIVITY_NAME")==null?"":tempMap.get("ACTIVITY_NAME"));
            String activity_state = String.valueOf(tempMap.get("ACTIVITY_STATE")==null?"":tempMap.get("ACTIVITY_STATE"));
            String activity_definition_id = String.valueOf(tempMap.get("ACTIVITY_DEFINITION_ID")==null?"":tempMap.get("ACTIVITY_DEFINITION_ID"));
            String blzt = String.valueOf(tempMap.get("BLZT")==null?"":tempMap.get("BLZT"));
            String userName = String.valueOf(tempMap.get("USER_NAME")==null?"":tempMap.get("USER_NAME"));
            resultMap.put("userName",StringUtils.isBlank(userName)?"":userName);
            if(StringUtils.isNotBlank(blzt) && "1".equals(blzt)){
                responseMessage.setMsg("6");
            }else if(StringUtils.isBlank(activityName) || "null".equalsIgnoreCase(activityName)){
                responseMessage.setMsg("0");
            }else if("1".equals(activity_state)){
                String[] configArr = (String[]) hcjdConfigMap.get(Hcxmlx.ZDHC.toString());
                if(StringUtils.isNotBlank(activity_definition_id)){
                    for(int i=0;i<configArr.length;i++){
                        if(activity_definition_id.equalsIgnoreCase(configArr[i])){
                            responseMessage.setMsg(i+1+"");
                        }
                    }
                }
            }

        }else{
            responseMessage.setMsg("0");
        }
        resultMap.put("statue",responseMessage.getMsg());
        return resultMap;
    }

    @Override
    @Transactional
    public void delWorkflow(String sgqdm,String djh) {

        if(djh!=null){
            String sSjGtbdSql = "update SSjGtbd  set blzt='' where blzt is not null and djh in ("+"select t.djh from Zd t where t.sgqdm like '"+sgqdm+"%' and t.djh in "+djh+")";
            baseRepository.executeJpql(sSjGtbdSql);
            //2，删除pf_assignment根据djh
            //删除pf_assignment
            String delAssignmentSql = "delete from pf_assignment t where t.assignment_id in ( " +
                    "       select t1.assignment_id from pf_assignment t1 " +
                    "       left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                    "       left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                    "       where t3.workflow_instance_id in( " +
                    "             select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in (select t.gtbd_id from s_sj_gtbd t where t.djh in(  " +
                    "             select t.djh from Zd t where t.sgqdm like '" + sgqdm + "%' and t.djh in "+djh+")   " +
                    "             ) " +
                    "      ))";
            Query delAssignmentQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmentSql);
            delAssignmentQuery.executeUpdate();
            //3,删除pf_assignmenthistory

            String delAssignmenthistorySql = "delete from pf_assignmenthistory t where t.assignment_id in ( " +
                    "       select t1.assignment_id from pf_assignmenthistory t1 " +
                    "       left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                    "       left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                    "       where t3.workflow_instance_id in ( " +
                    "             select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in (select t.gtbd_id from s_sj_gtbd t where t.djh in(  " +
                    "             select t.djh from Zd t where t.sgqdm like '" + sgqdm + "%' and t.djh in "+djh+")   " +
                    "             ) " +
                    "      ))";
            Query delAssignmenthistoryQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmenthistorySql);
            delAssignmenthistoryQuery.executeUpdate();
            //4，删除pf_activity
            //activityId list
            String delActivitySql = "delete from pf_activity t where t.activity_id in(select t1.activity_id from pf_activity t1 " +
                    "left join pf_workflow_instance t2 on t1.workflow_instance_id=t2.workflow_instance_id " +
                    "where t2.workflow_instance_id in ( " +
                    "      select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in ( " +
                    "             select t.gtbd_id from s_sj_gtbd t where t.djh in ( " +
                    "                    select t.djh from Zd t where t.sgqdm like '" + sgqdm + "%' and t.djh in "+djh+")   " +
                    "       ) " +
                    "))";
            Query delActivityQuery = baseRepository.getEntityManager().createNativeQuery(delActivitySql);
            delActivityQuery.executeUpdate();
            //5,删除pf_workflow_instance
            String delWorkflowInstanceSql = "delete from pf_workflow_instance t where t.workflow_instance_id in( " +
                    "       select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in ( " +
                    "              select t.gtbd_id from s_sj_gtbd t where t.djh in( " +
                    "                     select t.djh from Zd t where t.sgqdm like '" + sgqdm + "%' " +"and t.djh in "+djh+
                    "              )))";
            Query delWorkflowInstanceQuery = baseRepository.getEntityManager().createNativeQuery(delWorkflowInstanceSql);
            delWorkflowInstanceQuery.executeUpdate();
            //6,删除sw_hc_xm_rw_rel
            String delSwHcXmRwRelSql = "delete from SwHcXmRwRel t where t.shxrId in( " +
                    "       select t.shxrId from SwHcXmRwRel t where t.bdId in( " +
                    "              select t.gtbdId from SSjGtbd t where t.djh in ( " +
                    "                     select t.djh from Zd t where t.sgqdm like '" + sgqdm + "%' " +"and t.djh in "+djh+
                    "               )))";
            baseRepository.executeJpql(delSwHcXmRwRelSql);
        }else {
            String sSjGtbdSql = "update SSjGtbd  set blzt='' where blzt is not null and djh in ("+"select t.djh from Zd t where t.sgqdm like '"+sgqdm+"%' "+")";
            baseRepository.executeJpql(sSjGtbdSql);
            //删除pf_assignment
            String delAssignmentSql = "delete from pf_assignment t where t.assignment_id in ( " +
                    "       select t1.assignment_id from pf_assignment t1 " +
                    "       left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                    "       left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                    "       where t3.workflow_instance_id in( " +
                    "             select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in (select t.gtbd_id from s_sj_gtbd t where t.djh in(  " +
                    "             select t.djh from Zd t where t.sgqdm like '" + sgqdm + "%')   " +
                    "             ) " +
                    "      ))";
            Query delAssignmentQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmentSql);
            delAssignmentQuery.executeUpdate();
            //3,删除pf_assignmenthistory

        String delAssignmenthistorySql = "delete from pf_assignmenthistory t where t.assignment_id in ( " +
                "       select t1.assignment_id from pf_assignmenthistory t1 " +
                "       left join pf_activity t2 on t1.activity_id=t2.activity_id " +
                "       left join pf_workflow_instance t3 on t3.workflow_instance_id=t2.workflow_instance_id " +
                "       where t3.workflow_instance_id in ( " +
                "             select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in (select t.gtbd_id from s_sj_gtbd t where t.djh in(  " +
                "             select t.djh from Zd t where t.sgqdm like '"+sgqdm+"%')   " +
                "             ) " +
                "      ))";
        Query delAssignmenthistoryQuery = baseRepository.getEntityManager().createNativeQuery(delAssignmenthistorySql);
        delAssignmenthistoryQuery.executeUpdate();
        //4，删除pf_activity
        //activityId list
        String delActivitySql = "delete from pf_activity t where t.activity_id in(select t1.activity_id from pf_activity t1 " +
                "left join pf_workflow_instance t2 on t1.workflow_instance_id=t2.workflow_instance_id " +
                "where t2.workflow_instance_id in ( " +
                "      select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in ( " +
                "             select t.gtbd_id from s_sj_gtbd t where t.djh in ( " +
                "                    select t.djh from Zd t where t.sgqdm like '"+sgqdm+"%'  " +
                "             ) " +
                "       ) " +
                "))";
        Query delActivityQuery = baseRepository.getEntityManager().createNativeQuery(delActivitySql);
        delActivityQuery.executeUpdate();
        //5,删除pf_workflow_instance
        String delWorkflowInstanceSql = "delete from pf_workflow_instance t where t.workflow_instance_id in( " +
                "       select t.rw_id from sw_hc_xm_rw_rel t where t.bd_id in ( " +
                "              select t.gtbd_id from s_sj_gtbd t where t.djh in( " +
                "                     select t.djh from Zd t where t.sgqdm like '"+sgqdm+"%' " +
                "              )))";
        Query delWorkflowInstanceQuery = baseRepository.getEntityManager().createNativeQuery(delWorkflowInstanceSql);
        delWorkflowInstanceQuery.executeUpdate();
        //6,删除sw_hc_xm_rw_rel
        String delSwHcXmRwRelSql = "delete from SwHcXmRwRel t where t.shxrId in( " +
                "       select t.shxrId from SwHcXmRwRel t where t.bdId in( " +
                "              select t.gtbdId from SSjGtbd t where t.djh in ( " +
                "                     select t.djh from Zd t where t.sgqdm like '"+sgqdm+"%' " +
                "               )))";
        baseRepository.executeJpql(delSwHcXmRwRelSql);
		}
    }

    @Override
    @Transactional
    public void autoCreateWorkflow(String sgqdmLike) throws  Exception{
        //1,首先删除任务
        delWorkflow(sgqdmLike,null);

        //2,自动创建下发
        String jpql = "from SSjGtbd t where t.djh in(select t.djh from Zd t where t.sgqdm like '"+sgqdmLike+"%' )";
        List<SSjGtbd> list =  baseRepository.getByJpql(jpql);
        //创建任务
        if(CollectionUtils.isNotEmpty(list)){
            //获取市局用户id
            String loginName = AppConfig.getProperty(CREATE_USER_NAME);
          //  if(StringUtils.isBlank(loginName)){
           //     //默认自动创建的用户名是市局
          //      loginName = "shi_yanshi";
			//}
            //根据用户名获取用户
            PfUserVo userVo = sysUserService.getUserByloginName(loginName);

            if(userVo!=null){
                /**
                 *自动创建工作流
                 */
                String userId = userVo.getUserId();
                SwHcXm swHcXm = new SwHcXm();
                swHcXm.setMc("国土宗地核查项目"+new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                swHcXm.setXmId(UUIDGenerator.generate());
                swHcXm.setCjrq(Calendar.getInstance().getTime());
                swHcXm.setCjrId(userId);
                swHcXm.setXmlx(Hcxmlx.ZDHC.toString());
                swHcXm.setXmybj("0");
                baseRepository.save(swHcXm);
                for(SSjGtbd sSjGtbd:list){
                    Project project = new Project();
                    String wiid = UUIDGenerator.generate();
                    project.setProjectId(wiid);
                    String wwid = AppConfig.getProperty("sszd");
                    project.setWdid(wwid);
                    project.setBz(sSjGtbd.getDjh());
                    platUtil.createWorkFlowInstance(project, userId,sSjGtbd.getQlrmc());
                    SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
                    swHcXmRwRel.setShxrId(UUIDGenerator.generate());
                    swHcXmRwRel.setRwId(wiid);
                    swHcXmRwRel.setSwHcXm(swHcXm);
                    swHcXmRwRel.setBdId(sSjGtbd.getGtbdId());
                    swHcXmRwRel.setBlzt("0");
                    baseRepository.save(swHcXmRwRel);
                    sSjGtbd.setBlzt("0");
                    baseRepository.update(sSjGtbd);

                    //自动转发到区县
                    PerformerTaskModel result=getTurnUserList(userId,wiid);
                    List<PfUserVo> toUserList = result.getUserList();
                    String djh = sSjGtbd.getDjh();
                    String toUserId = "";
                    Zd zd = zdService.findZdByDjh(djh);
                    //根据djh过滤区县转发人
                    if(CollectionUtils.isNotEmpty(toUserList)){
                        for(PfUserVo pfUserVo : toUserList){

                            String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                            if(regionCode.length()>6){
                                regionCode = regionCode.substring(0,6);
                            }
                            /* 当时汉中下发任务存在配错问题 其他地方不用了
                            if(StringUtils.isBlank(regionCode) || regionCode.length()==8){
                                continue;
                            }
                            */

                            String sgqdm = zd.getSgqdm();
                            if(sgqdm.startsWith(regionCode)){
                                toUserId = pfUserVo.getUserId();
                                break;
                            }
                        }
                    }

                    //实现工作流转发
                    if(StringUtils.isNotBlank(toUserId)){
                        //任务自动转发
                        String taskid = PlatUtil.getTaskIdByProid(wiid);
                        String turnXml = initTurnTaskXml(wiid,toUserId,taskid);
                        //System.out.println(turnXml);
                        Document doc = DocumentHelper.parseText(turnXml);
                        workFlowService.turnTask(doc,taskid);

                        //转发给组长
                        PerformerTaskModel resultZz=getTurnUserList(toUserId,wiid);
                        List<PfUserVo> toUserListZz = resultZz.getUserList();
                        String toUserIdZz = "";


                        //根据sgqdm过滤区县转发人
                        if(CollectionUtils.isNotEmpty(toUserListZz)){
                            for(PfUserVo pfUserVo : toUserListZz){
                                String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                                zd = zdService.findZdByDjh(djh);
                                String sgqdm = zd.getSgqdm();
                                if(sgqdm.equals(regionCode)){
                                    toUserIdZz = pfUserVo.getUserId();
                                    break;
                                }
                            }
                        }
                        //实现工作流转发
                        if(StringUtils.isNotBlank(toUserIdZz)){
                            //任务自动转发
                            String taskidZz = PlatUtil.getTaskIdByProid(wiid);
                            String turnXmlZz = initTurnTaskXml(wiid,toUserIdZz,taskidZz);
                            //System.out.println(turnXml);
                            Document docZz = DocumentHelper.parseText(turnXmlZz);
                            workFlowService.turnTask(docZz,taskidZz);
                        }
                    }
                }
            }else{
                throw new RuntimeException("没有根据用户名"+loginName+"查出对应用户");
            }
        }
    }

    @Override
    public PerformerTaskModel getTurnUserList(String userId,String proid) throws  Exception{
        PerformerTaskModel result=new PerformerTaskModel();
        try {
            //获取工作流转发信息
            String taskid = PlatUtil.getTaskIdByProid(proid);
            if (StringUtils.isNotBlank(taskid)){
                WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
                // 活动模型
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
                // 定义转发列表
                List<TransitionModel> lstTrans = activityModel.getTransitionsList();
                List<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List<PerformerModel> performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                        if (!performerModel.getUserId().equals("")) {// 参与者是人
                            String userid = performerModel.getUserId();
                            PfUserVo userVo = sysUserService.getUserVo(userid);
                            List<PfOrganVo> organs=sysUserService.getOrganListByUser(userVo.getUserId());
                            result.setName(organs.get(0).getOrganName());
                            result.setId("0");
                            result.getUserList().add(userVo);
                            result.setType("User");
                        } else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
                            List<PfUserVo> users = sysUserService.getUserListByOragn(performerModel.getOrganId());
                            PfOrganVo organVo=sysUserService.getOrganVo(performerModel.getOrganId());
                            if (organVo!=null){
                                result.setName(organVo.getOrganName());
                                result.setId(organVo.getOrganId());
                                for(PfUserVo vo:users){
                                    result.getUserList().add(vo);
                                }
                            }
                            result.setType("Organ");
                        } else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                            List<PfUserVo> users = sysUserService.getUserListByRole(performerModel
                                    .getRoleId());
                            PfRoleVo roleVo = sysUserService.getRoleVo(performerModel
                                    .getRoleId());
                            result.setName(roleVo.getRoleName());
                            result.setId(roleVo.getRoleId());
                            for(PfUserVo vo:users){
                                result.getUserList().add(vo);
                            }
                            result.setType("Role");
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }
    @Override
    public String initTurnTaskXml(String proid,String userId,String taskid)throws Exception{
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo=info.getTransInfo();
        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            String nextActivityDefineId = lstTrans.get(0).getDefineId();
            WorkFlowXml workXml =WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);

            List<PerformerModel> performerList = nextModel.getPerformerList();
            if (performerList != null && performerList.size() > 0){
                String roleId = "";
                List<PfRoleVo> roleList = sysUserService.getRoleListByUser(userId);
                for (PerformerModel performerModel : performerList) {
                    if (StringUtils.isNotBlank(performerModel.getRoleId())){
                        boolean isok = false;
                        for (PfRoleVo roleVo : roleList){
                            if (StringUtils.equals(performerModel.getRoleId(),roleVo.getRoleId())){
                                roleId = performerModel.getRoleId();
                                isok = true;
                                break;
                            }
                        }
                        if (isok){
                            break;
                        }
                    }
                }

                String activityRelType = "";
                if (transInfo.getTransType().equalsIgnoreCase("and"))
                    activityRelType = "and";
                else
                    activityRelType = "or";

                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement += " SendSMS= \"false\"";
                activitysElement += ">";
                String activityElement = "<Activity ";
                activityElement += " Id=\"" + nextActivityDefineId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement += " RoleId=\"" + roleId + "\"";
                userInfoElement += " Id=\"" + userId + "\">";
                userInfoElement += "</UserInfo>";
                activityElement += userInfoElement;
                activityElement += "</Activity>";
                activitysElement += activityElement;

                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement += "</text>";
                remarkElement += remarkTextElement + "</ReMark>";
                activitysElement += remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getTJrws(GtSwTzQuery sSjGtbd) throws Exception{
        Map resultMap = new HashMap();
        String workflowDefinId = AppConfig.getProperty("sszd");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String wxf = getWxfSql(sSjGtbd,activityList,regionCode);
        String sjxf = getSjxfSql(sSjGtbd,activityList,regionCode);
        String qxxf = getQxxfSql(sSjGtbd,activityList,regionCode);
        String hczzxf = getHczzxfSql(sSjGtbd,activityList,regionCode);
        String swryxf = getSwryxfSql(sSjGtbd,activityList,regionCode);
        String qrrk = getQrrkSql(sSjGtbd,activityList,regionCode);
        String ybj = getYbjSql(sSjGtbd,activityList,regionCode);
        resultMap.put("WXF",wxf);
        resultMap.put("SJXF",sjxf);
        resultMap.put("QXXF",qxxf);
        resultMap.put("ZZ",hczzxf);
        resultMap.put("SWRY",swryxf);
        resultMap.put("QRRK",qrrk);
        resultMap.put("YBJ",ybj);
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public HashMap getSyScmjSumByDjh(String djh) {
        String sql ="select round(nvl(sum(nvl(t1.scmj,0)),0),2)sumScmj " +
                "from sw_dj_td t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                "left join zd t3 on t3.djh=t2.djh " +
                "where (t2.syzt is null or t2.syzt!='2')" +
                "and t3.djh='"+djh+"' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        HashMap result = new HashMap();
        if(CollectionUtils.isNotEmpty(list)){
            result = list.get(0);
        }
        return result;
    }

    @Override
    public void isShowBtnByRoleName(String delBtnRoleName, String autoCreRoleName, String createRoleName, Model model) {
        //根据当前登录用户判断是否显示删除，和自动创建按钮
        Boolean showDelBtn = false;
        Boolean showAutoBtn = false;
        Boolean showCreBtn = false;
        delBtnRoleName = AppConfig.getProperty(delBtnRoleName);
        autoCreRoleName = AppConfig.getProperty(autoCreRoleName);
        createRoleName = AppConfig.getProperty(createRoleName);

        List<PfRoleVo> roleList = sysUserService.getRoleListByUser(SessionUtil.getCurrentUserId());
        List roleNameList = new ArrayList();
        if(CollectionUtils.isNotEmpty(roleList)){
            for(int i=0;i<roleList.size();i++){
                roleNameList.add(roleList.get(i).getRoleName());
            }
        }

        String[] delBtnArr = delBtnRoleName.split(",");
        String[] autoBtnArr = autoCreRoleName.split(",");
        String[] createBtnArr = createRoleName.split(",");

        if(CollectionUtils.isNotEmpty(roleList)){
            for(int i=0;i<roleNameList.size();i++){
                for(int j=0;j<delBtnArr.length;j++){
                    if(roleNameList.get(i).equals(delBtnArr[j])){
                        showDelBtn = true;
                        break;
                    }
                }
                if(showDelBtn){
                    break;
                }
            }

            for(int i=0;i<roleNameList.size();i++){
                for(int j=0;j<autoBtnArr.length;j++){
                    if(roleNameList.get(i).equals(autoBtnArr[j])){
                        showAutoBtn = true;
                        break;
                    }
                }
                if(showAutoBtn){
                    break;
                }
            }

            for(int i=0;i<roleNameList.size();i++){
                for(int j=0;j<createBtnArr.length;j++){
                    if(roleNameList.get(i).equals(createBtnArr[j])){
                        showCreBtn = true;
                        break;
                    }
                }
                if(showCreBtn){
                    break;
                }
            }
        }
        model.addAttribute("showDelBtn",showDelBtn);
        model.addAttribute("showAutoBtn",showAutoBtn);
        model.addAttribute("showCreBtn",showCreBtn);
    }

    private String getYbjSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(*) from s_sj_gtbd t1 where t1.blzt='1' ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQrrkSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.gtbd_id)) from s_sj_gtbd t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='1' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(4)).get("activityDefinitionId"))+"' ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getSwryxfSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.gtbd_id)) from s_sj_gtbd t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='1' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(3)).get("activityDefinitionId"))+"' ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getHczzxfSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.gtbd_id)) from s_sj_gtbd t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='1' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(2)).get("activityDefinitionId"))+"' ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getQxxfSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.gtbd_id)) from s_sj_gtbd t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='1' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId"))+"' ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

//    private String getQxxfSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
//        String sql = "select count(distinct(t1.gtbd_id)) from s_sj_gtbd t1  " +
//                "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id=t2.bd_id " +
//                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
//                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
//                "where t3.xmlx='1' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(1)).get("activityDefinitionId"))+"' ";
//        sql = addQueryWhere(sSjGtbd,sql,regionCode);
//        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
//        List list = query.getResultList();
//        if(CollectionUtils.isNotEmpty(list))
//            return String.valueOf(list.get(0));
//        return null;
//    }

    private String getSjxfSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(distinct(t1.gtbd_id)) from s_sj_gtbd t1  " +
                "left join sw_hc_xm_rw_rel t2 on t1.gtbd_id=t2.bd_id " +
                "left join sw_hc_xm t3 on t3.id=t2.hcxm_id " +
                "left join (select * from pf_activity t where t.activity_state='1')t4 on t4.workflow_instance_id=t2.rw_id " +
                "where t3.xmlx='1' and t4.activity_definition_id='"+String.valueOf(((HashMap)activityList.get(0)).get("activityDefinitionId"))+"' ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String getWxfSql(GtSwTzQuery sSjGtbd,List activityList,String regionCode) {
        String sql = "select count(*) from s_sj_gtbd t1 where t1.blzt is null ";
        sql = addQueryWhere(sSjGtbd,sql,regionCode);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list))
            return String.valueOf(list.get(0));
        return null;
    }

    private String addQueryWhere(GtSwTzQuery sSjGtbd,String sql,String regionCode){
        if(StringUtils.isNotBlank(sSjGtbd.getDjh())){
            sql = sql + "and t1.djh like '%"+sSjGtbd.getDjh()+"%' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getQlrmc())){
            sql = sql +"and t1.qlrmc like '%"+sSjGtbd.getQlrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getTdytDm())){
            sql = sql + "and t1.tdyt_dm='"+sSjGtbd.getTdytDm()+"' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getTdzl())){
            sql = sql +"and t1.tdzl like '%"+sSjGtbd.getTdzl()+"%' ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getIsxf()) && Isxf.YXF.toString().equals(sSjGtbd.getIsxf())){
            sql = sql + "and t1.blzt is not null ";
        }
        if(StringUtils.isNotBlank(sSjGtbd.getIsxf()) && Isxf.WXF.toString().equals(sSjGtbd.getIsxf())){
            sql = sql + "and t1.blzt is null ";
        }
        sql = sql + "and t1.djh in (select t.djh from zd t where t.sgqdm like '"+regionCode+"%')";
        return sql;
    }

}
