package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SbZsQuery;
import cn.gtmap.landtax.model.query.SwDjJbbQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
@Service
public class TaxServiceImpl implements TaxService {


    @Autowired
    BaseRepository baseRepository;
    @Autowired
    private ZdService zdService;
    @Autowired
    private HcxmService hcxmService;
    @Autowired
    private SsjGtbdService ssjGtbdService;
    @Autowired
    DicService dicService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    SwDjQsService swDjQsService;
    @Autowired
    DwxxService dwxxService;

    @Override
    @Transactional(readOnly = true)
    public List<SwDjJbb> findAllSwDjJbb() {
        return baseRepository.dslList(QSwDjJbb.swDjJbb);
    }


    @Override
    @Transactional(readOnly = true)
    public Page<Map<String,Object>> findSwdjSyMap(Pageable pageable) {
        String sql = "select count(*) from view_sw_dj_sy";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(sql);
        sql = "select t.djh as djh,t.dbh as dbh,t.glbm as glbm,t.nsrmc as nsrmc,t.jbb_id as jbb_id from view_sw_dj_sy t";
        Query query = baseRepository.getEntityManager().createNamedQuery(sql);
        return baseRepository.find(query,countQuery,pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSyQuery> findSwdjTdMap(SwDjSyQuery swDjSyQuery,Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}


        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fwxzDm,qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qSwDjTd.tdsyytDm,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,qSwDjXmxx.xmId);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs, qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
            }
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(swDjSyQuery.getTddj()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){

            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            if (regionCode.length() > 6)
                regionCode = regionCode.substring(0, 6);
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGjzt()) && "2".equals(swDjSyQuery.getGjzt())){
            //jpaQuery.where(qZd.djh.notIn(new JPASubQuery().from(qSwDjXmxx).where(qSwDjXmxx.zd.djh.isNotNull()).list(qSwDjXmxx.zd.djh)));
            jpaQuery.where(qZd.djh.isNotNull());
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSyQuery> findSwdjFcMap(SwDjSyQuery swDjSyQuery,Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;


        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjFc.fwxzDm,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.sgztDm,qSwDjFc.sgztMc,qSwDjFc.sjly,qSwDjFc.fcId,qSwDjFc.zdsybz,qZd.qlrmc,qZd.tdyt,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,qSwDjXmxx.xmId);
        jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs, qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
            jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjFc.fcId.isNotNull());
        if(swDjSyQuery!=null){
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjFc.fcyzMs.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjFc.nynseFc.desc().nullsLast());
            }
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjFc.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjFc.msbz.isNull().or(qSwDjFc.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjFc.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjFc.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjFc,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }
        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }

        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        //jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.ZD.toString()));

        Page page = baseRepository.find(jpaQuery,qBean,pageable);

        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSyQuery> findLzlghTd(SwDjSyQuery swDjSyQuery,Sgzt sgzt, Pageable pageable) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc, qSwDjTd.tdzl,
                qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,
                qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb);
        Predicate djhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDjh())?qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS):null;
        Predicate glbmPredicate = StringUtils.isNotBlank(swDjSyQuery.getGlbm())?qSwDjJbb.glbm.like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS):null;
        Predicate dbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDbh())?qSwDjSy.dbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS):null;
        Predicate nsrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrmc())?qSwDjJbb.nsrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS):null;
        Predicate czrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getCzrmc())?qSwDjTd.czrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getCzrmc() + QueryCondition.WILDCARDS):null;
        jpaQuery.where(djhPredicate,glbmPredicate,dbhPredicate,nsrmcPredicate,czrmcPredicate);
        jpaQuery.where(qSwDjTd.sgztDm.eq(sgzt.toString()));
        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSyQuery> findLzlghFc(SwDjSyQuery swDjSyQuery, Sgzt sgzt, Pageable pageable) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
                qSwDjFc.czrmc,qSwDjFc.czrzjhm,qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,
                qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,
                qSwDjFc.nzj,qSwDjFc.nynseFc);
        jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb);
        Predicate djhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDjh())?qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS):null;
        Predicate glbmPredicate = StringUtils.isNotBlank(swDjSyQuery.getGlbm())?qSwDjJbb.glbm.like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS):null;
        Predicate dbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDbh())?qSwDjSy.dbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS):null;
        Predicate nsrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrmc())?qSwDjJbb.nsrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS):null;
        Predicate czrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getCzrmc())?qSwDjFc.czrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getCzrmc() + QueryCondition.WILDCARDS):null;
        Predicate fczhPredicate = StringUtils.isNotBlank(swDjSyQuery.getFczh())?qSwDjFc.fczh.like(QueryCondition.WILDCARDS + swDjSyQuery.getFczh() + QueryCondition.WILDCARDS):null;
        jpaQuery.where(djhPredicate,glbmPredicate,dbhPredicate,nsrmcPredicate,czrmcPredicate,fczhPredicate);
        jpaQuery.where(qSwDjFc.sgztDm.eq(sgzt.toString()));
        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(readOnly = true)
    public Page findZdsyTd(SwDjSyQuery swDjSyQuery, Pageable pageable,String sort,String dir,String beginPm,String endPm) {

        String sql ="select t.*,rownum as pm from( " +
                "select t2.djh,t2.dbh,t3.glbm,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc, to_char(t4.tdzl)tdzl,t1.scmj, t1.ynmj,t1.msmj,t1.nynse, t1.td_id,t1.zdsybz ,t3.hy_dm,t3.zclx_dm,rank() over(order by nvl(t1.nynse, 0) desc) as spm " +
                "from sw_dj_td t1 join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                "left join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id   " +
                "left join zd t4 on t4.djh=t2.djh "+
                "where ( t4.sgqdm like '"+SessionUtil.getCurrentUser().getRegionCode()+"%' and "+"t2.syzt is null or t2.syzt='1' ))t where  1=1 ";
        sql = addParameter(swDjSyQuery,sql,beginPm,endPm);
        if(StringUtils.isNotBlank(sort) && StringUtils.isNotBlank(dir)){
            sql += " order by nvl("+sort+",0) "+dir;
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    private String addParameter(SwDjSyQuery swDjSyQuery,String sql,String beginPm,String endPm){

        if(StringUtils.isNotBlank(swDjSyQuery.getDjh())){
            sql += " and t.djh like '"+swDjSyQuery.getDjh()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            sql += " and t.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
            sql += " and t.zgkg_dm like '2"+swDjSyQuery.getQx()+"%'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm())){
            sql += " and t.zgkg_dm ='"+swDjSyQuery.getZgkgDm()+"'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm())){
            sql += " and t.zclx_dm ='"+swDjSyQuery.getZclxDm()+"'";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm())){
            sql += " and t.hy_dm ='"+swDjSyQuery.getHyDm()+"'";
        }
        if(swDjSyQuery.getNynseTdBegin()!=null){
            sql += " and t.nynse >="+swDjSyQuery.getNynseTdBegin();
        }
        if(swDjSyQuery.getNynseTdEnd()!=null){
            sql += " and t.nynse <="+swDjSyQuery.getNynseTdEnd();
        }
        if(swDjSyQuery.getNynseFcBegin()!=null){
            sql += " and t.nynse >="+swDjSyQuery.getNynseFcBegin();
        }
        if(swDjSyQuery.getNynseFcEnd()!=null){
            sql += " and t.nynse <="+swDjSyQuery.getNynseFcEnd();
        }
        if(StringUtils.isNotBlank(beginPm)){
            sql += " and t.spm >="+beginPm;
        }
        if(StringUtils.isNotBlank(endPm)){
            sql += " and t.spm <="+endPm;
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            if("1".equals(swDjSyQuery.getZdsybz())){
                sql += " and t.zdsybz='1'";
            }else if("2".equals(swDjSyQuery.getZdsybz())){
                sql += " and t.zdsybz is null";
            }
        }
        String regionCode = "";
//        try{
//            regionCode = SessionUtil.getCurrentUser().getRegionCode();
//        }catch (Exception e){}
//        if(StringUtils.isNotBlank(regionCode)){
//            sql += " and t.zgkg_dm like '2"+regionCode+"%' ";
//        }
        if(StringUtils.isNotBlank(swDjSyQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjSyQuery.getExcelEnd())){
            Integer begin = Integer.parseInt(swDjSyQuery.getExcelBegin());
            Integer end = Integer.parseInt(swDjSyQuery.getExcelEnd());
            sql +=" and rownum>="+begin+" and rownum<="+end+" ";
        }
        return sql;
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSyQuery> findZdsyFc(SwDjSyQuery swDjSyQuery, Pageable pageable,String sort,String dir,String beginPm,String endPm) {
//        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
//        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
//        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
//        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
//        QBean qBean = Projections.bean(SwDjFc.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
//                qSwDjFc.czrmc,qSwDjFc.czrzjhm,qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,
//                qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,
//                qSwDjFc.nzj,qSwDjFc.nynseFc);
//        Predicate djhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDjh())?qSwDjFc.swDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS):null;
//        Predicate glbmPredicate = StringUtils.isNotBlank(swDjSyQuery.getGlbm())?qSwDjFc.swDjJbb.glbm.like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS):null;
//        Predicate dbhPredicate = StringUtils.isNotBlank(swDjSyQuery.getDbh())?qSwDjFc.swDjSy.dbh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS):null;
//        Predicate nsrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getNsrmc())?qSwDjFc.swDjJbb.nsrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS):null;
//        Predicate czrmcPredicate = StringUtils.isNotBlank(swDjSyQuery.getCzrmc())?qSwDjFc.czrmc.like(QueryCondition.WILDCARDS + swDjSyQuery.getCzrmc() + QueryCondition.WILDCARDS):null;
//        Predicate fczhPredicate = StringUtils.isNotBlank(swDjSyQuery.getFczh())?qSwDjFc.fczh.like(QueryCondition.WILDCARDS + swDjSyQuery.getFczh() + QueryCondition.WILDCARDS):null;
//        jpaQuery.where(djhPredicate,glbmPredicate,dbhPredicate,nsrmcPredicate,czrmcPredicate,fczhPredicate);
//        jpaQuery.where(qSwDjFc.zdsybz.eq("1"));
//        return baseRepository.find(jpaQuery,qBean,pageable);
        String sql ="select t.*,t2.spm,rownum as pm from ("+
                "select t2.djh,t2.dbh,t3.glbm,t3.nsrmc,t3.zgkg_mc,t3.zgkg_dm,t3.sgy_mc,t1.fczl,t1.fcmj,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.fc_id,t1.zdsybz" +
                " from sw_dj_fc t1" +
                " left join sw_dj_sy t2" +
                " on t1.sy_id=t2.sy_id" +
                " left join  sw_dj_jbb t3" +
                " on t1.jbb_id=t3.jbb_id "+
                " where (t2.syzt is null or t2.syzt='1'))t "+
                " right join(select  fc_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_fc)t2 on t.fc_id =t2.fc_id where 1=1 ";
        sql = addParameter(swDjSyQuery,sql,beginPm,endPm);
        if(StringUtils.isNotBlank(sort) && StringUtils.isNotBlank(dir)){
            sql += " order by nvl("+sort+",0) "+dir;
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        String countSql = "select count(*) from (";
        countSql += sql;
        countSql +=")";
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjSyQuery getSwDjSyById(String tdId, String fcId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;


        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        if(StringUtils.isNotBlank(tdId)) {

            QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.hyMc,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.msse,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjFc.qzczfcmj,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                    qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                    qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjTd.tdId.eq(tdId));
            swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);
        }
        else if(StringUtils.isNotBlank(fcId)) {
            QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjFc.czrmc,qSwDjFc.czrzjhm,qSwDjTd.tdzl,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.qzczfcmj,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                    qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                    qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjFc.fcId.eq(fcId));
            swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);
        }



        //征管系统已缴纳税额
        //swDjSyQuery = setZgxtSet(swDjSyQuery.getGlbm(),swDjSyQuery);
        return swDjSyQuery;

    }

    @Override
    public SwDjSyQuery getSwDjSyBySyId(String syId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;

        QSwHcXmRwRel qSwHcXmRwRel = QSwHcXmRwRel.swHcXmRwRel;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjTd.tdId,qSwDjFc.fcId,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyzh,qSwDjTd.tdsyztDm,qSwDjTd.tdqdfsDm,qSwDjTd.tdsyytDm,qSwDjTd.dj,qSwDjTd.qdsyqzfje,qSwDjTd.tdkfcb,qSwDjTd.csqdsj,qSwDjTd.syqzzsj,qSwDjTd.tdjmxzdm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,qSwDjTd.msse,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.czfcyz,qSwDjFc.jsbl,qSwDjFc.fcjmxzdm,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fczl,qSwDjFc.qzczfcmj,qZd.tdzh,qSwDjTd.sgztDm,qSwDjSy.bz,qSwDjTd.tdsyqlx,qSwHcXmRwRel.shxrId,qSwDjTd.tdMssjBegin,qSwDjTd.tdMssjEnd,qSwDjTd.tdMsyy,qSwDjFc.fcMssjBegin,qSwDjFc.fcMssjEnd,qSwDjFc.fcMsyy,qSwDjFc.sl,qSwDjSy.ishc,qSwDjTd.gtzdbyzyy,
                qSwDjFc.fczlXian,qSwDjFc.fczlZhen,qSwDjFc.fczlLu,qSwDjFc.fczlHao,qSwDjFc.fczlDong,qSwDjFc.fczlDy,qSwDjFc.fczlLou,qSwDjFc.fczlShi,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysSzly,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsYjne);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swHcXmRwRel,qSwHcXmRwRel).where(qSwDjSy.syId.eq(syId));
        swDjSyQuery = (SwDjSyQuery)baseRepository.get(query,qBean);

        return swDjSyQuery;
    }

    @Override
    public SwDjSyQuery setZgxtSet(String glbm,SwDjSyQuery swDjSyQuery){
        //征管系统已缴纳税额
        if(StringUtils.isNotBlank(glbm)) {
            String jpqlTd = "select nvl(sum(nse),0) nse from local_sb_rkss t where t.glbm='" + glbm + "' and t.szdm='" + Szdm.CZTDSYS.toString() + "' and to_char(t.fsrq,'yyyy')=to_char(sysdate,'yyyy')";
            Query jpqlQueryTd = baseRepository.getEntityManager().createNativeQuery(jpqlTd);
            BigDecimal tdyjne = (BigDecimal) jpqlQueryTd.getSingleResult();
            swDjSyQuery.setTdyjne(tdyjne);
            BigDecimal nynseTd = swDjSyQuery.getNynseTd();
            if (nynseTd != null) {
                BigDecimal tdqje = nynseTd.subtract(tdyjne);
                swDjSyQuery.setTdqje(tdqje);
                if(!nynseTd.equals(BigDecimal.ZERO)){
                    BigDecimal tdqjbl = tdqje.divide(nynseTd, 4, BigDecimal.ROUND_HALF_UP);
                    swDjSyQuery.setTdqjbl(tdqjbl.multiply(new BigDecimal(100)));
                }
            }

            String jpqlFc = "select nvl(sum(nse),0) nse from local_sb_rkss t where t.glbm='" + glbm + "' and t.szdm='" + Szdm.FCS.toString() + "' and to_char(t.fsrq,'yyyy')=to_char(sysdate,'yyyy')";
            Query jpqlQueryFc = baseRepository.getEntityManager().createNativeQuery(jpqlFc);
            BigDecimal fcyjne = (BigDecimal) jpqlQueryFc.getSingleResult();
            swDjSyQuery.setFcyjne(fcyjne);
            BigDecimal nynseFc = swDjSyQuery.getNynseFc() == null ? new BigDecimal(0) : swDjSyQuery.getNynseFc();
            if (nynseFc != null) {
                BigDecimal fcqje = nynseFc.subtract(fcyjne);
                swDjSyQuery.setFcqje(fcqje);
                if(!nynseFc.equals(BigDecimal.ZERO)){
                    BigDecimal fcqjbl = fcqje.divide(nynseFc, 4, BigDecimal.ROUND_HALF_UP);
                    swDjSyQuery.setFcqjbl(fcqjbl.multiply(new BigDecimal(100)));
                }
            }
        }
        return swDjSyQuery;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getSwjgByQx(String qx) {

        StringBuffer sql = new StringBuffer()
                .append("select swbmbm,mc from dm_swbm ");
        StringBuffer whereClause = new StringBuffer()
                .append("where swbmbm like '2").append(qx).append("%' ");
        sql.append(whereClause);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true)
    public List<HashMap<String, Object>> getZsSyxxListByGlbm(SbZsQuery sbZsQuery, String szdm) {
        int sqTotal = 4;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sqTotal = 4;
        }else if(szdm.equals(Szdm.FCS.toString())){
            sqTotal = 2;
        }

        String year = sbZsQuery.getYear();
        int sssq = Integer.valueOf(sbZsQuery.getSssq());
        int sqBegin, sqEnd;
        sqBegin = (sssq - 1) / sqTotal + 1;
        sqEnd = (sssq - 1) % sqTotal + 1;
        String startRq = year + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = year + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);

        // 一年分几个属期的变量
        String sqCount = String.valueOf(sqTotal);
        // 预征期数
        String yzqs = "0";
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            yzqs = "1";
        }else if(szdm.equals(Szdm.FCS.toString())){
            yzqs = "0";
        }
        // 本期所属税款表到式的分变量表达式
        String zsEndNfsq = "(TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMEND, 'MM')) - 1) / 12 * :sqCount) + 1 + :yzqs)";
        String zsStartNfsq = "(TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'YYYY')) * :sqCount + TRUNC((TO_NUMBER(TO_CHAR(t.TAXTERMBEGIN, 'MM')) - 1) / 12 * :sqCount) + 1 + :yzqs)";
        String ydEndNfsq = "(:ssnf * :sqCount + (MOD((TO_NUMBER(:sssq) - 1), :sqCount) + 1))";
        String ydStartNfsq = "(:ssnf * :sqCount + (TRUNC((TO_NUMBER(:sssq) - 1) / :sqCount, 0) + 1))";
        // 本期所属税款的计算表达式
        String bqSkExp = "t.NSE / (:zsEndNfsq - :zsStartNfsq + 1) * DECODE(SIGN(LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq)), -1, 0,  LEAST(:zsEndNfsq, :ydEndNfsq) - GREATEST(:zsStartNfsq, :ydStartNfsq) + 1)";
        // 将变量表达式替换成变量值
        bqSkExp = bqSkExp.replaceAll(":zsEndNfsq", zsEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":zsStartNfsq", zsStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydEndNfsq", ydEndNfsq);
        bqSkExp = bqSkExp.replaceAll(":ydStartNfsq", ydStartNfsq);
        bqSkExp = bqSkExp.replaceAll(":sqCount", sqCount);
        bqSkExp = bqSkExp.replaceAll(":sssq", sbZsQuery.getSssq());
        bqSkExp = bqSkExp.replaceAll(":ssnf", year);
        bqSkExp = bqSkExp.replaceAll(":yzqs", yzqs);

        String sql = "";
        sql =   "select sb_num, fsrq, szdm, glbm, nse, ROUND(" + bqSkExp + ", 2) as bqnse " +
                "from local_sb_rkss t " +
                "where t.szdm=':szdm' and (TO_CHAR(fsrq, 'YYYYMM') >= ':startRq' AND TO_CHAR(fsrq, 'YYYYMM') <= ':endRq') and glbm=':glbm' " +
                "order by fsrq";
        sql = sql.replaceAll(":szdm", szdm);
        sql = sql.replaceAll(":startRq", startRq);
        sql = sql.replaceAll(":endRq", endRq);
        sql = sql.replaceAll(":glbm", sbZsQuery.getGlbm());

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true)
    public BigDecimal getSumScmjByDjh(String djh) {
        String sql = "select nvl(sum(nvl(t2.scmj,0)),0)  " +
                "from sw_dj_sy t1  " +
                "left join sw_dj_td t2 on t2.sy_id=t1.sy_id  " +
                "left join zd t3 on t3.djh=t1.djh " +
                "where t2.sgzt_dm='01' and (t1.syzt='1' or t1.syzt is null) and t3.djh='"+djh+"'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        return (BigDecimal)query.getSingleResult();
    }




    @Override
    @Transactional(readOnly = true)
    public SwDjTd getSwDjTdById(String tdId) {
        return baseRepository.get(SwDjTd.class,tdId);
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjFc getSwDjFcById(String fcId) {
        return baseRepository.get(SwDjFc.class,fcId);
    }

    @Override
    @Transactional(readOnly = true)
    public List<SwDjSyQuery> getSwDjSyByDjh(String djh) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjTd.tdId,qSwDjSy.syId);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).where(qSwDjSy.zd.djh.eq(djh));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));
        return (List)baseRepository.dslList(query,qBean);

    }

    @Override
    public SwDjSy getSwDjSyById(String syId) {
        return baseRepository.get(SwDjSy.class,syId);
    }


    @Override
    @Transactional
    public void saveSwDjSy(SwDjSy swDjSy) {
        baseRepository.save(swDjSy);
    }

    @Override
    @Transactional
    public void deleteSwDjSy(String syId) {
        SwDjSy swDjSy = baseRepository.get(SwDjSy.class,syId);
        if(swDjSy.getSwDjTd()!=null)
            baseRepository.delete(swDjSy.getSwDjTd());
        if(swDjSy.getSwDjFc()!=null)
            baseRepository.delete(swDjSy.getSwDjFc());
        if(swDjSy.getSwDjQs()!=null)
            baseRepository.delete(swDjSy.getSwDjQs());
        baseRepository.delete(swDjSy);
    }


    private void applySwDjSyQueryPredicates(SwDjSyQuery swDjSyQuery,QSwDjSy qSwDjSy,QSwDjJbb qSwDjJbb,QSwDjTd qSwDjTd,QSwDjFc qSwDjFc,QZd qZd,QSwDjXmxx qSwDjXmxx,JPQLQuery jpaQuery){
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"glbm").like(QueryCondition.WILDCARDS + swDjSyQuery.getGlbm() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh()))
            jpaQuery.where(Expressions.stringPath(qSwDjSy,"dbh").like(QueryCondition.WILDCARDS + swDjSyQuery.getDbh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"nsrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getNsrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzh()))
            jpaQuery.where(Expressions.stringPath(qZd, "tdzh").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzh() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getQlrmc()))
            jpaQuery.where(Expressions.stringPath(qZd,"qlrmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getQlrmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl()))
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"tdzl").like(QueryCondition.WILDCARDS + swDjSyQuery.getTdzl() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getTdyt()))
            jpaQuery.where(Expressions.stringPath(qSwDjTd, "tdsyytDm").eq(swDjSyQuery.getTdyt()));
        if(StringUtils.isNotBlank(swDjSyQuery.getJf()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getJf() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getJd()))
            jpaQuery.where(Expressions.stringPath(qZd, "djh").like(swDjSyQuery.getJd() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getQx()))
            jpaQuery.where(Expressions.stringPath(qZd, "sgqdm").like(swDjSyQuery.getQx() + QueryCondition.WILDCARDS).or(qZd.sgqdm.isNull().and(qSwDjXmxx.xmXzqdm.eq(swDjSyQuery.getQx()))));
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"zclxDm").eq(swDjSyQuery.getZclxDm()));
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"hyDm").eq(swDjSyQuery.getHyDm()));
        if(StringUtils.isNotBlank(swDjSyQuery.getSgyMc()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"sgyMc").like(QueryCondition.WILDCARDS + swDjSyQuery.getSgyMc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm()))
            jpaQuery.where(Expressions.stringPath(qSwDjJbb,"zgkgDm").eq(swDjSyQuery.getZgkgDm()));
        if(StringUtils.isNotBlank(swDjSyQuery.getHclx())){
            if("1".equals(swDjSyQuery.getHclx())){
                jpaQuery.where(qZd.djh.isNotNull());
            }else if("2".equals(swDjSyQuery.getHclx())){
                jpaQuery.where(qZd.djh.like(QueryCondition.WILDCARDS + "999999"+ QueryCondition.WILDCARDS));
            }else if("3".equals(swDjSyQuery.getHclx())){
                jpaQuery.where(qSwDjXmxx.xmId.isNotNull());
            }
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getExcelBegin()) && StringUtils.isNotBlank(swDjSyQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(swDjSyQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(swDjSyQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }

    }

    @Override
    public SwDjJbb findSwDjJbbByGlbm(String glbm) {
        String jpql = "from SwDjJbb where glbm=?0";
        List list = baseRepository.getByJpql(jpql,glbm);
        if(CollectionUtils.isNotEmpty(list)){
            return (SwDjJbb)(list.get(0));
        }
        return null;

    }

    @Override
    @Transactional
    public void saveSwDjSyQuery(SwDjSyQuery swDjSyQuery,String syzt) throws Exception {
        String syId = swDjSyQuery.getSyId();
        String jbbId = swDjSyQuery.getJbbId();
        String tdId = swDjSyQuery.getTdId();
        String fcId = swDjSyQuery.getFcId();
        String shxrId = swDjSyQuery.getShxrId();

        //基本表操作
        SwDjJbb swDjJbb = null;
        String sgztDm = swDjSyQuery.getSgztDm();
        String glbm = swDjSyQuery.getGlbm();
        //if("01".equals(sgztDm)) {
            //根据管理编码查询是否存在基本表信息
        if(StringUtils.isNotBlank(glbm)){
            swDjJbb = findSwDjJbbByGlbm(glbm);
        }

        //}
        if(swDjJbb==null){
            swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(swDjSyQuery, swDjJbb);
            swDjJbb.setJbbId(UUIDGenerator.generate());
            //保存主管税务机关名称
            String zgkgDm = swDjSyQuery.getZgkgDm();
            String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
            swDjJbb.setZgkgMc(zgkgMc);
            baseRepository.save(swDjJbb);//先保存基本表
        }else{
            BeanUtils.copyProperties(swDjSyQuery,swDjJbb,new String[]{"jbbId"});
            //保存主管税务机关名称
            String zgkgDm = swDjSyQuery.getZgkgDm();
            String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
            swDjJbb.setZgkgMc(zgkgMc);
        }
        //税源主表操作
        SwDjSy swDjSy = new SwDjSy();
        BeanUtils.copyProperties(swDjSyQuery, swDjSy);
        //根据djh获取zd
        Zd zd = zdService.findZdByDjh(swDjSyQuery.getDjh());
        swDjSy.setZd(zd);
        swDjSy.setSyzt(syzt);

        //根据ShxrId获取
        if(StringUtils.isNotBlank(shxrId)){
            SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByShxrId(shxrId);
            swDjSy.setSwHcXmRwRel(swHcXmRwRel);
        }


        if(StringUtils.isBlank(syId)){
            swDjSy.setSyId(UUIDGenerator.generate());
            //判断填写的地编号是否在数据库中已经存在
            String dbh = swDjSyQuery.getDbh();
            SwDjSy tempSy = findSwDjSyByDjhAndDbh(zd.getDjh(),dbh);
            if(tempSy!=null){
                dbh = createDbhByDjh(zd.getDjh());
            }
            swDjSy.setDbh(dbh);
            swDjSy.setSysjly(Gtlx.ZD.toString());
            baseRepository.save(swDjSy);
        }else{
            swDjSy.setSyId(syId);
            //判断填写的地编号是否在数据库中已经存在,并且不是自己本身
            String dbh = swDjSyQuery.getDbh();
            SwDjSy tempSy = findSwDjSyByDjhAndDbh(zd.getDjh(),dbh);

            if(tempSy!=null && !tempSy.getSyId().equals(syId)){//查出来的税源对象与当前对象不一致，说明填写的地编号不符合
                dbh = createDbhByDjh(zd.getDjh());
            }
            swDjSy.setSysjly(Gtlx.ZD.toString());
            swDjSy.setDbh(dbh);
            baseRepository.update(swDjSy);
        }

        //土地税源操作
        SwDjTd swDjTd = new SwDjTd();
        BeanUtils.copyProperties(swDjSyQuery,swDjTd);
        swDjTd.setSwDjJbb(swDjJbb);
        swDjTd.setSwDjSy(swDjSy);
        if(StringUtils.isBlank(tdId)){
            swDjTd.setTdId(UUIDGenerator.generate());
            String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());

            swDjTd.setTdzl(fczl);
            swDjTd.setSjly(Sjly.SYHC.toString());
            swDjTd.setLrrq(new Date());
            swDjTd.setUpdateDate(new Date());
            baseRepository.save(swDjTd);
        }else{
            swDjTd.setTdId(tdId);
            String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());
            swDjTd.setTdzl(fczl);
            swDjTd.setSjly(Sjly.SYHC.toString());
            swDjTd.setUpdateDate(new Date());
            baseRepository.update(swDjTd);
        }

        //房产税源操作
        SwDjFc swDjFc = new SwDjFc();
        BeanUtils.copyProperties(swDjSyQuery, swDjFc);
        swDjFc.setSwDjJbb(swDjJbb);
        swDjFc.setSwDjSy(swDjSy);
        swDjFc.setLrrq(new Date());
        String fczl = CommonUtil.getFczl(swDjSyQuery.getFczlXian(), swDjSyQuery.getFczlZhen(), swDjSyQuery.getFczlLu(), swDjSyQuery.getFczlHao(), swDjSyQuery.getFczlDong(), swDjSyQuery.getFczlDy(), swDjSyQuery.getFczlLou(), swDjSyQuery.getFczlShi());
        swDjFc.setFczl(fczl);
        if(StringUtils.isBlank(fcId)){
            swDjFc.setFcId(UUIDGenerator.generate());
            swDjFc.setSjly(Sjly.SYHC.toString());
            baseRepository.save(swDjFc);
        }else{
            swDjFc.setFcId(fcId);
            swDjFc.setSjly(Sjly.SYHC.toString());
            baseRepository.update(swDjFc);
        }

        String xmmc = swDjSyQuery.getXmmc();
        if(StringUtils.isNotBlank(xmmc)){

        }

        //查询s_sj_gtbd该地籍号上的记录的ppzt是否是空，如果是空设置成3（税源核查）
        String djh = zd.getDjh();
        SSjGtbd sSjGtbd = ssjGtbdService.findByDjh(djh);
        if(sSjGtbd!=null && StringUtils.isBlank(sSjGtbd.getPpzt())){
            sSjGtbd.setPpzt("3");
            ssjGtbdService.updateSsjGtbd(sSjGtbd);
        }

        //****************************************************************保存msrdTd,msrdFc


    }

    @Override
    public String createDbhByDjh(String djh) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.dbh);
        query.from(qSwDjSy).where(qSwDjSy.zd.djh.eq(djh));
        query.where(qSwDjSy.dbh.isNotNull());
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));

        List<SwDjSyQuery> swDjSyQueryList =  (List)baseRepository.dslList(query,qBean);
        //获取所有地编号
        List<Long> dbhList = new ArrayList<Long>();
        for(SwDjSyQuery vo : swDjSyQueryList){
            dbhList.add(Long.parseLong(vo.getDbh()));
        }
        //根据地编号获取最大值
        Long temp = 0L;
        for(Long dbh : dbhList){
            temp = Math.max(temp,dbh);

        }
        temp = temp/10 + 1;
        String resultDbh = String.valueOf(temp);
        int length = resultDbh.length();
        for(int i=0;i<9-length;i++){
            resultDbh = "0" + resultDbh;
        }
        return resultDbh+"0";
    }

    @Override
    public List<SwDjJbbQuery> findJbbByGlbm(String glbm) {
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        query.from(qSwDjJbb).where(qSwDjJbb.glbm.like(glbm + QueryCondition.WILDCARDS));
        QBean qBean = Projections.bean(SwDjJbbQuery.class,qSwDjJbb.glbm,qSwDjJbb.nsrmc);
        return (List)baseRepository.dslList(query,qBean);
    }



    @Override
    @Transactional
    public void updateSwDjTd(SwDjTd swDjTd) {
       baseRepository.update(swDjTd);
    }

    @Override
    @Transactional
    public void updateSwDjFc(SwDjFc swDjFc) {
        baseRepository.update(swDjFc);
    }

    @Override
    @Transactional
    public void createSwDjFc(SwDjFc swDjFc) {
        baseRepository.save(swDjFc);
    }

    @Override
    @Transactional
    public void softDelSyDjSy(String syId, String syzt) {
        String jpql = "update SwDjSy set syzt=?0 where syId=?1";
        baseRepository.executeJpql(jpql,syzt,syId);
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjSy findSwDjSyByDjhAndDbh(String djh, String dbh) {
        String jpql = "from SwDjSy o where o.zd.djh=?0 and o.dbh=?1";
        List<SwDjSy> swDjSyList =  baseRepository.getByJpql(jpql,djh,dbh);
        if(CollectionUtils.isNotEmpty(swDjSyList)){
            return swDjSyList.get(0);
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Object> getZdsyTdList(HashMap param) {
        String beginPm = String.valueOf(param.get("beginPm")==null?"":param.get("beginPm"));
        String endPm = String.valueOf(param.get("endPm")==null?"":param.get("endPm"));
        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String sql ="select rank() over(order by nvl(t.nynse,0) desc) as pm,t.djh,t.dbh,t.glbm,t.nsrmc,t.zgkg_mc,t.sgy_mc,t.tdzl,t.scmj,t.ynmj,t.msmj,t.nynse,t2.spm from ("+
                "select t2.djh,t2.dbh,t3.glbm,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc,t1.tdzl,t1.scmj,t1.ynmj,t1.msmj,t1.nynse,t1.td_id,t1.zdsybz,t3.zgkg_dm" +
                " from sw_dj_td t1" +
                " left join sw_dj_sy t2" +
                " on t1.sy_id=t2.sy_id" +
                " left join  sw_dj_jbb t3" +
                " on t1.jbb_id=t3.jbb_id "+
                " where (t2.syzt is null or t2.syzt='1'))t "+
                " right join(select  td_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_td)t2 on t.td_id =t2.td_id where 1=1 ";

        if(obj==null) {//导出全部
            sql = addParameter(swDjSyQuery,sql,beginPm,endPm);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t.td_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    @Override
    public List<Object> getZdsyFcList(HashMap param) {
        String beginPm = String.valueOf(param.get("beginPm")==null?"":param.get("beginPm"));
        String endPm = String.valueOf(param.get("endPm")==null?"":param.get("endPm"));

        Object obj = param.get("ids");
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String sql ="select rank() over(order by nvl(t.nynse,0) desc) as pm,t.djh,t.dbh,t.glbm,t.nsrmc,t.zgkg_mc,t.sgy_mc,t.fczl,t.fcmj,t.fcyz_ys,fcyz_ms,t.nzj,t.nynse,t2.spm from ("+
                "select t2.djh,t2.dbh,t3.glbm,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc,t1.fczl,t1.fcmj,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.fc_id,t1.zdsybz,t3.zgkg_dm" +
                " from sw_dj_fc t1" +
                " left join sw_dj_sy t2" +
                " on t1.sy_id=t2.sy_id" +
                " left join  sw_dj_jbb t3" +
                " on t1.jbb_id=t3.jbb_id "+
                " where (t2.syzt is null or t2.syzt='1'))t "+
                " right join(select  fc_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_fc)t2 on t.fc_id =t2.fc_id where 1=1 ";

        if(obj==null) {//导出全部
            sql = addParameter(swDjSyQuery,sql,beginPm,endPm);
        }else{//checkbox导出
            String resultIds = "";
            String ids = String.valueOf(obj);
            String[] idsArr = ids.split(",");
            for(int i=0;i<idsArr.length;i++){
                if(i==idsArr.length-1){
                    resultIds = resultIds+"'"+idsArr[i]+"'";
                }else{
                    resultIds = resultIds+"'"+idsArr[i]+"'"+",";
                }
            }
            sql = sql + " and t1.fc_id in("+resultIds+")";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        List<Object> list =  query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public List<SwDjSyQuery> getSwdjTzList(HashMap param) {
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QZd qZd = QZd.zd;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = null;

        if(sylx.equals(Sylx.TDSY.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,
                    qSwDjJbb.nsrmc,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,qSwDjFc.fczl,
                    qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.tdsyytDm,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjTd.zdsybz);

            jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
            jpaQuery.where(qSwDjTd.tdId.isNotNull());
            if(swDjSyQuery!=null){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                    jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
                }else{
                    jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
                }
            }

        }else if(sylx.equals(Sylx.FCSY.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                    qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,qSwDjTd.tdzl,qSwDjTd.scmj,
                    qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjFc.sgztDm,qSwDjFc.sgztMc,qSwDjFc.sjly,qSwDjFc.fcId,qSwDjFc.zdsybz,qSwDjFc.fwxzDm);

            jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
            jpaQuery.where(qSwDjFc.fcId.isNotNull());
            if(swDjSyQuery!=null){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                    jpaQuery.orderBy(qSwDjFc.fcyzMs.desc().nullsLast());
                }else{
                    jpaQuery.orderBy(qSwDjFc.nynseFc.desc().nullsLast());
                }
            }

        }else if(sylx.equals(Sylx.GDZYS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,
                    qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                    qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                    qSwDjPcxx.pcmc,qSwDjPcxx.pwh,qSwDjPcxx.pzmj,qSwDjPcxx.nydmj,qSwDjPcxx.pzsj,qSwDjPcxx.pcYddw,qSwDjPcxx);

            jpaQuery.from(qSwDjGdzys).leftJoin(qSwDjGdzys.swDjSy,qSwDjSy).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjPcxx,qSwDjPcxx);
            jpaQuery.where(qSwDjGdzys.gdzysId.isNotNull()).where(qSwDjSy.syId.isNotNull());
        }else if(sylx.equals(Sylx.QS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjJbb.nsrmc,
                    qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,
                    qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx,
                    qSwDjXmxx.xmmc,qSwDjXmxx.xmYddw,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj);

            jpaQuery.from(qSwDjQs).leftJoin(qSwDjQs.swDjSy,qSwDjSy).leftJoin(qSwDjQs.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
            jpaQuery.where(qSwDjQs.qsId.isNotNull()).where(qSwDjSy.syId.isNotNull());
        }
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));

        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjSy.syId.in(idsList));
        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
                jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));

            if(sylx.equals(Sylx.TDSY.toString())){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                }
                if("1".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjTd.msbz.eq("1"));
                }
                if("2".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
                }
                if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                    jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
                }

            }else if(sylx.equals(Sylx.FCSY.toString())){
                if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                    jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                }
                if("1".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjFc.msbz.eq("1"));
                }
                if("2".equals(swDjSyQuery.getMsbz())){
                    jpaQuery.where(qSwDjFc.msbz.isNull().or(qSwDjFc.msbz.eq("")));
                }
                if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                    jpaQuery.where(qSwDjFc.sgztDm.eq(swDjSyQuery.getSgztDm()));
                }
            }else if(sylx.equals(Sylx.GDZYS.toString())){
                if(StringUtils.isNotBlank(swDjSyQuery.getPcXzqdm()))
                    jpaQuery.where(Expressions.stringPath(qSwDjPcxx, "pcXzqdm").eq(swDjSyQuery.getPcXzqdm()));
                if(StringUtils.isNotBlank(swDjSyQuery.getPcmc()))
                    jpaQuery.where(Expressions.stringPath(qSwDjPcxx, "pcmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getPcmc() + QueryCondition.WILDCARDS));
            }else if(sylx.equals(Sylx.QS.toString())){
                if(StringUtils.isNotBlank(swDjSyQuery.getXmXzqdm()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmXzqdm").eq(swDjSyQuery.getXmXzqdm()));
                if(StringUtils.isNotBlank(swDjSyQuery.getXmmc()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmmc").like(QueryCondition.WILDCARDS + swDjSyQuery.getXmmc() + QueryCondition.WILDCARDS));
                if(StringUtils.isNotBlank(swDjSyQuery.getQdfs()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "qdfs").eq(swDjSyQuery.getQdfs()));
                if(StringUtils.isNotBlank(swDjSyQuery.getXmTdyt()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmTdyt").eq(swDjSyQuery.getXmTdyt()));
                if(StringUtils.isNotBlank(swDjSyQuery.getXmYddw()))
                    jpaQuery.where(Expressions.stringPath(qSwDjXmxx, "xmYddw").like(QueryCondition.WILDCARDS + swDjSyQuery.getXmYddw() + QueryCondition.WILDCARDS));
            }
            if(StringUtils.isNotBlank(regionCode)){
                jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
            }
            applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        }

        baseRepository.addEntityPath(qSwDjSy);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }


    @Override
    @Transactional(readOnly = true)
    public String getIsYsdlByDm(String dm) {
        String whereClause = " where DM='"+dm+"'";
        String sql = "select ISYS from S_ZD_DLDM "+whereClause;
        String isys = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        if("1".equals(isys)){
            return "是";
        }
        return "否";
    }

    @Override
    @Transactional(readOnly = true)
    public String getDwseByTddj(String tddj) {
        String whereClause = " where DM='"+tddj+"'";
        String sql = "select sl from s_zd_tdjb "+whereClause;
        String sl = "";
        try {
            sl= String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        }catch (Exception e){}

        return sl;
    }

    @Override
    @Transactional(readOnly = true)
    public List<SwDjSyQuery> getSwDjSyByGlbm(String glbm,String szdm) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = null;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qZd.tdzl,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                    qSwDjTd.tdId,qSwDjSy.syId, qSwDjSy.sysjly, qSwDjXmxx.xmId, qSwDjPcxx.pcId);
            query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjJbb.glbm.eq(glbm));
            query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        }else if(szdm.equals(Szdm.FCS.toString())){
            qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
                    qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                    qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                    qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,
                    qSwDjSy.syId, qSwDjSy.sysjly, qSwDjXmxx.xmId, qSwDjPcxx.pcId);
            query.from(qSwDjSy).rightJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd)
                    .leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjJbb.glbm.eq(glbm));
            query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        }
        return (List)baseRepository.dslList(query,qBean);
    }

    /**
     * 诚征土地使用税税源列表，根据税种代码（szdm）区分
     * @param sbZsQuery
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public List<HashMap<String,Object>> getSbSyxxListByGlbm(SbZsQuery sbZsQuery,String szdm) {
        int sqTotal = 4;
        if(szdm.equals(Szdm.CZTDSYS.toString())){
            sqTotal = 4;
        }else if(szdm.equals(Szdm.FCS.toString())){
            sqTotal = 2;
        }

        String year = sbZsQuery.getYear();
        int jdlx = Integer.valueOf(sbZsQuery.getJdlx());
        int sqBegin, sqEnd;
        sqBegin = (jdlx - 1) / sqTotal + 1;
        sqEnd = (jdlx - 1) % sqTotal + 1;
        String startRq = year + StringUtils.right("0" + String.valueOf((sqBegin - 1) * (12 / sqTotal) + 1), 2);
        String endRq = year + StringUtils.right("0" + String.valueOf(sqEnd * (12 / sqTotal)), 2);

        String sql = "";
        sql =   "select sb_num, fsrq, szdm, glbm, nse " +
                "from local_sb_yzss t " +
                "where t.szdm='%s' and (TO_CHAR(fsrq, 'YYYYMM') >= '%s' AND TO_CHAR(fsrq, 'YYYYMM') <= '%s') and glbm='%s' " +
                "order by fsrq";
        sql = String.format(sql, szdm, startRq, endRq, sbZsQuery.getGlbm());

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Override
    @Transactional(readOnly = true)
    public List<SwDjSyQuery> getFcSwDjSyByGlbm(String glbm) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,
                qZd.tdyt,qZd.qlrmc,qZd.scmjZd,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjSy.syId);
        query.from(qSwDjSy).rightJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.zd, qZd).where(qSwDjJbb.glbm.eq(glbm));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    public List<SwDjSyQuery> getFcSbSyxxListByGlbm(String glbm) {
        QSbYzss qSbYzss = QSbYzss.sbYzss;
        JPQLQuery query =  new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSbYzss.sbNum,qSbYzss.fsrq,qSbYzss.glbm,qSbYzss.nse);
        query.from(qSbYzss);
        query.where(qSbYzss.glbm.eq(glbm)).where(qSbYzss.szdm.eq(Szdm.FCS.toString()));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    @Transactional(readOnly = true)
    public HashMap getHj(String sylx,SwDjSyQuery swDjSyQuery) {
        HashMap result = new HashMap();

        //计算税源数据宗地数
        Object zdCount = getSyZdCount(sylx,swDjSyQuery);
        result.put("zdCount",zdCount);
        //计算税源户数
        Object syhsCount = getSyhsCount(sylx, swDjSyQuery);
        result.put("syhsCount",syhsCount);


        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx) || Sylx.FCSY.toString().equals(sylx)) {
            //计算控管户户数
            Object kghCount = getKghCount(sylx, swDjSyQuery);
            result.put("kghCount", kghCount);
            //计算漏征漏管户数
            Object lzlghCount = getLzlghCount(sylx, swDjSyQuery);
            result.put("lzlghCount", lzlghCount);
            //计算可转化税源户数
            Object kzhsyCount = getKzhsyCount(sylx, swDjSyQuery);
            result.put("kzhsyCount", kzhsyCount);
            //计算机关单位户数
            Object jgdwCount = getJgdwCount(sylx, swDjSyQuery);
            result.put("jgdwCount", jgdwCount);
            //计算个人户数
            Object grCount = getGrCount(sylx, swDjSyQuery);
            result.put("grCount", grCount);
        }

        //计算合计

        HashMap resultMap = (HashMap)getHjmjAndFcyz(sylx, swDjSyQuery);
        Object scmj = resultMap.get("SCMJ");
        if(scmj==null){
            scmj=0;
        }
        result.put("scmj",scmj);

        Object msmj = resultMap.get("MSMJ");
        if(msmj==null){
            msmj=0;
        }
        result.put("msmj",msmj);
        Object ynmj = resultMap.get("YNMJ");
        if(ynmj==null){
            ynmj=0;
        }
        result.put("ynmj",ynmj);
        Object nynse = resultMap.get("NYNSE");
        if(nynse==null){
            nynse=0;
        }
        result.put("nynse",nynse);
        Object fcyz = resultMap.get("FCYZ");
        if(fcyz==null){
            fcyz=0;
        }
        result.put("fcyz",fcyz);
        Object fcyz_ys = resultMap.get("FCYZ_YS");
        if(fcyz_ys==null){
            fcyz_ys=0;
        }
        result.put("fcyz_ys",fcyz_ys);
        Object fcyz_ms = resultMap.get("FCYZ_MS");
        if(fcyz_ms==null){
            fcyz_ms=0;
        }
        result.put("fcyz_ms",fcyz_ms);
        Object ynse_zy = resultMap.get("YNSE_ZY");
        if(ynse_zy==null){
            ynse_zy=0;
        }
        result.put("ynse_zy",ynse_zy);
        Object ynse_cz = resultMap.get("YNSE_CZ");
        if(ynse_cz==null){
            ynse_cz=0;
        }
        result.put("ynse_cz",ynse_cz);


        Object gdzysYnse = resultMap.get("GDZYSYNSE");
        if(gdzysYnse==null){
            gdzysYnse=0;
        }
        result.put("gdzys_ynse",gdzysYnse);
        Object gdzysYjne = resultMap.get("GDZYSYJNE");
        if(gdzysYjne==null){
            gdzysYjne=0;
        }
        result.put("gdzys_yjne",gdzysYjne);
        Object gdzysXbjse = resultMap.get("GDZYSXBJSE");
        if(gdzysXbjse==null){
            gdzysXbjse=0;
        }
        result.put("gdzys_xbjse",gdzysXbjse);
        Object qsYnse = resultMap.get("QSYNSE");
        if(qsYnse==null){
            qsYnse=0;
        }
        result.put("qs_ynse",qsYnse);
        Object qsYjne = resultMap.get("QSYJNE");
        if(qsYjne==null){
            qsYjne=0;
        }
        result.put("qs_yjne",qsYjne);
        Object qsXbjse = resultMap.get("QSXBJSE");
        if(qsXbjse==null){
            qsXbjse=0;
        }
        result.put("qs_xbjse",qsXbjse);

        //以下是免税税源查询统计的逻辑
        if(swDjSyQuery != null) {
            if ( swDjSyQuery.getIsMsTz() != null && swDjSyQuery.getIsMsTz() == true) {
                HashMap resultmap = (HashMap) getTdfcsy(sylx, swDjSyQuery);
                if(resultMap != null){
                    if (StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)) {
                        //计算免税税源数
                        Object mssys = getSyhsCount(sylx, swDjSyQuery);
                        result.put("mssys", mssys);
                        Object mstdmj = resultmap.get("MSMJ");
                        if (mstdmj == null) {
                            mstdmj = 0;
                        }
                        result.put("mstdmj", mstdmj);
                        Object msse = resultmap.get("MSSE");
                        if (msse == null) {
                            msse = 0;
                        }
                        result.put("msse", msse);
                    } else if (Sylx.FCSY.toString().equals(sylx)) {
                        Object msfcyz = resultmap.get("FCYZ");
                        if (msfcyz == null) {
                            msfcyz = 0;
                        }
                        result.put("msfcyz", msfcyz);
                        Object mssefc = resultmap.get("FCYZ_MS");
                        if (mssefc == null) {
                            mssefc = 0;
                        }
                        result.put("mssefc", mssefc);
                    }
                }

            }
        }


        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getHjmjAndFcyz(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = "";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)){
            sql = "select sum(nvl(t1.scmj,0))scmj,sum(nvl(t1.msmj,0))msmj,sum(nvl(t1.ynmj,0))ynmj,sum(nvl(t1.nynse,0))nynse from sw_dj_td t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' ";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            sql = "select sum(nvl(t1.fcyz,0))fcyz,sum(nvl(t1.fcyz_ys,0))fcyz_ys,sum(nvl(t1.fcyz_ms,0))fcyz_ms,sum(nvl(t1.ynse_zy,0))ynse_zy,sum(nvl(t1.ynse_cz,0))ynse_cz,sum(nvl(t1.nynse,0))nynse from sw_dj_fc t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t5.jbb_id "+
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%'";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            sql = "select nvl(sum(ynse),0)gdzysYnse,nvl(sum(yjne),0)gdzysYjne,nvl(sum(xbjse),0)gdzysXbjse from sw_dj_gdzys t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' ";
        }else if(Sylx.QS.toString().equals(sylx)){
            sql = "select nvl(sum(t1.ynse),0)qsYnse,nvl(sum(t1.yjne),0)qsYjne,nvl(sum(t1.xbjse),0)qsXbjse FROM SW_DJ_QS t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "where  (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' ";
        }
        sql = sql +addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        Object resultMap = query.getSingleResult();
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getSgjgByQx(String qx) {
        String sql = "select substr(t.swbmbm,2,8) as SWBMBM,t.mc  from DM_SWBM t where t.swbmbm like '2"+qx+"%' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Map<String, Object>> tjNynseByQx(String sylx,String[] queryDwdm,String nf) {
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String sql = "";
        String dwdmStr = "";
        for(int i=0;i<queryDwdm.length;i++){
            if(StringUtils.isNotBlank(queryDwdm[i])){
                if(i==queryDwdm.length-1){
                    dwdmStr+="'"+queryDwdm[i]+"'";
                }else{
                    dwdmStr+="'"+queryDwdm[i]+"',";
                }

            }
        }
        if(regionCode.length()==4){//市
            if(Sylx.TDSY.toString().equals(sylx)){
                sql="select t1.dwdm,t1.dwmc,round(t1.sumNynse,2)sumNynse,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumnynse-nvl(t2.sumtaxfinal,0)),2)qjse from (select t1.dwdm,t1.dwmc,t2.sumNynse from (select t.dwdm,t.dwmc from s_dm_dwxx_cz t where length(t.dwdm)=6)t1  " +
                        "left join (select sum(nvl(t1.nynse,0))sumNynse,substr(t3.zgkg_dm,2,6)qx from sw_dj_td t1  " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "where t2.syzt is null or t2.syzt='1' " +
                        "group by substr(t3.zgkg_dm,2,6))t2 on t1.dwdm=t2.qx)t1 " +
                        "left join  " +
                        "(select sum(nvl(t1.taxfinal,0))sumtaxfinal,substr(t2.zgkg_dm,2,6)dwdm " +
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.glbm " +
                        "where t1.TaxTypeCode='13' and to_char(t1.declaredate,'yyyy')= " +nf+
                        "group by substr(t2.zgkg_dm,2,6))t2 " +
                        "on t1.dwdm=t2.dwdm " ;

            } else if(Sylx.FCSY.toString().equals(sylx)){
                sql="select t1.dwdm,t1.dwmc,round(t1.sumNynse,2)sumNynse,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumnynse-nvl(t2.sumtaxfinal,0)),2)qjse from (select t1.dwdm,t1.dwmc,t2.sumNynse from (select t.dwdm,t.dwmc from s_dm_dwxx_cz t where length(t.dwdm)=6)t1  " +
                        "left join (select sum(nvl(t1.nynse,0))sumNynse,substr(t3.zgkg_dm,2,6)qx from sw_dj_fc t1  " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "where t2.syzt is null or t2.syzt='1' " +
                        "group by substr(t3.zgkg_dm,2,6))t2 on t1.dwdm=t2.qx)t1 " +
                        "left join  " +
                        "(select sum(nvl(t1.taxfinal,0))sumtaxfinal,substr(t2.zgkg_dm,2,6)dwdm " +
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.glbm " +
                        "where t1.TaxTypeCode='11' and to_char(t1.declaredate,'yyyy')= " +nf+
                        "group by substr(t2.zgkg_dm,2,6))t2 " +
                        "on t1.dwdm=t2.dwdm " ;
            }
        }else if(regionCode.length()==6){//县
            if(Sylx.TDSY.toString().equals(sylx)){
                sql="select round(t1.sumNynse,2)sumNynse,t1.dwmc,round(t2.taxfinal,2) taxfinal,round(t1.sumNynse-t2.taxfinal,2)qjse from (select sum(nvl(t1.nynse,0))sumNynse,t4.dwdm dwdm,t4.dwmc dwmc,t4.swdm swdm from sw_dj_td t1 " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "left join S_DM_SWDWXX t4 on t3.zgkg_dm=t4.swdm " +
                        "where t2.syzt is null or t2.syzt='1'  " +
                        "group by t4.dwdm,t4.dwmc,t4.swdm)t1 " +
                        "left join  " +
                        "(select sum(t1.taxfinal)taxfinal,t2.zgkg_mc,t2.zgkg_dm " +
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.glbm " +
                        "where t1.TaxTypeCode='13' and to_char(t1.declaredate,'yyyy')= " + nf+" "+
                        "group by  t2.zgkg_dm,t2.zgkg_mc)t2 " +
                        "on t1.swdm=t2.zgkg_dm ";

            } else if(Sylx.FCSY.toString().equals(sylx)){
                sql= "select round(t1.sumNynse,2)sumNynse,t1.dwmc,round(t2.taxfinal,2)taxfinal,round(t1.sumNynse-t2.taxfinal,2) from (select sum(nvl(t1.nynse,0))sumNynse,t4.dwdm dwdm,t4.dwmc dwmc,t4.swdm from sw_dj_fc t1 " +
                        "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                        "left join sw_dj_jbb t3 on t3.jbb_id=t1.jbb_id " +
                        "left join S_DM_SWDWXX t4 on t3.zgkg_dm=t4.branchcode " +
                        "where t2.syzt is null or t2.syzt='1'  " +
                        "group by t4.dwdm,t4.dwmc,t4.swdm)t1 " +
                        "left join  " +
                        "(select sum(t1.taxfinal)taxfinal,t2.zgkg_mc,t2.zgkg_dm " +" "+
                        "from tb_lvy_levydata t1 " +
                        "join sw_dj_jbb t2 on t1.TaxRegCode=t2.glbm " +
                        "where t1.TaxTypeCode='11' and to_char(t1.declaredate,'yyyy')= " +nf+
                        "group by  t2.zgkg_dm,t2.zgkg_mc)t2 " +
                        "on t1.swdm=t2.zgkg_dm " ;
            }
        }
        if(!dwdmStr.equals("'null'")){
            sql=sql+"where t1.dwdm in ("+dwdmStr+") ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<Map<String,Object>> list = query.getResultList();
        return list;
    }




    @Override
    @Transactional(readOnly = true)
    public Object getSyZdCount(String sylx,SwDjSyQuery swDjSyQuery) {
        String sql = "select count(*) from (";
        sql = sql + getSyhsSqlBySylx(sylx);
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,true);

        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx) || Sylx.FCSY.toString().equals(sylx)){
            sql = sql +" group by t3.djh";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            sql = sql +" group by t6.pc_id";
        }else if(Sylx.QS.toString().equals(sylx)){
            sql = sql +" group by t7.xm_id";
        }

        sql = sql+")";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getSyhsCount(String sylx,SwDjSyQuery swDjSyQuery) {
        String sql =  getSyhsSqlBySylx(sylx);
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        if(swDjSyQuery != null && (Sylx.TDSY.toString().equals(sylx) || StringUtils.isBlank(sylx))){
            if(swDjSyQuery.getIsMsTz() != null && true == swDjSyQuery.getIsMsTz()){
                sql = sql + "and t1.msmj is not null and t1.msmj > 0 ";
            }
        };

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    public String addSyxxParameter(SwDjSyQuery swDjSyQuery,String sylx,boolean isZds){
        String sql = "";
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            sql = sql+" and t1.sgzt_dm = '"+swDjSyQuery.getSgztDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh())){
            sql = sql+" and t3.djh like '%"+swDjSyQuery.getDjh()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm())){
            sql = sql+" and t4.glbm like '%"+swDjSyQuery.getGlbm()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getDbh())){
            sql = sql+" and t2.dbh like '%"+swDjSyQuery.getDbh()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            sql = sql+" and t4.nsrmc like '%"+swDjSyQuery.getNsrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzh())){
            sql = sql+" and t3.tdzh like '%"+swDjSyQuery.getTdzh()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getQlrmc())){
            sql = sql+" and t3.qlrmc like '%"+swDjSyQuery.getQlrmc()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdzl())){
            sql = sql+" and t1.tdzl like '%"+swDjSyQuery.getTdzl()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTdyt())){
            sql = sql+" and t3.tdyt ='"+swDjSyQuery.getTdyt()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getJf())){
            sql = sql+" and t3.djh like '"+swDjSyQuery.getJf()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getJd())){
            sql = sql+" and t3.djh like '"+swDjSyQuery.getJd()+"%' ";
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
            if(isZds){
                sql = sql+" and t3.sgqdm like '"+swDjSyQuery.getQx()+"%' ";
            }else{
                sql = sql+" and (t3.sgqdm like '"+swDjSyQuery.getQx()+"%' or t7.xzqdm like '"+ swDjSyQuery.getQx() + "%') ";
            }

        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgyMc())){
            sql = sql+" and t4.sgyMc like '%"+swDjSyQuery.getSgyMc()+"%' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm())){
            sql = sql+" and t4.zgkg_dm ='"+swDjSyQuery.getZgkgDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            sql = sql+" and t1.zdsybz ='1' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZclxDm())){
            sql = sql+" and t4.zclx_dm='"+swDjSyQuery.getZclxDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getHyDm())){
            sql = sql + " and t4.hy_dm='"+swDjSyQuery.getHyDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getHclx())){
            if("1".equals(swDjSyQuery.getHclx())){
                sql = sql + " and t3.djh is not null";
            }else if("2".equals(swDjSyQuery.getHclx())){
                sql = sql + " and t3.djh like '%999999%' ";
            }else if("3".equals(swDjSyQuery.getHclx())){
                sql = sql + " and t2.gd_id is not null ";
            }
        }
        if(sylx != null && Sylx.TDSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
                sql = sql + " and t1.tddj = '"+swDjSyQuery.getTddj()+"'";
            }
        }

        if(swDjSyQuery.getIsZdsy() !=null && swDjSyQuery.getIsZdsy() != true){
            sql = sql + " and t1.zdsybz='1' ";
        }

        return sql;
    }


    private String getSyhsSqlBySylx(String sylx){
        String sql = "";

        String regionCode = dwxxService.getUserRegionCode();
        String xzqdm = regionCode;
        if (xzqdm.length() > 6) {
            xzqdm = dwxxService.getUserRegionCode().substring(0, 6);
        }
        String swTable = "sw_dj_td";
        String userFilter = "";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)){
            swTable = "sw_dj_td";
            userFilter = "(t4.zgkg_dm like '2"+xzqdm+"%' ) ";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            swTable = "sw_dj_fc";
            userFilter = "(t4.zgkg_dm like '2"+xzqdm+"%' )";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
            swTable = "sw_dj_gdzys";
            userFilter = "t6.xzqdm like '" + xzqdm + "%'";
        }else if(Sylx.QS.toString().equals(sylx)){
            swTable = "sw_dj_qs";
            userFilter = "t7.xzqdm like '" + xzqdm + "%'";
        }

        sql = "select count(*) from " + swTable + " t1 " +
                "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id ";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx) || Sylx.FCSY.toString().equals(sylx)){
           sql = sql + "left join zd t3 on t3.djh=t2.djh ";
           sql = sql + "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id ";
           sql = sql +" and t3.djh is not null and t3.djh not like '%999999%'";
        }else if(Sylx.GDZYS.toString().equals(sylx)){
           sql = sql +  "left join sw_dj_pcxx t6 on t6.pc_id=t2.bp_id ";
           sql = sql +" and t3.djh is not null and t3.djh not like '%999999%'";
        }else if(Sylx.QS.toString().equals(sylx)){
           sql = sql + "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id ";
        }

            sql = sql +"　left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and " + userFilter;

        return sql;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getKghCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='01' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }
    @Override
    @Transactional(readOnly = true)
    public Object getLzlghCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='02' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getKzhsyCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='03' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getJgdwCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='05' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }

    @Override
    @Transactional(readOnly = true)
    public Object getGrCount(String sylx, SwDjSyQuery swDjSyQuery) {
        String sql = getSyhsSqlBySylx(sylx);
        sql = sql + " and t1.sgzt_dm='04' ";
        sql = sql + addSyxxParameter(swDjSyQuery,sylx,false);
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        Object count = query.getSingleResult();
        return count;
    }



    /**
     * 标记重点税源
     * 1：是重点税源
     * @param tdId
     * @param fcId
     */
    @Override
    @Transactional
    public void setZdsy(String sylx,String tdId, String fcId,SwDjSyQuery swDjSyQuery,String beginPm,String endPm) {
        if(Sylx.TDSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(tdId)){
                String[] tdIds = tdId.split(",");
                for(String tmpTdId:tdIds){
                    SwDjTd swDjTd = baseRepository.get(SwDjTd.class,tmpTdId);
                    if(swDjTd!=null){
                        swDjTd.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjTd);
                    }
                }
            }else{//说明是条件认定重点税源
                String sql ="select t.td_id from ("+
                        "select t2.djh,t2.dbh,t3.glbm,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc,t1.tdzl,t1.scmj,t1.ynmj,t1.msmj,t1.nynse,t1.td_id,t1.zdsybz" +
                        " from sw_dj_td t1" +
                        " left join sw_dj_sy t2" +
                        " on t1.sy_id=t2.sy_id" +
                        " left join  sw_dj_jbb t3" +
                        " on t1.jbb_id=t3.jbb_id "+
                        " where (t2.syzt is null or t2.syzt='1'))t "+
                        " right join(select  td_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_td)t2 on t.td_id =t2.td_id where 1=1 ";
                sql = addParameter(swDjSyQuery,sql,beginPm,endPm);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                List list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(Object tempTdId : list){
                        SwDjTd swDjTd = baseRepository.get(SwDjTd.class,String.valueOf(tempTdId));
                        swDjTd.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjTd);
                    }

                }
            }
        }else if(Sylx.FCSY.toString().equals(sylx)){
            if(StringUtils.isNotBlank(fcId)){
                String[] fcIds = fcId.split(",");
                for(String tmpFcId:fcIds){
                    SwDjFc swDjFc = baseRepository.get(SwDjFc.class,tmpFcId);
                    if(swDjFc!=null){
                        swDjFc.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjFc);
                    }
                }

            }else{
                String sql ="select t.fc_id from ("+
                        "select t2.djh,t2.dbh,t3.glbm,t3.nsrmc,t3.zgkg_mc,t3.sgy_mc,t1.fczl,t1.fcmj,t1.fcyz_ys,t1.fcyz_ms,t1.nzj,t1.nynse,t1.fc_id,t1.zdsybz" +
                        " from sw_dj_fc t1" +
                        " left join sw_dj_sy t2" +
                        " on t1.sy_id=t2.sy_id" +
                        " left join  sw_dj_jbb t3" +
                        " on t1.jbb_id=t3.jbb_id "+
                        " where (t2.syzt is null or t2.syzt='1'))t "+
                        " right join(select  fc_id,rank() over(order by nvl(nynse,0) desc) as spm from sw_dj_fc)t2 on t.fc_id =t2.fc_id where 1=1 ";
                sql = addParameter(swDjSyQuery,sql,beginPm,endPm);
                Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
                List list = query.getResultList();
                if(CollectionUtils.isNotEmpty(list)){
                    for(Object tempFcId :list){
                        SwDjFc swDjFc = baseRepository.get(SwDjFc.class,String.valueOf(tempFcId));
                        swDjFc.setZdsybz(swDjSyQuery.getZdsybz());
                        baseRepository.update(swDjFc);
                    }

                }
            }
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Object tjNynseByHylx(String[] queryHydm, String sylx,String nf) {
        String hydmStr = "";
        String sql = "";
        for(int i=0;i<queryHydm.length;i++){
            if(StringUtils.isNotBlank(queryHydm[i])){
                if(i==queryHydm.length-1){
                    hydmStr+="'"+queryHydm[i]+"'";
                }else{
                    hydmStr+="'"+queryHydm[i]+"',";
                }

            }
        }
        if(Sylx.TDSY.toString().equals(sylx)){
            sql = "select round(t1.sumNynse,2)sumNynse,t1.hy_dm,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumNynse-nvl(t2.sumtaxfinal,0)),2)as qjse from  " +
                    "(select sum(nvl(t1.nynse,0))sumNynse,substr(t3.hy_dm,0,1) hy_dm from sw_dj_td t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id " +
                    "where t2.syzt is null or t2.syzt='1' " +
                    "group by  substr(t3.hy_dm,0,1))t1 " +
                    "left join " +
                    "(select sum(nvl(t1.nse,0))sumtaxfinal,substr(t2.hy_dm,0,1) hy_dm from LOCAL_SB_RKSS t1 " +
                    "join sw_dj_jbb t2 on t1.glbm=t2.glbm " +
                    "where t1.szdm ='13' "+
                    "and to_char(t1.fsrq,'yyyy')= " + nf +
                    "group by  substr(t2.hy_dm,0,1))t2 " +
                    "on t1.hy_dm=t2.hy_dm " ;



        } else if(Sylx.FCSY.toString().equals(sylx)){
            sql = "select round(t1.sumNynse,2)sumNynse,t1.hy_dm,round(nvl(t2.sumtaxfinal,0),2)sumtaxfinal,round((t1.sumNynse-nvl(t2.sumtaxfinal,0)),2)as qjse from  " +
                    "(select sum(nvl(t1.nynse,0))sumNynse,t3.hy_dm from sw_dj_fc t1 " +
                    "join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "join sw_dj_jbb t3 on t1.jbb_id=t3.jbb_id " +
                    "where t2.syzt is null or t2.syzt='1' " +
                    "group by t3.hy_dm)t1 " +
                    "left join " +
                    "(select sum(nvl(t1.taxfinal,0))sumtaxfinal,t2.hy_dm from tb_lvy_levydata t1 " +
                    "join sw_dj_jbb t2 on t1.TaxRegCode=t2.glbm " +
                    "where t1.TaxTypeCode ='11' "+
                    "and to_char(t1.declaredate,'yyyy')= " + nf +
                    "group by t2.hy_dm)t2 " +
                    "on t1.hy_dm=t2.hy_dm ";
        }
        if(!hydmStr.equals("'null'")){
            sql=sql+"where t1.hy_dm in("+hydmStr+")";

        }
        sql = "select t1.*, t2.mc as hy_mc from (" + sql + ") t1 left join dm_hydm t2 on t1.hy_dm=t2.dm";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Map<String, Object>> tjSybhfx(String sylx, String nf) {
        String sql = "";
        if(Sylx.TDSY.toString().equals(sylx)){
            sql = "select t1.yf ,round(t1.sumtaxfinal,2)sumtaxfinal,round(t2.sumynse,2)sumynse,round((t2.sumynse-t1.sumtaxfinal),2)qjse from  " +
                    "(select to_char(t1.fsrq,'mm')yf,sum(t1.nse) sumtaxfinal " +
                    "from (select t.fsrq,t.nse  from LOCAL_SB_RKSS t where to_char(t.fsrq,'yyyy')="+nf+" and t.szdm='13')t1 group by to_char(t1.fsrq,'mm') order by to_char(t1.fsrq,'mm') " +
                    ")t1, " +
                    "(select (sum(t1.nynse)/12)sumynse " +
                    "from sw_dj_td t1 " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                    "where t2.syzt is null or t2.syzt='1')t2 ";
        }else if (Sylx.FCSY.toString().equals(sylx)){
            sql = "select t1.yf ,round(t1.sumtaxfinal,2)sumtaxfinal,round(t2.sumynse,2)sumynse,round((t2.sumynse-t1.sumtaxfinal),2)qjse from  " +
                    "(select to_char(t1.declaredate,'mm')yf,sum(t1.taxfinal) sumtaxfinal " +
                    "from (select t.declaredate,t.taxfinal  from tb_lvy_levydata t where to_char(t.declaredate,'yyyy')="+nf+" and t.TaxTypeCode='11')t1 group by to_char(t1.declaredate,'mm') order by to_char(t1.declaredate,'mm') " +
                    ")t1, " +
                    "(select (sum(t1.nynse)/12)sumynse " +
                    "from sw_dj_fc t1 " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id  " +
                    "where t2.syzt is null or t2.syzt='1' or t2.syzt='' )t2 ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<Map<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object findSwDjGdzysMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjGdzys).leftJoin(qSwDjGdzys.swDjSy,qSwDjSy).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
            jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
            jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
        }else{
            jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(tddj));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);

        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object findSwDjQsMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjQs).leftJoin(qSwDjQs.swDjSy,qSwDjSy).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
            jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
        //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
        //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
        if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
            jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        }else{
            jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
        }
        jpaQuery.where(qSwDjTd.tdId.isNotNull());
        if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
            jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
            jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
        }else{
            jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
        }
        if("1".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.eq("1"));
        }else if("2".equals(swDjSyQuery.getMsbz())){
            jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
            String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
            jpaQuery.where(qSwDjTd.tddj.eq(tddj));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
            jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
            jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getZdsybz())){
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq(swDjSyQuery.getZdsybz()));
        }

        if(StringUtils.isNotBlank(regionCode)){
            jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);


        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public String findZgkgDmByRegionCode(String regionCode) {
        String whereClause = " where swbmbm = '2"+regionCode+"00'";
        String sql = "select swbmbm,mc from dm_swbm " + whereClause;
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        if(CollectionUtils.isNotEmpty(list)){
            Object obj = list.get(0);
            HashMap map = (HashMap)obj;
            String value = String.valueOf(map.get("SWBMBM"));
            return value;
        }
        return null;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTddjByDjhLike(String djh) {
        Zd zd = zdService.findZdByDjh(djh);
        String sgqdm = zd.getSgqdm();
        if(StringUtils.isBlank(sgqdm)){
            sgqdm = djh.substring(0,6)+djh.substring(djh.length()-4,djh.length());
        }
        sgqdm = sgqdm.substring(0,6);
        if (sgqdm.equals("610790")) {
            sgqdm = "610702";
        }
        String sql = "select t.* from S_ZD_TDJB t ";
//        if(StringUtils.isNotBlank(djh)){
//            sql = sql + "where t.dm like '"+ sgqdm +"%' ";
//        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTddjByQx(String qx) {

        String sql = "select t.* from S_ZD_TDJB t ";
        if(StringUtils.isNotBlank(qx)){
            sql = sql + "where t.dm like '"+ qx +"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }
    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getTddjByDm(String dm) {
        String sql = "select t.* from S_ZD_TDJB t ";
        if(StringUtils.isNotBlank(dm)){
            sql = sql + "where t.dm ='"+dm+"'";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        try {
            return query.getSingleResult();
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Zd getTddjByDjh(String djh) {
        Zd zd = zdService.findZdByDjh(djh);
        return zd;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List getTddjByXzqdm(String xmXzqdm) {
        String sql = "select t.* from S_ZD_TDJB t ";
        if(StringUtils.isNotBlank(xmXzqdm)){
            sql = sql + "where t.dm like '"+xmXzqdm+"%' ";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        return list;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjSyQuery> getSwDjSyByXmId(String xmId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qSwDjXmxx.xmId,qSwDjXmxx.xmmc,qSwDjXmxx.gdmj,qSwDjXmxx.qdfs,qSwDjXmxx.xmTdyt,qSwDjXmxx.xmYddw,qSwDjXmxx.xmXzqdm,qSwDjXmxx.qdjg,qSwDjXmxx.gdsj,qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjTd.tdId,qSwDjSy.syId);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjXmxx, qSwDjXmxx).where(qSwDjXmxx.xmId.eq(xmId));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    public List<SwDjSyQuery> getSwDjSyByPcId(String pcId) {
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;

        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.zd.djh,qSwDjSy.dbh,qSwDjJbb.glbm,qSwDjJbb.nsrmc,qSwDjTd.czrmc,qSwDjTd.czrzjhm,qSwDjTd.tdzl,
                qSwDjPcxx.pcId,qSwDjPcxx.pcmc,qSwDjPcxx.fgdnydmj,qSwDjPcxx.gdmj,qSwDjPcxx.jbntmj,qSwDjPcxx.nydmj,qSwDjPcxx.pcXzqdm,qSwDjPcxx.pcYddw,qSwDjPcxx.pwh,qSwDjPcxx.pzmj,qSwDjPcxx.pzsj,
                qSwDjJbb.zgkgDm,qSwDjJbb.sgyMc,qSwDjJbb.fddbr,qSwDjJbb.lxdh,qSwDjJbb.zclxDm,qSwDjJbb.hyDm,qSwDjJbb.zcdz,
                qSwDjTd.tdsyztDm,qSwDjTd.fzmj,qSwDjTd.scmj,qSwDjTd.tddj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.nynseTd,
                qSwDjFc.fczh,qSwDjFc.fcmj,qSwDjFc.fwxzDm,qSwDjFc.zyhczDm,qSwDjFc.fwjz,qSwDjFc.tdjz,qSwDjFc.fssbjz,qSwDjFc.fcyz,
                qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.ynseCz,qSwDjFc.nzj,qSwDjFc.nynseFc,qSwDjFc.fcId,qSwDjTd.tdId,qSwDjSy.syId);
        query.from(qSwDjSy).leftJoin(qSwDjSy.swDjTd, qSwDjTd).leftJoin(qSwDjSy.swDjFc,qSwDjFc).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).where(qSwDjPcxx.pcId.eq(pcId));
        query.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()));
        query.orderBy(new OrderSpecifier(Order.ASC, Expressions.stringPath(qSwDjSy,"dbh")));
        return (List)baseRepository.dslList(query,qBean);
    }

    @Override
    @Transactional(readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public Object parseTddjByDm(String dm) {
        String[] dms = dm.split(",");
        String sql = "";
        List<String> result = new ArrayList();
        for(int i=0;i<dms.length;i++){
            sql = "select t.mc from S_ZD_TDJB t where t.dm='"+dms[i]+"' ";
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            List list = query.getResultList();
            if(CollectionUtils.isNotEmpty(list)){
                result.add(String.valueOf(list.get(0)));
            }else{
                result.add("");
            }

        }
        return result;

    }

    @Override
    public List getzdsyfcList(HashMap param){
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QZd qZd = QZd.zd;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}

        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjFc.fcyz,qSwDjFc.fcyzYs,qSwDjFc.fcyzMs,qSwDjFc.ynseZy,qSwDjFc.nzj,qSwDjFc.sl,qSwDjFc.ynseCz,qSwDjFc.nynseFc,qSwDjTd.tddj,qSwDjTd.tdzl,qSwDjTd.scmj,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.sgztDm,qSwDjFc.sgztMc,qSwDjFc.sjly,qSwDjFc.fcId,qSwDjFc.zdsybz,qZd.qlrmc,qZd.tdyt,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjFc).leftJoin(qSwDjFc.swDjSy,qSwDjSy).leftJoin(qSwDjFc.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjTd,qSwDjTd).leftJoin(qSwDjSy.zd,qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjSy.syId.in(idsList));

        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
                jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
            if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
            }else{
                jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            }
            jpaQuery.where(qSwDjFc.fcId.isNotNull());
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjFc.fcyzMs.isNotNull().and(qSwDjFc.fcyzMs.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjFc.fcyzMs.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjFc.nynseFc.desc().nullsLast());
            }
            if("1".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjFc.msbz.eq("1"));
            }else if("2".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjFc.msbz.isNull().or(qSwDjFc.msbz.eq("")));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                jpaQuery.where(qSwDjFc.sgztDm.eq(swDjSyQuery.getSgztDm()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
                jpaQuery.where(qSwDjFc.sjly.eq(swDjSyQuery.getSjly()));
            }
            jpaQuery.where(Expressions.stringPath(qSwDjFc,"zdsybz").eq("1"));
            if(StringUtils.isNotBlank(regionCode)){
                jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
            }
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        return baseRepository.dslList(jpaQuery,qBean);
    }

    @Override
    public  List getzdsytdList(HashMap param){
        Object idsObj = param.get("ids");
        String sylx = String.valueOf(param.get("sylx"));
        SwDjSyQuery swDjSyQuery = (SwDjSyQuery) param.get("swDjSyQuery");

        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjQs qSwDjQs = QSwDjQs.swDjQs;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjTd qSwDjTd = QSwDjTd.swDjTd;
        QSwDjFc qSwDjFc = QSwDjFc.swDjFc;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QSwDjXmxx qSwDjXmxx = QSwDjXmxx.swDjXmxx;
        QZd qZd = QZd.zd;

        String regionCode = "";
        try{
            regionCode = SessionUtil.getCurrentUser().getRegionCode();
        }catch (Exception e){}
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        QBean qBean = Projections.bean(SwDjSyQuery.class,qSwDjSy.syId,qSwDjSy.dbh,qSwDjTd.tdId,qSwDjSy.zd.djh,qSwDjJbb.nsrmc,
                qSwDjFc.fczl,qSwDjTd.tddj,qZd.tdzl,qSwDjTd.scmj,qSwDjTd.msmj,qSwDjTd.ynmj,qSwDjTd.dwse,qSwDjTd.sgztDm,qSwDjTd.sgztMc,qSwDjTd.sjly,qSwDjTd.nynseTd,qSwDjTd.msse,qSwDjJbb.glbm,qSwDjJbb.zgkgMc,qSwDjJbb.sgyMc,qSwDjFc.fcId,qSwDjTd.zdsybz,qZd.qlrmc,qZd.tdyt,qZd.scmjZd,
                qSwDjGdzys.gdzysId,qSwDjGdzys.gdzysYnse,qSwDjGdzys.gdzysDwse,qSwDjGdzys.gdzysJmxz,qSwDjGdzys.gdzysJmse,qSwDjGdzys.gdzysJspz,qSwDjGdzys.gdzysYjne,qSwDjGdzys.gdzysXbjse,qSwDjGdzys.gdzysBz,qSwDjGdzys.gdzysLrrq,qSwDjGdzys.gdzysHclx,
                qSwDjQs.qsId,qSwDjQs.qsSzly,qSwDjQs.qsYnse,qSwDjQs.qsYjne,qSwDjQs.qsJmxz,qSwDjQs.qsJmse,qSwDjQs.qsJspz,qSwDjQs.qsXbjse,qSwDjQs.qsBz,qSwDjQs.qsLrrq,qSwDjQs.qsHclx);
        jpaQuery.from(qSwDjTd).leftJoin(qSwDjTd.swDjSy,qSwDjSy).leftJoin(qSwDjTd.swDjJbb,qSwDjJbb).leftJoin(qSwDjSy.swDjFc, qSwDjFc).leftJoin(qSwDjSy.zd, qZd).leftJoin(qSwDjSy.swDjGdzys,qSwDjGdzys).leftJoin(qSwDjSy.swDjQs,qSwDjQs).leftJoin(qSwDjSy.swDjXmxx,qSwDjXmxx);
        if(idsObj!=null){
            String ids = String.valueOf(idsObj);
            List idsList = Arrays.asList(ids.split(","));
            jpaQuery.where(qSwDjSy.syId.in(idsList));

        }else{
            if(StringUtils.isNotBlank(swDjSyQuery.getDjh()))
                jpaQuery.where(qSwDjSy.zd.djh.like(QueryCondition.WILDCARDS + swDjSyQuery.getDjh() + QueryCondition.WILDCARDS));
            //if(StringUtils.isNotBlank(swDjSyQuery.getXzqdm()))
            //    jpaQuery.where(qSwDjSy.zd.djh.like(swDjSyQuery.getXzqdm() + QueryCondition.WILDCARDS));
            if(StringUtils.isBlank(swDjSyQuery.getSyzt())){
                jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
            }else{
                jpaQuery.where(qSwDjSy.syzt.eq(swDjSyQuery.getSyzt()).or(qSwDjSy.syzt.eq("")).or(qSwDjSy.syzt.isNull()));
            }
            jpaQuery.where(qSwDjTd.tdId.isNotNull());
            if(swDjSyQuery.getIsMsTz()!=null && swDjSyQuery.getIsMsTz()){
                jpaQuery.where(qSwDjTd.msmj.isNotNull().and(qSwDjTd.msmj.gt(new BigDecimal(0))));
                jpaQuery.orderBy(qSwDjTd.msmj.desc().nullsLast());
            }else{
                jpaQuery.orderBy(qSwDjTd.nynseTd.desc().nullsLast());
            }
            if("1".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjTd.msbz.eq("1"));
            }else if("2".equals(swDjSyQuery.getMsbz())){
                jpaQuery.where(qSwDjTd.msbz.isNull().or(qSwDjTd.msbz.eq("")));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getTddj())){
                //String tddj = CommonUtil.reSetTddj(swDjSyQuery.getTddj());
                jpaQuery.where(qSwDjTd.tddj.eq(swDjSyQuery.getTddj()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSgztDm())){
                jpaQuery.where(qSwDjTd.sgztDm.eq(swDjSyQuery.getSgztDm()));
            }
            if(StringUtils.isNotBlank(swDjSyQuery.getSjly())){
                jpaQuery.where(qSwDjTd.sjly.eq(swDjSyQuery.getSjly()));
            }
            jpaQuery.where(Expressions.stringPath(qSwDjTd,"zdsybz").eq("1"));
            if(StringUtils.isNotBlank(regionCode)){
                if (regionCode.length() > 6)
                    regionCode = regionCode.substring(0, 6);
                jpaQuery.where(qSwDjJbb.zgkgDm.like("2" + regionCode + QueryCondition.WILDCARDS));
            }
        }
        applySwDjSyQueryPredicates(swDjSyQuery,qSwDjSy,qSwDjJbb, qSwDjTd,qSwDjFc,qZd,qSwDjXmxx,jpaQuery);
        List list = baseRepository.dslList(jpaQuery,qBean);
       return  list;
    }

    @Override
    @Transactional
    public void deletSwDjTdByTdId(String tdId) {

        String jpql = "delete from SwDjTd t where t.tdId=?0";
        baseRepository.executeJpql(jpql,tdId);
    }

    @Override
    @Transactional
    public void deletSwDjFcByFcId(String fcId) {
        String jpql = "delete from SwDjFc t where t.fcId=?0";
        baseRepository.executeJpql(jpql,fcId);
    }

    @Override
    @Transactional
    public String fandTdzl(String syId) {
        String tdzl = "";
        String jpql = "from SwDjSy t where t.syId=?0";
        List<SwDjSy> list = baseRepository.getByJpql(jpql, syId);
        if(list.size()>0) {
            SwDjSy swDjSy = list.get(0);

            if (swDjSy.getZd() != null) {
                String djh = swDjSy.getZd().getDjh();

                if (StringUtils.isNotBlank(djh)) {
                    Zd zd = baseRepository.get(Zd.class, djh);
                    tdzl = zd.getTdzl();
                }
            } else {
                String gdId = swDjSy.getSwDjXmxx().getXmId();

                if (StringUtils.isNotBlank(gdId)) {
                    SwDjXmxx swDjXmxx = baseRepository.get(SwDjXmxx.class, gdId);
                    tdzl = swDjXmxx.getXmTdzl();
                }
            }


        }
        return tdzl;
    }

    public Object getTdfcsy(String sylx,SwDjSyQuery swDjSyQuery){
        String sql = "";
        if(StringUtils.isBlank(sylx) || Sylx.TDSY.toString().equals(sylx)) {
            sql = "select sum(nvl(t1.scmj,0))scmj,sum(nvl(t1.msmj,0))msmj,sum(nvl(t1.ynmj,0))ynmj,sum(nvl(t1.nynse,0))nynse,sum(nvl(t1.msse,0))msse from sw_dj_td t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_jbb t4 on t4.jbb_id=t1.jbb_id " +
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id " +
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%' and t1.msmj is not null and t1.msmj >0 ";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            sql = "select sum(nvl(t1.fcyz,0))fcyz,sum(nvl(t1.fcyz_ys,0))fcyz_ys,sum(nvl(t1.fcyz_ms,0))fcyz_ms,sum(nvl(t1.ynse_zy,0))ynse_zy,sum(nvl(t1.ynse_cz,0))ynse_cz,sum(nvl(t1.nynse,0))nynse from sw_dj_fc t1  " +
                    "left join sw_dj_sy t2 on t1.sy_id=t2.sy_id " +
                    "left join zd t3 on t3.djh=t2.djh " +
                    "left join sw_dj_td t5 on t5.sy_id=t2.sy_id "+
                    "left join sw_dj_jbb t4 on t4.jbb_id=t5.jbb_id "+
                    "left join sw_dj_xmxx t7 on t7.xm_id=t2.gd_id "+
                    "where (t2.syzt='1' or t2.syzt is null)  and t4.zgkg_dm like '2" + dwxxService.getUserRegionCode() + "%'and t1.fcyz_ms is not null and t1.fcyz_ms >0";
        }
            sql = sql +addSyxxParameter(swDjSyQuery,sylx,false);
            Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            Object resultmap = query.getSingleResult();
            return resultmap;

    }

    @Override
    public List getHylxNext(String hydm) {
        int hydmlength=hydm.length()+2;
        String sql = "select dm as hydm,mc as hymc from dm_hydm where dm like '" + hydm + "%'" + " and length(dm)="+hydmlength;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;
    }


    @Override
    @Transactional(readOnly =true,propagation = Propagation.NOT_SUPPORTED)
    public List getMapTdZdsy() {
        String sql = "";
        sql = "select t1.djh,t2.tdzl,t2.ynmj,t2.nynse from SW_DJ_SY t1 , SW_DJ_TD t2 where t1.sy_id=t2.sy_id  and  t2.zdsybz  = '1' ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        List list = query.getResultList();
        return list;

    }
}
