package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.SwdjSyHisService;
import cn.gtmap.landtax.service.SwdjSyTempService;
import cn.gtmap.landtax.service.SyxgService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.PlatUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

/**
 * 税源修改服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
@Service
public class SyxgServiceImpl implements SyxgService {


    private static final String SYBJ_PREFIX="税源编辑";
    private static final String SYBJ_PREFIX_QS="契税编辑";
    private static final String SYBJ_PREFIX_GDZYS="耕地占用税编辑";
    private static final String SYBJ_WORKFLOW_CONFIG="sysj";
    private static final String SYBJ_WORKFLOW_CONFIG_QS="qssj";
    private static final String SYBJ_WORKFLOW_CONFIG_GDZYS="gdzyssj";
    private static final String SYBJ_WORKFLOW_SPETOR="_";
    @Autowired
    PlatUtil platUtil;
    @Autowired
    TaxService taxService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SwdjSyHisService swdjSyHisService;
    @Autowired
    SwdjSyTempService swdjSyTempService;

    @Override
    @Transactional
    public String createSyxgWorkflow(String syId) throws  Exception{


        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYBJ_WORKFLOW_CONFIG);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = "";
        try {
            proName = SYBJ_PREFIX + SYBJ_WORKFLOW_SPETOR + swDjSy.getZd().getQlrmc() + SYBJ_WORKFLOW_SPETOR + swDjSy.getZd().getDjh();
        }catch (Exception e){
            proName = SYBJ_PREFIX + SYBJ_WORKFLOW_SPETOR + "该税源无宗地信息";
        }
        //保存历史表
        swdjSyHisService.saveSwDjHis(swDjSy,proId,userId,Czlx.UPDATE.toString());

        //保存工作流
        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }
        return taskId;
    }

    @Override
    @Transactional
    public String createSyxgWorkflowQs(String syId) throws Exception {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYBJ_WORKFLOW_CONFIG_QS);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = "";
        try {
            proName = SYBJ_PREFIX_QS + SYBJ_WORKFLOW_SPETOR + swDjSy.getSwDjXmxx().getXmmc();
        }catch (Exception e){
            proName = SYBJ_PREFIX_QS + SYBJ_WORKFLOW_SPETOR + "该税源无宗地信息";
        }
        //保存历史表
        swdjSyHisService.saveSwDjHis(swDjSy,proId,userId,Czlx.UPDATE.toString());

        //保存工作流
        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }
        return taskId;
    }

    @Override
    @Transactional
    public String createSyxgWorkflowGdzys(String syId) throws Exception {
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        String wdid = AppConfig.getProperty(SYBJ_WORKFLOW_CONFIG_GDZYS);
        Project project = new Project();
        String proId = UUIDGenerator.generate();
        project.setProjectId(proId);
        project.setWdid(wdid);
        String userId = SessionUtil.getCurrentUserId();
        String proName = "";
        try {
            proName = SYBJ_PREFIX_GDZYS + SYBJ_WORKFLOW_SPETOR + swDjSy.getSwDjPcxx().getPcmc();
        }catch (Exception e){
            proName = SYBJ_PREFIX_GDZYS + SYBJ_WORKFLOW_SPETOR + "该税源无宗地信息";
        }
        //保存历史表
        swdjSyHisService.saveSwDjHis(swDjSy,proId,userId,Czlx.UPDATE.toString());

        //保存工作流
        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, proName);
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                String result = "java.lang:" + ((RuntimeException) e).getMessage();
                return result;
            } else {
                throw new RuntimeException();
            }
        }
        return taskId;
    }

    @Transactional(readOnly = true)
    public SwDjSyHis getSwDjSyHis(String proid){
        return baseRepository.get(SwDjSyHis.class,proid);
    }

    @Override
    @Transactional(readOnly = true)
    public SwDjSyQuery getSwDjSyxx(String proid) {
        QSwDjSyHis qSwDjSyHis = QSwDjSyHis.swDjSyHis;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QZd qZd = QZd.zd;

        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        QBean qBean = Projections.bean(SwDjSyQuery.class, qSwDjSy.zd.djh, qSwDjSy.dbh, qSwDjSyHis.glbm, qSwDjSyHis.jbbNsrmc, qSwDjSyHis.tdCzrmc, qSwDjSyHis.tdCzrzjhm, qSwDjSyHis.tdTdzl,
                qZd.tdyt, qZd.qlrmc, qZd.scmjZd, qSwDjSyHis.jbbZgkgDm,  qSwDjSyHis.jbbFddbr, qSwDjSyHis.jbbLxdh, qSwDjSyHis.jbbZclxDm, qSwDjSyHis.jbbHyDm, qSwDjSyHis.jbbZcdz,
                qSwDjSyHis.tdTdsyztDm, qSwDjSyHis.tdFzmj, qSwDjSyHis.tdScmj, qSwDjSyHis.tdTddj, qSwDjSyHis.tdMsmj, qSwDjSyHis.tdYnmj, qSwDjSyHis.tdDwse,
                qSwDjSyHis.fcFczh, qSwDjSyHis.fcFcmj, qSwDjSyHis.fcFwxzDm, qSwDjSyHis.fcZyhczDm, qSwDjSyHis.fcFwjz, qSwDjSyHis.fcTdjz, qSwDjSyHis.fcFssbjz, qSwDjSyHis.fcFcyz,
                qSwDjSyHis.fcFcyzYs, qSwDjSyHis.fcFcyzMs, qSwDjSyHis.fcYnseZy, qSwDjSyHis.fcYnseCz, qSwDjSyHis.fcNzj);
        query.from(qSwDjSyHis).leftJoin(qSwDjSyHis.swDjSy,qSwDjSy).leftJoin(qSwDjSy.zd,qZd).where(qSwDjSyHis.syhisId.eq(proid));
        return (SwDjSyQuery)baseRepository.get(query,qBean);

    }

    @Override
    @Transactional
    public void saveSwDjSyHis(SwDjSyHis swDjSyHis) {
        baseRepository.update(swDjSyHis);
    }

    @Override
    @Transactional
    public void updateSwDjSy(String syhisId) {
        SwDjSyHis swDjSyHis =baseRepository.get(SwDjSyHis.class,syhisId);
        SwDjSy swDjSy = swDjSyHis.getSwDjSy();
        SwDjTd swDjTd = swDjSy.getSwDjTd();
        SwDjFc swDjFc = swDjSy.getSwDjFc();
        SwDjJbb swDjJbb = swDjTd!=null?swDjTd.getSwDjJbb():swDjFc.getSwDjJbb();
        if(swDjJbb==null){
            swDjJbb = new SwDjJbb();
            swDjJbb.setJbbId(UUIDGenerator.generate());
            baseRepository.save(swDjJbb);
        }

        swDjJbb.setFddbr(swDjSyHis.getJbbFddbr());
        swDjJbb.setLxdh(swDjSyHis.getJbbLxdh());
        swDjJbb.setHyDm(swDjSyHis.getJbbHyDm());
        swDjJbb.setZclxDm(swDjSyHis.getJbbZclxDm());
        swDjJbb.setZcdz(swDjSyHis.getJbbZcdz());
        if(swDjTd==null){
            swDjTd = new SwDjTd();
            swDjTd.setTdId(UUIDGenerator.generate());
            swDjTd.setSwDjSy(swDjSy);
            swDjTd.setSwDjJbb(swDjJbb);
            baseRepository.save(swDjTd);
        }
        swDjTd.setTdsyztDm(swDjSyHis.getTdTdsyztDm());
        swDjTd.setFzmj(swDjSyHis.getTdFzmj());
        swDjTd.setScmj(swDjSyHis.getTdScmj());
        swDjTd.setTddj(swDjSyHis.getTdTddj());
        swDjTd.setMsmj(swDjSyHis.getTdMsmj());
        swDjTd.setYnmj(swDjSyHis.getTdYnmj());
        swDjTd.setDwse(swDjSyHis.getTdDwse());
        swDjTd.setNynseTd(swDjSyHis.getTdNynse());
        swDjTd.setCzrmc(swDjSyHis.getTdCzrmc());
        swDjTd.setCzrzjhm(swDjSyHis.getTdCzrzjhm());
        baseRepository.update(swDjTd);


        if(swDjFc==null){
            swDjFc = new SwDjFc();
            swDjFc.setFcId(UUIDGenerator.generate());
            swDjFc.setSwDjSy(swDjSy);
            swDjFc.setSwDjJbb(swDjJbb);
            baseRepository.save(swDjFc);
        }

        swDjFc.setFczh(swDjSyHis.getFcFczh());
        swDjFc.setFcmj(swDjSyHis.getFcFcmj());
        swDjFc.setFwxzDm(swDjSyHis.getFcFwxzDm());
        swDjFc.setZyhczDm(swDjSyHis.getFcZyhczDm());
        swDjFc.setFwjz(swDjSyHis.getFcFwjz());
        swDjFc.setTdjz(swDjSyHis.getFcTdjz());
        swDjFc.setFssbjz(swDjSyHis.getFcFssbjz());
        swDjFc.setFcyz(swDjSyHis.getFcFcyz());
        swDjFc.setFcyzYs(swDjSyHis.getFcFcyzYs());
        swDjFc.setFcyzMs(swDjSyHis.getFcFcyzMs());
        swDjFc.setYnseZy(swDjSyHis.getFcYnseZy());
        swDjFc.setYnseCz(swDjSyHis.getFcYnseCz());
        swDjFc.setNzj(swDjSyHis.getFcNzj());
        swDjFc.setNynseFc(swDjSyHis.getFcNynse());
        swDjFc.setFczl(swDjSyHis.getFcFczl());
        baseRepository.update(swDjFc);
    }

    @Override
    @Transactional
    public void del(String proid) {
        //删除sw_dj_sy_his表数据
        List<SwDjSyHis> swDjSyHisList = getSwDjSyHisListByRwid(proid);
        if(CollectionUtils.isNotEmpty(swDjSyHisList)){
            baseRepository.delete(swDjSyHisList.get(0));
        }
        //删除sw_dj_sy_temp表数据,税源编辑中会用到
        List<SwDjSyTemp> swDjSyTempList = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        if(CollectionUtils.isNotEmpty(swDjSyTempList)){
            baseRepository.delete(swDjSyTempList.get(0));
        }

    }

    @Override
    @Transactional(readOnly = true)
    public List<SwDjSyHis> getSwDjSyHisListByRwid(String rwid) {
        QSwDjSyHis qSwDjSyHis = QSwDjSyHis.swDjSyHis;
        JPQLQuery query = new JPAQuery(baseRepository.getEntityManager());

        query.from(qSwDjSyHis);
        query.where(qSwDjSyHis.rwid.eq(rwid));
        return (List)baseRepository.dslList(query,qSwDjSyHis);

    }

    @Override
    @Transactional(readOnly = true ,propagation = Propagation.NOT_SUPPORTED)
    public Object getSyxgxxLsitJson(SwDjSyQuery swDjSyQuery,Pageable pageable, String sylx) {
        String sql = "";
        if (StringUtils.isEmpty(sylx))
            sylx = Sylx.TDSY.toString();
        if (sylx.equals(Sylx.TDSY.toString()) || sylx.equals(Sylx.FCSY.toString())) {
            sql = "SELECT t1.SY_ID, t1.DJH, " +
                    "       t2.TD_ID, t2.TDDJ, t2.SCMJ, t2.YNMJ, t2.NYNSE AS NYNSETD, " +
                    "       t3.FC_ID, t3.FCYZ, t3.FCYZ_YS, t3.NZJ, t3.NYNSE AS NYNSEFC, " +
                    "       t4.XGRQ, " +
                    "       t5.GLBM, t5.NSRMC " +
                    "FROM SW_DJ_SY t1 " +
                    "     LEFT JOIN SW_DJ_TD t2 ON t1.SY_ID=t2.SY_ID " +
                    "     LEFT JOIN SW_DJ_FC t3 ON t1.SY_ID=t3.SY_ID " +
                    "     LEFT JOIN ( " +
                    "           SELECT MAX(XGRQ) AS XGRQ, SY_ID " +
                    "           FROM SW_DJ_SY_HIS " +
                    "           WHERE CZLX='UPDATE' " +
                    "           GROUP BY SY_ID " +
                    "      ) t4 ON t1.SY_ID=t4.SY_ID " +
                    "     LEFT JOIN SW_DJ_JBB t5 ON t5.JBB_ID=t2.JBB_ID " +
                    "     LEFT JOIN ZD t6 ON t1.DJH=t6.DJH " +
                    "WHERE t1.SYZT='1' AND t4.SY_ID IS NOT NULL AND t2.SY_ID IS NOT NULL ";
            if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
                sql = sql + " and t6.SGQDM like '"+swDjSyQuery.getQx()+"%'";
            }
        } else if (sylx.equals(Sylx.QS.toString())) {
            sql = "SELECT t1.SY_ID, t1.DJH, " +
                    "       t2.TD_ID, t2.TDDJ, t2.SCMJ, t2.YNMJ, t2.NYNSE AS NYNSETD, " +
                    "       t3.FC_ID, t3.FCYZ, t3.FCYZ_YS, t3.NZJ, t3.NYNSE AS NYNSEFC, " +
                    "       t7.YNSE AS QSYNSE, t7.JMSE AS QSJMSE, t7.YJNE AS QSYJNE, t7.XBJSE AS QSXBJSE, " +
                    "       t4.XGRQ, " +
                    "       t5.GLBM, t5.NSRMC " +
                    "FROM SW_DJ_SY t1 " +
                    "     LEFT JOIN SW_DJ_TD t2 ON t1.SY_ID=t2.SY_ID " +
                    "     LEFT JOIN SW_DJ_FC t3 ON t1.SY_ID=t3.SY_ID " +
                    "     LEFT JOIN SW_DJ_QS t7 ON t1.SY_ID=t7.SY_ID " +
                    "     LEFT JOIN ( " +
                    "           SELECT MAX(XGRQ) AS XGRQ, SY_ID " +
                    "           FROM SW_DJ_SY_HIS " +
                    "           WHERE CZLX='UPDATE' " +
                    "           GROUP BY SY_ID " +
                    "           ) t4 ON t1.SY_ID=t4.SY_ID " +
                    "     LEFT JOIN SW_DJ_JBB t5 ON t5.JBB_ID=t7.JBB_ID " +
                    "     LEFT JOIN SW_DJ_XMXX t6 ON t1.GD_ID=t6.XM_ID " +
                    "WHERE t1.SYZT='1' AND t4.SY_ID IS NOT NULL AND t7.SY_ID IS NOT NULL ";
            if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
                sql = sql + " and t6.XZQDM = '"+swDjSyQuery.getQx()+"'";
            }
        } else if (sylx.equals(Sylx.GDZYS.toString())) {
            sql = "SELECT t1.SY_ID, " +
                    "       t6.TDZL AS BPTDZL, t6.PZMJ, t6.PZSJ, " +
                    "       t7.YNSE AS GDZYSYNSE, t7.JMSE AS GDZYSJMSE, t7.YJNE AS GDZYSYJNE, t7.XBJSE AS GDZYSXBJSE, " +
                    "       t4.XGRQ, " +
                    "       t5.GLBM, t5.NSRMC, t5.ZGKG_MC  " +
                    "FROM SW_DJ_SY t1 " +
                    "     LEFT JOIN SW_DJ_GDZYS t7 ON t1.SY_ID=t7.SY_ID " +
                    "     LEFT JOIN ( " +
                    "           SELECT MAX(XGRQ) AS XGRQ, SY_ID " +
                    "           FROM SW_DJ_SY_HIS " +
                    "           WHERE CZLX='UPDATE' " +
                    "           GROUP BY SY_ID " +
                    "           ) t4 ON t1.SY_ID=t4.SY_ID " +
                    "     LEFT JOIN SW_DJ_JBB t5 ON t5.JBB_ID=t7.JBB_ID " +
                    "     LEFT JOIN SW_DJ_PCXX t6 ON t1.BP_ID=t6.PC_ID " +
                    "WHERE t1.SYZT='1' AND t4.SY_ID IS NOT NULL AND t7.SY_ID IS NOT NULL ";
            if(StringUtils.isNotBlank(swDjSyQuery.getQx())){
                sql = sql + " and t6.XZQDM = '"+swDjSyQuery.getQx()+"'";
            }
        }

        if(StringUtils.isNotBlank(swDjSyQuery.getZgkgDm())){
            sql = sql + " and t5.zgkg_dm ='"+swDjSyQuery.getZgkgDm()+"' ";
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getSgyMc())){
            sql = sql + " and t5.sgy_mc ='"+swDjSyQuery.getSgyMc()+"' ";
        }
        if(swDjSyQuery.getXgrqBegin()!=null){
            sql = sql + " and to_date(to_char(t4.xgrq,'yyyy-MM-dd'),'yyyy-MM-dd')>= to_date('"+new SimpleDateFormat("yyyy-MM-dd").format(swDjSyQuery.getXgrqBegin())+"','yyyy-MM-dd')";
        }
        if(swDjSyQuery.getXgrqEnd()!=null){
            sql = sql + " and to_date(to_char(t4.xgrq,'yyyy-MM-dd'),'yyyy-MM-dd')<= to_date('"+new SimpleDateFormat("yyyy-MM-dd").format(swDjSyQuery.getXgrqEnd())+"','yyyy-MM-dd')";
        }
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }
}
