package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SwDjFc;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjTd;
import cn.gtmap.landtax.service.SwgxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Created by zenglihuan on 2016-9-16.
 */
@Service
public class SwgxServiceImpl implements SwgxService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TjService tjService;
    @Autowired
    TaxService taxService;

    @Override
    @Transactional
    public void updateSwData() {
        String tag = null;
        String sql = null;
        Query query = null;
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        try {
            // 更新纳税人数据
            tag = "swgxNsrXz";
            sql = tjService.getTjSql(tag);
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            // 更新土地税新增数据
            tag = "swgxTdsXz";
            sql = tjService.getTjSql(tag);
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            // 更新税源主表数据
            /*sql = "INSERT INTO SW_DJ_SY (SYZT, SY_ID, SJLY, BZ) " +
                  "SELECT '1' AS SYZT, t1.SY_ID AS SY_ID, '0' AS SJLY, '税务数据更新_新增税务数据入库' AS BZ " +
                  "FROM SW_DJ_TD t1 " +
                  "LEFT JOIN SW_DJ_SY t2 ON t1.SY_ID=t2.SY_ID " +
                  "WHERE t2.SY_ID IS NULL ";
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();*/

            // 更新土地税修改数据
            tag = "swgxTdsXg";
            sql = tjService.getTjSql(tag);
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();

            // 更新修改数据
            /*tag = "swgxSyXg";
            sql = tjService.getTjSql(tag);
            query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.executeUpdate();*/
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}
