package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.service.MapService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.onemap.service.GeoService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.util.HashMap;
import java.util.LinkedHashMap;

/**
 * .
 * <p/>
 * 地图功能服务
 *
 * @author yang
 * @version V1.0, 14-5-29
 */
@Service
public class MapServiceImpl implements MapService {


    @Value("${egov.conf}/landtax/map.json")
    String configPath;
    @Autowired
    ZdService zdService;
    @Autowired
    GeoService geoService;
    @Override
    @Cacheable(value = "mapConfig")
    public Object getMapConfig() throws Exception {
        return readJsonFile(configPath);
    }

    @Override
    @Transactional
    public String insertZd(String geometry, String qlr, String tdzl, String bjqx, String bjjd, String bjjf,String tdjb) {
        LinkedHashMap geometryMap = JSON.parseObject(geometry, LinkedHashMap.class);

        HashMap propertiesMap = new HashMap();

        propertiesMap.put("QLRMC",qlr);
        propertiesMap.put("TDZL",tdzl);
        //获取土地级别后三位

        tdjb = tdjb.substring(tdjb.length()-3);
        //根据街道获取虚拟宗地最大地籍号
        String maxDjh = zdService.getMaxXnzdDjhByJd(bjjd);
        //编号自增
        Integer bh = Integer.parseInt(maxDjh.substring(maxDjh.length()-4))+1;
        String newDjh = bjjf+tdjb+String.valueOf(bh);
        propertiesMap.put("DJH",newDjh);
        propertiesMap.put("is_insert","1");
        geometryMap.put("properties", propertiesMap);
        //根据区县获取图层名称
        String landtaxDbUsername = AppConfig.getProperty("landtax.db.username");
        String layerName = landtaxDbUsername+".ZD_K_"+bjqx;

        String result = geoService.insert(layerName,JSON.toJSONString(geometryMap),true,null);
        return result;
    }

    private Object readJsonFile(String path) throws Exception {
        if (StringUtils.isNotBlank(path)) {
            if (path.indexOf("file:/") > -1)
                path = path.substring(path.indexOf("file:/") + 6);
            File file = new File(path);
            if (!file.exists())
                throw new FileNotFoundException();
            BufferedReader bufferedReader = null;
            StringBuffer config = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
                String tmp = null;
                while ((tmp = bufferedReader.readLine()) != null) {
                    config.append(tmp);
                }
            } finally {
                if (bufferedReader != null)
                    bufferedReader.close();
            }
            if (StringUtils.isNotBlank(config.toString())) {
                return JSON.parse(config.toString());
            }
        }
        return null;
    }
}
