package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Gqszly;
import cn.gtmap.landtax.model.dictionary.Gtlx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.service.GdzysService;
import cn.gtmap.landtax.service.SwdjSyHisService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Projections;
import com.mysema.query.types.QBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 * 耕地占用税服务实现类
 * @author zhouzhiwei
 * @version V1.0, 2015/3/10
 */
@Service
public class GdzysServiceImpl implements GdzysService {


    @Autowired
    BaseRepository baseRepository;
    @Autowired
    TaxService taxService;
    @Autowired
    DicService dicService;
    @Autowired
    SwdjSyHisService swdjSyHisService;

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<GdzysQuery> findPCXX(GdzysQuery gdzysQuery, Pageable pageable) {
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QBean qBean = Projections.bean(GdzysQuery.class, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj, qSwDjPcxx.jbntmj, qSwDjPcxx.fgdnydmj, qSwDjPcxx.gdmj, qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjPcxx);
        applyGdzysQueryPredicates(gdzysQuery, qSwDjPcxx, jpaQuery);
        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Page<QSwDjSy> findGdzystz(GdzysQuery gdzysQuery, Pageable pageable) {
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;

        QBean qBean = Projections.bean(GdzysQuery.class, qSwDjSy.syId, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj,qSwDjPcxx.jbntmj,qSwDjPcxx.fgdnydmj,qSwDjPcxx.gdmj,
                qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw, qSwDjPcxx.pcXzqdm, qSwDjGdzys.gdzysId, qSwDjGdzys.gdzysYnse, qSwDjGdzys.gdzysDwse, qSwDjGdzys.gdzysJmxz, qSwDjGdzys.gdzysJmse, qSwDjGdzys.gdzysJspz,
                qSwDjGdzys.gdzysYjne, qSwDjGdzys.gdzysXbjse, qSwDjGdzys.gdzysBz, qSwDjGdzys.gdzysLrrq, qSwDjGdzys.gdzysHclx,
                qSwDjJbb.glbm, qSwDjJbb.nsrmc, qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjGdzys, qSwDjGdzys).leftJoin(qSwDjSy.swDjPcxx, qSwDjPcxx).leftJoin(qSwDjGdzys.swDjJbb, qSwDjJbb).where(qSwDjPcxx.pcId.isNotNull());
        applyGdzysQueryPredicates(gdzysQuery, qSwDjPcxx, jpaQuery);
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.BP.toString()).or(qSwDjSy.sysjly.isNull()));
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        return baseRepository.find(jpaQuery,qBean,pageable);
    }

    private void applyGdzysQueryPredicates(GdzysQuery gdzysQuery, QSwDjPcxx qSwDjPcxx, JPQLQuery jpaQuery){
        if(StringUtils.isNotBlank(gdzysQuery.getPcXzqdm()))
            jpaQuery.where(Expressions.stringPath(qSwDjPcxx, "pcXzqdm").eq(gdzysQuery.getPcXzqdm()));
        if(StringUtils.isNotBlank(gdzysQuery.getPcmc()))
            jpaQuery.where(Expressions.stringPath(qSwDjPcxx, "pcmc").like(QueryCondition.WILDCARDS + gdzysQuery.getPcmc() + QueryCondition.WILDCARDS));
        if(StringUtils.isNotBlank(gdzysQuery.getIds())){
            jpaQuery.where(qSwDjPcxx.pcId.in(Arrays.asList(gdzysQuery.getIds().split(","))));
        }
        if(StringUtils.isNotBlank(gdzysQuery.getExcelBegin()) && StringUtils.isNotBlank(gdzysQuery.getExcelEnd())){
            Integer offset = Integer.parseInt(gdzysQuery.getExcelBegin())-1;
            Integer limit = Integer.parseInt(gdzysQuery.getExcelEnd())-offset;
            jpaQuery.offset(offset).limit(limit);
        }
    }
    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<GdzysQuery> findAllGdzysQuery() {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QBean qBean = Projections.bean(GdzysQuery.class, qSwDjSy.syId,qSwDjSy.ishc, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj,
                qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw, qSwDjPcxx.pcXzqdm, qSwDjGdzys.gdzysId, qSwDjGdzys.gdzysYnse, qSwDjGdzys.gdzysDwse, qSwDjGdzys.gdzysJmxz, qSwDjGdzys.gdzysJmse, qSwDjGdzys.gdzysJspz,
                qSwDjGdzys.gdzysYjne, qSwDjGdzys.gdzysXbjse, qSwDjGdzys.gdzysBz, qSwDjGdzys.gdzysLrrq, qSwDjGdzys.gdzysHclx, qSwDjJbb.jbbId, qSwDjJbb.glbm, qSwDjJbb.nsrmc,
                qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc, qSwDjJbb.sgyDm, qSwDjJbb.sgyMc, qSwDjJbb.fddbr, qSwDjJbb.lxdh, qSwDjJbb.zclxDm,
                qSwDjJbb.zclxMc, qSwDjJbb.hyDm, qSwDjJbb.hyMc, qSwDjJbb.zcdz);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjGdzys, qSwDjGdzys).leftJoin(qSwDjGdzys.swDjJbb, qSwDjJbb).rightJoin(qSwDjSy.swDjPcxx, qSwDjPcxx);
        jpaQuery.where(qSwDjPcxx.pcId.isNotNull());
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.BP.toString()).or(qSwDjSy.sysjly.isNull()));
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        baseRepository.addEntityPath(qSwDjPcxx);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public GdzysQuery findGdzysqueryByPCID(String pcid) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QBean qBean = Projections.bean(GdzysQuery.class, qSwDjSy.syId,qSwDjSy.ishc, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj,qSwDjPcxx.jbntmj,qSwDjPcxx.fgdnydmj,qSwDjPcxx.gdmj,
                qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw, qSwDjPcxx.pcXzqdm,qSwDjPcxx.pcTdzl, qSwDjGdzys.gdzysId, qSwDjGdzys.gdzysYnse, qSwDjGdzys.gdzysDwse, qSwDjGdzys.gdzysJmxz, qSwDjGdzys.gdzysJmse, qSwDjGdzys.gdzysJspz,
                qSwDjGdzys.gdzysYjne, qSwDjGdzys.gdzysXbjse, qSwDjGdzys.gdzysBz, qSwDjGdzys.gdzysLrrq, qSwDjGdzys.gdzysHclx, qSwDjJbb.jbbId, qSwDjJbb.glbm, qSwDjJbb.nsrmc,
                qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc, qSwDjJbb.sgyDm, qSwDjJbb.sgyMc, qSwDjJbb.fddbr, qSwDjJbb.lxdh, qSwDjJbb.zclxDm,
                qSwDjJbb.zclxMc, qSwDjJbb.hyDm, qSwDjJbb.hyMc, qSwDjJbb.zcdz);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjGdzys, qSwDjGdzys).leftJoin(qSwDjGdzys.swDjJbb, qSwDjJbb).rightJoin(qSwDjSy.swDjPcxx, qSwDjPcxx);
        jpaQuery.where(qSwDjPcxx.pcId.eq(pcid));
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.BP.toString()).or(qSwDjSy.sysjly.isNull()));
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));

        GdzysQuery gdzysQuery = (GdzysQuery) baseRepository.get(jpaQuery, qBean);
        if (gdzysQuery == null) {
            jpaQuery = new JPAQuery(baseRepository.getEntityManager());
            jpaQuery.from(qSwDjPcxx).where(qSwDjPcxx.pcId.eq(pcid));
            qBean = Projections.bean(GdzysQuery.class, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj,qSwDjPcxx.pcTdzl);
            gdzysQuery = (GdzysQuery) baseRepository.get(jpaQuery, qBean);
        }

        return gdzysQuery;
    }

    @Override
    public GdzysQuery findGdzysqueryBySyId(String syId) {
        QSwDjGdzys qSwDjGdzys = QSwDjGdzys.swDjGdzys;
        QSwDjSy qSwDjSy = QSwDjSy.swDjSy;
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QSwDjJbb qSwDjJbb = QSwDjJbb.swDjJbb;
        QBean qBean = Projections.bean(GdzysQuery.class, qSwDjSy.syId,qSwDjSy.ishc, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj,
                qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw, qSwDjPcxx.pcXzqdm, qSwDjGdzys.gdzysId, qSwDjGdzys.gdzysYnse, qSwDjGdzys.gdzysDwse, qSwDjGdzys.gdzysJmxz, qSwDjGdzys.gdzysJmse, qSwDjGdzys.gdzysJspz,
                qSwDjGdzys.gdzysYjne, qSwDjGdzys.gdzysXbjse, qSwDjGdzys.gdzysBz, qSwDjGdzys.gdzysLrrq, qSwDjGdzys.gdzysHclx, qSwDjJbb.jbbId, qSwDjJbb.glbm, qSwDjJbb.nsrmc,
                qSwDjJbb.zgkgDm, qSwDjJbb.zgkgMc, qSwDjJbb.sgyDm, qSwDjJbb.sgyMc, qSwDjJbb.fddbr, qSwDjJbb.lxdh, qSwDjJbb.zclxDm,
                qSwDjJbb.zclxMc, qSwDjJbb.hyDm, qSwDjJbb.hyMc, qSwDjJbb.zcdz);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjSy).leftJoin(qSwDjSy.swDjGdzys, qSwDjGdzys).leftJoin(qSwDjGdzys.swDjJbb, qSwDjJbb).rightJoin(qSwDjSy.swDjPcxx, qSwDjPcxx);
        jpaQuery.where(qSwDjSy.syId.eq(syId));
        jpaQuery.where(qSwDjSy.sysjly.eq(Gtlx.BP.toString()).or(qSwDjSy.sysjly.isNull()));
        jpaQuery.where(qSwDjSy.syzt.eq(Syzt.ZC.toString()).or(qSwDjSy.syzt.isNull()).or(qSwDjSy.syzt.eq("")));
        return (GdzysQuery) baseRepository.get(jpaQuery, qBean);
    }

    @Override
    @Transactional
    public void SaveGdzys(GdzysQuery gdzysQuery) {
        String gdzysId = gdzysQuery.getGdzysId();
        String pcId = gdzysQuery.getPcId();
        String syId = gdzysQuery.getSyId();

        SwDjPcxx swDjPcxx = baseRepository.get(SwDjPcxx.class, pcId);

        if(!StringUtils.isBlank(syId)){
            // 保存历史记录
            SwDjSy swDjSy = taxService.getSwDjSyById(syId);
            swdjSyHisService.saveSwDjHis(swDjSy, "", SessionUtil.getCurrentUserId(), Czlx.UPDATE.toString());
        }

        // 税源主表
        SwDjSy swDjSy = new SwDjSy();
        BeanUtils.copyProperties(gdzysQuery, swDjSy);
        if (StringUtils.isBlank(syId)) {
            swDjSy.setSyId(UUIDGenerator.generate());
            swDjSy.setSwDjPcxx(swDjPcxx);
            swDjSy.setSyzt(Syzt.ZC.toString());
            swDjSy.setSysjly(Gtlx.BP.toString());
            baseRepository.save(swDjSy);
        }

        // 保存主管税务机关名称
        String zgkgDm = gdzysQuery.getZgkgDm();
        String zgkgMc = dicService.findZgkgMcByZgkgDm(zgkgDm);
        gdzysQuery.setZgkgMc(zgkgMc);

        //基本表操作
        SwDjJbb swDjJbb = null;
        String glbm = gdzysQuery.getGlbm();
        // 根据管理编码查询是否存在基本表信息
        if(StringUtils.isNotBlank(glbm)){
            swDjJbb = taxService.findSwDjJbbByGlbm(glbm);
        }
        if(swDjJbb==null){
            swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(gdzysQuery, swDjJbb);
            swDjJbb.setJbbId(UUIDGenerator.generate());
            baseRepository.save(swDjJbb);//先保存基本表
        }else{
            BeanUtils.copyProperties(gdzysQuery, swDjJbb, new String[]{"jbbId"});
            baseRepository.update(swDjJbb);
        }

        // 耕地占用税数据操作
        SwDjGdzys swDjGdzys = new SwDjGdzys();
        BeanUtils.copyProperties(gdzysQuery, swDjGdzys);
        swDjGdzys.setSwDjJbb(swDjJbb);
        swDjGdzys.setSwDjSy(swDjSy);
        swDjGdzys.setGdzysZt(Syzt.ZC.toString());
        swDjGdzys.setGdzysSzly(Gqszly.XMLR.toString());
        if(StringUtils.isBlank(gdzysId)){
            swDjGdzys.setGdzysId(UUIDGenerator.generate());
            swDjGdzys.setGdzysLrrq(new Date());
            baseRepository.save(swDjGdzys);
        }else{
            baseRepository.update(swDjGdzys);
        }
    }

    @Override
    @Transactional
    public void DelGdzys(String pcid) {
        // 获取删除的耕地占用税
        GdzysQuery gdzysQuery = findGdzysqueryByPCID(pcid);

        // 保存历史记录
        String syId = gdzysQuery.getSyId();
        SwDjSy swDjSy = taxService.getSwDjSyById(syId);
        swdjSyHisService.saveSwDjHis(swDjSy, "", SessionUtil.getCurrentUserId(), Czlx.DELETE.toString());

        // 删除
        swDjSy = new SwDjSy();
        BeanUtils.copyProperties(gdzysQuery, swDjSy);
        swDjSy.setSyzt(Syzt.SC.toString());
        baseRepository.update(swDjSy);
    }

    @Override
    public String getDwseByXzqdm(String xzqdm) {
        String sql = "SELECT DWSE " +
                     "FROM S_DM_GDZYSDWSE " +
                     "WHERE QXDM = '" + xzqdm + "'";
        String dwse = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        return dwse;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public SwDjPcxx getPcByPcmc(String pcmc) {
        String jpql = "from SwDjPcxx o where o.pcmc=?0";
        List list = baseRepository.getByJpql(jpql,pcmc);
        if(CollectionUtils.isNotEmpty(list)){
            return (SwDjPcxx)list.get(0);
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<GdzysQuery> getPcxxList(GdzysQuery gdzysQuery) {
        QSwDjPcxx qSwDjPcxx = QSwDjPcxx.swDjPcxx;
        QBean qBean = Projections.bean(GdzysQuery.class, qSwDjPcxx.pcId, qSwDjPcxx.pcmc, qSwDjPcxx.pwh, qSwDjPcxx.pzmj, qSwDjPcxx.nydmj, qSwDjPcxx.jbntmj, qSwDjPcxx.fgdnydmj, qSwDjPcxx.gdmj, qSwDjPcxx.pzsj, qSwDjPcxx.pcYddw);
        JPQLQuery jpaQuery = new JPAQuery(baseRepository.getEntityManager());
        jpaQuery.from(qSwDjPcxx);
        applyGdzysQueryPredicates(gdzysQuery, qSwDjPcxx, jpaQuery);
        return (List)baseRepository.dslList(jpaQuery,qBean);
    }


}
