package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.QSDmDwxxCz;
import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.dictionary.Dwjb;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.web.SessionUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
@Service
public class DwxxServiceImpl implements DwxxService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    ZdService zdService;

    @Override
    @Transactional(readOnly = true)
    public List<SDmDwxxCz> getAllDwxx() {
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        return baseRepository.dslList(qDmDwxxCz);
    }

    @Override
    @Transactional(readOnly = true)
    public SDmDwxxCz getDwxxByDwdm(String dwdm) {
        return baseRepository.get(SDmDwxxCz.class, dwdm);
    }

    @Override
    @Transactional(readOnly = true)
    public SDmDwxxCz getCityByDwdm(String dwdm) {
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.eq(dwdm).and(qDmDwxxCz.dwjb.eq(Dwjb.DS.toString()))).uniqueResult(qDmDwxxCz);
    }

    @Override
    @Transactional(readOnly = true)
    public List<SDmDwxxCz> getCountiesByDwdm(String dwdm) {
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.like(dwdm+ QueryCondition.WILDCARDS).and(qDmDwxxCz.dwjb.eq(Dwjb.QX.toString()))).list(qDmDwxxCz);
    }

    @Override
    @Transactional(readOnly = true)
    public List<SDmDwxxCz> getAllQxList() {
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        List<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();
        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                qxDwxxList.add(tempVo);
            }
        }
        return qxDwxxList;
    }

    @Override
    public List<SDmDwxxCz> getUserQxList() {
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        List<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();

        String swdwdm = getUserQxDm();
        String dwdmStr = zdService.TransQueryXzq(swdwdm);
        List dwdmList= Arrays.asList(dwdmStr.split(","));

        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                if (dwdmStr.isEmpty() || dwdmStr == "" || dwdmList.contains(tempVo.getDwdm())){
                    qxDwxxList.add(tempVo);
                }
            }
        }
        if (qxDwxxList.size() == 0)
            qxDwxxList = getAllQxList();
        return qxDwxxList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<SDmDwxxCz> getJdByQx(String qx) {
        if(StringUtils.isBlank(qx)){
            return new ArrayList();
        }
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.like(qx + QueryCondition.WILDCARDS).and(qDmDwxxCz.dwjb.eq(Dwjb.XZJD.toString()))).list(qDmDwxxCz);
    }

    @Override
    public List<SDmDwxxCz> getJfByJd(String jd) {
        if(StringUtils.isBlank(jd)){
            return new ArrayList();
        }
        QSDmDwxxCz qDmDwxxCz = QSDmDwxxCz.sDmDwxxCz;
        JPQLQuery jpqlQuery = new JPAQuery(baseRepository.getEntityManager());
        return jpqlQuery.from(qDmDwxxCz).where(qDmDwxxCz.dwdm.like(jd + QueryCondition.WILDCARDS).and(qDmDwxxCz.dwjb.eq(Dwjb.CJF.toString()))).list(qDmDwxxCz);
    }

    @Override
    public String getUserQxDm() {
        String swdwdm = "";
        if (SessionUtil.getCurrentUser()!=null) {
            swdwdm = SessionUtil.getCurrentUser().getRegionCode();
            if (swdwdm == null || swdwdm.length() < 6) {
                swdwdm = "";
            } else {
                swdwdm = swdwdm.substring(0, 6);
                if (swdwdm.substring(4, 6) == "00" || swdwdm.substring(4, 6).isEmpty()) {
                    swdwdm = "";
                }
            }
        }

        return swdwdm;
    }

    @Override
    public String getUserRegionCode() {
        String regionCode = "";
        try {
            if (SessionUtil.getCurrentUser() != null) {
                regionCode = SessionUtil.getCurrentUser().getRegionCode();
                if (regionCode == null) {
                    regionCode = "";
                }
            }
        } catch (Exception e) {}

        return regionCode;
    }


}
