package cn.gtmap.landtax.service.impl;/*
 * @author <a href="mailto:wangzhengqing@gtmap.cn">wangzhengqing</a>
 * @version 1.0, 2016/4/23 0023
 * @description 
 */

import cn.gtmap.landtax.entity.SwDjPcxx;
import cn.gtmap.landtax.model.query.DictTreeGrid;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.service.CzfxxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import javax.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service
public class CzfxxServiceImpl implements CzfxxService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SysUserService sysUserService;

    @Override
    public Page<SwDjPcxx> czf() {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from sw_dj_fc t left join sw_dj_jbb b on b.jbb_id = t.jbb_id ");
        /*sql.append("order by cyje desc");*/
        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        //Page page = baseRepository.find(query, countQuery, pageable);
        return null;
    }

    @Override
    public Object syncHcjdRootJson(String hcxmlx, String id) {
        Integer flag = null;
        String regionCode = "";
        Boolean isSgy = false;

        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();
        //判断当前登陆人是否是税管员
        if (user.getRegionCode().length() == 8 && (StringUtils.isBlank(sysUserService.getUserVo(userId).getRemark()) || sysUserService.getUserVo(userId).getRemark().indexOf("zuzhang") != -1)) {
            isSgy = true;
        }

        Integer length = null;

        String organId = "";
        if (StringUtils.isNotBlank(id)) {
            regionCode = id;
            length = regionCode.length() + 2;
        } else {

            regionCode = user.getRegionCode();
            length = regionCode.length();
        }

        if (length == 4) {//说明是市局用户
            flag = 0;
        } else if (length == 6) {//说明是区县管理员
            flag = 1;
        } else if (length == 8) {//
            flag = 2;
        } else if (length > 8) {
            flag = 3;
            //根据regionCode获取organId
            List<PfOrganVo> organList = sysUserService.getOrganByRegionCode(regionCode);
            if (CollectionUtils.isNotEmpty(organList)) {
                organId = organList.get(0).getOrganId();
            }
        }
        String sql = "";
        if(StringUtils.isBlank(id)){
            sql = "select t1.*,t2.dwmc from\n" +
                    "(\n" +
                    "select count(*)zs,sum(t1.nzj)hjNzj,sum(t1.ynse_cz), substr(t2.zgkg_dm,2,8)zgkg_dm from sw_dj_fc t1 \n" +
                    "left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id\n" +
                    "group by substr(t2.zgkg_dm,2,8)\n" +
                    ")t1 left join s_dm_swdwxx t2 on t1.zgkg_dm=t2.swdm" +
                    "where t1.zgkg_dm = '6107'";
        }
        else if(id.length()==6){
            sql = "select t1.*,t2.dwmc from\n" +
                    "(\n" +
                    "select count(*)zs,sum(t1.nzj)hjNzj,sum(t1.ynse_cz), substr(t2.zgkg_dm,2,8)zgkg_dm from sw_dj_fc t1 \n" +
                    "left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id\n" +
                    "group by substr(t2.zgkg_dm,2,8)\n" +
                    ")t1 left join s_dm_swdwxx t2 on t1.zgkg_dm=t2.swdm" +
                    "where t1.zgkg_dm = '" + id + "'";
        }else if(id.length()==10){
            sql = "select t1.*,t2.dwmc from\n" +
                    "(\n" +
                    "select count(*)zs,sum(t1.nzj)hjNzj,sum(t1.ynse_cz), substr(t2.zgkg_dm,1,11)zgkg_dm from sw_dj_fc t1 \n" +
                    "left join sw_dj_jbb t2 on t1.jbb_id=t2.jbb_id\n" +
                    "group by substr(t2.zgkg_dm,1,11)\n" +
                    ")t1 left join s_dm_swdwxx t2 on t1.zgkg_dm=t2.swdm" +
                    "where t1.zgkg_dm = '" + id + "'";
        }



        /*sql = "SELECT t1.ORGAN_NAME as DWMC,t1.REGION_CODE as XZQDM from pf_organ t1 " + "WHERE t1.REGION_CODE LIKE "+"'"+ regionCode +"%'"+
                    "            AND LENGTH (t1.REGION_CODE) = "+"'"+length+"'";*/


        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String, Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (HashMap tempMap : list) {
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setName(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setYcl(String.valueOf(tempMap.get("YCL")));
                tempGrid.setWcl(String.valueOf(tempMap.get("WCL")));
                tempGrid.setCll(String.valueOf(tempMap.get("CLL")));
                tempGrid.setXzqdm(String.valueOf(tempMap.get("ZGKG_DM")));
                resultList.add(tempGrid);

            }
        }
        return resultList;
    }
}
