package cn.gtmap.landtax.service;

import cn.gtmap.landtax.entity.Project;
import cn.gtmap.landtax.entity.SSjSwbd;
import cn.gtmap.landtax.entity.SwDjFcWbd;
import cn.gtmap.landtax.entity.SwDjTdWbd;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.HashMap;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author yang
 * @version V1.0, 14-7-5
 */
public interface SwdjtzService {

    public List getSwdjtz(String xzq);

    public Page<SSjSwbd> findSyppxxMap(String xzqbh,String lx, Pageable pageable,SwDjSyQuery swDjSyQuery,Sylx lxs);

    /**
     * 查找未匹配的税源信息
     * @param xzqbh
     * @param pageable
     * @param swDjSyQuery
     * @param lxs
     * @return
     */
    public Page<SSjSwbd> findWppSyMap(String xzqbh, Pageable pageable, SwDjSyQuery swDjSyQuery, Sylx lxs);

    public String getSwtzJson(String xzq,StringBuffer stringBuffer,String lx);

    public String getCreateNewProject(String glbm,Project newProject,String sylx,String hcxmMc,String tdIds,String fcIds);

    public List<SSjSwbd>  findWppxxJsonProject(Pageable pageable,String proid);

    public String getProjectSwtzJson(String xzq,StringBuffer stringBuffer);

    public String saveListJson(String json);

    public Project  getProjectInform();

    /**
     * 办结税源核查的工作流项目，即将gtbd的blzt=1，istx，proid字段设置为空，同事录入sw_dj_sy台帐
     */
    public void uploadToData(String proid) throws  Exception;

    /**
     * 删除未匹配税源核查的工作流项目，即将gtbd的blzt，istx，proid字段设置为空
     */
    void delSwbdProject(String proid);

    List<SSjSwbd> getSSjSwbdById(String[] bdIds);

    List<SwDjTdWbd> getSwDjTdWbdByIds(String[] bdIds);
    List<SwDjFcWbd> getSwDjFcWbdByIds(String[] bdIds);

    SSjSwbd findSSjSwbdByProid(String proid);

    SwDjTdWbd findSwDjTdWbdByJbbId(String jbbId);
    SwDjTdWbd findSwDjTdWbdByProid(String proid);
    SwDjFcWbd findSwDjFcWbdByJbbId(String jbbId);
    SwDjFcWbd findSwDjFcWbdByProid(String proid);

    void saveDjh(String djh, String tdId,String fcId,String dbh) throws Exception;

    List<GtSwTzQuery> getSwdjTzList(HashMap param);

    Page<SSjSwbd> findYxfSyMap(Pageable pageable, SwDjSyQuery swDjSyQuery, Sylx lxs);
}
