package cn.gtmap.landtax.quartz;

import com.gtis.config.AppConfig;

/**
 * 接口定时器入口
 * Created by Zenglihuan on 20160922
 */

public class TbSbSjQuartzFactory {

    public TbSbSjQuartz createInstance() {
        //获取定时器配置
        String timerConfig = AppConfig.getProperty("TIMER_CONFIG");
        if(timerConfig == null || "".equals(timerConfig)){
            timerConfig = "default";
        }

        //都转为小写
        String timerConfig_lowerCase = timerConfig.toLowerCase();
        //类名
        String clazzName = "TbSbSjQuartz_"+timerConfig_lowerCase;

        TbSbSjQuartz quartz = null;
        try{
            Class clazz = Class.forName("cn.gtmap.landtax.quartz.quartzImpl."+clazzName);
            quartz = (TbSbSjQuartz)clazz.newInstance();
        }catch (Exception e){
            e.printStackTrace();
        }
        return quartz;
    }

}
