package cn.gtmap.landtax.printexcel.access;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import cn.gtmap.landtax.printexcel.xmlparse.XMLParse;
import cn.gtmap.landtax.printexcel.xmlparse.element.Cell;
import cn.gtmap.landtax.printexcel.xmlparse.element.Group;
import cn.gtmap.landtax.printexcel.xmlparse.element.Sheet;
import cn.gtmap.landtax.printexcel.xmlparse.element.Single;
import cn.gtmap.landtax.printexcel.xmlparse.element.cellstyle.*;
import cn.gtmap.landtax.util.CommonUtil;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class WriteSheet {
	Log log = LogFactory.getLog(getClass().getName());

	String xslPath = "\\static\\excel\\temp\\";

	String xmlPath = "\\static\\excel\\xml\\";

	public WriteSheet() {
	}

	@SuppressWarnings( { "deprecation", "unchecked" })
	public String execute(HashMap groupMap, Object[] pojos, String xls, String xml, HttpServletRequest request) {
		String XlsName = new Date().getTime() + ".xls";
		String url = request.getRealPath("/");
		WritableWorkbook writableworkbook = null;
		Workbook rw = null;
		WritableSheet writablesheet = null;
		try { // 获取只读的Excel工作薄的模板对象
			rw = Workbook.getWorkbook(new File(request.getRealPath("/" + "static\\excel\\template"), xls));
			// 拷贝模板，创建一个可写的副本
			writableworkbook = Workbook.createWorkbook(new File(url + xslPath + "\\" + XlsName), rw);
			// writablesheet = writableworkbook.getSheet(0);
		} catch (BiffException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// 开始解析对应的xml配置文件
		XMLParse xmlParse = new XMLParse();
		// xmlList中封装所有的sheet对象
		StringBuffer xmlBuff = new StringBuffer(url);
		xmlBuff.append(xmlPath);
		xmlBuff.append(xml);
		List xmlList = xmlParse.loadXml(xmlBuff.toString());
		// 循环获取sheet
		for (int i = 0; i < xmlList.size(); i++) {
			// Tusersign signPo=null; //签名表信息
			Sheet sheet = (Sheet) xmlList.get(i);
			// 获取该sheet的name
			String sheetName = sheet.getName();
			// 获取在Excel中要写入的sheet
			writablesheet = writableworkbook.getSheet(sheetName);
			// 获取该sheet下的sequence
			List seqList = sheet.getSequenceList();
			// 按照sequence顺序循环写入
			for (int j = 0; j < seqList.size(); j++) {
				String sq = (String) seqList.get(j);
				HashMap elementMap = (HashMap) sheet.getElementMap();
				// 遍历哈希表
				if (elementMap.containsKey(sq)) {
					Object elementObj = elementMap.get(sq);
					if (elementObj instanceof Single) {
						// writeSingle((Single) elementObj);
						Single single = (Single) elementObj;
						List cellist = single.getCellList();
						if (cellist != null && cellist.size() > 0) {
							Object value = null; //
							// 一个single下最多只有一个cell,此处设计不太合理，修改？？
							Cell cell = (Cell) cellist.get(0);
							int row = cell.getRow();// 注意：如果row是负数时，说明它的位置
							// 不定，如果是-1时：表示在它前面的第一个group结束后的第一行，依次类推
							if (row < 0) { // 查找在它前面的第一个group
								for (int t = j - 1; t >= 0; t--) {
									String preGroupKey = (String) seqList.get(t);
									if (elementMap.containsKey(preGroupKey)) {
										if (elementMap.get(preGroupKey) instanceof Group) {
											Group preGroup = (Group) elementMap.get(preGroupKey);
											int endRow = preGroup.getEndRow(); // 结束行
											row = Math.abs(row) + endRow - 1;
											break;
										} else
											continue;
									}
								}
							}
							if (row == 10000) { // 注意此处只在“供地方案”页面中用到，设计不合理，最好再设置一个标志节点
								for (int t = j - 1; t >= 0; t--) {
									String preGroupKey = (String) seqList.get(t);
									if (elementMap.containsKey(preGroupKey)) {
										if (elementMap.get(preGroupKey) instanceof Group) {
											Group preGroup = (Group) elementMap.get(preGroupKey);
											int beginRow = preGroup.getBeginRow(); // 起始行
											row = beginRow - 1;
											break;
										} else
											continue;
									}
								}
							}
							int column = cell.getColumn();
							ComeFrom cf = (ComeFrom) cell.getComeFrom();
							String pojoName = cf.getPojoName();
							String attribute = cf.getAttribute();
							@SuppressWarnings("unused")
							String signArr = null; // 在签名表中的字段属性
							int v = attribute.indexOf(",");
							if (v != -1) {
								signArr = attribute.substring(v, attribute.length());
								attribute = attribute.substring(0, v);
							}
							if (pojoName != null && pojoName.equalsIgnoreCase("request")) {
								// 来自request容器,强制类型转换成字符串
								if (request.getAttribute(attribute) == null) {
									log.info("request锟斤拷没锟斤拷锟斤拷锟斤拷牟锟斤拷锟絘ttribute锟斤拷" + attribute);
									// value="";
								} else
									value = request.getAttribute(attribute);
							} else if (pojoName != null && pojoName.equalsIgnoreCase("template")) {
								// 来自excel模板，只需要读取数据，修改单元格式
								value = writablesheet.getCell(column, row).getContents();
							} else { // 来自pojo
								Class c = null;
								try {
									c = Class.forName(pojoName);
									if (pojos == null || pojos.length == 0) {
										log.error("传递过来的pojo对象数组为空，无法操作！");
									} else {
										for (int t = 0; t < pojos.length; t++) {
											if (c.isInstance(pojos[t])) {
												StringBuffer methodName = new StringBuffer("get");
												methodName.append(attribute.substring(0, 1).toUpperCase());
												methodName.append(attribute.substring(1));
												Method meth = c.getMethod(methodName.toString(), null);
												value = meth.invoke(pojos[t], null);
												// if(signArr!=null){//来自签名表的信息
												// if(value!=null&&(signPo==null||(signPo!=null&&!signPo.getSiId().equals(value)))){
												// signPo
												// =getSingPo(value.toString(),request);
												// }
												// if(signPo!=null&&signPo.getSiId().equals(value)){
												// Class
												// _c=Class.forName("com.jsegov.entity.pojo.Tusersign");
												// StringBuffer _methodName=new
												// StringBuffer("get");
												// _methodName.append(signArr.substring(1,2).toUpperCase());
												// _methodName.append(signArr.substring(2));
												// Method _meth =
												// _c.getMethod(_methodName.toString(),null);
												// value=_meth.invoke(signPo,null);
												// }
												// else
												// value="";
												// }
												break;
											}
										}
									}

								} catch (ClassNotFoundException e) {
									log.error("没有找到该路径下的类：" + pojoName);
									e.printStackTrace();
								} catch (SecurityException e) {
									e.printStackTrace();
								} catch (NoSuchMethodException e) {
									e.printStackTrace();
								} catch (IllegalArgumentException e) {
									e.printStackTrace();
								} catch (IllegalAccessException e) {
									e.printStackTrace();
								} catch (InvocationTargetException e) {
									e.printStackTrace();
								} catch (Exception e) {
									e.printStackTrace();
								}
							}
							String valueType = cell.getValueType();
							if (value == null) {
								value = "";

							} else {
								if (value instanceof Date) { // 时间类型需要格式化YYYY-MM-DD=>YYYY年MM月DD日
									// value=ObjectView.toString((Date)value);
									// value=CanlendarUtil.DateToStringCHN((Date)value);
								}
								if (valueType != null && valueType.equalsIgnoreCase("double")) {
									int precision = cell.getPrecision();
									if (!value.equals("")) {
										value = CommonUtil.DoubleToString(Double.parseDouble(value.toString()), precision);
									}

								}
							}
							CellStyle cellStyle = cell.getCellStyle();
							// 获取cell的基本格式
							WritableCellFormat cellFormat = getCellFormat(cellStyle);
							try { // 设置excel背景颜色
								cellFormat.setBackground(Colour.WHITE);
							} catch (WriteException e1) {
								e1.printStackTrace();
							}
							MergedCell mergedCell = cellStyle.getMergedCell();
							if (mergedCell != null) {// //合并单元格
								// 如果toy为负值，说明合并至第几行为不定值，-1表示合并至
								// 它前面第一个group的结束行，-2表示在group行的下一行，依次类推
								// 如果fromy为负值，表示从第几行开始合并为不定值，-1表示从它上面第一个group
								// 开始行的上面一行，依次类推。
								String fromX = mergedCell.getFromX();
								int fromY = mergedCell.getFromY();
								String toX = mergedCell.getToX();
								int toY = mergedCell.getToY();
								
								int groupBeginRow=0;
								int groupEndRow=0;
								
								//获取第一个group的最后一行的行数，方便在group下面插入一些数据
								for (int t = j - 1; t >= 0; t--) {
									String preGroupKey = (String) seqList.get(t);
									if (elementMap.containsKey(preGroupKey)) {
										if (elementMap.get(preGroupKey) instanceof Group) {
											Group preGroup = (Group) elementMap.get(preGroupKey);
											groupBeginRow = preGroup.getBeginRow()-1; // 开始行
											groupEndRow = preGroup.getEndRow(); // 结束行
											break;
										} else
											continue;
									}
								}
								//如果开始y小于零，则fromy取值为它前面的第一个group的最后一行行数，即从group下面添加数据
								//fromy小于零的时候，判断toy是否小于零，如果也是小于零，则相当于fromy与toy相等，
								//是在同一行添加数据；如果toy大于零，则toy是在group的行数基础上，在加toy行，
								//就是，后来添加的该数据,是在group下面，toy则制定了该数据占用多少行
								//如果开始y大于零，并且小于group的开始行行数,则相当于该数据是在group之上插入的，
								//此时，如果toy小于零，则toy=fromy，反之，则是在fromy基础上加上toy，相当于该数据占用了toy行
								//XcdArea.xml中有相关例子（<single id="bz">）
//								if (fromY<0) {
//									fromY=groupEndRow;
//									if (toY<0) {
//										toY=groupEndRow;
//									}else {
//										toY=toY+groupEndRow;
//									}
//								}else if (fromY<groupBeginRow) {
//									if (toY<0) {
//										toY=fromY;
//									}else {
//										toY=toY+fromY;
//									}
//								}
								
								if (fromY>0) {
									fromY=groupEndRow+fromY;
									toY=toY+groupEndRow;
//									if (toY<0) {
//										toY=groupEndRow;
//									}else {
//										toY=toY+fromY;
//									}
								}
								
//								if (toY < 0) { 
//									//获取第一个group的最后一行的行数，方便在group下面插入一些数据
//									for (int t = j - 1; t > 0; t--) {
//										String preGroupKey = (String) seqList.get(t);
//										if (elementMap.containsKey(preGroupKey)) {
//											if (elementMap.get(preGroupKey) instanceof Group) {
//												Group preGroup = (Group) elementMap.get(preGroupKey);
//												int endRow = preGroup.getEndRow(); // 锟斤拷锟斤拷锟斤拷
//												toY = Math.abs(toY) + endRow - 2;
//												break;
//											} else
//												continue;
//										}
//									}
//								}
//								if (fromY < 0) { // 锟斤拷锟斤拷锟斤拷前锟斤拷牡锟揭伙拷锟絞roup
//									for (int t = j - 1; t > 0; t--) {
//										String preGroupKey = (String) seqList.get(t);
//										if (elementMap.containsKey(preGroupKey)) {
//											if (elementMap.get(preGroupKey) instanceof Group) {
//												Group preGroup = (Group) elementMap.get(preGroupKey);
//												int beginRow = preGroup.getBeginRow(); // 锟斤拷始锟斤拷
//												fromY = beginRow - Math.abs(fromY);
//												break;
//											} else
//												continue;
//										}
//									}
//								}
								try { // 在该sheet中合并单元格
									writablesheet.mergeCells(Integer.parseInt(fromX), fromY, Integer.parseInt(toX), toY);
								} catch (RowsExceededException e) {
									e.printStackTrace();
								} catch (NumberFormatException e) {
									e.printStackTrace();
								} catch (WriteException e) {
									e.printStackTrace();
								}
							}

							Picture picture = cellStyle.getPicture();
							if (picture != null && valueType != null && valueType.equalsIgnoreCase("jpeg")) { // 写入的元素是图片

								log.info("开始写入签名图片...");
								// if(PrintPicture()){
								double imageHeight = picture.getHeight();
								double imageWidth = picture.getWidth();
								if (value instanceof Blob) {// 开始写入
									ByteArrayOutputStream image = getImage((Blob) value);
									writablesheet.addImage(new WritableImage(column, row, imageWidth, imageHeight, image.toByteArray()));

									log.info("成功写入签名图片！");
								}
								// else if(!value.equals("")&&!(value instanceof
								// Blob)){
								// log.info("写入条形码...");
								// ByteArrayOutputStream
								// image=getImage(value.toString());
								// writablesheet.addImage(new
								// WritableImage(column,
								// row,imageWidth,imageHeight,image.toByteArray()));
								// log.info("成功写入条形码！");
								// }
								else
									log.info("不存在签名图片，写入失败！");
								// }else{
								// log.info("配置了签名图片，但是不需要显示！");
								// }
							} else { // 开始写入其他元素
								Label label = new Label(column, row, value.toString(), cellFormat);
								try {
									writablesheet.addCell(label);
								} catch (RowsExceededException e) {
									e.printStackTrace();
								} catch (WriteException e) {
									e.printStackTrace();
								}
							}

						}
					} else if (elementObj instanceof Group) {
						// WriteGroup((Group) elementObj);
						Group group = (Group) elementObj;
						String groupId = group.getId();
						boolean insert = group.isInsert(); // 是否插入
						// 准备写入的list
						List pageList = (List) groupMap.get(groupId);
						// group的大小
						int groupSize = pageList.size();
						int beginRow = group.getBeginRow(); // 起始行
						if (beginRow < 0) { // 表示在它之前的一个group结束后的第|begionRow|行
							// 查找之前的第一个group
							for (int t = j - 1; t >= 0; t--) {
								String preGroupKey = (String) seqList.get(t);
								if (elementMap.containsKey(preGroupKey)) {
									if (elementMap.get(preGroupKey) instanceof Group) {
										Group preGroup = (Group) elementMap.get(preGroupKey);
										int endRow = preGroup.getEndRow(); // 结束行
										beginRow = Math.abs(beginRow) + endRow - 1;
										break;
									} else
										continue;
								}
							}

						}
						group.setGroupSize(groupSize);// 给group的大小赋值
						group.setEndRow(beginRow + groupSize);// 给group的结束行赋值
						group.setBeginRow(beginRow); // 给group的起始行赋值
						// 获取该group下的所有Item对象
						List itemList = group.getItemList();
						HashMap formatMap = new HashMap(); // 保存列和item格式
						HashMap itemMap = new HashMap(); // 保存下标和精确度
						HashMap mergedMap = new HashMap(); // 保存group中的单元格合并信息
						for (int k = 0; k < itemList.size(); k++) {
							Item item = (Item) itemList.get(k);
							int field = item.getField(); // 所在数组的下标
							CellStyle cellStyle = item.getCellStyle();
							// 获取cell的基本格式
							WritableCellFormat cellFormat = getCellFormat(cellStyle);

							MergedCell mergedCell = cellStyle.getMergedCell();
							if (mergedCell != null) {// 在group中合并单元格,暂时不支持两个group
								String fromX = mergedCell.getFromX();
								@SuppressWarnings("unused")
								short fromY = mergedCell.getFromY();
								String toX = mergedCell.getToX();
								@SuppressWarnings("unused")
								short toY = mergedCell.getToY();
								mergedMap.put(fromX, toX); // 从该group起始行起，合并列fromx到tox
							}
							// group中不存在图片信息
							formatMap.put(field + "", cellFormat);
							itemMap.put(field + "", item);
						}
						// 开始写入group
						for (int m = 0; m < pageList.size(); m++) {
							String[] arrs = (String[]) pageList.get(m);
							if (insert) { // 根据insert判断是追加数据，还是插入数据
								writablesheet.insertRow(beginRow + m);
							}
							for (int n = 0; n < arrs.length; n++) {
								if (formatMap.containsKey(n + "")) {
									String value = arrs[n]; // 写入的值

									Item tempItem = (Item) itemMap.get(n + "");
									String valueType = tempItem.getValueType(); // 数据类型

									if (valueType.equalsIgnoreCase("Double")) {
										int pricision = tempItem.getPrecision(); // 精确度
										if (arrs[n] == null || arrs[n].equals("null") || arrs[n].equals("")) {
											value = "";
										} else
											value = CommonUtil.DoubleToString(Double.parseDouble(arrs[n]), pricision);
									}
									if (valueType.equalsIgnoreCase("String")) { // 过滤null
										value = arrs[n]+"";
										value = value.replace("null", "").trim();
									}
									int beginColumn = tempItem.getBeginColumn(); // 起始列
									// 以下合并单元格
									if (mergedMap.containsKey(beginColumn + "")) {
										try {
											writablesheet.mergeCells(beginColumn, beginRow + m, Integer.parseInt(mergedMap.get(beginColumn + "").toString()), beginRow + m);
										} catch (RowsExceededException e) {
											e.printStackTrace();
										} catch (NumberFormatException e) {
											e.printStackTrace();
										} catch (WriteException e) {
											e.printStackTrace();
										}
									}// 合并单元格结束
									Label label = new Label(beginColumn, beginRow + m, value, (WritableCellFormat) formatMap.get(n + ""));
									try {
										writablesheet.addCell(label);
									} catch (RowsExceededException e) {
										e.printStackTrace();
									} catch (WriteException e) {
										e.printStackTrace();
									}
								}
							}
						}
						formatMap.clear(); // 释放内存
						itemMap.clear();
						mergedMap.clear();

					} else {
						log.error("该ElementObj目前尚未被支持=" + elementObj);
					}
				}
			}
		}
		// 正式写入
		try {
			writableworkbook.write();
			writableworkbook.close();
		
		} catch (Exception e) {
			e.printStackTrace();
		}
		rw.close();
		// 生成excel下载脚本
		// return JSforExcel("/docroot/" + (xslPath.replaceAll("\\\\", "/")) +
		// ""
		// + XlsName);
		// 生成excel下载路径
		return request.getContextPath()+"/" + (xslPath.replaceAll("\\\\", "/")) + "" + XlsName;
	}

	/**
	 * 是否需要打印图片，默认是打印图片的
	 * 
	 * @return
	 */
	// private boolean PrintPicture(){
	// String printPicture = "true";
	// try {
	// printPicture = StaticGetter.get("PrintExcelPicture");
	// } catch (Exception e) {
	// }
	// boolean NotPrint = (printPicture+"").equalsIgnoreCase("false");
	// return (!NotPrint);
	// }
	/**
	 * 生成js脚本，弹出下载提示
	 * 
	 * @param url
	 * @return
	 */
	@SuppressWarnings("unused")
	private String JSforExcel(String url) {
		StringBuffer sb = new StringBuffer("<script language=javascript>");
		sb.append("openExcelWindow('");
		sb.append(url);
		sb.append("','excel');");
		sb.append("</script>");
		return sb.toString();
	}

	/**
	 * 写入single
	 * 
	 * @param single
	 */
	@SuppressWarnings("unused")
	private void writeSingle(Single single) {

	}

	/**
	 * 写入group
	 * 
	 * @param group
	 */
	@SuppressWarnings("unused")
	private void WriteGroup(Group group) {
	}

	/**
	 * 获取单元格的基本格式
	 * 
	 * @param
	 * @return
	 */
	@SuppressWarnings("deprecation")
	private WritableCellFormat getCellFormat(CellStyle cellStyle) {
		short bottom = 0;
		short top = 0;
		short left = 0;
		short right = 0;
		Font font = cellStyle.getFont(); // 字体对象
		String fontName = font.getFontName();// 字体名称
		short fontHeight = font.getFontHeight();// 字体大小
		boolean isBold = font.isBold(); // 字体是否加粗
		Border border = cellStyle.getBorder();
		if (border != null) {
			bottom = border.getBorderBottom();
			top = border.getBorderTop();
			left = border.getBorderLeft();
			right = border.getBorderRight();
		}
		String pa = cellStyle.getParalletAlignment();// 水平对齐
		String va = cellStyle.getVerticalAlignment();// 垂直对齐
		boolean isAutoFill = cellStyle.isAutoFill(); // 自动填充
		boolean isWrapText = cellStyle.isWrapText(); // 自动换行
		// 设置单元格式,默认为黑色，并且无下画线
		WritableFont cellFont = isBold ? new WritableFont(WritableFont.createFont(fontName), fontHeight, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK) : new WritableFont(
				WritableFont.createFont(fontName), fontHeight, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
		WritableCellFormat cellFormat = new WritableCellFormat(cellFont);

		try {
			cellFormat.setWrap(isWrapText);
			cellFormat.setShrinkToFit(isAutoFill);
			if (left == 1) {
				cellFormat.setBorder(jxl.write.Border.LEFT, jxl.format.BorderLineStyle.THIN);
			} else
				cellFormat.setBorder(jxl.write.Border.LEFT, jxl.format.BorderLineStyle.NONE);
			if (right == 1) {
				cellFormat.setBorder(jxl.write.Border.RIGHT, jxl.format.BorderLineStyle.THIN);
			} else
				cellFormat.setBorder(jxl.write.Border.RIGHT, jxl.format.BorderLineStyle.NONE);
			if (bottom == 1) {
				cellFormat.setBorder(jxl.write.Border.BOTTOM, jxl.format.BorderLineStyle.THIN);
			} else
				cellFormat.setBorder(jxl.write.Border.BOTTOM, jxl.format.BorderLineStyle.NONE);
			if (top == 1) {
				cellFormat.setBorder(jxl.write.Border.TOP, jxl.format.BorderLineStyle.THIN);
			} else
				cellFormat.setBorder(jxl.write.Border.TOP, jxl.format.BorderLineStyle.NONE);

			if (pa != null) {
				if (pa.equalsIgnoreCase("left")) {
					cellFormat.setAlignment(Alignment.LEFT);
				}
				if (pa.equalsIgnoreCase("center")) {
					cellFormat.setAlignment(Alignment.CENTRE);
				}
				if (pa.equalsIgnoreCase("right")) {
					cellFormat.setAlignment(Alignment.RIGHT);
				}
			}
			if (va != null) {
				if (va.equalsIgnoreCase("top")) {
					cellFormat.setVerticalAlignment(VerticalAlignment.TOP);
				}
				if (va.equalsIgnoreCase("bottom")) {
					cellFormat.setVerticalAlignment(VerticalAlignment.BOTTOM);
				}
				if (va.equalsIgnoreCase("center")) {
					cellFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
				}
				if (va.equalsIgnoreCase("justify")) {
					cellFormat.setVerticalAlignment(VerticalAlignment.JUSTIFY);
				}
			}

		} catch (WriteException e) {
			e.printStackTrace();
		}
		return cellFormat;
	}

	/**
	 * 从签名表中获取数据,包括签名信息和签名图片
	 * 
	 */
	// private Tusersign getSingPo(String keyValue,HttpServletRequest request){
	// Tusersign t=null;
	// Session session=(Session)request.getAttribute("HibernateSession_BSA");
	// try{
	// t = (Tusersign) session.get(Tusersign.class, keyValue);
	// }catch(Exception ex){
	// ex.printStackTrace();
	// }finally{
	//
	// }
	// return t;
	// }
	/**
	 * 获取条形码图片流
	 */
	// private synchronized ByteArrayOutputStream getImage(String barKey){
	// ByteArrayOutputStream BOS=new ByteArrayOutputStream();
	// if(barKey==null||barKey.trim().equals(""))
	// return BOS;
	// try {
	// BufferedImage inputImg = CreateBarCodeServlet.getBufferedImage(barKey);
	// ImageIO.write(inputImg,"jpeg",BOS);
	// BOS.close();
	//			
	// }catch (Exception e) {
	// e.printStackTrace();
	// }
	// return BOS;
	// }
	/**
	 * 获取前面图片流
	 * 
	 * @param blob
	 * @return
	 */
	private synchronized ByteArrayOutputStream getImage(Blob blob) {
		ByteArrayOutputStream BOS = new ByteArrayOutputStream();
		if (blob == null) {
			return BOS;
		}
		InputStream is = null;
		try {
			is = blob.getBinaryStream();
			if (is == null || blob.length() == 0) {
				log.info("--不存在签名图片！");
			} else {
				byte[] buf = new byte[1024 * 8];
				int i = 0;
				while (is.read(buf) != -1) {
					i++;
					BOS.write(buf);
				}
				is.close();
				BOS.close();
				buf = null;
				System.gc();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return BOS;
	}
}
