package cn.gtmap.landtax.print;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@SuppressWarnings("serial")
public class PrintServlet extends HttpServlet {
	ApplicationContext ctx;

	/**
	 * Constructor of the object.
	 */
	public PrintServlet() {
		super();
	}

	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		Log log = LogFactory.getLog(this.getClass());
		log.info("---->>进入PrintServlet...");
		request.setCharacterEncoding("GBK");
		response.setContentType("text/xml; charset=GBK");
		PrintWriter out = response.getWriter();
		XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
		
		String params = request.getQueryString();
		Map paramsMap = new HashMap();
		if (null != params && !("").equals(params.trim())) {
			String[] paramsArr = params.split("&");
			String[] oneParam = null;
			for (int i = 0; i < paramsArr.length; i++) {
				if (!paramsArr[i].equals("")) {
					oneParam = paramsArr[i].split("=");
					if (oneParam != null && oneParam.length == 2) {
						paramsMap.put(oneParam[0], oneParam[1]);
					}
				}
			}
		}
		String dataXml = "";
		if (paramsMap.get("dataUrl") != null) {
			try {
				dataXml = getStringProxy(paramsMap);
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			if (paramsMap.get("beanName") != null) {
				dataXml = getStringSpring(paramsMap, request);
			}
		}
		String res=xmlBuildHelper.getPrintXml(dataXml);
		out.print(res);
		out.flush();
		out.close();
	}

	/**
	 * 代理方法获取
	 * 
	 * @param paramsMap
	 * @return
	 * @throws Exception
	 */
	private String getStringProxy(Map paramsMap) throws Exception {
		String returnXml = null;
		Object obj = Class.forName(paramsMap.get("dataUrl") + "").newInstance();
		IPrint targetObject = (IPrint) obj;
		IPrint print = null;
		Object proxy = MyProxyFactory.getProxy(targetObject);
		if (proxy instanceof IPrint) {
			print = (IPrint) proxy;
			returnXml = print.getPrintXml(paramsMap,null);
		}

		return returnXml;
	}

	/**
	 * spring管理
	 * 
	 * @param paramsMap
	 * @return
	 */
	private String getStringSpring(Map paramsMap, HttpServletRequest request){
		this.ctx = WebApplicationContextUtils.getWebApplicationContext(request.getSession().getServletContext());
		IPrint ip = (IPrint) ctx.getBean(paramsMap.get("beanName") + "");
		//return ip.getPrintXml(paramsMap);
		return ip.getPrintXml(paramsMap,request);
	}

	public void init() throws ServletException {
	}

}
