package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 数据操作类型
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
public enum Zdlx {
    ZSZD("1", "真实宗地"),
    XNZD("2", "虚拟宗地");
    private String dm;
    private String mc;

    private Zdlx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm) {
        if (StringUtils.isNotBlank(dm)) {
            Zdlx[] Czlxs = Zdlx.values();
            for (int i = 0; i < Czlxs.length; i++) {
                if (Czlxs[i].getDm().equals(StringUtils.trim(dm))) {
                    return Czlxs[i].getMc();
                }
            }
        }
        return null;
    }
}
