package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/7
 */
public enum Zclx {
    DM000("000","虚拟全部注册类型"),
    DM100("100","内资企业"),
    DM110("110","国有企业"),
    DM120("120","集体企业"),
    DM130("130","股份合作企业"),
    DM140("140","联营企业"),
    DM141("141","国有联营企业"),
    DM142("142","集体联营企业"),
    DM143("143","国有与集体联营企业"),
    DM149("149","其他联营企业"),
    DM150("150","有限责任公司"),
    DM151("151","国有独资公司"),
    DM159("159","其他有限责任公司"),
    DM160("160","股份有限公司"),
    DM170("170","私营企业"),
    DM171("171","私营独资企业"),
    DM172("172","私营合伙企业"),
    DM173("173","私营有限责任公司"),
    DM174("174","私营股份有限公司"),
    DM190("190","其他企业"),
    DM200("200","港、澳、台商投资企业"),
    DM210("210","合资经营企业（港、澳、台资）"),
    DM220("220","合作经营企业（港、澳、台资）"),
    DM230("230","港澳台商独资经营企业"),
    DM240("240","港澳台商投资股份有限责任公司"),
    DM300("300","外商投资企业"),
    DM310("310","中外合资经营企业"),
    DM320("320","中外合作经营企业"),
    DM330("330","外资企业"),
    DM340("340","外商投资股份有限公司"),
    DM400("400","港澳台商企业常驻代表机构及其他"),
    DM410("410","数据迁移产生"),
    DM500("500","外国企业"),
    DM610("610","社会团体"),
    DM611("611","其他"),
    DM620("620","民办非企业单位"),
    DM710("710","个体户"),
    DM720("720","个人合伙"),
    DM799("799","自然人"),
    DM900("900","其他"),
    DM910("910","行政机关"),
    DM920("920","事业单位");

    private String dm;
    private String mc;

    private Zclx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Zclx[] Zclxs = Zclx.values();
            for(int i=0;i<Zclxs.length;i++){
                if(Zclxs[i].getDm().equals(StringUtils.trim(dm))){
                    return Zclxs[i].getMc();
                }
            }
        }
        return null;
    }
}
