package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 土地使用权类型
 * Created by xuchao on 2014/8/25.
 */
public enum Tdsyqlx {
    HB("01", "划拨"),
    CR("02", "出让"),
    CB("03", "储备"),
    QT("04", "其他");
    private String dm;
    private String mc;

    private Tdsyqlx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Tdsyqlx[] Tdsyqlxs = Tdsyqlx.values();
            for(int i=0;i<Tdsyqlxs.length;i++){
                if(Tdsyqlxs[i].getDm().equals(StringUtils.trim(dm))){
                    return Tdsyqlxs[i].getMc();
                }
            }
        }
        return null;
    }
}
