package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 数据操作类型
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
public enum Gqszly {
    ZDLR("1", "国土部门未及时更新产权人"),
    XMLR("2", "原企业产权已分给职工");

    private String dm;
    private String mc;

    private Gqszly(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Gqszly[] Byzyys = Gqszly.values();
            for(int i=0;i<Byzyys.length;i++){
                if(Byzyys[i].getDm().equals(StringUtils.trim(dm))){
                    return Byzyys[i].getMc();
                }
            }
        }
        return null;
    }
}
