package cn.gtmap.landtax.entity;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 土地申报修改申请表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "td_sb_xgsqb")
public class TdSbXgsqb implements Serializable {
    @Id
    @Column
    private String proid;//主键
    @Column
    private Date xgrq;//修改日期
    @Column
    private String swjgdm;//税务机关代码
    @Column
    private String swjgmc;//税务机关名称
    @Column
    private String sgydm;//税管员代码
    @Column
    private String sgymc;//税管员名称
    @Column
    private String xgyy;//修改原因
    @Column
    private String glbm;//管理代码
    @Column
    private String nsrmc;//纳税人名称
    @Column
    private BigDecimal ynmj;//应纳总面积
    @Column
    private BigDecimal nynse;//应纳税额
    @Column
    private BigDecimal sbse;//申报税额
    @Column
    private BigDecimal cyje;//差异金额
    @Column
    private String Bz;//备注
    @Column
    private String hsqk;//核实情况，办结后将该字段填入疑点清册记录中
    @Column
    private BigDecimal rkse;

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Date getXgrq() {
        return xgrq;
    }

    public void setXgrq(Date xgrq) {
        this.xgrq = xgrq;
    }

    public String getSwjgdm() {
        return swjgdm;
    }

    public void setSwjgdm(String swjgdm) {
        this.swjgdm = swjgdm;
    }

    public String getSwjgmc() {
        return swjgmc;
    }

    public void setSwjgmc(String swjgmc) {
        this.swjgmc = swjgmc;
    }

    public String getSgydm() {
        return sgydm;
    }

    public void setSgydm(String sgydm) {
        this.sgydm = sgydm;
    }

    public String getSgymc() {
        return sgymc;
    }

    public void setSgymc(String sgymc) {
        this.sgymc = sgymc;
    }

    public String getXgyy() {
        return xgyy;
    }

    public void setXgyy(String xgyy) {
        this.xgyy = xgyy;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }

    public String getNsrmc() {
        return nsrmc;
    }

    public void setNsrmc(String nsrmc) {
        this.nsrmc = nsrmc;
    }

    public BigDecimal getYnmj() {
        return ynmj;
    }

    public void setYnmj(BigDecimal ynmj) {
        this.ynmj = ynmj;
    }

    public BigDecimal getNynse() {
        return nynse;
    }

    public void setNynse(BigDecimal nynse) {
        this.nynse = nynse;
    }

    public BigDecimal getSbse() {
        return sbse;
    }

    public void setSbse(BigDecimal sbse) {
        this.sbse = sbse;
    }

    public BigDecimal getCyje() {
        return cyje;
    }

    public void setCyje(BigDecimal cyje) {
        this.cyje = cyje;
    }

    public String getBz() {
        return Bz;
    }

    public void setBz(String bz) {
        Bz = bz;
    }


    public BigDecimal getRkse() {
        return rkse;
    }

    public void setRkse(BigDecimal rkse) {
        this.rkse = rkse;
    }

    public String getHsqk() {
        return hsqk;
    }

    public void setHsqk(String hsqk) {
        this.hsqk = hsqk;
    }
}
