package cn.gtmap.landtax.entity;

import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 税务登记房产未比对表
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/25
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_FC_WBD")
public class SwDjFcWbd extends SwDjFcBase implements Serializable {

    @Id
    @Column
    private String fcId;
    @Column
    private String djh;
    @Column
    private String dbh;
    @Column
    private String glbm;
    @Column
    private String nsrmc;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "JBB_ID")
    private SwDjJbbWbd swDjJbbWbd;

    public String getFcId() {
        return fcId;
    }

    public void setFcId(String fcId) {
        this.fcId = fcId;
    }

    public SwDjJbbWbd getSwDjJbbWbd() {
        return swDjJbbWbd;
    }

    public void setSwDjJbbWbd(SwDjJbbWbd swDjJbbWbd) {
        this.swDjJbbWbd = swDjJbbWbd;
    }


    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getDbh() {
        return dbh;
    }

    public void setDbh(String dbh) {
        this.dbh = dbh;
    }

    public String getNsrmc() {
        return nsrmc;
    }

    public void setNsrmc(String nsrmc) {
        this.nsrmc = nsrmc;
    }

    public String getGlbm() {
        return glbm;
    }

    public void setGlbm(String glbm) {
        this.glbm = glbm;
    }


}
