;
(function ($) {
    /**
     * jqGrid English Translation
     * Tony Tomov tony@trirand.com
     * http://trirand.com/blog/
     * Dual licensed under the MIT and GPL licenses:
     * http://www.opensource.org/licenses/mit-license.php
     * http://www.gnu.org/licenses/gpl.html
     **/
    $.jgrid = $.jgrid || {};
    $.extend($.jgrid, {
        defaults: {
            recordtext: "{0} - {1} 总共 {2}条",
            emptyrecords: "无记录",
            loadtext: "加载中...",
            pgtext: " {0} 共 {1}页"
        },
        search: {
            caption: "Search...",
            Find: "查找",
            Reset: "重置",
            odata: [
                { oper: 'eq', text: 'equal'},
                { oper: 'ne', text: 'not equal'},
                { oper: 'lt', text: 'less'},
                { oper: 'le', text: 'less or equal'},
                { oper: 'gt', text: 'greater'},
                { oper: 'ge', text: 'greater or equal'},
                { oper: 'bw', text: 'begins with'},
                { oper: 'bn', text: 'does not begin with'},
                { oper: 'in', text: 'is in'},
                { oper: 'ni', text: 'is not in'},
                { oper: 'ew', text: 'ends with'},
                { oper: 'en', text: 'does not end with'},
                { oper: 'cn', text: 'contains'},
                { oper: 'nc', text: 'does not contain'}
            ],
            groupOps: [
                { op: "AND", text: "all" },
                { op: "OR", text: "any" }
            ]
        },
        edit: {
            addCaption: "添加记录",
            editCaption: "编辑记录",
            bSubmit: "提交",
            bCancel: "取消",
            bClose: "关闭",
            saveData: "数据已经修改,要保存修改吗?",
            bYes: "是",
            bNo: "否",
            bExit: "取消",
            msg: {
                required: "必填项",
                number: "必须是数字",
                minValue: "请填大于或等于 ",
                maxValue: "请填小于或等于",
                email: "e-mail格式不正确",
                integer: "请输入整数",
                date: "日期格式错误",
                url: "URL 格式错误 ('http://' 或者 'https://' 开头)",
                nodefined: " is not defined!",
                novalue: " 必须要有返回值!",
                customarray: "返回值应该是数组!",
                customfcheck: "Custom function should be present in case of custom checking!"

            }
        },
        view: {
            caption: "显示",
            bClose: "关闭"
        },
        del: {
            caption: "删除",
            msg: "确定删除记录?",
            bSubmit: "删除",
            bCancel: "取消"
        },
        nav: {
            edittext: "",
            edittitle: "编辑选择的列",
            addtext: "",
            addtitle: "添加新的记录",
            deltext: "",
            deltitle: "删除选择记录",
            searchtext: "",
            searchtitle: "查找",
            refreshtext: "",
            refreshtitle: "重载",
            alertcap: "警告",
            alerttext: "请选择一条记录",
            viewtext: "",
            viewtitle: "View selected row"
        },
        col: {
            caption: "请选择记录",
            bSubmit: "确认",
            bCancel: "取消"
        },
        errors: {
            errcap: "错误",
            nourl: "No url is set",
            norecords: "No records to process",
            model: "Length of colNames <> colModel!"
        },
        formatter: {
            integer: {thousandsSeparator: ",", defaultValue: '0'},
            number: {decimalSeparator: ".", thousandsSeparator: ",", decimalPlaces: 2, defaultValue: '0.00'},
            currency: {decimalSeparator: ".", thousandsSeparator: ",", decimalPlaces: 2, prefix: "", suffix: "", defaultValue: '0.00'},
            date: {
                dayNames: [
                    "Sun", "Mon", "Tue", "Wed", "Thr", "Fri", "Sat",
                    "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
                ],
                monthNames: [
                    "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
                    "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
                ],
                AmPm: ["am", "pm", "AM", "PM"],
                S: function (j) {
                    return j < 11 || j > 13 ? ['st', 'nd', 'rd', 'th'][Math.min((j - 1) % 10, 3)] : 'th';
                },
                srcformat: 'Y-m-d',
                newformat: 'n/j/Y',
                parseRe: /[Tt\\\/:_;.,\t\s-]/,
                masks: {
                    // see http://php.net/manual/en/function.date.php for PHP format used in jqGrid
                    // and see http://docs.jquery.com/UI/Datepicker/formatDate
                    // and https://github.com/jquery/globalize#dates for alternative formats used frequently
                    // one can find on https://github.com/jquery/globalize/tree/master/lib/cultures many
                    // information about date, time, numbers and currency formats used in different countries
                    // one should just convert the information in PHP format
                    ISO8601Long: "Y-m-d H:i:s",
                    ISO8601Short: "Y-m-d",
                    // short date:
                    //    n - Numeric representation of a month, without leading zeros
                    //    j - Day of the month without leading zeros
                    //    Y - A full numeric representation of a year, 4 digits
                    // example: 3/1/2012 which means 1 March 2012
                    ShortDate: "n/j/Y", // in jQuery UI Datepicker: "M/d/yyyy"
                    // long date:
                    //    l - A full textual representation of the day of the week
                    //    F - A full textual representation of a month
                    //    d - Day of the month, 2 digits with leading zeros
                    //    Y - A full numeric representation of a year, 4 digits
                    LongDate: "l, F d, Y", // in jQuery UI Datepicker: "dddd, MMMM dd, yyyy"
                    // long date with long time:
                    //    l - A full textual representation of the day of the week
                    //    F - A full textual representation of a month
                    //    d - Day of the month, 2 digits with leading zeros
                    //    Y - A full numeric representation of a year, 4 digits
                    //    g - 12-hour format of an hour without leading zeros
                    //    i - Minutes with leading zeros
                    //    s - Seconds, with leading zeros
                    //    A - Uppercase Ante meridiem and Post meridiem (AM or PM)
                    FullDateTime: "l, F d, Y g:i:s A", // in jQuery UI Datepicker: "dddd, MMMM dd, yyyy h:mm:ss tt"
                    // month day:
                    //    F - A full textual representation of a month
                    //    d - Day of the month, 2 digits with leading zeros
                    MonthDay: "F d", // in jQuery UI Datepicker: "MMMM dd"
                    // short time (without seconds)
                    //    g - 12-hour format of an hour without leading zeros
                    //    i - Minutes with leading zeros
                    //    A - Uppercase Ante meridiem and Post meridiem (AM or PM)
                    ShortTime: "g:i A", // in jQuery UI Datepicker: "h:mm tt"
                    // long time (with seconds)
                    //    g - 12-hour format of an hour without leading zeros
                    //    i - Minutes with leading zeros
                    //    s - Seconds, with leading zeros
                    //    A - Uppercase Ante meridiem and Post meridiem (AM or PM)
                    LongTime: "g:i:s A", // in jQuery UI Datepicker: "h:mm:ss tt"
                    SortableDateTime: "Y-m-d\\TH:i:s",
                    UniversalSortableDateTime: "Y-m-d H:i:sO",
                    // month with year
                    //    Y - A full numeric representation of a year, 4 digits
                    //    F - A full textual representation of a month
                    YearMonth: "F, Y" // in jQuery UI Datepicker: "MMMM, yyyy"
                },
                reformatAfterEdit: false
            },
            baseLinkUrl: '',
            showAction: '',
            target: '',
            checkbox: {disabled: true},
            idName: 'id'
        }
    });
})(jQuery);