$(document).ready(function(){
    // Set up the chart
    var options = {
        chart: {
            renderTo: 'container',
            type: 'column',
            margin: 75,
            options3d: {
                enabled: true,
                alpha: 10,
                beta: 0,
                depth: 50,
                viewDistance: 25
            }
        },
        title: {
            text: '计划完成情况',
            x: 0 //center
        },
        xAxis: {
            //categories: ['1','2','3','4','5','6','7']
        },
        yAxis:[{
            tickPixelInterval:50,
            lineWidth: 1,
            labels: {
                style: {
                    color: '#89A54E'
                }
            },
            title: {
                text: '万元',
                style: {
                    color: '#89A54E'
                }
            }
        }],
        plotOptions: {
            column: {
                depth: 25
            }
        },
        series: [{}]
    };
    $("#hyjhwc").click(function(){
        $.ajax({
            url:"/landtax/aiddecision/getHyjhwc",
            async:false,
            dataType: "json",
            type:"post",
            success:function(value){
                options.series[0] = value.data[0];
                options.series[1] = value.data[2];
                options.xAxis.categories = value.data[1].data;

                var chart = new Highcharts.Chart(options);

            },
            error:function(){
                alert("加载错误！");
            }
        });
        $("#tittle").html("");

    });


});