﻿define(["jquery","dojo/_base/declare",
    "dojo/_base/lang","dojo/on","mapUtils","mustache","mapThematic","dojo/domReady!"
], function($,declare,lang,on,mapUtils,Mustache,mapThematic) {
   return declare([],{
       map:null,
       moduleConfig:null,
       templateId:'serviceTpl',
       template:null,
       title:'图层',
       contentId:'serviceList',
       constructor:function(options){
           declare.safeMixin(this,options);
           this.template = $('#'+this.templateId).html();
           Mustache.parse(this.template);
       },
       refreshLOC:function(){
           $('#'+this.contentId).empty();
           for(var i=this.map.layerIds.length-1;i>=0;i--){
               var layerId = this.map.layerIds[i];
               var tmpLayer = this.map.getLayer(layerId);
               var tempItem = Mustache.render(this.template, {serviceId:tmpLayer.id,serviceName:tmpLayer.alias,serviceVisible:tmpLayer.visible});
               $('#'+this.contentId).append(tempItem);
               on($('#service'+tmpLayer.id),'change',lang.hitch(this,function(layerId,event){
                   var tmpVisible = $(event.target).is(':checked');
                   mapUtils.setMapSerivceVisible(layerId,tmpVisible);
                   mapUtils.setMapThematicChecked(layerId,tmpVisible);
               },layerId));


           }
           $('#'+this.contentId).sortable({
               'stop':lang.hitch(this,function(event,ui){
                   var newIndex = $(ui.item[0]).nextAll().length;
                   var serviceId = $(ui.item[0]).attr('data-id');
                   this.map.reorderLayer(this.map.getLayer(serviceId),newIndex);
               })
           });
       }
   });
});