define(["dojo/_base/declare","dojo/_base/lang",'esri/graphic', 'esri/tasks/IdentifyTask', 'esri/tasks/IdentifyParameters',
	"dojo/on","mapUtils"], function(declare,lang,Graphic, IdentifyTask,
	IdentifyParameters,on,mapUtils) {
    return declare([],{
        map:null,
        moduleConfig:null,
        _identifyHandle:null,
        _identifyResults:null,
        _identifyFeatures:null,
        _identifiedMapServiceCount:0,
        _callback:null,
        constructor:function(args){
            declare.safeMixin(this,args);
        },
        identifyTool:function(){
            this._identifyHandle = on(this.map, "click", lang.hitch(this,this._doIdentify));
            this.map.infoWindow.resize(420, 250);
            this.map.infoWindow.setTitle("属性查看");
            this.map.setMapCursor('crosshair');
        },
        destroyIdentifyTool:function(){
            if(this._identifyHandle!=null)
               this._identifyHandle.remove();
            this._callback=null;
        },
        _doIdentify:function(event) {
            this._identifiedMapServiceCount = this.map.layerIds.length;
            this.map.setMapCursor('wait');
            this._identifyResults = [];
            this.map.graphics.clear();
            var identifyParams = new IdentifyParameters();
            identifyParams.tolerance = 3;
            identifyParams.returnGeometry = true;
            identifyParams.layerOption = IdentifyParameters.LAYER_OPTION_VISIBLE;
            identifyParams.width = this.map.width;
            identifyParams.height = this.map.height;
            identifyParams.geometry = event.mapPoint;
            identifyParams.mapExtent = this.map.extent;

            for(var i=0;i<this._identifiedMapServiceCount;i++){
                var identifyTask = new IdentifyTask(this.map.getLayer(this.map.layerIds[i]).url);
                on(identifyTask, 'error', this._identifyResultError);
                identifyTask.execute(identifyParams, lang.hitch(this,this._handleIdentifyResult,event));
            }


        },
        _identifyResultError:function(event) {
            alert(event.error);
        },
        _handleIdentifyResult:function(event,result) {
            if ((result != null && result.length > 0)&&this._identifiedMapServiceCount>0) {
                this._identifyResults = this._identifyResults.concat(result);
            }
            this._identifiedMapServiceCount -=1;
            if(this._identifiedMapServiceCount==0){
                if (this._callback&&typeof this._callback === "function")
                {
                    this.map.setMapCursor('default');
                    this._callback(this._identifyResults,this);
                }
                else
                    this._showIdentifyInfo(event.screenPoint);
            }
        },
        _showIdentifyInfo:function(pos){
            this.map.setMapCursor('default');
            var content = this._highIdentifyFeature(this._identifyResults);
            this.map.infoWindow.setContent(content);
            this.map.infoWindow.show(pos, this.map.getInfoWindowAnchor(pos));
            if(this._identifyResults.length>0){
                var features = [];
                features.push(this._identifyResults[0].feature);
                mapUtils.highlightFeatures(features);
            }
            on($('#infoDiv ul a[data-toggle="tab"]'),'click',lang.hitch(this,this._handleLayerClick));
            this.destroyIdentifyTool();
        },
        _highIdentifyFeature:function(identifyResults){
            var symbol = new esri.symbol.SimpleFillSymbol(esri.symbol.SimpleFillSymbol.STYLE_SOLID, new esri.symbol.SimpleLineSymbol(esri.symbol.SimpleLineSymbol.STYLE_SOLID, new dojo.Color([255, 0, 0]), 2), new dojo.Color([255, 0, 0, 0.8]));
            var content = $('<div></div>');
            var tabContent = $('<div class="tab-content"></div>');

            var listTabs = $('<ul class="nav nav-tabs"></ul>');
            this._identifyFeatures = [];
            for (var i = 0; i < this._identifyResults.length; i++) {
                var result = this._identifyResults[i];
                var feature = result.feature;
                this._identifyFeatures.push(feature);
                var table = $('<table></table>');
                table.attr('border', '1');
                table.css('text-align', 'center');
                table.append($('<thead><tr><th width="30%">属性名称</th><th width="70%">属性值</th></tr></thead>'));
                var tableBody = $('<tbody></tbody>');

                var layerName = result.layerName;
                if (layerName === null || layerName === '')
                    continue;
                if (i === 0) {
                    listTabs.append($('<li class="active"><a data-toggle="tab" href="#' + i + '">' + layerName + '</a></li>'));
                    //mapUtils.highlightFeature(feature);
                } else
                    listTabs.append($('<li><a data-toggle="tab" href="#' + i + '">' + layerName + '</a></li>'));
                var attributes = result.feature.attributes;
                for (var key in attributes) {
                    if (key.indexOf('OBJECTID') > -1 || key.indexOf('SHAPE') > -1)
                        continue;
                    if (attributes[key] === 'Null' || attributes[key] === '')
                        continue;
                    var tmpRow = $('<tr></tr>');
                    tmpRow.append($('<td></td>').text(key));
                    tmpRow.append($('<td></td>').text(attributes[key]))
                    tableBody.append(tmpRow);
                }
                table.append(tableBody);
                if (i === 0)
                    tabContent.append($('<div class="tab-pane active" id="' + i + '"></div>').append(table));
                else
                    tabContent.append($('<div class="tab-pane" id="' + i + '"></div>').append(table));

            }
            content.append(listTabs);
            content.append(tabContent);
            return '<div id="infoDiv" class="tabbable tabs-left">' + content.html() + '</div>';
        },
        _handleLayerClick:function(event){
            var index = event.currentTarget.attributes['href'].value.substr(1);
            var features = [];
            features.push(this._identifyResults[index].feature);
            mapUtils.highlightFeatures(features);
        }
    });
});