/**
 * Author:  yingxiufeng
 * Project: landtax
 * Date:    2015/4/24 11:25
 * File:    geometryUtils
 * (c) Copyright gtmap Corp.2015
 */
define(["jquery",
    "dojo/_base/lang",
    "dojo/topic",
    'esri/graphic',
    'esri/toolbars/draw',
    "esri/geometry/Geometry",
    "mapUtils",
    "dojo/domReady!"
],function ($,lang,topic,Graphic,Geometry,MapUtils) {



    const GEOMETRY_TYPE_POINT = "Point";
    const GEOMETRY_TYPE_LINE = "LineString";
    const GEOMETRY_TYPE_MUlTILINE="MultiLineString";
    const GEOMETRY_TYPE_POLYGON = "Polygon";

    const FEATURE_TYPE_FEATURE="Feature";
    const FEATURE_TYPE_FEATURECOLLECTION="FeatureCollection";

    const EPSG="EPSG:";
    const CRS="crs";
    const COORDINATES="coordinates";
    const PROPERTIES="properties";

    const SR="spatialReference";
    const WKID="wkid";
    const WKT="wkt";

    var _map;


    /***
     *
     * @param geo
     * @param prop
     * @returns {null}
     * @private
     */
    function _toGeoJSON(geo,prop){

        if(!geo)return null;
        var feature={};
        feature.type=FEATURE_TYPE_FEATURE;
        feature.id=Math.random();

        /** 简单判断是graphic还是geometry **/
        if (geo.hasOwnProperty("geometry")) {
            if (geo.geometry!=undefined)
                return prop!=undefined?_toGeoJSON(geo.geometry,lang.mixin(geo.attributes,prop)):_toGeoJSON(geo.geometry,geo.attributes);
        } else if (geo.hasOwnProperty("type")) {
            if (geo.hasOwnProperty(SR)) {
                var sr = geo[SR];
                var crs = {};
                if (sr && sr != undefined) {
                    if (sr.hasOwnProperty(WKID)) {
                        crs.type = "name";
                        crs[PROPERTIES] = {"name": EPSG + sr[WKID].toString()};

                    } else if (sr.hasOwnProperty(WKT)) {
                        crs.type = "value";
                        crs[PROPERTIES] = {"value": sr[WKT]};
                    }
                }
                feature[CRS] = crs;
            }
            //geojson中的geometry对象
            var geoObj = {};
            switch (geo.type) {
                case "polygon":
                    geoObj.type = GEOMETRY_TYPE_POLYGON;
                    geoObj[COORDINATES] = geo.toJson().rings;
                    break;
                case "polyline":
                    geoObj.type = GEOMETRY_TYPE_MUlTILINE;
                    geoObj[COORDINATES] = geo.toJson().paths;
                    break;
                case "point":
                    geoObj.type = GEOMETRY_TYPE_POINT;
                    geoObj[COORDINATES] = geo.toJson();
                    break;
            }
            feature.geometry=geoObj;
        }
        if(prop&&prop!=undefined)feature[PROPERTIES]=prop;
        return JSON.stringify(feature);
    }

    /***
     * 解析geojson
     * @param geojson
     * @returns graphic
     * @private
     */
    function _readUnTypeGeoJSON(geojson){

        if(!geojson||geojson===undefined)return null;
        var obj=JSON.parse(geojson);

        switch (obj.type)
        {
            case FEATURE_TYPE_FEATURE: //生成graphic
                var _geo={};
                if(obj.geometry&&obj.geometry.type===GEOMETRY_TYPE_POLYGON)
                {
                    _geo={rings:obj.geometry[COORDINATES]};
                }
                if(!obj.crs||obj.crs===undefined) //如果geojson自身不带有crs 则采用map的默认sr
                {
                    var sr = _map.spatialReference;
                    if (sr.hasOwnProperty(WKT)) {
                        _geo.spatialReference = {wkt: sr.wkt};
                    } else if (sr.hasOwnProperty(WKID))
                        _geo.spatialReference = {wkid: sr.wkid};
                    else
                        console.error("--map sr error--");
                }else{

                    var crs=obj.crs;
                    if(crs.type==="name"){
                        _geo.spatialReference = {wkid: crs.properties.name};
                    }else if(crs.type=="value"){
                        _geo.spatialReference = {wkt: crs.properties.value};
                    }
                }
                var gra=new Graphic({geometry:_geo});
                if(obj.properties!=undefined)
                gra.attributes=obj.properties;
                return gra;
                break;
            case FEATURE_TYPE_FEATURECOLLECTION:
                if(obj.hasOwnProperty("features")){
                    var _arr=[];
                    for(var i=0;i<obj.features.length;i++){
                        _arr.push(_readUnTypeGeoJSON(JSON.stringify(obj.features[i])));
                    }
                }
                return _arr;
                break;
        }
        return null;
    }


    return {
        /***
         *
         * @param value
         */
        setMap:function(value){
            _map=value;
        },

        /**
         * 把graphic或geometry转换为geojson格式字符串
         * @param geo
         */
        toGeoJSON: function (geo) {
            return _toGeoJSON(geo, null);
        },
        /***
         * 解析geojson成graphic或geometry
         * @param geojson
         */
        readUnTypeGeoJSON: function (geojson) {
            return _readUnTypeGeoJSON(geojson);
        }
    };
});