<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>“以地”控税管理信息系统</title>
    <link rel="stylesheet" href="${base}/static/css/index.css" >
    <link rel="stylesheet" href="${base}/static/css/other.css" >
    <script src="${base}/static/thirdparty/jquery/jquery-1.11.0.min.js"></script>
    <link href="${base}/static/thirdparty/bootstrap/css/bootstrap.css" rel="stylesheet" />
    <script src="${base}/static/thirdparty/bootstrap/js/bootstrap.js"></script>
    <script src="${base}/static/js/public.js"></script>
    <script type="text/javascript" src="${base}/static/thirdparty/highcharts/highcharts.js"></script>
    <script type="text/javascript" src="${base}/static/thirdparty/highcharts/highcharts-3d.js"></script>
    <script>
        $(function () {
            $('#container1').highcharts({
                chart: {
                    type: 'pie',
                    options3d: {
                        enabled: true,
                        alpha: 45,
                        beta: 0
                    }
                },
                title: {
                    text: '纳税面积'
                },
                subtitle: {
                    text: '(单位：平方米)'
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        depth: 35,
                        dataLabels: {
                            enabled: true,
                            format: '{point.name}'
                        }
                    }
                },
                series: [{
                    type: 'pie',
                    name: '面积',
                    data: [
                        ['已纳税',   ${tdgkYnmj!}],
                        ['免税',   ${tdgkMsmj!}],
                        {
                            name: '差异',
                            y: 10333098.67,
                            sliced: true,
                            selected: true
                        }
                    ]
                }]
            });
        });
        /*申报*/
        ﻿$(function () {
            $('#container2').highcharts({
                chart: {
                    type: 'pie',
                    options3d: {
                        enabled: true,
                        alpha: 45
                    }
                },
                title: {
                    text: '申报纳税'
                },
                subtitle: {
                    text: '(单位：万元)'
                },
                plotOptions: {
                    pie: {
                        innerSize: 100,
                        depth: 45
                    }
                },
                series: [{
                    name: '税额',
                    data: [
                        ['申报税额', ${tdgkSbnse!}],
                        ['差异', 0]

                    ]
                }]
            });
        });
        /*智能比对*/
        $(function () {
            var chart = new Highcharts.Chart({
                chart: {
                    renderTo: 'container3',
                    type: 'pie'
                },
                title :{
                    text:'智能比对结果'
                },
                plotOptions: {
                    pie: {
                        startAngle:-180,
                        endAngle:180,
                        center: ['50%', '70%']
                    }
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
                },
                series: [{
                    name: '个数',
                    data: [
                        ['已匹配',   ${znbdTdsys!}],
                        ['未匹配',      ${znbdWppsys!}]
                    ]
                }]
            });
        });

        /*格式化数字*/
        $(function () {
            var tdgkScmj = $("#tdgkScmj").text();
            tdgkScmj = numFormat(tdgkScmj,2);
            $("#tdgkScmj").text(tdgkScmj);

            var tdgkYnmj = $("#tdgkYnmj").text();
            tdgkYnmj = numFormat(tdgkYnmj,2);
            $("#tdgkYnmj").text(tdgkYnmj);

            var tdgkMsmj = $("#tdgkMsmj").text();
            tdgkMsmj = numFormat(tdgkMsmj,2);
            $("#tdgkMsmj").text(tdgkMsmj);

            var tdgkCymj = $("#tdgkCymj").text();
            tdgkCymj = numFormat(tdgkCymj,2);
            $("#tdgkCymj").text(tdgkCymj);

            var tdgkKzse = $("#tdgkKzse").text();
            tdgkKzse = numFormat(tdgkKzse,2);
            $("#tdgkKzse").text(tdgkKzse);

            var tdgkYnse = $("#tdgkYnse").text();
            tdgkYnse = numFormat(tdgkYnse,2);
            $("#tdgkYnse").text(tdgkYnse);

            var tdgkSbnse = $("#tdgkSbnse").text();
            tdgkSbnse = numFormat(tdgkSbnse,2);
            $("#tdgkSbnse").text(tdgkSbnse);

            var tdgkYnmjse = $("#tdgkYnmjse").text();
            tdgkYnmjse = numFormat(tdgkYnmjse,2);
            $("#tdgkYnmjse").text(tdgkYnmjse);

            var tdgkMsmjse = $("#tdgkMsmjse").text();
            tdgkMsmjse = numFormat(tdgkMsmjse,2);
            $("#tdgkMsmjse").text(tdgkMsmjse);

            var tdgkKzseSb = $("#tdgkKzseSb").text();
            tdgkKzseSb = numFormat(tdgkKzseSb,2);
            $("#tdgkKzseSb").text(tdgkKzseSb);

        });
    </script>
</head>

<body >
<!-- 首页内容 -->
<div class="middles" style="width:1280px;">
    <div class="row">
        <div class="col-md-8">
            <div class="panel-group" id="accordion2">
                <div class="panel panel-default ">
                    <div class="panel-heading"> <a class="accordion-toggle Lab1" data-toggle="collapse" data-parent="#accordion2" href="#collapseOne">
                        <h2>土地税概况</h2>
                    </a> </div>
                    <div id="collapseOne" class="panel-collapse in collapse" style="height: auto;">
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div id="container1"  style="min-width:400px;min-height:260px;float:left"></div>
                                </div>
                                <div class="col-md-6">
                                    <p class="Highlights">第三方提供总面积 <font id="tdgkScmj">${tdgkScmj!}</font> 平方米<br/>
                                        地税数据提供面积应纳面积<font id="tdgkYnmj">${tdgkYnmj!}</font>平方米<br/>
					地税数据库免税面积：<font id="tdgkMsmj">${tdgkMsmj!}</font>平方米<br/>
                                        差异<font id="tdgkCymj">${tdgkCymj!}</font>平方米<br/>
                                        理论可新增税额<font id="tdgkKzse"> ${tdgkKzse!}</font> 万元<br/>
                                        <a href="${base}/ts">详细>></a> </p>
                                </div>
                            </div>
                            <hr/>
                            <div class="row">
                                <div class="col-md-6">
                                    <div id="container2"  style="min-width:400px;min-height:260px;float:left"></div>
                                </div>
                                <div class="col-md-6">
                                    <p class="Highlights">第三方提供理论应纳税额<font id="tdgkYnse">${tdgkYnse!}</font>万元<br/>
				        地税数据库提供申报纳税额<font id="tdgkSbnse">${tdgkSbnse!}</font>万元<br/>
                                        根据地税数据库应纳税面积计算应纳税额<font id="tdgkYnmjse">${tdgkYnmjse!}</font>万元<br/>
					地税数据库提供理论免税税额<font id="tdgkMsmjse">${tdgkMsmjse!}</font>万元<br/>
					理论可新增税额<font id="tdgkKzseSb">${tdgkKzse!}</font>万元<br/>
                                        <a href="${base}/ydqc/sy">详细>></a></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading"> <a class="accordion-toggle Lab1" data-toggle="collapse" data-parent="#accordion2" href="#collapseTwo">
                        <h2>重点税源
                            <p class="Highlights1">总数<font> ${zdsyCounts!}</font>个，应税面积 <font id="zdsyYsmj">${zdsyYsmj!}</font>平方米，年应纳税额<font id="zdsyYnse">${zdsyYnse!}</font>万元</p>
                        </h2>
                    </a> </div>
                    <div id="collapseTwo" class="panel-collapse collapse" style="height: 0px;">
                        <div class="panel-body">

                            <h4 class="Highlights1 Lab3"><i class="icon-th-list"></i> 排名前五重点税源 <a href="${base}/zdsy/td">详细>></a></h4>
                            <div class="baseTable">
                                <table cellspacing="0" class="table table-bordered" id="zdsyTable">
                                    <thead>
                                    <tr>
                                        <th></th>
                                        <th width="20%">管理编码</th>
                                        <th width="20%">纳税人名称</th>
                                        <th width="30%" class="right">应税面积（单位：平方米）</th>
                                        <th width="30%" class="right">年应纳税额（单位：元）</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>

                            </div>


                        </div>
                    </div>
                </div>
                <div class="panel panel-default">
                    <div class="panel-heading"> <a class="accordion-toggle Lab1" data-toggle="collapse" data-parent="#accordion2" href="#collapseThree">
                        <h2>漏征漏管户<p class="Highlights1">总数<font>${lzlgCounts!}</font>个，应税面积 <font id="lzlgYsmj">${lzlgYsmj!}</font>平方米，年应纳税额<font id="lzlgYnse">${lzlgYnse!}</font>万元</p></h2>
                    </a> </div>
                    <div id="collapseThree" class="panel-body collapse" style="height: 0px;">
                        <div class="panel-body">
                            <h4 class="Highlights1 Lab3"><i class="icon-th-list"></i> 排名前漏征漏管户 <a href="${base}/tj/lzlgh/td">详细>></a></h4>
                            <div class="baseTable">
                                <table cellspacing="0" class="table table-bordered" id="lzlghTable">
                                    <thead>
                                    <tr>
                                        <th></th>
                                        <th width="20%">管理编码</th>
                                        <th width="20%">纳税人名称</th>
                                        <th width="30%" class="right">应税面积（单位：平方米）</th>
                                        <th width="30%" class="right">年应纳税额（单位：元）</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>

                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="Lab1"><h2>智能比对</h2></div>
                </div>
                <div class="panel-body">
                    <div id="container3" style="min-width:200px;height:400px"></div>
                    <p class="Highlights1">已匹配土地税源<font> ${znbdTdsys!}</font>个<br/>未匹配税源 <font>${znbdWppsys!}</font>个<br/>未匹配第三方数据<font>${znbdWppzds!}</font>个<br/> <a href="${base}/syhc/zdhc/whclb">详细>></a></p>
                </div>
            </div>


        </div>
    </div>
</div>
</body>
<script>
    $(function(){
        var zdsyUrl="${base}/ts/syJson?zdsybz=1&page=1&rows=5";
        $.get(zdsyUrl,function(data){
            var zdsyContent = data.content;
            $('#zdsyTable>tbody').empty();
            for(var i=0;i<zdsyContent.length;i++){

                var trData = "<tr><td>"+(i+1)+".</td><td>"+zdsyContent[i].glbm+"</td><td>"+
                        zdsyContent[i].nsrmc+"</td><td class='right'>"+zdsyContent[i].ynmj
                        +"</td><td class='right'>"+(zdsyContent[i].ynmj*5).toFixed(1)+"</td></tr>"
                $('#zdsyTable>tbody').append(trData);
            }

        });
        var lzlghUrl = "${base}/tj/lzlgh/tdListJson?page=1&rows=5";
        $.get(lzlghUrl,function(data){
            var lzlghContent = data.content;
            $('#lzlghTable>tbody').empty();
            for(var i=0;i<lzlghContent.length;i++){
                var trData = "<tr><td>"+(i+1)+".</td><td>"+lzlghContent[i].glbm+"</td><td>"+
                        lzlghContent[i].nsrmc+"</td><td class='right'>"+(lzlghContent[i].ynmj!=null?lzlghContent[i].ynmj:'')+"</td><td class='right'>"+(lzlghContent[i].ynmj!=null?(lzlghContent[i].ynmj*5).toFixed(1):'')+"</td></tr>"
                $('#lzlghTable>tbody').append(trData);
            }
        });

    });
</script>
</html>