<#assign jsContent>
    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
</#assign>

<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>

<@com.html title="${reportName!}" import="jquery,jqueryEasyUI,multiselect,jqgrid,bootstrap,bootbox,datetimepicker,highcharts" js=jsContent css=cssContent >
    <#if hcxmlx == "1">
        <#assign colJson = 'hcjd/zdhcJson'>;
        <#assign headPageFile = ''>;
    <#elseif hcxmlx == '2'>
        <#assign colJson = 'hcjd/syhcJson'>;
        <#assign headPageFile = ''>;
    <#elseif hcxmlx?string = '4'>
        <#assign colJson = 'hcjd/zdsymjdfTjJson'>;
        <#assign headPageFile = ''>;
    </#if>

    <div class="main-container" id="main-container">
        <script type="text/javascript">
            try {
                ace.settings.check('main-container', 'fixed')
            } catch (e) {
            }
        </script>

        <div class="main-container-inner" id="basetj">
            <div class="page-content">
                <div class="row">
                    <div class="widget-box transparent">
                        <div class="widget-body">
                            <div class="widget-main">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="col-xs-12">
                                            <div>
                                                <form id="queryForm">
                                                    <#if headPageFile?? && headPageFile != "">
                                                        <#include "../${headPageFile!}" />
                                                    </#if>
                                                    <div class="no-padding-left col-sm-12" style="margin-top: 5px">
                                                        <fieldset class="searchInput form-inline">
                                                            <#if headPageFile?? && headPageFile != "">
                                                            <button type="button" class="btn btn-info btn-sm" id="btnQuery" >
                                                                <i class="ace-icon fa fa-search bigger-110"></i>
                                                                查询
                                                            </button>
                                                            </#if>
                                                            <button type="button" class="btn btn-success btn-sm" id="btnExportExcel">
                                                                <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                导出
                                                            </button>
                                                        </fieldset>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <p></p>
                                <row>
                                    <div class="col-xs-12" >
                                        <div id="gGrid" data-definition="${base}/static/json/${colJson}.json">
                                            <table id="grid-table"></table>
                                            <div id="grid-pager"></div>
                                        </div>
                                    </div>
                                </row>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.main-container-inner -->
    </div>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>
    </#assign>
</@com.html>

<script type="text/javascript">
    var grid;

    $(function () {
        bootbox.setDefaults({
            locale: "zh_CN"
        });

        var scrollHeight = 15;
        var minRows = 3;
        var rowHeigth = 33;

        var drawHeight = jQuery(window).height() - 140 - $('#basetj')[0].clientHeight;
        var drawRowNum = Math.floor(drawHeight / rowHeigth);
        drawHeight = drawRowNum * rowHeigth + scrollHeight;

        if (drawHeight < minRows * rowHeigth) {
            drawHeight = minRows * rowHeigth + scrollHeight;
            drawRowNum = minRows;
        }
        var showRowNum = drawRowNum;

        grid = $('#gGrid').gGrid({
            rownumbers: true,
            rownumWidth: 40,
            footerrow: false,
            autoHeight: false,
            height: drawHeight,
            rowNum: showRowNum,
            caption: "${reportName!}",
            url:'/landtax/hcxm/wclYclTzJson?hcxmlx=${hcxmlx}&xzqdm=${xzqdm!}&xflx=${xflx!}&cllx=${cllx!}',
            gridComplete: function() {
                //在gridComplete调用行合并方法
                $('#gGrid').mergeRowCell();
            }
        });

        $('#btnExportExcel').click(function () {
            exportExcel(2);
        });

        $(":input").focus(
                function(){
                    if(this.value=="" ||this.value==null){this.placeholder=""};
                }
        ) ;

        $(":input").blur(
                function(){
                    if(this.value==""||this.value==null){this.placeholder=(this.getAttribute("aliasName") == null) ? "" : this.getAttribute("aliasName");};
                }
        ) ;
        initializeSelect($);
    });

    $('#btnQuery').click(function () {
        var params = $('#queryForm').serializeJson();
        queryCommand(params);
    });

    function queryCommand (params) {
        $('#gGrid').refreshGrid(params);
    }

    function exportExcel(param){
        var queryParam = $('#queryForm').serializeJson();
        var gridOptions = $('#gGrid').getOptions();
        var actionURL;
        actionURL = '${base}/hcxm/exportExcelTjEx?hcxmlx=${hcxmlx}&xzqdm=${xzqdm!}&xflx=${xflx!}&cllx=${cllx!}&query=' + queryParam["query"] + '&gridOptions=' + JSON.stringify(gridOptions);
        window.open(actionURL,"exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no");
    }

    function turnToUrl(id, baseUrl, paramNames, paramValues, paramOperators) {
        paramNames = paramNames.split(",");
        paramValues = paramValues.split(",");

        if (paramOperators == null)
            paramOperators = '';
        paramOperators = paramOperators.split(",");

        var paramCnt = paramNames.length;
        var paramName, paramValue, paramOperator, paramStr, i;
        var valueJson = {};
        var operatorJson = {};
        var hasCustomParams = false;
        id = (id.split("="))[1];
        for (i = 0; i < paramCnt; i++) {
            paramName = paramNames[i].trim();
            paramValue = grid.jqGrid('getRowData', id)[paramValues[i].trim()];
            if (paramValue == null)
                paramValue = paramValues[i].trim();

            if (i < paramOperators.length) {
                paramOperator = paramOperators[i].trim();
            } else {
                paramOperator = '';
            }
            if (paramOperator == '') {
                if (paramStr != '')
                    paramStr += '&';
                paramStr += paramName + '=' + paramValue;
            } else {
                hasCustomParams = true;
                valueJson[paramName] = paramValue;
                operatorJson[paramName] = paramOperators[i];
            }
        }

        if (hasCustomParams) {
            if (paramStr != '')
                paramStr += '&';
            paramStr += 'customParams=' + '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';
        }
        window.open("${base!}/" + baseUrl + "?" + paramStr, "")
    }

    function gotoTask(id, proidField) {
        id = (id.split("="))[1];
        var proid = grid.jqGrid('getRowData', id)[proidField];
        $.ajax({
            type: 'post',
            url: "${base}/hcxm/getTaskUrl",
            data:{proid: proid},
            dataType: 'json',
            success: function (data) {
                if (data.msg == '') {
                    bootbox.alert("当前用户没有参与该任务流程！");
                } else {
                    window.open("${platform}/" + data.msg);
                }
            }
        });
    }
</script>