<#assign jsContent>
    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
</#assign>

<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>

<@com.html title="${reportName!}" import="jquery,jqueryEasyUI,multiselect,jqgrid,bootstrap,bootbox" js=jsContent css=cssContent >
    <div class="main-container" id="main-container">
        <script type="text/javascript">
            try {
                ace.settings.check('main-container', 'fixed')
            } catch (e) {
            }
        </script>

        <div class="main-container-inner" id="basetj">
            <div class="page-content">
                <div class="row">
                    <div class="widget-box transparent">
                        <div class="widget-body">
                            <div class="widget-main">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="col-xs-12">
                                            <div>
                                                <form id="queryForm">
                                                    <#if headPageFile?? && headPageFile != "">
                                                        <#include "../${headPageFile!}" />
                                                    </#if>
                                                    <div class="no-padding-left col-sm-12" style="margin-top: 5px">
                                                        <div class="no-padding-left col-sm-9" style="margin-top: 5px">
                                                            <fieldset class="searchInput form-inline">
                                                                <#if headPageFile?? && headPageFile != "">
                                                                <button type="button" class="btn btn-info btn-sm" id="btnQuery" >
                                                                    <i class="ace-icon fa fa-search bigger-110"></i>
                                                                    查询
                                                                </button>
                                                                </#if>
                                                                <#if needExport?? || autoExport??>
                                                                <button type="button" class="btn btn-success btn-sm" id="btnExportExcel">
                                                                    <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                    导出
                                                                </button>
                                                                </#if>

                                                                <button type="button" class="btn btn-success btn-sm" id="btnCreateAllHcxm">
                                                                    <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                    自动创建核查任务
                                                                </button>

                                                                <button type="button" class="btn btn-success btn-sm" id="btnCreateHcxm">
                                                                    <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                    人工创建核查任务
                                                                </button>

                                                                <button type="button" class="btn btn-success btn-sm" id="btnForbiddenCreate">
                                                                    <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                    无需下发任务
                                                                </button>

                                                                <button type="button" class="btn btn-success btn-sm" id="btnNeedCreate">
                                                                    <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                    待下发任务
                                                                </button>
                                                            </fieldset>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <p></p>
                                <div>
                                    <div class="col-xs-12"><label id="bottomTip" style="margin: 0px"></label></div>
                                </div>
                                <row>
                                    <div class="col-xs-12" >
                                        <div id="gGrid" data-definition="${base}/static/json/${colJson}.json">
                                            <table id="grid-table"></table>
                                            <div id="grid-pager"></div>
                                        </div>
                                    </div>
                                </row>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.main-container-inner -->
    </div>

    <div class="modal fade" id="inputMjModal" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: #f7f7f7;background-image:linear-gradient(to bottom, #fff 0, #eee 100%);background-repeat:repeat-x;">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        <i class="fa fa-pencil-square" style="color: #669fc7;">请输入面积阈值及下发分局：</i>
                    </h4>
                </div>
                <div class="modal-body alert alert-info" style="margin: 10px;">
                    <span style="color: #669fc7;">面积：</span>
                    <input type="text" class="form-control search-query"
                           id="mjyz" aliasName="面积" onblur="f_check_number(this)">
                    <span style="color: #669fc7;">下发分局：</span>
                    <select class="form-control" name="plxffj" id="plxffj" data-url="Xffj"></select>
                    <br/>
                    <br/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">取消
                    </button>
                    <button type="button" class="btn btn-primary" id="btnMjOk" onclick="">
                        确定
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="selFJModal" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: #f7f7f7;background-image:linear-gradient(to bottom, #fff 0, #eee 100%);background-repeat:repeat-x;">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        <i class="fa fa-pencil-square" style="color: #669fc7;">请选择下发分局：</i>
                    </h4>
                </div>
                <div class="modal-body alert alert-info" style="margin: 10px;">
                    <span style="color: #669fc7;">下发分局：</span>
                    <select class="form-control" name="xffj" id="xffj" data-url="Xffj"></select>
                    <br/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">取消
                    </button>
                    <button type="button" class="btn btn-primary" id="btnFJOk" onclick="">
                        确定
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- 标记不需要创建核查任务时，输入原因 -->
    <div class="modal fade" id="inputBzModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header" style="background: #f7f7f7;background-image:linear-gradient(to bottom, #fff 0, #eee 100%);background-repeat:repeat-x;">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        <i class="fa fa-pencil-square" style="color: #669fc7;">原因说明：</i>
                    </h4>
                </div>
                <div class="modal-body alert alert-info" style="margin: 10px;">
                    <span style="color: #669fc7;">无需下发任务原因：</span>
                    <input class="form-control" name="inputBz" id="inputBz" ></input>
                    <br/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">取消
                    </button>
                    <button type="button" class="btn btn-primary" id="btnInputBzOk">
                        确定
                    </button>
                </div>
            </div>
        </div>
    </div>

    <#include "../jdt/jdt.ftl"/>

    <#assign jsContent>
        <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
        <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>
    </#assign>
</@com.html>

<script type="text/javascript">
    var grid;

    $(function () {
        bootbox.setDefaults({
            locale: "zh_CN"
        });

        // 控制按钮是否可见
        <#if forbiddenList?? && forbiddenList=true>
            $('#btnCreateHcxm').css("display", "none");
            $('#btnCreateAllHcxm').css("display", "none");
            $('#btnForbiddenCreate').css("display", "none");
        <#else>
            $('#btnNeedCreate').css("display", "none");
        </#if>

        var scrollHeight = 8;
        var minRows = 5;
        var rowHeigth = 33;

        var drawHeight = jQuery(window).height() - 140 - $('#basetj')[0].clientHeight;
        var drawRowNum = Math.floor(drawHeight / rowHeigth);
        drawHeight = drawRowNum * rowHeigth + scrollHeight;

        if (drawHeight < minRows * rowHeigth) {
            drawHeight = minRows * rowHeigth + scrollHeight;
            drawRowNum = minRows;
        }
        grid = $('#gGrid').gGrid({
            rownumbers: true,
            rownumWidth: 40,
            footerrow: false,
            autoHeight: false,
            multiselect: true,
            height: drawHeight,
            rowNum: drawRowNum,
            caption: "${reportName!}",
            url:'/landtax/tj/tjJson?tag=${tag}&customParams=${customParams!}',
            gridComplete: function() {
                //在gridComplete调用行合并方法
                $('#gGrid').mergeRowCell();
            }
        });

        $('#btnExportExcel').click(function () {
            if ("${needExport!}" != null && "${needExport!}" != "") {
                exportExcel(1);
            } else {
                exportExcel(2);
            }
        });

        $('#btnCreateHcxm').click(function () {
            var ids = getSelectWxfRwid();

            if (ids == "") {
                bootbox.alert("请选择未下发任务的纳税人！");
                return;
            }

            var fjdm = getFirstSelectFjdm();
            $("#xffj").val(fjdm);
            $("#selFJModal").modal("show");
        });

        $('#btnFJOk').click(function () {
            var fjdm = $("#xffj").val();
            if (fjdm == null || fjdm == ""){
                bootbox.alert("请选择下发的分局！");
                return;
            }

            var ids = getSelectWxfRwid();
            var wxfCount = 0;

            if (ids == "") {
                bootbox.alert("请选择未下发任务的纳税人！");
                return;
            } else {
                wxfCount = ids.split(",").length;
            }
            $("#selFJModal").modal("hide");

            bootbox.confirm("是否确定将选择的" + wxfCount.toString() + "个纳税人创建核查任务并下发到指定分局?", function(result) {
                if(result){
                    showJdt($, true);
                    $.ajax({
                        type: 'post',
                        url: "${base}/hcxm/createSelHcxm",
                        data:{hcxmlx: "${hcxmlx!}", tag: "${tag!}", ids: ids, fjdm: fjdm},
                        dataType: 'json',
                        success: function (data) {
                            showJdt($, false);
                            if (data != null && data != '') {
                                if (data.msg != null && data.msg.substr(0, 9) == "java.lang") {
                                    bootbox.alert("该用户不允许创建该流程");
                                } else {
                                    bootbox.alert("创建完成，共创建并下发" + data.msg + "条任务！");
                                    grid.trigger('reloadGrid');
                                }
                            }
                        }
                    });
                }
            });
        });

        $('#btnCreateAllHcxm').click(function () {
            $("#mjyz").val('');
            $("#plxffj").val('');
            $("#inputMjModal").modal("show");
        });

        $('#btnMjOk').click(function () {
            var mjyz = $("#mjyz").val();
            if (mjyz == null || mjyz == ""){
                bootbox.alert("请输入面积阈值！");
                return;
            }

            var fjdm = $("#plxffj").val();
            if (fjdm == null || fjdm == ""){
                bootbox.alert("请选择下发的分局！");
                return;
            }
            $("#inputMjModal").modal("hide");

            var queryParam = $('#queryForm').serializeJson();
            bootbox.confirm("是否确定将面积大于" + mjyz + "的纳税人创建核查任务并下发到指定分局?", function(result) {
                if(result){
                    showJdt($, true);
                    $.ajax({
                        type: 'post',
                        url: "${base}/hcxm/createAllHcxm",
                        data:{hcxmlx: "${hcxmlx!}", tag: "${tag!}", customParams:"${customParams!}", query: queryParam["query"], mjyz: mjyz, fjdm: fjdm},
                        dataType: 'json',
                        success: function (data) {
                            showJdt($, false);
                            if (data != null && data != '') {
                                if (data.msg != null && data.msg.substr(0, 9) == "java.lang") {
                                    bootbox.alert("该用户不允许创建该流程");
                                } else {
                                    bootbox.alert("创建完成，共创建并下发" + data.msg + "条任务！");
                                    grid.trigger('reloadGrid');
                                }
                            }
                        }
                    });
                }
            });
        });

        $('#btnForbiddenCreate').click(function () {
            var ids = getSelectWxfRwid();
            if (ids == "") {
                bootbox.alert("请选择未下发任务的纳税人！");
                return;
            }

            $("#inputBz").val('');
            $("#inputBzModal").modal("show");
        });

        $('#btnInputBzOk').click(function () {
            var ids = getSelectWxfRwid();
            var wxfCount = 0;

            if (ids == "") {
                bootbox.alert("请选择未下发任务的纳税人！");
                return;
            } else {
                wxfCount = ids.split(",").length;
            }

            var bz = $("#inputBz").val();
            if (bz == "") {
                bootbox.alert("请填写无需下发任务原因！");
                return;
            }

            $("#inputBzModal").modal("hide");

            bootbox.confirm("是否确定将选择的" + wxfCount.toString() + "个纳税人标记为无需下发任务?", function(result) {
                if(result){
                    showJdt($, true);
                    $.ajax({
                        type: 'post',
                        url: "${base}/hcxm/forbiddenCreateHcxm",
                        data:{hcxmlx: "${hcxmlx!}", tag: "${tag!}", ids: ids, bz: bz},
                        dataType: 'json',
                        success: function (data) {
                            showJdt($, false);
                            if (data.msg == undefined || data.msg.length == 0) {
                                bootbox.alert("标记完成！");
                            } else {
                                bootbox.alert("标记过程出现异常！");
                            }
                            grid.trigger('reloadGrid');
                        }
                    });
                }
            });
        });

        $('#btnNeedCreate').click(function () {
            var ids = getSelectWxfRwid();
            var wxfCount = 0;

            if (ids == "") {
                bootbox.alert("请选择需要创建下发任务的纳税人！");
                return;
            } else {
                wxfCount = ids.split(",").length;
            }

            bootbox.confirm("是否确定将选择的" + wxfCount.toString() + "个纳税人标记为需要创建下发任务?", function(result) {
                if(result){
                    showJdt($, true);
                    $.ajax({
                        type: 'post',
                        url: "${base}/hcxm/needCreateHcxm",
                        data:{hcxmlx: "${hcxmlx!}", tag: "${tag!}", ids: ids},
                        dataType: 'json',
                        success: function (data) {
                            showJdt($, false);
                            if (data.msg == undefined || data.msg.length == 0) {
                                bootbox.alert("标记完成！");
                            } else {
                                bootbox.alert("标记过程出现异常！");
                            }
                            grid.trigger('reloadGrid');
                        }
                    });
                }
            });
        });

        $(":input").focus(
                function(){
                    if(this.value=="" ||this.value==null){this.placeholder=""};
                }
        ) ;

        $(":input").blur(
                function(){
                    if(this.value==""||this.value==null){this.placeholder=(this.getAttribute("aliasName") == null) ? "" : this.getAttribute("aliasName");};
                }
        ) ;
        initializeSelect();

        refreshTipMsg();
    });

    $('#btnQuery').click(function () {
        var params = $('#queryForm').serializeJson();
        queryCommand(params);

        refreshTipMsg();
    });

    function queryCommand (params) {
        $('#gGrid').refreshGrid(params);
    }

    function exportExcel(param){
        var queryParam = $('#queryForm').serializeJson();
        var gridOptions = $('#gGrid').getOptions();
        var actionURL;
        if (param == 1) {
            actionURL = '${base}/tj/exportExcelTj?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"];
        } else {
            actionURL = '${base}/tj/exportExcelTjEx?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"] + '&gridOptions=' + JSON.stringify(gridOptions);
        }
        window.open(actionURL,"exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no");
    }

    function initializeSelect(){
        var selectDataType = '';
        $('select').each(function(){
            var dataType = $(this).attr('data-url');
            if(dataType != null && dataType != ''){
                selectDataType += dataType + ',';
            }
        });
        if(selectDataType != null && selectDataType != ''){
            $.getJSON('${base}/dic?name=' + selectDataType, function(data){
                for(var key in data){
                    var targetElement = $('select[data-url = "' + key + '"]');
                    targetElement.empty();
                    if ($('select[data-url = "' + key + '"][multiple="multiple"]').length == 0)
                        targetElement.append("<option value=''>---请选择---</option>");
                    for(var valueKey in data[key]){
                        var value = targetElement.attr('value');
                        targetElement.append("<option value='" + valueKey + "'" + (value === valueKey ? " selected " : "") + ">" + data[key][valueKey] + "</option>");
                    }
                }

                $('select[multiple="multiple"]').multiselect({
                    noneSelectedText: "---请选择---",
                    checkAllText: "全选",
                    selectedList:3
                });
            });
        }
    }

    function turnToUrl(id, baseUrl, paramNames, paramValues, paramOperators) {
        paramNames = paramNames.split(",");
        paramValues = paramValues.split(",");

        if (paramOperators == null)
            paramOperators = '';
        paramOperators = paramOperators.split(",");

        var paramCnt = paramNames.length;
        var paramName, paramValue, paramOperator, paramStr, i;
        var valueJson = {};
        var operatorJson = {};
        var hasCustomParams = false;
        id = (id.split("="))[1];
        for (i = 0; i < paramCnt; i++) {
            paramName = paramNames[i].trim();
            paramValue = grid.jqGrid('getRowData', id)[paramValues[i].trim()];
            if (paramValue == null)
                paramValue = paramValues[i].trim();

            if (i < paramOperators.length) {
                paramOperator = paramOperators[i].trim();
            } else {
                paramOperator = '';
            }
            if (paramOperator == '') {
                if (paramStr != '')
                    paramStr += '&';
                paramStr += paramName + '=' + paramValue;
            } else {
                hasCustomParams = true;
                valueJson[paramName] = paramValue;
                operatorJson[paramName] = paramOperators[i];
            }
        }

        if (hasCustomParams) {
            if (paramStr != '')
                paramStr += '&';
            paramStr += 'customParams=' + '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';
        }
        window.open("${base!}/" + baseUrl + "?" + paramStr, "")
    }

    function getSelectWxfRwid () {
        var text = "";
        var rwbmfield = "RWBM";
        var blztfield = "BLZT";
        var ids = grid.jqGrid('getGridParam', 'selarrrow');
        for (var i = 0; i < ids.length; i++) {
            var rowData = grid.jqGrid('getRowData', ids[i]);
            if (rowData[rwbmfield] == null || rowData[rwbmfield] == ""){
                continue;
            }
            if (rowData[blztfield] != null && rowData[blztfield] == "-1") {
                if (text != "")
                    text += ",";
                text += rowData[rwbmfield];
            }
        }
        return text;
    };

    function getFirstSelectFjdm () {
        var text = "";
        var rwbmfield = "RWBM";
        var blztfield = "BLZT";
        var fjdmfield = "FJDM";
        var ids = grid.jqGrid('getGridParam', 'selarrrow');
        for (var i = 0; i < ids.length; i++) {
            var rowData = grid.jqGrid('getRowData', ids[i]);
            if (rowData[rwbmfield] == null || rowData[rwbmfield] == ""){
                continue;
            }
            if (rowData[blztfield] != null && rowData[blztfield] == "-1") {
                text = rowData[fjdmfield];
                break;
            }
        }
        return text;
    };

    function refreshTipMsg() {
        var queryParam = $('#queryForm').serializeJson();
        $.ajax({
            type: 'post',
            url: "${base}/hcxm/getTipMsg",
            data:{hcxmlx: "${hcxmlx!}", tag: "${tag!}", customParams:"${customParams!}", query: queryParam["query"]},
            dataType: 'json',
            success: function (data) {
                $("#bottomTip").text(data.msg);
            }
        });
    }
</script>