<#assign jsContent>
    <@com.script name="static/js/tax/grid.js"></@com.script>
    <@com.script name="static/js/public.js"></@com.script>
    <@com.script name="static/js/tax/swDjSy-save-validate.js"></@com.script>
    <@com.script name="static/thirdparty/bootstrap/js/bootstrap-typeahead.min.js"></@com.script>
    <@com.script name="static/thirdparty/ace/js/ace-extra.min.js"></@com.script>
    <@com.script name="static/thirdparty/ace/js/ace-elements.min.js"></@com.script>
    <@com.script name="static/thirdparty/ace/js/ace.min.js"></@com.script>
</#assign>

<#assign cssContent>
    <@com.style name="static/css/pageForm.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/font-awesome.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-fonts.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-skins.min.css"></@com.style>
    <@com.style name="static/thirdparty/ace/css/ace-rtl.min.css"></@com.style>
</#assign>

<@com.html title="${reportName!}" import="jquery,multiselect,jqgrid,bootstrap,bootbox,datetimepicker" js=jsContent css=cssContent >
    <div class="main-container" id="main-container">
        <script type="text/javascript">
            try {
                ace.settings.check('main-container', 'fixed')
            } catch (e) {
            }
        </script>

        <div class="main-container-inner" id="sytz">
            <div class="page-content">
                <div class="row">
                    <div class="widget-box transparent">
                        <div class="widget-body">
                            <div class="widget-main">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="col-xs-12">
                                            <div>
                                                <form id="queryForm">
                                                    <#if headPageFile?? && headPageFile != "">
                                                        <#include "../${headPageFile!}" />
                                                    </#if>
                                                    <div class="no-padding-left col-sm-12" style="margin-top: 5px">
                                                        <div class="no-padding-left col-sm-6" style="margin-top: 5px">
                                                            <#if headPageFile?? && headPageFile != "">
                                                            <button type="button" class="btn btn-info btn-sm pull-left" id="btnQuery" >
                                                                <i class="ace-icon fa fa-search bigger-110"></i>
                                                                查询
                                                            </button>
                                                            </#if>
                                                        </div>
                                                        <div class="no-padding-left col-sm-6" style="margin-top: 5px">
                                                            <#if needExport?? || autoExport??>
                                                                <button type="button" class="btn btn-success btn-sm pull-right" id="btnExportExcel">
                                                                    <i class="ace-icon glyphicon glyphicon-share bigger-110"></i>
                                                                    导出
                                                                </button>
                                                            </#if>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <p></p>
                                <row>
                                    <div class="col-xs-12" >
                                        <div id="gGrid" data-definition="${base}/static/json/${colJson}.json">
                                            <table id="grid-table"></table>
                                            <div id="grid-pager"></div>
                                        </div>
                                    </div>
                                </row>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /.main-container-inner -->
    </div>

    <div class="main-container-inner" id="syxx" toggleId="sytz" style="display:none;">

    </div>
</@com.html>

<script type="text/javascript">
    var grid;

    $(function () {
        bootbox.setDefaults({
            locale: "zh_CN"
        });

        var scrollHeight = 12;
        var minRows = 5;
        var rowHeigth = 33;

        var drawHeight = jQuery(window).height() - 140 - $('#sytz')[0].clientHeight;
        var drawRowNum = Math.floor(drawHeight / rowHeigth);
        drawHeight = drawRowNum * rowHeigth + scrollHeight;

        if (drawHeight < minRows * rowHeigth) {
            drawHeight = minRows * rowHeigth + scrollHeight;
            drawRowNum = minRows;
        }
        grid = $('#gGrid').gGrid({
            rownumbers: true,
            rownumWidth: 40,
            footerrow: false,
            autoHeight: false,
            height: drawHeight,
            rowNum: drawRowNum,
            caption: "${reportName!}",
            url:'/landtax/tj/tjJson?tag=${tag}&customParams=${customParams!}',
            gridComplete: function() {
                //在gridComplete调用行合并方法
                $('#gGrid').mergeRowCell();

                // 重加载操作
                loadCzValue();
            }
        });

        $('#btnExportExcel').click(function () {
            if ("${needExport!}" != null && "${needExport!}" != "") {
                exportExcel(1);
            } else {
                exportExcel(2);
            }
        });

        $(":input").focus(
                function(){
                    if(this.value=="" ||this.value==null){this.placeholder=""};
                }
        ) ;

        $(":input").blur(
                function(){
                    if(this.value==""||this.value==null){this.placeholder=(this.getAttribute("aliasName") == null) ? "" : this.getAttribute("aliasName");};
                }
        ) ;
        initializeSelect($);
    });

    $('#btnQuery').click(function () {
        var params = $('#queryForm').serializeJson();
        queryCommand(params);
    });

    // 更改税源类型时，重新加载页面
    $('#sylx').change(function () {
        var sylx = $('#sylx').val();
        var url = "${base}/ts/sytz?sylx=" + sylx + "&noEdit=${noEdit!}";
        location.replace(url);
    });

    function queryCommand (params) {
        $('#gGrid').refreshGrid(params);
    }

    function exportExcel(param){
        var queryParam = $('#queryForm').serializeJson();
        var gridOptions = $('#gGrid').getOptions();
        var actionURL;
        if (param == 1) {
            actionURL = '${base}/tj/exportExcelTj?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"];
        } else {
            actionURL = '${base}/tj/exportExcelTjEx?tag=${tag}&customParams=${customParams!}&query=' + queryParam["query"] + '&gridOptions=' + JSON.stringify(gridOptions);
        }
        window.open(actionURL,"exportWin", "left=50,top=50,height=600px,width=750px,resizable=yes,status=yes,toolbar=no, menubar=no,location=no");
    }

    function turnToUrl(id, baseUrl, paramNames, paramValues, paramOperators) {
        paramNames = paramNames.split(",");
        paramValues = paramValues.split(",");

        if (paramOperators == null)
            paramOperators = '';
        paramOperators = paramOperators.split(",");

        var paramCnt = paramNames.length;
        var paramName, paramValue, paramOperator, paramStr, i;
        var valueJson = {};
        var operatorJson = {};
        var hasCustomParams = false;
        id = (id.split("="))[1];
        for (i = 0; i < paramCnt; i++) {
            paramName = paramNames[i].trim();
            paramValue = grid.jqGrid('getRowData', id)[paramValues[i].trim()];
            if (paramValue == null)
                paramValue = paramValues[i].trim();

            if (i < paramOperators.length) {
                paramOperator = paramOperators[i].trim();
            } else {
                paramOperator = '';
            }
            if (paramOperator == '') {
                if (paramStr != '')
                    paramStr += '&';
                paramStr += paramName + '=' + paramValue;
            } else {
                hasCustomParams = true;
                valueJson[paramName] = paramValue;
                operatorJson[paramName] = paramOperators[i];
            }
        }

        if (hasCustomParams) {
            if (paramStr != '')
                paramStr += '&';
            paramStr += 'customParams=' + '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';
        }
        window.open("${base!}/" + baseUrl + "?" + paramStr, "")
    }

    // 重加载税源数据操作类型
    function loadCzValue() {
        var rowIds = grid.jqGrid("getDataIDs");
        for (var i = 0; i < rowIds.length; i++) {
            var id = rowIds[i];
            var rowData = grid.jqGrid("getRowData", id);

            var mapLink = "";
            mapLink += "<div title='宗地定位' class='pull-left'  style='margin-left: 5px'>";
            mapLink += "<a href=javascript:locateZd(\'" + rowData.DJH + "\')>";
            mapLink += "<i class='ace-icon fa fa-map-marker'></i>";
            mapLink += "</a>";
            mapLink += "</div>";

            var editLink = "";
            editLink += "<div title='税源编辑' class='pull-left'  style='margin-left: 5px'>";
            editLink += "<a href=javascript:editSy(\'" + rowData.SY_ID + "\')>";
            editLink += "<i class='ace-icon fa fa-pencil'></i>";
            editLink += "</a>";
            editLink += "</div>";

            var viewLink = "";
            viewLink += "<div title='税源查看' class='pull-left'  style='margin-left: 5px'>";
            viewLink += "<a href=javascript:viewSy(\'" + rowData.SY_ID + "\')>";
            viewLink += "<i class='ace-icon fa fa-pencil'></i>";
            viewLink += "</a>";
            viewLink += "</div>";

            var deleteLink = "";
            deleteLink += "<div title='税源删除' class='pull-left'  style='margin-left: 5px'>";
            deleteLink += "<a href=javascript:delSy(\'" + rowData.SY_ID + "\')>";
            deleteLink += "<i class='ace-icon glyphicon glyphicon-remove'></i>";
            deleteLink += "</a>";
            deleteLink += "</div>";

            var historyLink = "";
            historyLink += "<div title='税源修改历史记录' class='pull-left'  style='margin-left: 5px'>";
            historyLink += "<a href=javascript:hisSy(\'" + rowData.SY_ID + "\')>";
            historyLink += "<i class='ace-icon glyphicon glyphicon-home'></i>";
            historyLink += "</a>";
            historyLink += "</div>";

            var cz = "";
            <#if noEdit?? && noEdit != ''>
                if ("${sylx!}" == "1") {
                    cz += mapLink;
                }
                cz += viewLink;
                cz += historyLink;
            <#else>
                if ("${sylx!}" == "1") {
                    cz += mapLink;
                }
                cz += editLink;
                cz += deleteLink;
                cz += historyLink;
            </#if>
            grid.jqGrid('setRowData', id, {CZ: cz});
        }
    }

    // 宗地定位
    function locateZd(djh) {
        var url = "${base}/map/index?djh=" + djh;
        window.open(url);
    }

    // 编辑税源
    function editSy(syId) {
        $.ajax({
            type: 'post',
            url: "${base}/ts/syxxInput",
            data:{syId: syId, sylx: '${sylx}'},
            dataType: 'text',
            success: function (data) {
                $('#syxx').empty();
                $('#syxx').append(data);
                $("#syxx").toggle(300);
                $("#sytz").toggle(300);
            },
            error: function (XmlHttpRequest, textStatus, errorThrown) {
                alert('读取税源信息有误！');
            }
        });
    }
    // 查看税源
    function viewSy(syId) {
        var url = "${base}/ts/syxxInput?noBack=ture&noSave=ture&syId=" + syId + "&sylx=${sylx}";
        window.open(url);
    }
    // 删除税源
    function delSy(syId) {
        bootbox.confirm("是否确定删除税源?", function(result) {
            if(result){
                $.ajax({
                    type: 'post',
                    url: "${base}/ts/delSy",
                    data:{syId:syId},
                    dataType: 'text',
                    success: function (data) {
                        bootbox.alert("税源删除成功！");

                        var params = $('#queryForm').serializeJson();
                        var page = grid.jqGrid('getGridParam', 'page');
                        var curPageRows = grid.jqGrid('getGridParam', 'records');
                        if (curPageRows == 1 && page > 1)
                            page = page - 1;
                        grid.jqGrid('setGridParam', {
                            postData: params,
                            page: page
                        }).trigger("reloadGrid");
                    },
                    error: function (XmlHttpRequest, textStatus, errorThrown) {
                        alert('税源删除失败！');
                    }
                });
            }
        });
    }

    // 税源修改历史记录
    function hisSy(syId) {
        var tag = "tdsSyHisList";
        if ("${sylx}" == "2")
            tag = "fcsSyHisList";

        var valueJson = {};
        var operatorJson = {};
        valueJson["SY_ID"] = syId;
        operatorJson["SY_ID"] = "=";
        var customParams = 'customParams=' + '[' + JSON.stringify(valueJson) + ',' + JSON.stringify(operatorJson) + ']';

        var url = "${base}/tj/baseTj?tag=" + tag + "&" + customParams;
        window.open(url);
    }
</script>