<#macro html title="" import="" css="" js="">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
    <title>${title}</title>
    <#if import??>
        <#list import?split(",") as lib>
            <#switch lib>
                <#case "jquery">
                    <!--[if !IE]> -->
                    <script type="text/javascript">
                        window.jQuery || document.write("<script src='${base}/static/thirdparty/jquery/jquery-2.1.0.min.js'>"+"<"+"/script>");
                    </script>
                    <!-- <![endif]-->

                    <!--[if IE]>
                    <script type="text/javascript">
                        window.jQuery || document.write("<script src='${base}/static/thirdparty/jquery/jquery-1.11.0.min.js'>"+"<"+"/script>");
                    </script>
                    <![endif]-->


                    <#break />
                <#case "jqueryUI">
                    <@script name="static/thirdparty/jqueryUI/js/jquery-ui.min.js"></@script>
                    <@style name="static/thirdparty/jqueryUI/css/jquery-ui.min.css"></@style>
                    <#break />
                <#case "ace">
                    <@style name="static/thirdparty/ace/css/font-awesome.min.css"></@style>
                    <@style name="static/thirdparty/ace/css/ace-fonts.css"></@style>
                    <@style name="static/thirdparty/ace/css/ace.min.css"></@style>
                    <@style name="static/thirdparty/ace/css/ace-skins.min.css"></@style>
                    <@style name="static/thirdparty/ace/css/ace-rtl.min.css"></@style>
                    <@script name="static/thirdparty/ace/js/ace-extra.min.js"></@script>
                    <@script name="static/thirdparty/ace/js/ace-elements.min.js"></@script>
                    <@script name="static/thirdparty/ace/js/ace.min.js"></@script>
                    <#break />
                <#case "jqgrid">
                    <@script name="static/thirdparty/jqGrid/jquery.jqGrid.min.js"></@script>
                    <@script name="static/thirdparty/jqGrid/i18n/grid.locale-en.js"></@script>
                    <@style name="static/thirdparty/jqGrid/css/ui.jqgrid.css"></@style>
                    <@script name="static/thirdparty/jqGrid/grid.treegrid.js"></@script>
                    <#break />
                <#case "jqueryEasyUI">
                    <@script name="static/thirdparty/jquery/easyui/jquery.easyui.min.js"></@script>
                    <@style name="static/thirdparty/jquery/easyui/themes/gray/easyui.css"></@style>
                    <@style name="static/thirdparty/jquery/easyui/themes/icon.css"></@style>
                    <#break />

                <#case "multiselect">
                    <@script name="static/thirdparty/multiselect/ui/jquery.ui.core.js"></@script>
                    <@script name="static/thirdparty/multiselect/ui/jquery.ui.widget.js"></@script>
                    <@script name="static/thirdparty/multiselect/multiselectSrc/jquery.multiselect.js"></@script>
                    <@script name="static/thirdparty/multiselect/multiselectSrc/jquery.multiselect.filter.js"></@script>
                    <@style name="static/thirdparty/multiselect/multiselectSrc/jquery.multiselect.css"></@style>
                    <@style name="static/thirdparty/multiselect/assets/style.css"></@style>
                    <@style name="static/thirdparty/multiselect/assets/prettify.css"></@style>
                    <#break />
                <#case "treegrid">
                    <@script name="static/thirdparty/treegrid/js/jquery-1.3.2.min.js"></@script>
                    <@script name="static/thirdparty/treegrid/js/TreeGrid.js"></@script>
                    <@style name="static/thirdparty/treegrid/css/TreeGrid.css"></@style>
                    <#break />
                <#case "datetimepicker">
                    <@script name="static/thirdparty/bootstrap/js/bootstrap-datetimepicker.js"></@script>
                    <@style name="static/thirdparty/bootstrap/css/bootstrap-datetimepicker.css"></@style>
                    <#break />
                <#case "datetime">
                    <@script name="static/thirdparty/datetime/bootstrap-datepicker.min.js"></@script>
                    <#break />
                <#case "span">
                    <@script name="static/thirdparty/spin/spin.js"></@script>
                    <#break />
                <#case "highcharts">
                    <@script name="static/thirdparty/highcharts/highcharts.js"></@script>
                     <@script name="static/thirdparty/highcharts/modules/exporting.js"></@script>
                    <#break />
                <#case "bootstrap">
                    <@script name="static/thirdparty/bootstrap/js/bootstrap.min.js"></@script>
                    <@style name="static/thirdparty/bootstrap/css/bootstrap.min.css"></@style>
                    <#break />
                <#case "bootbox">
                    <@script name="static/thirdparty/bootstrap/js/bootbox.min.js"></@script>
                    <@script name="static/thirdparty/bootstrap/js/bootbox-locale.js"></@script>
                    <#break />
                <#case "common">
                    <@script name="static/js/public.js"></@script>
                    <@style name="static/css/common.css"></@style>
                    <#break/>
                <#case "datepicker">
                    <@script name="static/thirdparty/jquery/plugins/js/jquery.ui.datepicker-zh-CN.js"></@script>
                    <#break />
                <#case "jqueryForm">
                    <@script name="static/thirdparty/jquery/plugins/js/jquery.form.min.js"></@script>
                    <#break />
                <#case "validate">
                    <@script name="static/thirdparty/jquery/plugins/js/jquery.validate.min.js"></@script>
                    <@script name="static/thirdparty/jquery/plugins/js/jquery.validate.messages_zh.js"></@script>
                    <#break />
                <#case "selectBoxIt">
                    <@script name="static/thirdparty/jquery/plugins/js/jquery.selectBoxIt.min.js"></@script>
                    <@style name="static/thirdparty/jquery/plugins/css/jquery.selectBoxIt.css"></@style>
                    <#break />
                <#case "zTree">
                    <@script name="static/thirdparty/ztree/js/jquery.ztree.core-3.5.js"></@script>
                    <@script name="static/thirdparty/ztree/js/jquery.ztree.excheck-3.5.js"></@script>
                    <@style name="static/thirdparty/ztree/css/zTreeStyle/zTreeStyle.css"></@style>
                    <#break />
                <#case "artDialog">
                    <@script name="static/thirdparty/artDialog/artDialog.min.js"></@script>
                    <@script name="static/thirdparty/artDialog/artDialog.plugins.min.js"></@script>
                    <@script name="static/thirdparty/artDialog/jquery.artDialog.min.js"></@script>
                    <@style name="static/thirdparty/artDialog/skins/default.css"></@style>
                    <#break />
                <#case "arcgisMap">
                    <script>
                        var arcgisUrl= "${env.getEnv('arcgis.url')}";
                    </script>
                    <script src="${env.getEnv('arcgis.url')}/3.9/init.js"></script>
                    <link href="${env.getEnv('arcgis.url')}/3.9/js/dojo/dojox/widget/ColorPicker/ColorPicker.css" type="text/css" media="screen" rel="stylesheet"/>
                    <link href="${env.getEnv('arcgis.url')}/3.9/js/esri/css/esri.css" type="text/css" media="screen" rel="stylesheet"/>
                    <link href="${env.getEnv('arcgis.url')}/3.9/js/dojo/dijit/themes/tundra/tundra.css" type="text/css" media="screen" rel="stylesheet"/>
                    <#break />
                <#default>
            </#switch>
        </#list>
    </#if>
${css!}
</head>
<body>
    <#nested />
${js!}
</body>
</html>
</#macro>



<#--计算合计值-->
<#function sum nums...>
    <#local total = 0>
    <#list nums as num>
        <#if num??>
            <#local total = total + num>
        </#if>
    </#list>
    <#return total>
</#function>

<#macro script name>
<script src="<@rootPath/>/${name}" type="text/javascript"></script>
</#macro>

<#macro style name>
<link href="<@rootPath/>/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>

<#macro rootPath>${springMacroRequestContext.getContextPath()}</#macro>

<#macro signhtml signKey="" signName="" proId="" isOpinion=true  opinionType="" signdiv="" disabled="false">
<div id="${signdiv}"></div>
<script type="text/javascript">
    $(document).ready(function () {
        var disabled = "false";
        <#if disabled?exists>
            disabled = "${disabled}";
        </#if>

        var params = {
            "signVo.signKey": "${signKey}",
            "signVo.signName": "${signName}",
            "signVo.proId": "${proId}",
            <#if isOpinion?exists>
                "opinion":${isOpinion?string("true","false")},
            </#if>
            <#if opinionType?exists>
                opinionType: "${opinionType}",
            </#if>
            disabled: disabled
        };
        var ajaxUrl = "/platform/tag/signtag.action";

        var urlParam = document.location.search;
        if ($("#taskid")) {
            if ($("#taskid").val() && $("#taskid").val().trim() != "") {
                params.taskid = $("#taskid").val();
                urlParam = urlParam.replace("taskid", "taskid_");
            }
        }

        if ($("#wiid")) {
            if ($("#wiid").val() && $("#wiid").val().trim() != "") {
                params.wiid = $("#wiid").val();
                urlParam = urlParam.replace("wiid", "wiid_");
            }
        }

        if ($("#proid")) {
            if ($("#proid").val() && $("#proid").val().trim() != "") {
                params.proid = $("#proid").val();
                urlParam = urlParam.replace("proid", "proid_");
            }
        }

        if ($("#rid")) {
            if ($("#rid").val() && $("#rid").val().trim() != "") {
                params.rid = $("#rid").val();
                urlParam = urlParam.replace("rid", "rid_");
            }
        }

        if ($("#from")) {
            if ($("#from").val() && $("#from").val().trim() != "") {
                params.from = $("#from").val();
                urlParam = urlParam.replace("from", "from_");
            }
        }
        //alert(ajaxUrl+params)  ;
        $.ajax({
            type: "POST",
            url: ajaxUrl + urlParam,
            data: params,
            cache: false,
            success: function (msg) {
                $("#" + "${signdiv}").html(msg);
            }
        });
    });
</script>
</#macro>