/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web.map;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.MapService;
import cn.gtmap.landtax.support.spring.BaseController;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/map"})
public class MapController
extends BaseController {
    @Autowired
    DwxxService dwxxService;
    @Autowired
    MapService mapService;
    @Autowired
    HcxmService hcxmService;

    @RequestMapping(value={"/index"})
    public String showMap(Model model, String xzqdm, String djh, String proid) {
        if (StringUtils.isBlank((String)xzqdm)) {
            xzqdm = SessionUtil.getCurrentUser().getRegionCode();
        }
        if (xzqdm.length() > 6) {
            xzqdm = xzqdm.substring(0, 6);
        }
        Map cityMap = this.getCityMap(xzqdm);
        List counties = this.getCounties(xzqdm);
        model.addAttribute("city", (Object)cityMap);
        model.addAttribute("counties", (Object)counties);
        if (cityMap != null) {
            model.addAttribute("xzqdm", cityMap.get("xzqdm"));
            model.addAttribute("xzqmc", cityMap.get("xzqmc"));
        } else if (counties.size() > 0) {
            Map county = (Map)counties.get(0);
            for (int i = 0; i < counties.size(); ++i) {
                if (!xzqdm.equals(((Map)counties.get(i)).get("xzqdm"))) continue;
                county = (Map)counties.get(i);
                break;
            }
            model.addAttribute("xzqdm", county.get("xzqdm"));
            model.addAttribute("xzqmc", county.get("xzqmc"));
        } else {
            String tmpXzqdm = StringUtils.substring((String)xzqdm, (int)0, (int)6);
            model.addAttribute("xzqdm", (Object)tmpXzqdm);
            SDmDwxxCz sDmDwxxCz = this.dwxxService.getDwxxByDwdm(tmpXzqdm);
            model.addAttribute("xzqmc", (Object)(sDmDwxxCz == null ? "" : sDmDwxxCz.getDwmc()));
        }
        if (StringUtils.isNotEmpty((String)djh)) {
            model.addAttribute("djh", (Object)djh);
        }
        if (StringUtils.isNotEmpty((String)proid)) {
            model.addAttribute("proid", (Object)proid);
        }
        return "landtax/map/map";
    }

    @RequestMapping(value={"/queryMap"})
    public String queryMap(Model model) {
        return "landtax/querymap";
    }

    @RequestMapping(value={"/config"})
    @ResponseBody
    public Object mapConfig(Model model) throws Exception {
        return this.mapService.getMapConfig();
    }

    private Map getCityMap(String xzqdm) {
        SDmDwxxCz sDmDwxxCz;
        HashMap cityMap = null;
        if (StringUtils.endsWith((String)xzqdm, (String)"00")) {
            xzqdm = StringUtils.strip((String)xzqdm, (String)"00");
        }
        if ((sDmDwxxCz = this.dwxxService.getCityByDwdm(xzqdm)) != null) {
            cityMap = Maps.newHashMap();
            cityMap.put("xzqdm", sDmDwxxCz.getDwdm());
            cityMap.put("xzqmc", sDmDwxxCz.getDwmc());
        }
        return cityMap;
    }

    private List getCounties(String xzqdm) {
        ArrayList counties = Lists.newArrayList();
        HashMap countyMap = null;
        if (StringUtils.endsWith((String)xzqdm, (String)"00")) {
            xzqdm = StringUtils.strip((String)xzqdm, (String)"00");
        }
        List sDmDwxxCzList = this.dwxxService.getCountiesByDwdm(xzqdm);
        for (SDmDwxxCz sDmDwxxCz : sDmDwxxCzList) {
            countyMap = Maps.newHashMap();
            countyMap.put("xzqdm", sDmDwxxCz.getDwdm());
            countyMap.put("xzqmc", sDmDwxxCz.getDwmc());
            counties.add(countyMap);
        }
        return counties;
    }
}

