/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SwDjFc;
import cn.gtmap.landtax.entity.SwDjFcTemp;
import cn.gtmap.landtax.entity.SwDjJbb;
import cn.gtmap.landtax.entity.SwDjJbbTemp;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyTemp;
import cn.gtmap.landtax.entity.SwDjTd;
import cn.gtmap.landtax.entity.SwDjTdTemp;
import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.Dldm;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.ExportFormExcelUtil;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.SyhcService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ts"})
public class TaxSourceController {
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    SyhcService syhcService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    TjService tjService;

    @RequestMapping(value={"sytz"})
    public Object sytz(Model model, String sylx, String noEdit) throws Exception {
        if (StringUtils.isEmpty((String)sylx)) {
            sylx = "1";
        }
        model.addAttribute("sylx", (Object)sylx);
        model.addAttribute("noEdit", (Object)noEdit);
        String tag = null;
        tag = sylx.equals("1") ? "sytzTds" : "sytzFcs";
        String customParams = null;
        String regionCode = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null && (regionCode = userInfo.getRegionCode()).equals("32038102")) {
            regionCode = "320381";
        }
        customParams = "[{\"REGIONCODE\":\"" + regionCode + "\"},{\"REGIONCODE\":\"" + "llike" + "\"}]";
        model.addAttribute("tag", (Object)tag);
        model.addAttribute("customParams", (Object)customParams);
        TjBaseParamVo tjBaseParamVo = this.tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", (Object)tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", (Object)tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", (Object)tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", (Object)tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank((String)tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank((String)tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", (Object)"true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", (Object)"true");
            }
        }
        return "landtax/fzjc/sytz";
    }

    @RequestMapping(value={"syJson"})
    @ResponseBody
    public Object getSwdjSy(Model model, Pageable request, String sylx, SwDjSyQuery swDjSyQuery) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sylx) || Sylx.TDSY.toString().equals(sylx)) {
            return this.taxService.findSwdjTdMap(swDjSyQuery, request);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sylx) || Sylx.FCSY.toString().equals(sylx)) {
            return this.taxService.findSwdjFcMap(swDjSyQuery, request);
        }
        return null;
    }

    @RequestMapping(value={"syxxInput"})
    public Object syxxInput(Model model, String syId, String noSave, String noPrint, String noBack, String sylx) throws Exception {
        SwDjSy swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)syId);
        if (swDjSy.getZd() == null) {
            swDjSy.setZd(new Zd());
        }
        if (swDjSy.getSwDjJbb() == null) {
            swDjSy.setSwDjJbb(new SwDjJbb());
        }
        if (swDjSy.getSwDjTd() == null) {
            swDjSy.setSwDjTd(new SwDjTd());
        }
        if (swDjSy.getSwDjFc() == null) {
            swDjSy.setSwDjFc(new SwDjFc());
        }
        model.addAttribute("sylx", (Object)sylx);
        model.addAttribute("swDjSy", (Object)swDjSy);
        model.addAttribute("noBack", (Object)noBack);
        model.addAttribute("noPrint", (Object)noPrint);
        model.addAttribute("noSave", (Object)noSave);
        return "landtax/fzjc/syxxTz";
    }

    @RequestMapping(value={"syxxTempInput"})
    public String syxxTempInput(Model model, String tempId, String noSave, String noPrint, String noBack, String sylx) {
        SwDjSyTemp swDjSyTemp = (SwDjSyTemp)this.baseRepository.get(SwDjSyTemp.class, (Object)tempId);
        if (swDjSyTemp.getZd() == null) {
            swDjSyTemp.setZd(new Zd());
        }
        if (swDjSyTemp.getSwDjJbbTemp() == null) {
            swDjSyTemp.setSwDjJbbTemp(new SwDjJbbTemp());
        }
        if (swDjSyTemp.getSwDjTdTemp() == null) {
            swDjSyTemp.setSwDjTdTemp(new SwDjTdTemp());
        }
        if (swDjSyTemp.getSwDjFcTemp() == null) {
            swDjSyTemp.setSwDjFcTemp(new SwDjFcTemp());
        }
        model.addAttribute("swDjSyTemp", (Object)swDjSyTemp);
        model.addAttribute("sylx", (Object)sylx);
        model.addAttribute("noBack", (Object)noBack);
        model.addAttribute("noPrint", (Object)noPrint);
        model.addAttribute("noSave", (Object)noSave);
        return "landtax/fzjc/syxxTz";
    }

    @RequestMapping(value={"syxxSave"})
    @ResponseBody
    public Object syxxSave(Model model, SwDjSy swDjSy, String sylx) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = "";
        try {
            if (swDjSy.getSwDjJbb() != null && StringUtils.isEmpty((String)swDjSy.getSwDjJbb().getJbbId())) {
                swDjSy.getSwDjJbb().setJbbId(UUIDGenerator.generate());
            }
            this.taxService.addSwDjSyUpdateInfo(swDjSy, Syzt.ZC.toString());
            this.taxService.updateSwDjSy(swDjSy);
            responseMessage.setMsg(" \u4fdd\u5b58\u6210\u529f\uff01 ");
        }
        catch (Exception e) {
            e.printStackTrace();
            responseMessage.setMsg(" \u51fa\u73b0\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25\uff01 ");
        }
        return responseMessage;
    }

    @RequestMapping(value={"syxxTempSave"})
    @ResponseBody
    public Object syxxTempSave(Model model, SwDjSyTemp swDjSyTemp, String sylx) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        String syId = swDjSyTemp.getSyId();
        String tempId = swDjSyTemp.getTempId();
        String msg = "";
        try {
            if (swDjSyTemp.getSwDjTdTemp() == null && (sylx == null || sylx == "1")) {
                SwDjTdTemp swDjTdTemp = new SwDjTdTemp();
                swDjTdTemp.setTempId(tempId);
                swDjTdTemp.setSyId(syId);
                swDjSyTemp.setSwDjTdTemp(swDjTdTemp);
            }
            if (swDjSyTemp.getSwDjFcTemp() == null && (sylx == null || sylx == "2")) {
                SwDjFcTemp swDjFcTemp = new SwDjFcTemp();
                swDjFcTemp.setTempId(tempId);
                swDjFcTemp.setSyId(syId);
                swDjSyTemp.setSwDjFcTemp(swDjFcTemp);
            }
            if (swDjSyTemp.getSwDjJbbTemp() != null && StringUtils.isEmpty((String)swDjSyTemp.getSwDjJbbTemp().getJbbId())) {
                swDjSyTemp.getSwDjJbbTemp().setJbbId(UUIDGenerator.generate());
            }
            this.taxService.addSwDjSyTempUpdateInfo(swDjSyTemp, Syzt.ZC.toString());
            this.syhcService.saveSyTemp(swDjSyTemp);
            responseMessage.setMsg(" \u4fdd\u5b58\u6210\u529f\uff01 ");
        }
        catch (Exception e) {
            e.printStackTrace();
            responseMessage.setMsg(" \u51fa\u73b0\u5f02\u5e38\uff0c\u4fdd\u5b58\u5931\u8d25\uff01 ");
        }
        return responseMessage;
    }

    @RequestMapping(value={"delSy"})
    @ResponseBody
    public Object delSy(Model model, String syId) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            this.taxService.deleteSwDjSy(syId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return responseMessage;
    }

    @RequestMapping(value={"parseTdytByDm"})
    @ResponseBody
    public Object parseTdytByDm(Model model, String dm) {
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for (int i = 0; i < dms.length; ++i) {
            String tempTdytmc;
            tdytmcs[i] = tempTdytmc = Dldm.getMcByDm((String)dms[i]);
        }
        return tdytmcs;
    }

    @RequestMapping(value={"loginUserInfo"})
    @ResponseBody
    public Object loginUserInfo() {
        HashMap<String, String> loginUserInfo = new HashMap<String, String>();
        String userName = "";
        String ssfj = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            String regionCode = userInfo.getRegionCode();
            userName = userInfo.getUsername();
            if (regionCode.length() == 8) {
                ssfj = "2" + regionCode + "00";
            }
        }
        loginUserInfo.put("userName", userName);
        loginUserInfo.put("ssfj", ssfj);
        return loginUserInfo;
    }

    @RequestMapping(value={"getJsbl"})
    @ResponseBody
    public Object getJsbl() {
        String jsblConf = AppConfig.getProperty((String)"jsbl");
        if (StringUtils.isBlank((String)jsblConf)) {
            jsblConf = "0.7";
        }
        return jsblConf;
    }

    @RequestMapping(value={"findSwDjJbbByGlbm"})
    @ResponseBody
    public Object findSwDjJbbByGlbm(Model model, String glbm, String syzt) {
        SwDjJbb swDjJbb = null;
        if (syzt == null || syzt.equals("1")) {
            swDjJbb = this.taxService.findSwDjJbbByGlbm(glbm);
        } else if (syzt.equals("3")) {
            SwDjJbbTemp swDjJbbTemp = this.taxService.findSwDjJbbTempByGlbm(glbm);
            if (swDjJbbTemp != null) {
                swDjJbb = new SwDjJbb();
                BeanUtils.copyProperties((Object)swDjJbbTemp, (Object)swDjJbb);
            } else {
                swDjJbb = this.taxService.findSwDjJbbByGlbm(glbm);
            }
        }
        return swDjJbb;
    }

    @RequestMapping(value={"printSyxx"})
    @ResponseBody
    public void printSyxx(Model model, HttpServletResponse response, String syId, String djh, String sylx) throws Exception {
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSy swDjSy = new SwDjSy();
        if (StringUtils.isNotBlank((String)syId)) {
            swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)syId);
        } else {
            Zd zd = (Zd)this.baseRepository.get(Zd.class, (Object)djh);
            swDjSy.setZd(zd);
        }
        xml.append(xmlBuildHelper.voToXml((Object)swDjSy));
        String res = xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"printSyxxTemp"})
    @ResponseBody
    public void printSyxxTemp(Model model, HttpServletResponse response, String tempId, String djh) throws Exception {
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        if (StringUtils.isNotBlank((String)tempId)) {
            swDjSyTemp = (SwDjSyTemp)this.baseRepository.get(SwDjSyTemp.class, (Object)tempId);
        } else {
            Zd zd = (Zd)this.baseRepository.get(Zd.class, (Object)djh);
            swDjSyTemp.setZd(zd);
        }
        SwDjSy swDjSy = this.taxService.copyTempToSy(swDjSyTemp);
        xml.append(xmlBuildHelper.voEntityToXml((Object)swDjSy));
        String res = xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"exportSyxx"})
    public String exportSyxx(Model model, HttpServletRequest request, String syId, String djh, String xls) throws Exception {
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSy swDjSy = new SwDjSy();
        if (StringUtils.isNotBlank((String)syId)) {
            swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)syId);
        } else {
            Zd zd = (Zd)this.baseRepository.get(Zd.class, (Object)djh);
            swDjSy.setZd(zd);
        }
        ExportFormExcelUtil.exportFormExcel((HttpServletRequest)request, (Object)swDjSy, (String)xls);
        return "common/downExcel";
    }

    @RequestMapping(value={"exportSyxxTemp"})
    public String exportSyxxTemp(Model model, HttpServletRequest request, String tempId, String djh, String xls) throws Exception {
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        if (StringUtils.isNotBlank((String)tempId)) {
            swDjSyTemp = (SwDjSyTemp)this.baseRepository.get(SwDjSyTemp.class, (Object)tempId);
        } else {
            Zd zd = (Zd)this.baseRepository.get(Zd.class, (Object)djh);
            swDjSyTemp.setZd(zd);
        }
        SwDjSy swDjSy = this.taxService.copyTempToSy(swDjSyTemp);
        ExportFormExcelUtil.exportFormExcel((HttpServletRequest)request, (Object)swDjSy, (String)xls);
        return "common/downExcel";
    }

    @RequestMapping(value={"getPrintIdByProid"})
    @ResponseBody
    public Object getPrintIdByProid(Model model, String proid) {
        String hcxmlx = this.workFlowService.getHcxmlx(proid);
        SwHcXmRwRel swHcXmRwRel = this.hcxmService.getCurSwHcXmRwRelByProid(proid);
        String bdId = swHcXmRwRel.getBdId();
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            queryConditionList.add(new QueryCondition("QLR_ID", "=", (Object)bdId));
        } else {
            queryConditionList.add(new QueryCondition("JBB_ID", "=", (Object)bdId));
        }
        List zdList = this.tjService.getTjList("zdList", queryConditionList);
        ArrayList<String> djhList = new ArrayList<String>();
        for (HashMap hashMap : zdList) {
            if (hashMap.get("DJH") == null) continue;
            djhList.add(hashMap.get("DJH").toString());
        }
        List swDjSyTempList = new ArrayList();
        swDjSyTempList = this.syhcService.getSyxx(swHcXmRwRel.getShxrId());
        String tdsTempIds = "";
        String fcsTempIds = "";
        String djh = null;
        for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
            if (!swDjSyTemp.getSyzt().equals(Syzt.ZC.toString())) continue;
            if (swDjSyTemp.getZd() != null && djhList.indexOf(djh = swDjSyTemp.getZd().getDjh()) > -1) {
                djhList.remove(djh);
            }
            if (swDjSyTemp.getSwDjTdTemp() != null) {
                if (!tdsTempIds.equals("")) {
                    tdsTempIds = tdsTempIds + ",";
                }
                tdsTempIds = tdsTempIds + swDjSyTemp.getTempId();
            }
            if (swDjSyTemp.getSwDjFcTemp() == null) continue;
            if (!fcsTempIds.equals("")) {
                fcsTempIds = fcsTempIds + ",";
            }
            fcsTempIds = fcsTempIds + swDjSyTemp.getTempId();
        }
        String zddjhs = "";
        for (String zddjh : djhList) {
            if (!zddjhs.equals("")) {
                zddjhs = zddjhs + ",";
            }
            zddjhs = zddjhs + zddjh;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("zddjh", zddjhs);
        data.put("tdsTempId", tdsTempIds);
        data.put("fcsTempId", fcsTempIds);
        return data;
    }
}

