/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.util;

import cn.gtmap.landtax.util.CommonUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectValueManager
implements Serializable {
    private static final String MSG_NULLOBJECT = "\u5bf9\u8c61\u4e3a\u7a7a";
    private static final String MSG_OUTBOUND = "\u7d22\u5f15\u8d85\u51fa\u8303\u56f4";
    private static final String CLASS_PATH = "cn.gtmap";
    private List<Object> objectList;
    private HashMap<String, Method> methodHashMap;

    public ObjectValueManager(Object o) throws Exception {
        this.checkNullObject(o);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(o);
        this.objectList = list;
        this.initObjectMethodFactory();
    }

    public ObjectValueManager(List<Object> list) throws Exception {
        this.checkNullObject(list);
        this.objectList = list;
        this.initObjectMethodFactory();
    }

    public String getObjectValue(String fieldName) {
        return this.getObjectValue(fieldName, Integer.valueOf(0));
    }

    public String getObjectValue(String fieldName, Integer index) {
        String fieldValue = null;
        try {
            Object o = this.getObject(index);
            String[] fieldNames = fieldName.split("\\.");
            fieldName = "";
            Object fieldValueObject = null;
            for (int i = 0; i < fieldNames.length; ++i) {
                Method method;
                if (fieldName != "") {
                    fieldName = fieldName + ".";
                }
                if ((method = (Method)this.methodHashMap.get(fieldName = fieldName + fieldNames[i])) == null || o == null) {
                    return null;
                }
                o = fieldValueObject = method.invoke(o, null);
            }
            fieldValue = this.objectToString(fieldValueObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldValue;
    }

    private void checkNullObject(Object o) throws Exception {
        if (o == null) {
            throw new Exception("\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }

    private void checkNullObject(List<Object> list) throws Exception {
        if (CollectionUtils.isEmpty(list)) {
            throw new Exception("\u5bf9\u8c61\u4e3a\u7a7a");
        }
        this.checkNullObject(list.get(0));
    }

    private void initObjectMethodFactory() {
        this.methodHashMap = new HashMap();
        if (CollectionUtils.isEmpty((Collection)this.objectList)) {
            return;
        }
        Object o = this.objectList.get(0);
        if (o == null) {
            return;
        }
        this.initObjectMethodFactory(o, null);
    }

    private void initObjectMethodFactory(Object o, String parentName) {
        if (o == null) {
            return;
        }
        List fieldList = ObjectValueManager.findObjectFieldList((Object)o);
        if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
            for (Field field : fieldList) {
                String classType = field.getGenericType().toString();
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method method = this.getMethod(o, getMethodName);
                if (method != null) {
                    this.methodHashMap.put(StringUtils.isEmpty((String)parentName) ? fieldName : parentName + "." + fieldName, method);
                }
                if (!classType.startsWith("class cn.gtmap")) continue;
                try {
                    Object fieldObject = Class.forName(classType.substring(6)).newInstance();
                    this.initObjectMethodFactory(fieldObject, StringUtils.isEmpty((String)parentName) ? fieldName : parentName + "." + fieldName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Method getMethod(Object o, String methodName) {
        Method method = null;
        try {
            method = o.getClass().getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            methodName = "get" + methodName.substring(3, 4).toLowerCase() + methodName.substring(4, methodName.length());
            try {
                method = o.getClass().getMethod(methodName, new Class[0]);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
        }
        return method;
    }

    private Object getObject(Integer index) throws Exception {
        if (index == null || index < 0 || index >= this.objectList.size()) {
            throw new Exception("\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
        }
        Object o = this.objectList.get(index);
        return o;
    }

    private String objectToString(Object o) {
        String value = null;
        String fieldType = "";
        if (o == null) {
            return null;
        }
        fieldType = o.getClass().getSimpleName();
        if (fieldType.equals("String")) {
            value = (String)o;
        } else if (fieldType.equals("int")) {
            int temp = (Integer)o;
            value = Integer.toString(temp);
        } else if (fieldType.equals("Boolean")) {
            Boolean temp = (Boolean)o;
            value = Boolean.toString(temp);
        } else if (fieldType.equals("float")) {
            float temp = ((Float)o).floatValue();
            value = Float.toString(temp);
        } else if (fieldType.equalsIgnoreCase("double")) {
            double temp = (Double)o;
            value = CommonUtil.DoubleToString((Double)temp, (Integer)4, (boolean)false);
        } else if (fieldType.equals("BigDecimal")) {
            BigDecimal temp = (BigDecimal)o;
            value = temp.toString();
        } else if (fieldType.equals("Long")) {
            long temp = (Long)o;
            value = Long.toString(temp);
        } else if (fieldType.equals("short")) {
            short temp = (Short)o;
            value = Short.toString(temp);
        } else if (fieldType.equals("byte")) {
            byte temp = (Byte)o;
            value = Byte.toString(temp);
        } else if (fieldType.equals("Integer")) {
            Integer tempInt = (Integer)o;
            value = String.valueOf(tempInt);
        } else if (fieldType.equals("Date") || fieldType.equals("Timestamp")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date tempInt = (Date)o;
            value = String.valueOf(sdf.format(tempInt));
        } else {
            value = "";
        }
        return value;
    }

    public static List<Field> findObjectFieldList(Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fieldArr = null;
        fieldArr = o.getClass().getDeclaredFields();
        fieldList.addAll(Arrays.asList(fieldArr));
        for (Class<?> superClazz = o.getClass().getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
            fieldArr = superClazz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fieldArr));
        }
        return fieldList;
    }

    public HashMap<String, Method> getMethodHashMap() {
        return this.methodHashMap;
    }
}

