/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.support.jpa;

import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.jpa.BaseRepositoryCustomFetch;
import cn.gtmap.landtax.util.QueryCondition;
import com.google.common.collect.Lists;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

@Repository
public class BaseRepositoryImpl
implements BaseRepository {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    public BaseRepositoryCustomFetch baseRepositoryCustomFetch;
    private List<EntityPath> entityPathList = Lists.newLinkedList();

    public <T> T get(Class<T> clazz, Object id) {
        return (T)this.entityManager.find(clazz, id);
    }

    public <T> void delete(Class<T> clazz, Object id) {
        Object entity;
        if (id != null && (entity = this.get(clazz, id)) != null) {
            this.delete(entity);
        }
    }

    public <T> void delete(Class<T> clazz, Object[] ids) {
        if (ids != null) {
            for (Object id : ids) {
                this.delete(clazz, id);
            }
        }
    }

    public <T> void delete(Object entity) {
        this.entityManager.remove(entity);
    }

    public <T> List<T> dslList(EntityPath<T> entityPath) {
        return ((JPAQuery)new JPAQuery(this.entityManager).from(entityPath)).list(entityPath);
    }

    public List<Object> dslList(JPQLQuery query, Expression expression) {
        return query.list(expression);
    }

    public <T> List<T> dslList(EntityPath<T> entityPath, Expression<T> expression) {
        return expression != null ? ((JPAQuery)new JPAQuery(this.entityManager).from(entityPath)).list(expression) : this.dslList(entityPath);
    }

    public <T> List<T> dslList(EntityPath<T> entityPath, Expression<T> expression, Predicate ... predicates) {
        JPAQuery jpaQuery = (JPAQuery)new JPAQuery(this.entityManager).from(entityPath);
        if (predicates != null) {
            jpaQuery = (JPAQuery)jpaQuery.where(predicates);
        }
        return expression != null ? jpaQuery.list(expression) : jpaQuery.list(entityPath);
    }

    public <T> List<T> sql(String sql) {
        return this.entityManager.createNativeQuery(sql).getResultList();
    }

    public <T> List<T> sql(String sql, Class<T> clazz) {
        return this.entityManager.createNativeQuery(sql, clazz).getResultList();
    }

    public void save(Object entity) {
        this.entityManager.persist(entity);
    }

    public void update(Object entity) {
        this.entityManager.merge(entity);
    }

    public Object get(JPQLQuery query) {
        return this.get(query, null);
    }

    public Object get(JPQLQuery query, Expression expression) {
        return query.uniqueResult(expression);
    }

    public <T> List<T> find(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy, int currentPage, int pageSize) {
        Query query = this.getQuery(clazz, queryConditions, orderBy, false);
        if (currentPage == 0 && pageSize == 0) {
            return query.getResultList();
        }
        return query.setFirstResult((currentPage - 1) * pageSize).setMaxResults(pageSize).getResultList();
    }

    public <T> PageImpl<T> find(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy, Pageable pageable) {
        Query query = this.getQuery(clazz, queryConditions, orderBy, false);
        if (pageable.getPageNumber() == 0 && pageable.getPageSize() == 0) {
            List resultList = query.getResultList();
            return new PageImpl(resultList, pageable, (long)resultList.size());
        }
        return new PageImpl(query.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize()).setMaxResults(pageable.getPageSize()).getResultList(), pageable, this.getRecordCount(clazz, queryConditions));
    }

    public <T> PageImpl<T> find(EntityPath<T> entityPath, Pageable pageable, Predicate ... predicates) {
        return this.find(entityPath, pageable, null, predicates);
    }

    public <T> PageImpl<T> find(EntityPath entityPath, Pageable pageable, Expression expression, Predicate ... predicates) {
        JPAQuery jpaQuery;
        JPAQuery jPAQuery = jpaQuery = predicates != null ? (JPAQuery)((JPAQuery)new JPAQuery(this.entityManager).from(entityPath)).where(predicates) : (JPAQuery)new JPAQuery(this.entityManager).from(entityPath);
        if (pageable.getSort() != null) {
            this.addEntityPath(new EntityPath[]{entityPath});
            jpaQuery = this.applySorting(pageable.getSort(), (JPQLQuery)jpaQuery);
        }
        List resultList = null;
        if (pageable.getPageNumber() == 0 && pageable.getPageSize() == 0) {
            resultList = expression != null ? jpaQuery.list(expression) : jpaQuery.list((Expression)entityPath);
            return new PageImpl(resultList, pageable, (long)resultList.size());
        }
        resultList = expression != null ? ((JPQLQuery)((JPQLQuery)jpaQuery.offset((long)(pageable.getOffset() - pageable.getPageSize()))).limit((long)pageable.getPageSize())).list(expression) : ((JPQLQuery)((JPQLQuery)jpaQuery.offset((long)((pageable.getPageNumber() - 1) * pageable.getPageSize()))).limit((long)pageable.getPageSize())).list((Expression)entityPath);
        return new PageImpl(resultList, pageable, jpaQuery.count());
    }

    public <T> Page<T> find(JPQLQuery jpaQuery, Expression expression, Pageable pageable) {
        return this.find(jpaQuery, expression, null, pageable);
    }

    public <T> Page<T> find(JPQLQuery jpaQuery, Expression expression, Query countQuery, Pageable pageable) {
        List resultList = null;
        if (pageable.getSort() != null) {
            jpaQuery = this.applySorting(pageable.getSort(), jpaQuery);
        }
        if (pageable.getPageNumber() == 0 && pageable.getPageSize() == 0) {
            resultList = expression != null ? jpaQuery.list(expression) : jpaQuery.list(new Expression[0]);
            return new PageImpl(resultList, pageable, (long)resultList.size());
        }
        resultList = expression != null ? ((JPQLQuery)((JPQLQuery)jpaQuery.offset((long)((pageable.getPageNumber() - 1) * pageable.getPageSize()))).limit((long)pageable.getPageSize())).list(expression) : ((JPQLQuery)((JPQLQuery)jpaQuery.offset((long)((pageable.getPageNumber() - 1) * pageable.getPageSize()))).limit((long)pageable.getPageSize())).list(new Expression[0]);
        long totalCount = countQuery != null ? this.getRecordCount(countQuery) : ((JPQLQuery)jpaQuery.distinct()).count();
        return new PageImpl(resultList, pageable, totalCount);
    }

    public <T> Page<T> find(Query query, Query countQuery, Pageable pageable) {
        List resultList = null;
        if (pageable.getPageNumber() == 0 && pageable.getPageSize() == 0) {
            resultList = query.getResultList();
            return new PageImpl(resultList, pageable, (long)resultList.size());
        }
        return new PageImpl(query.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize()).setMaxResults(pageable.getPageSize()).getResultList(), pageable, this.getRecordCount(countQuery));
    }

    private Query getQuery(Class clazz, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        String className = clazz.getSimpleName();
        String preJPQL = isQueryTotal ? "select count(*) from " : "select o from ";
        StringBuffer jpql = new StringBuffer(preJPQL);
        jpql.append(className).append(" as o ");
        if (!isQueryTotal) {
            String joinSql = this.getJoinSql(className, "o", null);
            jpql.append(joinSql).append(" ");
        }
        jpql.append("where 1=1 ");
        Query query = null;
        if (queryConditions != null && queryConditions.size() > 0) {
            for (QueryCondition queryCondition : queryConditions) {
                if (queryCondition == null) continue;
                if (queryCondition.getOperator().equals("custom")) {
                    jpql.append(" and (").append(queryCondition.getCustomJPQL()).append(")");
                }
                if (queryCondition.getValue() == null || "".equals(queryCondition.getValue())) continue;
                String placeholder = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                String operator = queryCondition.getOperator();
                if (operator.equals("llike") || operator.equals("rlike")) {
                    operator = "like";
                }
                jpql.append(" and o.").append(queryCondition.getField().trim()).append(" ").append(operator).append(":").append(placeholder.trim());
            }
        }
        if (orderBy != null && !"".equals(orderBy)) {
            jpql.append(" ").append(orderBy);
        }
        query = this.entityManager.createQuery(jpql.toString());
        if (queryConditions != null && queryConditions.size() > 0) {
            for (QueryCondition queryCondition : queryConditions) {
                String queryConditionField;
                if (queryCondition == null || queryCondition.getValue() == null || "".equals(queryCondition.getValue())) continue;
                String string = queryConditionField = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                if (queryCondition.getOperator().equals("like")) {
                    query.setParameter(queryConditionField, (Object)("%" + queryCondition.getValue() + "%"));
                    continue;
                }
                if (queryCondition.getOperator().equals("llike")) {
                    query.setParameter(queryConditionField, (Object)(queryCondition.getValue() + "%"));
                    continue;
                }
                if (queryCondition.getOperator().equals("rlike")) {
                    query.setParameter(queryConditionField, (Object)("%" + queryCondition.getValue()));
                    continue;
                }
                query.setParameter(queryConditionField, queryCondition.getValue());
            }
        }
        return query;
    }

    private String getJoinSql(String clazzName, String aliasName, List<String> joinedLsit) {
        List fetchSubEntityList;
        String joinSql = "";
        if (joinedLsit == null) {
            joinedLsit = new ArrayList<String>();
            joinedLsit.add(clazzName);
        }
        if (CollectionUtils.isNotEmpty((Collection)(fetchSubEntityList = this.baseRepositoryCustomFetch.getSubEntityFetchMap(clazzName)))) {
            for (String subEntityName : fetchSubEntityList) {
                if (joinedLsit.indexOf(subEntityName) != -1) continue;
                String subAliasName = subEntityName.substring(0, 1).toLowerCase() + subEntityName.substring(1);
                String fullName = aliasName + "." + subAliasName;
                joinSql = joinSql + " left join fetch " + fullName + " as " + subAliasName;
                joinSql = joinSql + this.getJoinSql(subEntityName, subAliasName, joinedLsit);
            }
        }
        return joinSql;
    }

    public <T> List<T> list(Class<T> clazz, List<QueryCondition> queryConditions) {
        return this.find(clazz, queryConditions, null, 0, 0);
    }

    public <T> List<T> list(Class<T> clazz, List<QueryCondition> queryConditions, String orderBy) {
        return this.find(clazz, queryConditions, orderBy, 0, 0);
    }

    public <T> List<T> list(CriteriaQuery<T> criteriaQuery) {
        return this.entityManager.createQuery(criteriaQuery).getResultList();
    }

    public Object getSingleResult(Class clazz, List<QueryCondition> queryConditions) {
        Query query = this.getQuery(clazz, queryConditions, null, false);
        return query.getSingleResult();
    }

    public long getRecordCount(Class clazz, List<QueryCondition> queryConditions) {
        Query query = this.getQuery(clazz, queryConditions, null, true);
        return this.getRecordCount(query);
    }

    public long getRecordCount(Query query) {
        long recordCount = 0L;
        Object result = query.getSingleResult();
        if (result != null) {
            if (result instanceof Long) {
                recordCount = (Long)result;
            } else if (result instanceof BigDecimal) {
                recordCount = ((BigDecimal)result).longValue();
            }
        }
        return recordCount;
    }

    public <T> List<T> getByJpql(String jpql, Object ... objects) {
        Query query = this.entityManager.createQuery(jpql);
        if (objects != null && objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        return query.getResultList();
    }

    public int executeJpql(String jpql, Object ... objects) {
        Query query = this.entityManager.createQuery(jpql);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        return query.executeUpdate();
    }

    public Object getUniqueResultByJpql(String jpql, Object ... objects) {
        Query query = this.entityManager.createQuery(jpql);
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                query.setParameter(i, objects[i]);
            }
        }
        try {
            return query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private JPQLQuery applySorting(Sort sort, JPQLQuery query) {
        if (sort == null) {
            return query;
        }
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrder(order)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrder(Sort.Order order) {
        Expression property = this.getOrderExpression(order.getProperty());
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, property);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    private PathBuilder getBuilder(String property) {
        for (EntityPath entityPath : this.entityPathList) {
            PathBuilder tmpBuilder = new PathBuilder(entityPath.getType(), entityPath.getMetadata());
            if (tmpBuilder.get(property) == null) continue;
            return tmpBuilder;
        }
        return null;
    }

    private Expression<Object> getOrderExpression(String property) {
        for (EntityPath entityPath : this.entityPathList) {
            PathBuilder tmpBuilder = new PathBuilder(entityPath.getType(), entityPath.getMetadata());
            if (this.getClassField(entityPath.getType(), property) == null) continue;
            return tmpBuilder.get(property);
        }
        return null;
    }

    public void addEntityPath(EntityPath ... entityPaths) {
        this.entityPathList.clear();
        for (EntityPath entityPath : entityPaths) {
            if (this.entityPathList.contains(entityPath)) continue;
            this.entityPathList.add(entityPath);
        }
    }

    public Field getClassField(Class clazz, String name) {
        Class superClazz = clazz.getSuperclass();
        try {
            return superClazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e1) {
                return null;
            }
        }
    }
}

