/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SSjZdbg;
import cn.gtmap.landtax.entity.SSjZdbgAnaly;
import cn.gtmap.landtax.entity.SSjZdbgDobg;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.entity.ZdHistory;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.service.ZdbgService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZdbgServiceImpl
implements ZdbgService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DicService dicService;
    @Autowired
    TaxService taxService;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    SysUserService sysUserService;

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public List<SSjZdbg> findZdBgList(Date startDate, Date endDate) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("bgrq", ">=", (Object)startDate));
        queryConditionList.add(new QueryCondition("bgrq", "<=", (Object)endDate));
        List sSjZdbgList = this.baseRepository.list(SSjZdbg.class, queryConditionList);
        return sSjZdbgList;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public List<HashMap> findZdBgChangeMap(Date startDate, Date endDate) {
        String sql = "WITH S_SJ_ZDBG_FIND AS (   SELECT t.*   FROM S_SJ_ZDBG t   WHERE TO_CHAR(t.BGRQ, 'yyyymmdd') <=TO_CHAR(SYSDATE - 1, 'yyyymmdd') AND TO_CHAR(t.BGRQ, 'yyyymmdd') BETWEEN :GEDATE AND :LEDATE ), S_SJ_ZDBG_QUERY AS (   SELECT t.*   FROM S_SJ_ZDBG_FIND t   WHERE NOT EXISTS (SELECT * FROM S_SJ_ZDBG_FIND t1 WHERE t.BGBH=t1.BGBH AND t1.BGFS!=t.BGFS)         AND NOT EXISTS (SELECT * FROM S_SJ_ZDBG_FIND t1 WHERE t.DJH_NEW=t1.DJH_OLD AND t.BGFS='\u5c5e\u6027\u53d8\u66f4' AND t1.BGBH>t.BGBH)         AND NOT EXISTS (SELECT * FROM S_SJ_ZDBG_FIND t1 WHERE t.BGBH=t1.BGBH AND t.BGFS='\u5b97\u5730\u7efc\u5408\u53d8\u66f4'                                                                    AND ((t.DJH_NEW=t1.DJH_OLD AND t1.DJH_OLD IS NOT NULL) OR (t1.DJH_NEW=t.DJH_OLD AND t1.DJH_NEW IS NOT NULL))) ) SELECT t.* FROM (       SELECT t.*,              CASE                WHEN t.PDJH IS NULL THEN                  CASE                    WHEN (t.TDYT IN ('071','072')) THEN                      '\u65b0\u589e\u514d\u7a0e\u5b97\u5730'                    ELSE                      '\u65b0\u589e\u5e94\u7a0e\u5b97\u5730'                  END                WHEN (t1.TDYT IS NULL OR t1.TDYT IN ('071','072')) THEN                  CASE                    WHEN (t.TDYT IS NULL) THEN                      '\u514d\u7a0e\u5b97\u5730\u706d\u5931'                    WHEN (t.TDYT IN ('071','072')) THEN                      '\u514d\u7a0e\u5b97\u5730\u8f6c\u514d\u7a0e\u5b97\u5730'                    ELSE                      '\u514d\u7a0e\u5b97\u5730\u8f6c\u5e94\u7a0e\u5b97\u5730'                  END                ELSE                  CASE                    WHEN (t.TDYT IS NULL) THEN                      '\u5e94\u7a0e\u5b97\u5730\u706d\u5931'                    WHEN (t.TDYT IN ('071','072')) THEN                      '\u5e94\u7a0e\u5b97\u5730\u8f6c\u514d\u7a0e\u5b97\u5730'                    ELSE                      '\u5e94\u7a0e\u5b97\u5730\u8f6c\u5e94\u7a0e\u5b97\u5730'                  END              END              AS BGLX       FROM (             SELECT CONNECT_BY_ISLEAF, CONNECT_BY_ROOT DJH_OLD AS PDJH, SYS_CONNECT_BY_PATH(BGBH,',') AS BGBHLIST,                    t.*             FROM S_SJ_ZDBG_QUERY t             WHERE CONNECT_BY_ISLEAF IN ('1')             START WITH (NOT EXISTS (SELECT t1.* FROM S_SJ_ZDBG_QUERY t1 WHERE t.DJH_OLD=t1.DJH_NEW AND t.BGBH > t1.BGBH) OR t.DJH_OLD IS NULL)             CONNECT BY (t.DJH_OLD=PRIOR t.DJH_NEW  AND t.BGBH > PRIOR t.BGBH)            ) t            LEFT JOIN ZD t1 ON t.PDJH=t1.DJH      ) t WHERE BGLX NOT IN ('\u514d\u7a0e\u5b97\u5730\u706d\u5931', '\u514d\u7a0e\u5b97\u5730\u8f6c\u514d\u7a0e\u5b97\u5730', '\u65b0\u589e\u514d\u7a0e\u5b97\u5730') ORDER BY BGBH DESC";
        Query query = this.baseRepository.getEntityManager().createNativeQuery(sql);
        query.setParameter("GEDATE", (Object)(startDate != null ? new SimpleDateFormat("yyyyMMdd").format(startDate) : "20150101"));
        if (endDate == null) {
            endDate = Calendar.getInstance().getTime();
        }
        query.setParameter("LEDATE", (Object)new SimpleDateFormat("yyyyMMdd").format(endDate));
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();
    }

    @Transactional
    public void bgZd(String bgAnalyProid) {
        if (StringUtils.isBlank((String)bgAnalyProid)) {
            return;
        }
        SSjZdbgAnaly sSjZdbgAnaly = (SSjZdbgAnaly)this.baseRepository.get(SSjZdbgAnaly.class, (Object)bgAnalyProid);
        if (sSjZdbgAnaly == null) {
            return;
        }
        Zd zdOld = null;
        Zd zdNew = null;
        if (StringUtils.isNotEmpty((String)sSjZdbgAnaly.getDjhBefore()) && (zdOld = (Zd)this.baseRepository.get(Zd.class, (Object)sSjZdbgAnaly.getDjhBefore())) != null) {
            ZdHistory zdHistory = new ZdHistory();
            try {
                BeanUtils.copyProperties((Object)zdHistory, (Object)zdOld);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            zdHistory.setDjhNew(sSjZdbgAnaly.getsSjZdbg().getDjhNew());
            zdHistory.setUserid(SessionUtil.getCurrentUserId());
            zdHistory.setUsername(SessionUtil.getCurrentUser().getUsername());
            zdHistory.setGxrq(Calendar.getInstance().getTime());
            zdHistory.setHisId(UUIDGenerator.generate());
            this.baseRepository.save((Object)zdHistory);
        }
        if (StringUtils.isNotEmpty((String)sSjZdbgAnaly.getsSjZdbg().getDjhNew())) {
            zdNew = (Zd)this.baseRepository.get(Zd.class, (Object)sSjZdbgAnaly.getsSjZdbg().getDjhNew());
            if (zdNew == null) {
                zdNew = new Zd();
                zdNew.setDjh(sSjZdbgAnaly.getsSjZdbg().getDjhNew());
                this.updateBgInfo(zdNew, sSjZdbgAnaly.getsSjZdbg());
                if (zdOld != null) {
                    zdNew.setTddj(zdOld.getTddj());
                    zdNew.setSgqdm(zdOld.getSgqdm());
                    zdNew.setZdlx(zdOld.getZdlx());
                    zdNew.setXzqdm(zdOld.getXzqdm());
                }
                this.setZdOtherInfo(zdNew);
                this.baseRepository.save((Object)zdNew);
            } else {
                this.updateBgInfo(zdNew, sSjZdbgAnaly.getsSjZdbg());
                this.baseRepository.update((Object)zdNew);
            }
            if (zdNew.getTdyt() == null || zdNew.getTdyt().equals("071") || zdNew.getTdyt().equals("072")) {
                this.baseRepository.delete((Object)zdNew);
            }
        }
        if (!(zdOld == null || zdNew != null && zdOld.getDjh().equalsIgnoreCase(zdNew.getDjh()))) {
            this.baseRepository.delete((Object)zdOld);
        }
    }

    @Transactional
    public String analyZdBgData(Date startDate, Date endDate) {
        List zdbgChangeMap = this.findZdBgChangeMap(startDate, endDate);
        if (CollectionUtils.isEmpty((Collection)zdbgChangeMap)) {
            return null;
        }
        String bgbhStr = null;
        ArrayList<String> bgbhList = new ArrayList<String>();
        String groupid = null;
        HashMap<String, String> bgbhGroup = new HashMap<String, String>();
        SSjZdbgDobg sSjZdbgDobg = this.doZdbg(startDate, endDate);
        if (sSjZdbgDobg == null) {
            return null;
        }
        for (HashMap hashMap : zdbgChangeMap) {
            bgbhStr = hashMap.get("BGBHLIST").toString();
            bgbhList.clear();
            bgbhList.addAll(Arrays.asList(bgbhStr.split(",")));
            bgbhList.remove(0);
            groupid = null;
            for (String bgbh : bgbhList) {
                if (bgbhGroup.get(bgbh) == null) continue;
                groupid = (String)bgbhGroup.get(bgbh);
                break;
            }
            if (StringUtils.isBlank(groupid)) {
                groupid = UUIDGenerator.generate();
            }
            for (String bgbh : bgbhList) {
                if (bgbhGroup.get(bgbh) != null) continue;
                bgbhGroup.put(bgbh, groupid);
            }
            SSjZdbgAnaly sSjZdbgAnaly = new SSjZdbgAnaly();
            sSjZdbgAnaly.setProid(UUIDGenerator.generate());
            sSjZdbgAnaly.setGroupid(groupid);
            sSjZdbgAnaly.setDjhBefore(hashMap.get("PDJH") == null ? null : hashMap.get("PDJH").toString());
            SSjZdbg sSjZdbg = (SSjZdbg)this.baseRepository.get(SSjZdbg.class, (Object)hashMap.get("PROJECTID").toString());
            sSjZdbgAnaly.setsSjZdbg(sSjZdbg);
            sSjZdbgAnaly.setsSjZdbgDobg(sSjZdbgDobg);
            sSjZdbgAnaly.setBglx(hashMap.get("BGLX") == null ? null : hashMap.get("BGLX").toString());
            sSjZdbgAnaly.setClzt("0");
            this.baseRepository.save((Object)sSjZdbgAnaly);
            this.bgZd(sSjZdbgAnaly.getProid());
        }
        return sSjZdbgDobg.getProid();
    }

    private SSjZdbgDobg doZdbg(Date startDate, Date endDate) {
        SSjZdbgDobg sSjZdbgDobg = this.findZdbgDobg(startDate, endDate);
        if (sSjZdbgDobg != null) {
            return sSjZdbgDobg;
        }
        if (startDate == null && endDate == null) {
            return null;
        }
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("bgEnd", ">=", (Object)startDate));
        List list = this.baseRepository.list(SSjZdbgDobg.class, queryConditionList);
        if (CollectionUtils.isEmpty((Collection)list)) {
            sSjZdbgDobg = new SSjZdbgDobg();
            sSjZdbgDobg.setProid(UUIDGenerator.generate());
            sSjZdbgDobg.setBgBegin(startDate);
            sSjZdbgDobg.setBgEnd(endDate);
            sSjZdbgDobg.setCzrq(Calendar.getInstance().getTime());
            UserInfo userInfo = SessionUtil.getCurrentUser();
            sSjZdbgDobg.setUserid(userInfo.getId());
            sSjZdbgDobg.setUsername(userInfo.getUsername());
            this.baseRepository.save((Object)sSjZdbgDobg);
        }
        return sSjZdbgDobg;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public List<SSjZdbgAnaly> findZdbgAnaly(Date startDate, Date endDate) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("analyBegin", ">=", (Object)startDate));
        queryConditionList.add(new QueryCondition("analyEnd", "<=", (Object)endDate));
        String orderBy = " order by sSjZdbg.bgbh";
        List sSjZdbgAnalyList = this.baseRepository.list(SSjZdbgAnaly.class, queryConditionList, orderBy);
        return sSjZdbgAnalyList;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public SSjZdbgDobg findZdbgDobg(Date startDate, Date endDate) {
        SSjZdbgDobg sSjZdbgDobg = null;
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("bgBegin", "=", (Object)startDate));
        queryConditionList.add(new QueryCondition("bgEnd", "=", (Object)endDate));
        List list = this.baseRepository.list(SSjZdbgDobg.class, queryConditionList);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sSjZdbgDobg = (SSjZdbgDobg)list.get(0);
        }
        return sSjZdbgDobg;
    }

    @Transactional
    public void refreshZdSwRelation(String dobgid) {
        String zdgx = "\u81ea\u52a8\u53d8\u66f4\u7a0e\u52a1\u6570\u636e";
        String cjhcrw = "\u521b\u5efa\u6838\u67e5\u4efb\u52a1\u4e0b\u53d1";
        String sql = "SELECT DISTINCT t.GROUPID,        CASE          WHEN t.DJH_NEW_CNT=1 AND t.DJH_BEFORE_CNT>0 THEN            :zdgx          ELSE            :cjhcrw        END        AS CLFS FROM (       SELECT t1.GROUPID, t1.DOBGID,              COUNT(DISTINCT DECODE(SUBSTR(t1.BGLX, 1, 4), '\u5e94\u7a0e\u5b97\u5730', t1.DJH_BEFORE, NULL)) OVER(PARTITION BY GROUPID) AS DJH_BEFORE_CNT,              COUNT(DISTINCT DECODE(SUBSTR(t1.BGLX, LENGTH(BGLX)-4+1, 4), '\u5e94\u7a0e\u5b97\u5730', t2.DJH_NEW, NULL)) OVER(PARTITION BY GROUPID) AS DJH_NEW_CNT       FROM S_SJ_ZDBG_ANALY t1            LEFT JOIN S_SJ_ZDBG t2 ON t1.BGPROID=t2.PROJECTID      ) t WHERE t.DOBGID=:dobgid ";
        Query query = this.baseRepository.getEntityManager().createNativeQuery(sql);
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        query.setParameter("dobgid", (Object)dobgid);
        query.setParameter("zdgx", (Object)zdgx);
        query.setParameter("cjhcrw", (Object)cjhcrw);
        List list = query.getResultList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ArrayList<String> djhOldList = new ArrayList<String>();
        ArrayList<String> djhNewList = new ArrayList<String>();
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        List sSjZdbgAnalyList = null;
        List swDjSyList = null;
        List toUserList = null;
        for (HashMap hashMap : list) {
            String groupid = hashMap.get("GROUPID").toString();
            String clfs = hashMap.get("CLFS").toString();
            queryConditionList.clear();
            queryConditionList.add(new QueryCondition("groupid", "=", (Object)groupid));
            sSjZdbgAnalyList = this.baseRepository.list(SSjZdbgAnaly.class, queryConditionList);
            djhOldList.clear();
            djhNewList.clear();
            for (SSjZdbgAnaly sSjZdbgAnaly : sSjZdbgAnalyList) {
                String bglx = sSjZdbgAnaly.getBglx();
                String djh = sSjZdbgAnaly.getDjhBefore();
                if (StringUtils.isNotBlank((String)djh) && bglx.startsWith("\u5e94\u7a0e\u5b97\u5730") && djhOldList.indexOf(djh) == -1) {
                    djhOldList.add(djh);
                }
                if (!StringUtils.isNotBlank((String)(djh = sSjZdbgAnaly.getsSjZdbg().getDjhNew())) || !bglx.endsWith("\u5e94\u7a0e\u5b97\u5730") || djhNewList.indexOf(djh) != -1) continue;
                djhNewList.add(djh);
            }
            String djhFilterStr = "";
            for (int i = 0; i < djhOldList.size(); ++i) {
                if (djhFilterStr != "") {
                    djhFilterStr = djhFilterStr + "','";
                }
                djhFilterStr = djhFilterStr + (String)djhOldList.get(i);
            }
            djhFilterStr = "'" + djhFilterStr + "'";
            queryConditionList.clear();
            queryConditionList.add(new QueryCondition("zd.djh in (" + djhFilterStr + ")"));
            swDjSyList = this.baseRepository.list(SwDjSy.class, queryConditionList);
            if (clfs.equals(zdgx)) {
                Zd zd = (Zd)this.baseRepository.get(Zd.class, djhNewList.get(0));
                for (SwDjSy swDjSy : swDjSyList) {
                    swDjSy.setZd(zd);
                    swDjSy.setBz("\u5b97\u5730\u6570\u636e\u66f4\u65b0");
                    this.taxService.addSwDjSyUpdateInfo(swDjSy, Czlx.UPDATE.toString());
                    this.taxService.updateSwDjSy(swDjSy);
                }
                continue;
            }
            String wiid = this.workFlowService.wfCreateZdgxhc(Hcxmlx.ZDGXHC.toString(), groupid, swDjSyList);
            if (toUserList == null) {
                PerformerTaskModel result = null;
                try {
                    result = this.workFlowService.getTurnUserList(SessionUtil.getCurrentUserId(), wiid);
                    toUserList = result.getUserList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String fjdm = "";
            if (CollectionUtils.isNotEmpty((Collection)swDjSyList)) {
                fjdm = ((SwDjSy)swDjSyList.get(0)).getZd().getSgqdm();
            } else {
                Zd zd = (Zd)this.baseRepository.get(Zd.class, djhNewList.get(0));
                if (zd != null) {
                    fjdm = zd.getSgqdm();
                }
            }
            if (wiid.startsWith("java.lang:") || fjdm == "") continue;
            String toUserId = "";
            for (PfUserVo pfUserVo : toUserList) {
                String regionCode = this.sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                if (regionCode.length() > 8) {
                    regionCode = regionCode.substring(0, 8);
                }
                if (!regionCode.startsWith(fjdm)) continue;
                toUserId = pfUserVo.getUserId();
                break;
            }
            this.workFlowService.autoTurnWorkflow(wiid, toUserId);
        }
    }

    private void updateBgInfo(Zd zd, SSjZdbg sSjZdbg) {
        if (zd == null) {
            zd = new Zd();
        }
        if (sSjZdbg == null) {
            return;
        }
        if (sSjZdbg.getDjhNew() != null) {
            zd.setDjh(sSjZdbg.getDjhNew());
        }
        if (sSjZdbg.getQlrmc() != null) {
            zd.setQlrmc(sSjZdbg.getQlrmc());
        }
        if (sSjZdbg.getScmj() != null) {
            zd.setScmj(sSjZdbg.getScmj());
        }
        if (sSjZdbg.getTdzl() != null) {
            zd.setTdzl(sSjZdbg.getTdzl());
        }
        if (sSjZdbg.getTdyt() != null) {
            zd.setTdyt(sSjZdbg.getTdyt());
            try {
                zd.setTdytmc(this.dicService.findMcByDm("Dldm", sSjZdbg.getTdyt()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setZdOtherInfo(Zd zd) {
        if (zd == null) {
            return;
        }
        String djh = zd.getDjh();
        if (StringUtils.isBlank((String)djh)) {
            return;
        }
        if (zd.getTddj() == null || zd.getSgqdm() == null) {
            String sql = "SELECT t.* FROM S_DM_ZDSX t WHERE t.DM=:XZDM";
            Query query = this.baseRepository.getEntityManager().createNativeQuery(sql);
            ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            query.setParameter("XZDM", (Object)djh.substring(0, 9));
            List list = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                HashMap hashMap = (HashMap)list.get(0);
                if (zd.getTddj() == null) {
                    zd.setTddj((String)hashMap.get("TDDJ"));
                }
                if (zd.getSgqdm() == null) {
                    zd.setSgqdm((String)hashMap.get("SGQDM"));
                }
            }
        }
        if (zd.getXzqdm() == null) {
            zd.setXzqdm(djh.substring(0, 12));
        }
        if (zd.getZdlx() == null) {
            zd.setZdlx("1");
        }
    }
}

