/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TjServiceImpl
implements TjService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    ArrayList tjBaseParamList;

    @Transactional(readOnly=true)
    public Page getTjJson(Pageable request, String sqlTag, List<QueryCondition> queryConditionList) {
        Page page = null;
        String sql = this.getTjSql(sqlTag);
        if (StringUtils.isNotEmpty((String)sql)) {
            Query query = this.createQuery(sql, queryConditionList, null, false);
            ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            Query countQuery = this.createQuery(sql, queryConditionList, null, true);
            page = this.baseRepository.find(query, countQuery, request);
        } else {
            TjBaseParamVo tjBaseParamVo = this.getTjBaseParam(sqlTag);
            Class aclass = this.getTjEntityClass(sqlTag);
            List customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty((Collection)customQueryConditionList)) {
                queryConditionList.addAll(customQueryConditionList);
            }
            if (aclass != null) {
                page = this.baseRepository.find(aclass, queryConditionList, tjBaseParamVo.getOrderBy(), request);
            }
        }
        return page;
    }

    @Transactional(readOnly=true)
    public List getTjList(String sqlTag, List<QueryCondition> queryConditionList) {
        List list = null;
        String sql = this.getTjSql(sqlTag);
        if (StringUtils.isNotEmpty((String)sql)) {
            Query query = this.createQuery(sql, queryConditionList, null, false);
            ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.getResultList();
        } else {
            TjBaseParamVo tjBaseParamVo = this.getTjBaseParam(sqlTag);
            Class aclass = this.getTjEntityClass(sqlTag);
            List customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty((Collection)customQueryConditionList)) {
                queryConditionList.addAll(customQueryConditionList);
            }
            if (aclass != null) {
                list = this.baseRepository.list(aclass, queryConditionList, tjBaseParamVo.getOrderBy());
            }
        }
        return list;
    }

    public TjBaseParamVo getTjBaseParam(String tag) {
        TjBaseParamVo tjBaseParam = null;
        if (this.tjBaseParamList != null) {
            for (int i = 0; i < this.tjBaseParamList.size(); ++i) {
                String tagValue = ((TjBaseParamVo)this.tjBaseParamList.get(i)).getTag();
                if (!tagValue.equals(tag)) continue;
                tjBaseParam = (TjBaseParamVo)this.tjBaseParamList.get(i);
                break;
            }
        }
        return tjBaseParam;
    }

    public String getTjSql(String sqlTag) {
        String sqlBase = "";
        TjBaseParamVo tjBaseParam = this.getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            sqlBase = tjBaseParam.getSql();
        }
        return sqlBase;
    }

    private Class getTjEntityClass(String sqlTag) {
        Class<?> aClass = null;
        TjBaseParamVo tjBaseParam = this.getTjBaseParam(sqlTag);
        if (tjBaseParam != null && StringUtils.isNotEmpty((String)tjBaseParam.getEntityName())) {
            try {
                aClass = Class.forName(tjBaseParam.getEntityName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return aClass;
    }

    public Query createQuery(String sql, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        return this.createQuery(sql, null, queryConditions, orderBy, isQueryTotal);
    }

    public Query createQuery(String sql, String resultExpression, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        if (StringUtils.isEmpty((String)resultExpression)) {
            resultExpression = "*";
        }
        StringBuffer sqlQuery = new StringBuffer("SELECT " + resultExpression + " FROM (" + sql + ") WHERE 1=1");
        if (queryConditions != null && queryConditions.size() > 0) {
            for (QueryCondition queryCondition : queryConditions) {
                if (queryCondition == null) continue;
                if (queryCondition.getOperator().equals("custom")) {
                    sqlQuery.append(" AND (").append(queryCondition.getCustomJPQL()).append(")");
                }
                if (queryCondition.getValue() == null || "".equals(queryCondition.getValue())) continue;
                String placeholder = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                String operator = queryCondition.getOperator();
                if (operator.equals("llike") || operator.equals("rlike")) {
                    operator = "like";
                }
                sqlQuery.append(" AND ").append(queryCondition.getField().trim()).append(" ").append(operator).append(":").append(placeholder.trim());
            }
        }
        if (isQueryTotal) {
            sqlQuery.insert(0, "select count(*) from (").append(")");
        } else if (orderBy != null && !"".equals(orderBy)) {
            sqlQuery.append(" ").append(orderBy);
        }
        Query query = this.baseRepository.getEntityManager().createNativeQuery(sqlQuery.toString());
        if (queryConditions != null && queryConditions.size() > 0) {
            for (QueryCondition queryCondition : queryConditions) {
                String queryConditionField;
                if (queryCondition == null || queryCondition.getValue() == null || "".equals(queryCondition.getValue())) continue;
                String string = queryConditionField = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                if (queryCondition.getOperator().equals("like")) {
                    query.setParameter(queryConditionField, (Object)("%" + queryCondition.getValue() + "%"));
                    continue;
                }
                if (queryCondition.getOperator().equals("llike")) {
                    query.setParameter(queryConditionField, (Object)(queryCondition.getValue() + "%"));
                    continue;
                }
                if (queryCondition.getOperator().equals("rlike")) {
                    query.setParameter(queryConditionField, (Object)("%" + queryCondition.getValue()));
                    continue;
                }
                query.setParameter(queryConditionField, queryCondition.getValue());
            }
        }
        return query;
    }
}

