/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.PublicVo;
import cn.gtmap.landtax.entity.Zgswjg;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DicServiceImpl
implements DicService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    ArrayList dicRelList;

    public Map buildEnumMap(String name) throws Exception {
        Map valueMap = Maps.newLinkedHashMap();
        String dicSql = this.findDicSql(name);
        if (dicSql != null) {
            Query query = this.baseRepository.getEntityManager().createNativeQuery(dicSql);
            ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            List dicList = query.getResultList();
            for (int i = 0; i < dicList.size(); ++i) {
                valueMap.put(((HashMap)dicList.get(i)).get("DM"), ((HashMap)dicList.get(i)).get("MC"));
            }
        } else {
            valueMap = this.getDicMapByName(name);
        }
        return valueMap;
    }

    public List findAllZgswjg() {
        String sql = "select swbmbm, mc from dm_swbm ";
        List list = this.baseRepository.getEntityManager().createNativeQuery(sql).getResultList();
        return list;
    }

    public String findZgkgMcByZgkgDm(String zgkgDm) {
        Zgswjg zgswjg = (Zgswjg)this.baseRepository.get(Zgswjg.class, (Object)zgkgDm);
        String zgkgMc = zgswjg.getMc();
        return zgkgMc;
    }

    public String findMcByDm(String dicName, String dm) throws Exception {
        String mc = "";
        Map dicMap = this.buildEnumMap(dicName);
        if (dicMap != null && dicMap.get(dm) != null) {
            mc = dicMap.get(dm).toString();
        }
        return mc;
    }

    private String findDicSql(String name) {
        String dicValue = null;
        if (this.dicRelList != null) {
            for (int i = 0; i < this.dicRelList.size(); ++i) {
                String dicName = ((PublicVo)this.dicRelList.get(i)).getName();
                if (!dicName.equals(name)) continue;
                dicValue = ((PublicVo)this.dicRelList.get(i)).getValue();
                break;
            }
        }
        return dicValue;
    }

    @Cacheable(value={"dictionary"}, key="#name.concat('buildEnumMap')")
    private Map getDicMapByName(String name) throws Exception {
        ?[] objects;
        ?[] arr$;
        int len$;
        int i$;
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        Class<?> clazz = Class.forName("cn.gtmap.landtax.model.dictionary." + name);
        if (clazz.isEnum() && (i$ = 0) < (len$ = (arr$ = (objects = clazz.getEnumConstants())).length)) {
            Object obj = arr$[i$];
            Method m = obj.getClass().getDeclaredMethod("values", null);
            Object[] result = (Object[])m.invoke(obj, null);
            List<Object> list = Arrays.asList(result);
            for (Object objOne : list) {
                Field dm = objOne.getClass().getDeclaredField("dm");
                Field mc = objOne.getClass().getDeclaredField("mc");
                dm.setAccessible(true);
                mc.setAccessible(true);
                valueMap.put(dm.get(objOne), mc.get(objOne));
            }
        }
        return valueMap;
    }
}

