/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.print.sign;

import cn.gtmap.landtax.print.sign.SignVo;
import cn.gtmap.landtax.util.CommonUtil;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class SignListXml {
    private List list = null;

    public SignListXml(List list) {
        this.list = list;
    }

    public String getXMLDataWithAutoSign(HttpServletRequest request) throws Exception {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.list.iterator();
        int num = -1;
        while (it.hasNext()) {
            SignVo sign = (SignVo)it.next();
            sb.append(this.getSignXmlBySignVo(request, sign));
        }
        return sb.toString();
    }

    private StringBuffer getSignXmlBySignVo(HttpServletRequest request, SignVo sign) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (sign != null) {
            sign = (SignVo)CommonUtil.initObj((Object)sign, (boolean)true, (boolean)true, (boolean)false);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            String retvalue = "";
            if (sign.getSignDate() != null) {
                retvalue = String.valueOf(sdf.format(sign.getSignDate()));
            }
            sb.append("<data name=\"");
            sb.append(sign.getSignKey());
            sb.append("_NAME\"");
            sb.append(" type=\"String\">");
            sb.append(sign.getSignName());
            sb.append("</data>");
            sb.append("<data name=\"");
            sb.append(sign.getSignKey());
            sb.append("_OPINION\"");
            sb.append(" type=\"String\">");
            if (sign.getSignOpinion() == null || "".equals(sign.getSignOpinion())) {
                sb.append(" ");
            } else {
                sb.append(sign.getSignOpinion());
            }
            sb.append("</data>");
            sb.append("<data name=\"");
            sb.append(sign.getSignKey());
            sb.append("_Date\"");
            sb.append(" type=\"String\">");
            sb.append(retvalue);
            sb.append("</data>");
            sb.append("<data name=\"");
            sb.append(sign.getSignKey());
            sb.append("_PIC\"");
            sb.append(" type=\"image\">");
            sb.append(this.getSignPic(request, sign));
            sb.append("</data>");
        }
        return sb;
    }

    private String getSignPic(HttpServletRequest request, SignVo signVo) {
        if (signVo.getSignId() == null || signVo.getSignId().trim().length() == 0) {
            return "";
        }
        StringBuffer autoSignPicUrl = new StringBuffer();
        autoSignPicUrl.append(request.getScheme());
        autoSignPicUrl.append("://");
        autoSignPicUrl.append(request.getServerName());
        autoSignPicUrl.append(":");
        autoSignPicUrl.append(request.getServerPort());
        autoSignPicUrl.append("/platform/formprint.action?r=" + Math.random() + "&amp;datatype=signature&amp;signid=");
        autoSignPicUrl.append(signVo.getSignId());
        String picUrl = signVo.getSignPicUrl();
        if (picUrl == null || picUrl.trim().length() == 0) {
            if (this.hasSignPic(autoSignPicUrl.toString())) {
                return autoSignPicUrl.toString();
            }
            return "";
        }
        if (this.hasSignPic(picUrl)) {
            return picUrl;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSignPic(String url) {
        url = url.replace("&amp;", "&");
        HttpClient client = new HttpClient();
        GetMethod httpGet = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)httpGet);
            InputStream in = httpGet.getResponseBodyAsStream();
            int num = in.read();
            if (num > -1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            httpGet.releaseConnection();
        }
    }
}

