/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.print;

import cn.gtmap.landtax.print.VoListXml;
import cn.gtmap.landtax.print.VoXml;
import cn.gtmap.landtax.print.sign.GetSignInfo;
import cn.gtmap.landtax.print.sign.SignListXml;
import cn.gtmap.landtax.print.sign.SignVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class XMLBuildHelper {
    public String voToXml(Object vo) {
        if (vo == null) {
            return "";
        }
        VoXml vxml = new VoXml(vo);
        return vxml.getXMLData();
    }

    public String voEntityToXml(Object vo) {
        if (vo == null) {
            return "";
        }
        VoXml vxml = new VoXml(vo);
        return vxml.getEntityXMLData();
    }

    public String hashMapToXml(HashMap<String, String> map) {
        VoXml vxml = new VoXml();
        vxml.setMap(map);
        return vxml.getXMLDataByHashMap();
    }

    public String voListToXml(List volist) {
        if (volist == null) {
            volist = new ArrayList();
        }
        VoListXml vlxml = new VoListXml(volist);
        return vlxml.getXMLData();
    }

    public String hashMapListToXml(List<HashMap<String, String>> maplist) {
        VoListXml vlxml = new VoListXml();
        vlxml.setMaplist(maplist);
        return vlxml.getXMLDataByHashMap();
    }

    public String getSignToXml(String proid, HttpServletRequest request, HashMap<String, Boolean> keyMap) {
        try {
            GetSignInfo signInfo = new GetSignInfo();
            List signVoList = signInfo.getSign(proid);
            signVoList = this.unsignedInfoAdd(signVoList, keyMap);
            SignListXml signXml = new SignListXml(signVoList);
            try {
                return signXml.getXMLDataWithAutoSign(request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    public String getSignToXml(StringBuilder xml, HashMap<String, Boolean> keyMap) {
        StringBuffer sb = new StringBuffer();
        try {
            String str = xml.toString();
            if (keyMap != null) {
                Set<String> values = keyMap.keySet();
                for (Object e : values) {
                    String sign;
                    if (e == null || !StringUtils.isNotBlank((String)String.valueOf(e)) || str.indexOf(sign = String.valueOf(e) + "_") >= 0) continue;
                    sb.append("<data name=\"" + sign + "NAME\" type=\"String\"/>");
                    sb.append("<data name=\"" + sign + "Date\" type=\"String\"/>");
                    sb.append("<data name=\"" + sign + "OPINION\" type=\"String\"/>");
                    sb.append("<data name=\"" + sign + "PIC\" type=\"image\"/>");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (sb != null && StringUtils.isNotBlank((String)sb.toString())) {
            return sb.toString();
        }
        return "";
    }

    private List unsignedInfoAdd(List signVoList, HashMap<String, Boolean> keyMap) {
        Vector<SignVo> finsihSignVoList = new Vector<SignVo>();
        HashMap<String, Vector<SignVo>> signVoMap = new HashMap<String, Vector<SignVo>>();
        if (signVoList == null) {
            return finsihSignVoList;
        }
        for (int i = 0; i < signVoList.size(); ++i) {
            SignVo tempSignVo = (SignVo)signVoList.get(i);
            Vector<SignVo> curSignVoList = (Vector<SignVo>)signVoMap.get(tempSignVo.getSignKey());
            if (curSignVoList == null) {
                curSignVoList = new Vector<SignVo>();
                signVoMap.put(tempSignVo.getSignKey(), curSignVoList);
            }
            curSignVoList.add(tempSignVo);
            for (Map.Entry<String, Boolean> entry : keyMap.entrySet()) {
                String key = entry.getKey();
                boolean val = entry.getValue();
                if (tempSignVo.getSignKey().equalsIgnoreCase(key.toString())) {
                    val = true;
                }
                keyMap.put(key, val);
            }
        }
        for (Map.Entry<String, Boolean> entry : keyMap.entrySet()) {
            String key = entry.getKey();
            boolean val = entry.getValue();
            if (!val) {
                SignVo tempCbdwCbrSignVo = new SignVo();
                tempCbdwCbrSignVo.setSignKey(key);
                finsihSignVoList.add(tempCbdwCbrSignVo);
                continue;
            }
            finsihSignVoList.addAll((Collection)signVoMap.get(key));
        }
        return finsihSignVoList;
    }

    public String getPrintXml(String dataXml) {
        StringBuilder xml = new StringBuilder();
        xml.append(this.getPrintXml(dataXml, null));
        return xml.toString();
    }

    public String getPrintXml(String dataXml, String detailXml) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>\n");
        xml.append("<fetchdatas>\n");
        xml.append("<datas>\n");
        xml.append(dataXml);
        if (xml.indexOf("</datas>") < 0) {
            xml.append("</datas>");
        }
        if (StringUtils.isNotBlank((String)detailXml)) {
            xml.append(detailXml);
            if (xml.indexOf("</detail>") < 0) {
                xml.append("</detail>");
            }
        }
        xml.append("</fetchdatas>");
        System.out.println(xml.toString());
        return xml.toString();
    }
}

